/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.ToastManager;
import com.fr.fs.base.entity.User;
import com.fr.fs.base.entity.UserInfo;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataUserDAO;
import com.fr.fs.privilege.auth.FSAuthenticationManager;
import com.fr.fs.web.FSConstants;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.FSMailModuleGetAllReportAction;
import com.fr.fs.web.service.FSMainModuleGetRootsAction;
import com.fr.fs.web.service.FSManagerModuleGetHomePageURLAction;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.utils.WebUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSOpenEntryService
extends AbstractFSAuthService {
    private int expires = -10;

    public String actionOP() {
        return "fs";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (!FSRegisterForBI.isSupportFS()) {
            throw new RegistEditionException(VT4FR.FS_BI);
        }
        FSContext.initData();
        httpServletRequest.getSession(true).removeAttribute("originalURL");
        PrivilegeVote privilegeVote = this.getFSVote(httpServletRequest, httpServletResponse);
        if (!privilegeVote.isPermitted()) {
            privilegeVote.action(httpServletRequest, httpServletResponse);
            return;
        }
        this.init(httpServletRequest, httpServletResponse, string);
    }

    protected void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", (long)this.expires);
        String string2 = "stranger";
        UserInfo userInfo = FSAuthenticationManager.exAuth4FineServer(httpServletRequest).getUserInfo();
        String string3 = userInfo.getUsername();
        User user = UserControl.getInstance().getByUserName(string3);
        if (user.getId() != userInfo.getId()) {
            FSAuthenticationManager.refreshAuth4FineServer(httpServletRequest, user.getId());
        }
        if (user != null && StringUtils.isNotEmpty(user.getRealname())) {
            string2 = user.getRealname();
        } else if (FSAuthenticationManager.exAuth4FineServer(httpServletRequest) != null) {
            string2 = FSAuthenticationManager.exAuth4FineServer(httpServletRequest).getUserInfo().getUsername();
        }
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        Map map = this.getFSParaMap(httpServletRequest, string2, l2);
        WebUtils.writeOutTemplate(this.searchTemplatePath(httpServletRequest), httpServletResponse, map);
    }

    protected String searchTemplatePath(HttpServletRequest httpServletRequest) {
        if ("true".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "debug"))) {
            return "/com/fr/fs/web/fs_debug.html";
        }
        if (FRContext.isShouldForceEnglish()) {
            return "/com/fr/fs/web/fs_en_us.html";
        }
        return "/com/fr/fs/web/fs.html";
    }

    protected Map getFSParaMap(HttpServletRequest httpServletRequest, String string, long l2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("company", FSConfig.getInstance().getLoginTitle4FS());
        hashMap.put("userName", string);
        hashMap.put("isAdmin", l2 == -999L);
        hashMap.put("loginImageID4FS", FSConfig.getInstance().getLoginImageID4FS());
        hashMap.put("backgroundImageID", FSConfig.getInstance().getBgImageID4FS());
        hashMap.put("homePageUrl", FSManagerModuleGetHomePageURLAction.addTimestamp(httpServletRequest, FSConfig.getInstance().getHomePageURL()));
        hashMap.put("isRegiste", !ComparatorUtils.equals(StableUtils.getBytes(), null) + "");
        hashMap.put("isLicExist", this.checkLicExist() + "");
        hashMap.put("allReports", FSMailModuleGetAllReportAction.getAllReports(l2).toString());
        hashMap.put("roots", FSMainModuleGetRootsAction.getCatalogInfo(l2).toString());
        hashMap.put("isTableDataUser", (FSConfig.getInstance().getControl().getUserDAO() instanceof TableDataUserDAO) + "");
        hashMap.put("isLicExist", this.checkLicExist() + "");
        hashMap.put("allReports", FSMailModuleGetAllReportAction.getAllReports(l2).toString());
        hashMap.put("roots", FSMainModuleGetRootsAction.getCatalogInfo(l2).toString());
        hashMap.put("isTableDataUser", (FSConfig.getInstance().getControl().getUserDAO() instanceof TableDataUserDAO) + "");
        hashMap.put("authenticateType", FSConfig.getInstance().getAuthenticateType());
        hashMap.put("hasprocess", PlateFactory.containsPlate(FSConstants.PLATE.PROCESS));
        hashMap.put("hasbi", PlateFactory.containsPlate(FSConstants.PLATE.BIS));
        hashMap.put("hasAnalysis", PlateFactory.containsPlate(FSConstants.PLATE.BSDESIGNER));
        hashMap.put("hasnavigation", FSConfig.getInstance().hasNavigation());
        hashMap.put("navigationimgs", FSConfig.getInstance().getNavigationImages4FS());
        hashMap.put("style", FSConfig.getInstance().getStyle());
        hashMap.put("ismobilebinddev", String.valueOf(FSConfig.getInstance().isMobiledevbind()));
        hashMap.put("hasReportProcess", VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.MULTI_DATA_REPORT.support());
        hashMap.put("hasGradeAuthority", FSConfig.getInstance().hasMultiPrivilege());
        hashMap.put("needCheckMessage", ToastManager.needCheck(l2));
        hashMap.put("gradeAuthority", FSConfig.getInstance().isGradeAuthority());
        hashMap.put("editReportAuthority", FSConfig.getInstance().isEditReportAuthority());
        hashMap.put("templatePrivilegeType", PrivilegeManager.getInstance().getPrivilegeFilterType());
        hashMap.put("dataConnectionAuthority", FSConfig.getInstance().isDataConnectionAuthority());
        hashMap.put("departmentAllID", CompanyRoleControl.getInstance().getDepartmentAllID());
        hashMap.put("postAllID", CompanyRoleControl.getInstance().getPostAllID());
        hashMap.put("hasRegistePrivilege", ModuleControl.getInstance().hasRegisterInfoModulePrivilege(l2) + "");
        return hashMap;
    }

    private boolean checkLicExist() {
        if (ConfigManager.getInstance().isLicUseLock()) {
            return true;
        }
        try {
            Env env = FRContext.getCurrentEnv();
            String string = env.getLicName();
            InputStream inputStream = env.readBean(string, "resources");
            return inputStream != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

