/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.TemplateUtils;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.web.UserInfo;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSLoadLogoutAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(true);
        FSLoadLogoutAction.logout2RemoveInfo(httpSession, httpServletResponse);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        this.writeSignOutInfo(httpServletRequest, printWriter);
        printWriter.flush();
        printWriter.close();
    }

    protected void writeSignOutInfo(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws Exception {
        printWriter.print(TemplateUtils.render("${servletURL}?op=fs_load&cmd=fs_signin&_=" + System.currentTimeMillis()));
    }

    public String getCMD() {
        return "logout";
    }

    public static void logout2RemoveInfo(HttpSession httpSession, HttpServletResponse httpServletResponse) {
        if (httpSession == null) {
            return;
        }
        httpSession.removeAttribute("originalURL");
        FSAuthentication fSAuthentication = (FSAuthentication)httpSession.getAttribute("fr_fs_auth_key");
        if (fSAuthentication != null) {
            httpSession.removeAttribute("fr_fs_auth_key");
            httpSession.removeAttribute("fr_username");
            httpSession.removeAttribute("fr_authority");
            httpSession.removeAttribute("fr_userposition");
            httpSession.removeAttribute("fr_current_privilege_loader");
            UserControl.getInstance().logout(fSAuthentication.getUserInfo().getId());
        }
        UserInfo userInfo = new UserInfo();
        userInfo.removeCookies(httpServletResponse);
    }
}

