/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.TemplateUtils;
import com.fr.data.dao.DAOBean;
import com.fr.fs.FSConfig;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.auth.AuthenticateResult;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.auth.FailResult;
import com.fr.fs.privilege.auth.LdapAuthenticationProvider;
import com.fr.fs.privilege.auth.SuccessResult;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.privilege.base.FServicePrivilegeLoader;
import com.fr.fs.privilege.entity.DaoFSAuthentication;
import com.fr.fs.web.FSConstants;
import com.fr.fs.web.UserInfo;
import com.fr.general.ComparatorUtils;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.authentication.UsernamePasswordAuthentication;
import com.fr.privilege.providers.HttpAuthenticationProvider;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSLoadLoginAction
extends ActionNoSessionCMD {
    public static String USERNAME = "fsusername";
    public static String PASSWORD = "fspassword";
    public static String REMEMBER = "fsremember";
    private static boolean isFirstTime = true;
    private static final String FSDEFAULTURL = "${serverURL}${servletURL}?op=fs&_=";
    private static final String PLATFORMDEFAULTURL = "${serverURL}${servletURL}?op=fr_platform&_=";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        if (WebUtils.isMobileAPPRequest(httpServletRequest) && isFirstTime) {
            isFirstTime = false;
            PlateFactory.getPlateWithPlateName(FSConstants.PLATE.MOBILE).registerData();
            FSConfig.getInstance().getLoginAction().actionCMD(httpServletRequest, httpServletResponse);
            isFirstTime = true;
            FSConfig.getInstance().setLoginAction(this);
            return;
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "fsusername");
        if (StringUtils.isEmpty(string2)) {
            USERNAME = "username";
            string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "username");
        }
        if (StringUtils.isEmpty(string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fspassword"))) {
            PASSWORD = "password";
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "password");
        }
        boolean bl = ComparatorUtils.equals("true", WebUtils.getHTTPRequestParameter(httpServletRequest, "isTemplate"));
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        if (this.dealLoginInfo(httpServletRequest, httpServletResponse, string2, string, bl)) {
            UserInfo userInfo = new UserInfo(string2, string, Boolean.valueOf(WebUtils.getHTTPRequestParameter(httpServletRequest, "fsremember")));
            userInfo.dealBrowserCookies(httpServletResponse);
            Object object = httpServletRequest.getSession(true).getAttribute(bl ? "fr_template_originalUrl" : "originalURL");
            String string3 = object == null ? TemplateUtils.render(this.getRenderUrl() + System.currentTimeMillis()) : object.toString() + "&_=" + System.currentTimeMillis();
            this.signOnSuccess(httpServletRequest, httpServletResponse, printWriter, string3);
        } else {
            this.signOnFailure(httpServletRequest, printWriter);
        }
        printWriter.flush();
        printWriter.close();
    }

    protected void signOnSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string) throws IOException {
        if ("true".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "__redirect__"))) {
            httpServletResponse.sendRedirect(string);
            return;
        }
        printWriter.print("{\"url\" : \"" + string + "\"}");
    }

    protected void signOnFailure(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        printWriter.print("{\"fail\" : true}");
    }

    public String getCMD() {
        return "login";
    }

    private boolean dealLoginInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, boolean bl) throws Exception {
        Object object;
        AuthenticateResult authenticateResult;
        boolean bl2 = true;
        if (!this.isRootUser(string, string2)) {
            if (!FSRegisterForBI.isSupportFS() && !bl) {
                return false;
            }
            if (ComparatorUtils.equals("ldap", FSConfig.getInstance().getAuthenticateType()) || ComparatorUtils.equals("http", FSConfig.getInstance().getAuthenticateType())) {
                if (!this.doAuthentication(string, string2)) {
                    return false;
                }
                if (bl) {
                    return true;
                }
                bl2 = false;
            }
        }
        UserNamePassWordFSAuthenticationProvider userNamePassWordFSAuthenticationProvider = UserNamePassWordFSAuthenticationProvider.getInstance();
        userNamePassWordFSAuthenticationProvider.setNeedPassword(bl2);
        UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
        boolean bl3 = userNamePassWordFSAuthenticationProvider.authenticate(usernamePasswordAuthentication);
        if (!bl3) {
            authenticateResult = new FailResult("No User & Password Exist!");
        } else {
            object = UserControl.getInstance().getByUserName(string);
            if (object != null) {
                DaoFSAuthentication daoFSAuthentication = new DaoFSAuthentication(new com.fr.fs.base.entity.UserInfo(((DAOBean)object).getId(), ((User)object).getUsername(), ((User)object).getPassword()));
                daoFSAuthentication.setRoot(usernamePasswordAuthentication.isRoot());
                daoFSAuthentication.setAuthenticated(true);
                daoFSAuthentication.setAuthorities(usernamePasswordAuthentication.getAuthorities());
                authenticateResult = new SuccessResult(daoFSAuthentication);
            } else {
                authenticateResult = new FailResult("No User & Password Exist!");
            }
        }
        if (authenticateResult.success()) {
            object = authenticateResult.getFSAuthentication();
            long l2 = ((FSAuthentication)object).getUserInfo().getId();
            HttpSession httpSession = httpServletRequest.getSession(true);
            PrivilegeInfoSessionMananger.login(new FServicePrivilegeLoader(string, UserControl.getInstance().getAllSRoleNames(l2), UserControl.getInstance().getUserDP(l2)), httpSession, httpServletResponse);
            httpSession.setAttribute("fr_fs_auth_key", object);
            UserControl.getInstance().login(l2);
            return true;
        }
        return false;
    }

    private boolean doAuthentication(String string, String string2) throws Exception {
        if (ComparatorUtils.equals("ldap", FSConfig.getInstance().getAuthenticateType())) {
            String string3 = FSConfig.getInstance().getPrincipalSuffix();
            if (StringUtils.isNotEmpty(string3)) {
                string = string + string3;
            }
            return LdapAuthenticationProvider.getInstance().ldapAuthentication(string, string2);
        }
        String string4 = FSConfig.getInstance().getHttpUrl();
        if (StringUtils.isNotEmpty(string4)) {
            UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
            HttpAuthenticationProvider httpAuthenticationProvider = new HttpAuthenticationProvider();
            httpAuthenticationProvider.setUrl(string4);
            return httpAuthenticationProvider.authenticate(usernamePasswordAuthentication);
        }
        return false;
    }

    protected String getRenderUrl() {
        return FSRegisterForBI.isSupportFS() ? FSDEFAULTURL : PLATFORMDEFAULTURL;
    }

    private boolean isRootUser(String string, String string2) {
        if (StringUtils.isNotEmpty(string) && ComparatorUtils.equals(string, PrivilegeManager.getInstance().getRootManagerName())) {
            return StringUtils.isNotEmpty(string2) && ComparatorUtils.equals(string2, PrivilegeManager.getInstance().getRootManagerPassword());
        }
        return false;
    }
}

