/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web;

import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBookTemplateDelegate;
import com.fr.privilege.authentication.FSRoleAuthentication;
import com.fr.stable.Actor;
import com.fr.stable.web.SessionProvider;
import com.fr.web.WebletException;
import com.fr.web.cache.ReportCacheManager;
import com.fr.web.cache.ReportEntry;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.reportlet.FixedPolicyReportlet;
import com.fr.web.request.AbstractReportletRequest;
import com.fr.web.request.ReportletRequest;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FSReportlet
extends FixedPolicyReportlet {
    private String bookPath;
    private String name;
    private Map parameterMap;

    public FSReportlet(String string, String string2, Map map, Actor actor) {
        super(actor);
        this.name = string2;
        this.bookPath = string;
        this.parameterMap = map;
    }

    public void setTplPath(String string) {
        this.bookPath = string;
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    public SessionProvider createSessionIDInfor(HttpServletRequest httpServletRequest, String string, Map map) throws WebletException {
        map.putAll(this.parameterMap);
        for (Object k2 : this.parameterMap.keySet()) {
            if (k2 == null) continue;
            httpServletRequest.setAttribute(k2.toString(), this.parameterMap.get(k2));
        }
        return new ReportSessionIDInfor(string, map, this.createReport(AbstractReportletRequest.getInstance(httpServletRequest)), this.name, this.bookPath, this.getActor(), new FSRoleAuthentication(this.getUserRoleString(httpServletRequest)));
    }

    private String getUserRoleString(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            int n2;
            FArray fArray;
            Object object = httpSession.getAttribute("fr_authority");
            Object object2 = httpSession.getAttribute("fr_userposition");
            if (object == null && object2 == null) {
                return PrivilegeConstants.ROLE_UNDEFINED;
            }
            FArray fArray2 = new FArray();
            if (object instanceof FArray) {
                fArray = (FArray)object;
                fArray2.add(fArray);
            } else if (object != null) {
                fArray2.add((String)object);
            }
            if (object2 instanceof FArray) {
                fArray = (FArray)object2;
                for (int i2 = 0; i2 < fArray.length(); ++i2) {
                    JSONObject jSONObject = (JSONObject)fArray.elementAt(i2);
                    try {
                        fArray2.add(jSONObject.getString("departments") + jSONObject.getString("jobTitle"));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        FRLogger.getLogger().info(jSONException.getMessage());
                    }
                }
            } else if (object2 != null) {
                fArray2.add((String)object2);
            }
            if ((n2 = fArray2.length()) > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringBuffer.append(fArray2.elementAt(i3).toString()).append("&");
                }
                return stringBuffer.toString();
            }
        }
        return PrivilegeConstants.ROLE_UNDEFINED;
    }

    public TemplateWorkBook createReport(ReportletRequest reportletRequest) throws WebletException {
        ReportEntry reportEntry = ReportCacheManager.getInstance().getReportEntry(this.bookPath);
        return new WorkBookTemplateDelegate(reportEntry, false);
    }
}

