/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.third.org.quartz.CronTrigger;
import com.fr.third.org.quartz.Trigger;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class CalendarITrigger
extends ITrigger {
    public static final String TABLE_NAME = "fr_calendar_itrigger";
    public static final int TYPE = 3;
    public static final int EVERY_DAY = 1;
    public static final int WEEK_DAYS = 2;
    public static final int MONTH_DAYS = 3;
    public static final String NAME = "calendar";
    public static final String ALL = "*";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(CalendarITrigger.class, new Table("fr_calendar_itrigger"), (FieldColumnMapper[])ArrayUtils.addAll(ITrigger.ITRIGGER_FIELDMAPPER, new FieldColumnMapper[]{ITrigger.EndTimeFieldMapper, new CommonFieldColumnMapper("minutes", 4, "minutes", new ColumnSize(10), true), new CommonFieldColumnMapper("hours", 4, "hours", new ColumnSize(10), true), new CommonFieldColumnMapper("dayType", 4, "day_type", new ColumnSize(10), true), new CommonFieldColumnMapper("weekDays", 12, "week_days", new ColumnSize(255), true), new CommonFieldColumnMapper("monthDays", 12, "month_days", new ColumnSize(255), true), new CommonFieldColumnMapper("months", 12, "months", new ColumnSize(255), true)}));
    private static final long serialVersionUID = 1L;
    private long minutes = 0L;
    private long hours = 0L;
    private long dayType = 1L;
    private String weekDays = "*";
    private String monthDays = "*";
    private String months = "*";

    public ITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            Date date;
            String string;
            CalendarITrigger calendarITrigger = new CalendarITrigger();
            long l2 = jSONObject.getLong("startType");
            calendarITrigger.setStartType(l2);
            if (l2 == 2L) {
                string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    calendarITrigger.setStartTime(date);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), parseException);
                }
            }
            if (jSONObject.has("endTime")) {
                string = jSONObject.getString("endTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    calendarITrigger.setEndTime(date);
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage(), parseException);
                }
            }
            long l3 = jSONObject.getLong("dayType");
            calendarITrigger.setDayType(l3);
            long l4 = jSONObject.getLong("minutes");
            calendarITrigger.setMinutes(l4);
            long l5 = jSONObject.getLong("hours");
            calendarITrigger.setHours(l5);
            String string2 = jSONObject.getString("months");
            calendarITrigger.setMonths(string2);
            if (l3 == 2L) {
                String string3 = jSONObject.getString("weekDays");
                calendarITrigger.setWeekDays(string3);
            } else if (l3 == 3L) {
                String string4 = jSONObject.getString("monthDays");
                calendarITrigger.setMonthDays(string4);
            }
            if (jSONObject.has("id")) {
                calendarITrigger.setId(jSONObject.getLong("id"));
            }
            return calendarITrigger;
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            return null;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("recurrenceType", NAME);
        if (this.getEndTime() != null) {
            Date date = this.getEndTime();
            String string = DateUtils.DATETIMEFORMAT2.format(date);
            jSONObject.put("endTime", string);
        }
        long l2 = this.getMinutes();
        jSONObject.put("minutes", l2);
        long l3 = this.getHours();
        jSONObject.put("hours", l3);
        long l4 = this.getDayType();
        jSONObject.put("dayType", l4);
        if (l4 == 2L) {
            jSONObject.put("weekDays", this.getWeekDays());
        } else if (l4 == 3L) {
            jSONObject.put("monthDays", this.getMonthDays());
        }
        jSONObject.put("months", this.getMonths());
        return jSONObject;
    }

    public Trigger createTrigger() {
        CronTrigger cronTrigger = new CronTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                cronTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("The statemenet is illegal.");
            }
        }
        if (this.getEndTime() != null) {
            cronTrigger.setEndTime(this.getEndTime());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0').append(' ');
        stringBuffer.append(this.getMinutes()).append(' ');
        stringBuffer.append(this.getHours()).append(' ');
        if (this.getDayType() == 1L) {
            stringBuffer.append('*').append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append('?');
        } else if (this.getDayType() == 2L) {
            stringBuffer.append('?').append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append(this.getWeekDays());
        } else if (this.getDayType() == 3L) {
            stringBuffer.append(this.getMonthDays().replace("32", "L")).append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append('?');
        }
        try {
            cronTrigger.setCronExpression(stringBuffer.toString());
        }
        catch (ParseException parseException) {
            FRContext.getLogger().error(parseException.getMessage(), parseException);
        }
        cronTrigger.setTimeZone(TimeZone.getTimeZone(this.getTimeZoneID()));
        cronTrigger.setMisfireInstruction(2);
        return cronTrigger;
    }

    public int getITriggerIdPrefix() {
        return 3;
    }

    public void setMinutes(long l2) {
        this.minutes = l2;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public void setHours(long l2) {
        this.hours = l2;
    }

    public long getHours() {
        return this.hours;
    }

    public void setDayType(long l2) {
        this.dayType = l2;
    }

    public long getDayType() {
        return this.dayType;
    }

    public void setWeekDays(String string) {
        this.weekDays = string;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setMonthDays(String string) {
        this.monthDays = string;
    }

    public String getMonthDays() {
        return this.monthDays;
    }

    public void setMonths(String string) {
        this.months = string;
    }

    public String getMonths() {
        return this.months;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CalendarITrigger)) {
            return false;
        }
        CalendarITrigger calendarITrigger = (CalendarITrigger)object;
        return ComparatorUtils.equals(this.getEndTime(), calendarITrigger.getEndTime()) && this.getMinutes() == calendarITrigger.getMinutes() && this.getHours() == calendarITrigger.getHours() && this.getDayType() == calendarITrigger.getDayType() && ComparatorUtils.equals(this.getWeekDays(), calendarITrigger.getWeekDays()) && ComparatorUtils.equals(this.getMonthDays(), calendarITrigger.getMonthDays()) && ComparatorUtils.equals(this.getMonths(), calendarITrigger.getMonths());
    }
}

