/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.base.FRContext;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.FSConfig;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.dao.DaoObject;
import com.fr.fs.dao.TaskInfoUserTableMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class TaskInfoUser
extends DaoObject {
    public static final String TASKINFOID = "taskInfoID";
    public static final String USERID = "userID";
    private static ObjectTableMapper tableMapper = null;
    private long taskInfoID = -1L;
    private long userID = -1L;

    public TaskInfoUser() {
    }

    public TaskInfoUser(long l2, long l3) {
        this.userID = l2;
        this.taskInfoID = l3;
    }

    public static ObjectTableMapper getObjectTableMapper() {
        if (tableMapper == null) {
            tableMapper = new TaskInfoUserTableMapper();
        }
        return tableMapper;
    }

    public static List getUserTasks(long l2) {
        List list = new ArrayList();
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            try {
                list = (ArrayList)SystemManagerFavoriteAndADHOC.getInstance().findSysTaskNodes();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            list = FSConfig.getInstance().getControl().getTaskInfoUserDAO().findByUserId(new Long(l2));
        }
        return list;
    }

    public long getTaskInfoID() {
        return this.taskInfoID;
    }

    public void setTaskInfoID(long l2) {
        this.taskInfoID = l2;
    }

    public long getUserID() {
        return this.userID;
    }

    public void setUserID(long l2) {
        this.userID = l2;
    }

    public void initObjectTableMapper() {
    }

    protected int hashCode4Properties() {
        return 0;
    }

    public boolean equals4Properties(Object object) {
        return false;
    }

    public void save() {
        FSConfig.getInstance().getControl().getTaskInfoUserDAO().save(this);
    }

    public void update() {
        if (this.getId() < 0L) {
            FRContext.getLogger().log(Level.INFO, "Need ID to update!");
            return;
        }
        FSConfig.getInstance().getControl().getTaskInfoUserDAO().update(this);
    }

    public void remove() {
        if (this.getId() < 0L && this.getUserID() != UserControl.getInstance().getSuperManagerID()) {
            FRContext.getLogger().log(Level.INFO, "Need ID to remove!");
            return;
        }
        try {
            SystemManagerFavoriteAndADHOC.getInstance().deleteTaskNodeById(this.getId());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FSConfig.getInstance().getControl().getTaskInfoUserDAO().remove(this);
            return;
        }
    }
}

