/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AddColumn;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.DAOManager;
import com.fr.data.dao.DAOManagerFactory;
import com.fr.data.dao.DAOSession;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.dao.properties.FsJdbcDaoProperties;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.web.core.db.PlatformDB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class FSDAOManager {
    private static DAOManager manager = null;

    public static DAOSession createSession() {
        return FSDAOManager.getJDBCDAOManager().startSession();
    }

    public static DAOManager getJDBCDAOManager() {
        if (manager == null) {
            FSDAOManager.refreshManager();
        }
        return manager;
    }

    public static synchronized void refreshManager() {
        FsJdbcDaoProperties fsJdbcDaoProperties = new FsJdbcDaoProperties();
        manager = DAOManagerFactory.createJDBCDAOManager(fsJdbcDaoProperties);
        try {
            manager.checkTables();
            Connection connection = PlatformDB.getDB().createConnection();
            FSDAOManager.dealWithJSRoleTable(connection);
            FSDAOManager.dealWithDepartmentTable(connection);
            FSDAOManager.dealWithEntryTable4SortColumn(connection);
            FSDAOManager.dealWithUnnecessaryModules(connection);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    private static void dealWithEntryTable4SortColumn(Connection connection) {
        for (int i2 = 0; i2 < EntryTableName.ENTRYTABLENAMES.length; ++i2) {
            String string = EntryTableName.ENTRYTABLENAMES[i2];
            if (!FSDAOManager.shouldAddTableColumn(connection, string, "sortindex")) continue;
            FSDAOManager.addTableColumn4NewConnection(string, new Column("sortindex", -5, new ColumnSize(10)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addTableColumn4NewConnection(String string, Column column) {
        Connection connection = null;
        try {
            try {
                connection = PlatformDB.getDB().createConnection();
                connection.setAutoCommit(false);
                Dialect dialect = DialectFactory.generateDialect(connection);
                FSDAOManager.addTableColumn(connection, dialect, column, string);
                connection.commit();
            }
            catch (Exception exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
                FRContext.getLogger().error("Add" + string + "SortColumn Action Failed!");
                FRContext.getLogger().error(exception.getMessage(), exception);
                Object var6_6 = null;
                DBUtils.closeConnection(connection);
                return;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTableColumn(Connection connection, Dialect dialect, Column column, String string) throws SQLException {
        Table table = new Table(string);
        AddColumn addColumn = new AddColumn(table, column, dialect);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = addColumn.createPreparedStatement(connection);
            preparedStatement.execute();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean shouldAddTableColumn(Connection var0, String var1_1, String var2_2) {
        block16: {
            block15: {
                var3_3 = new Table(var1_1);
                var4_4 = new Select(var3_3, DialectFactory.generateDialect(var0));
                var5_5 = null;
                var6_6 = null;
                try {
                    try {
                        var5_5 = var4_4.createPreparedStatement(var0);
                        var6_6 = var5_5.executeQuery();
                        var7_7 = var6_6.getMetaData();
                        var8_9 = var7_7.getColumnCount();
                        for (var9_11 = true; var9_11 <= var8_9; var9_11 += 1) {
                            if (!var2_2.equalsIgnoreCase(var7_7.getColumnName((int)var9_11))) continue;
                            var10_12 = false;
                            var12_13 = null;
                            break block15;
                        }
                        var9_11 = true;
                        break block16;
                    }
                    catch (SQLException var7_8) {
                        FRContext.getLogger().error("Check" + var1_1 + "SortColumn Action Failed!");
                        FRContext.getLogger().error(var7_8.getMessage(), var7_8);
                        var8_10 = false;
                        var12_15 = null;
                        try {
                            if (var6_6 != null) {
                                var6_6.close();
                            }
                            if (var5_5 == null) return var8_10;
                            var5_5.close();
                            return var8_10;
                        }
                        catch (SQLException var13_19) {
                            // empty catch block
                        }
                        return var8_10;
                    }
                }
                catch (Throwable var11_21) {
                    var12_16 = null;
                    try {}
                    catch (SQLException var13_20) {
                        throw var11_21;
                    }
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                    if (var5_5 == null) throw var11_21;
                    var5_5.close();
                    throw var11_21;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 178->205)] { 
lbl48:
            // 1 sources

            if (var6_6 != null) {
                var6_6.close();
            }
            if (var5_5 == null) return var10_12;
            var5_5.close();
            return var10_12;
lbl53:
            // 1 sources

            catch (SQLException var13_17) {
                // empty catch block
            }
            return var10_12;
        }
        var12_14 = null;
        try {}
        catch (SQLException var13_18) {
            // empty catch block
            return var9_11;
        }
        if (var6_6 != null) {
            var6_6.close();
        }
        if (var5_5 == null) return var9_11;
        var5_5.close();
        return var9_11;
    }

    private static void dealWithJSRoleTable(Connection connection) {
        FSDAOManager.writeDataToNewTable(connection);
        FSDAOManager.deletJSRoleTable(connection);
        FSDAOManager.addPrivilegeTypeColumn(connection);
        FSDAOManager.writeModuleDataToNewTable(connection);
    }

    private static void dealWithDepartmentTable(Connection connection) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string = "FR_T_DEPARTMENT";
        Table table = new Table("INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS");
        Where where = new Where();
        where.addColumn("TABLE_NAME", string);
        where.addColumn("CONSTRAINT_TYPE", "UNIQUE");
        Select select = new Select(table, where, DialectFactory.generateDialect(connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
            return;
        }
        try {
            while (resultSet.next()) {
                String string2 = resultSet.getString("CONSTRAINT_NAME");
                Statement statement = connection.createStatement();
                statement.execute("ALTER TABLE " + string + " DROP CONSTRAINT " + string2);
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage());
        }
    }

    private static void addPrivilegeTypeColumn(Connection connection) {
        for (String string : CRoleEntryTableName.TABLENAMES) {
            String string2 = "view";
            if (FSDAOManager.shouldAddTableColumn(connection, string, string2)) {
                FSDAOManager.addTableColumn4NewConnection(string, new Column(string2, -5, new ColumnSize(10)));
                FSDAOManager.addTableColumn4NewConnection(string, new Column("authorized", -5, new ColumnSize(10)));
                FSDAOManager.addTableColumn4NewConnection(string, new Column("edit", -5, new ColumnSize(10)));
            }
            if (!FSDAOManager.shouldAddTableColumn(connection, string, string2 = "edit")) continue;
            FSDAOManager.addTableColumn4NewConnection(string, new Column("edit", -5, new ColumnSize(10)));
        }
    }

    private static void writeDataToNewTable(String string, Connection connection) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Table table = new Table(string);
        Select select = new Select(table, DialectFactory.generateDialect(connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
            return;
        }
        try {
            while (resultSet.next()) {
                FSDAOManager.dealWithTableName(string, resultSet, connection);
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage());
        }
    }

    private static void writeDataToNewTable(Connection connection) {
        for (int i2 = JSRoleTableName.JSROLETABLENAMES.length - 1; i2 >= 0; --i2) {
            String string = JSRoleTableName.JSROLETABLENAMES[i2];
            FSDAOManager.writeDataToNewTable(string, connection);
        }
    }

    private static void writeModuleDataToNewTable(Connection connection) {
        for (String string : CRoleModuleTableName.TABLENAMES) {
            FSDAOManager.writeDataToNewTable(string, connection);
        }
    }

    private static void dealWithTableName(String string, ResultSet resultSet, Connection connection) throws SQLException {
        if (ComparatorUtils.equals(string, "FR_T_JROLE")) {
            CompanyRole companyRole = new CompanyRole(resultSet.getLong("postId"), resultSet.getLong("departmentId"), resultSet.getString("description"));
            companyRole.setId(resultSet.getLong("id"));
            manager.startSession().save(companyRole);
        } else if (ComparatorUtils.equals(string, "FR_T_SROLE")) {
            CustomRole customRole = new CustomRole(resultSet.getString("rolename"), resultSet.getString("description"));
            customRole.setId(resultSet.getLong("id"));
            manager.startSession().save(customRole);
        } else if (ComparatorUtils.equals(string, "FR_T_JROLEENTRYPRIVILEGE")) {
            CompanyRoleEntryPrivilege companyRoleEntryPrivilege = new CompanyRoleEntryPrivilege(resultSet.getLong("roleId"), resultSet.getInt("type"), resultSet.getLong("entryid"), 1L, 0L, 0L);
            companyRoleEntryPrivilege.setId(resultSet.getLong("id"));
            manager.startSession().save(companyRoleEntryPrivilege);
        } else if (ComparatorUtils.equals(string, "FR_T_SROLEENTRYPRIVILEGE")) {
            CustomRoleEntryPrivilege customRoleEntryPrivilege = new CustomRoleEntryPrivilege(resultSet.getLong("roleId"), resultSet.getInt("type"), resultSet.getLong("entryid"), 1L, 0L, 0L);
            customRoleEntryPrivilege.setId(resultSet.getLong("id"));
            manager.startSession().save(customRoleEntryPrivilege);
        } else if (ComparatorUtils.equals(string, "FR_T_JROLE_MODULE")) {
            long l2 = resultSet.getLong("id");
            long l3 = resultSet.getLong("jroleId");
            long l4 = resultSet.getLong("moduleId");
            Insert insert = new Insert(new Table("FR_T_COMPANYROLE_MODULE"));
            insert.addColumn("id", 4, new Long(l2));
            insert.addColumn("companyroleId", 4, new Long(l3));
            insert.addColumn("moduleId", 4, new Long(l4));
            insert.execute(connection);
        } else if (ComparatorUtils.equals(string, "FR_T_MODULE_SROLE")) {
            long l5 = resultSet.getLong("id");
            long l6 = resultSet.getLong("sroleId");
            long l7 = resultSet.getLong("moduleId");
            Insert insert = new Insert(new Table("FR_T_CUSTOMROLE_MODULE"));
            insert.addColumn("id", 4, new Long(l5));
            insert.addColumn("customroleId", 4, new Long(l6));
            insert.addColumn("moduleId", 4, new Long(l7));
            insert.execute(connection);
        } else if (ComparatorUtils.equals(string, "FR_T_SROLE_USER")) {
            long l8 = resultSet.getLong("id");
            long l9 = resultSet.getLong("sroleId");
            long l10 = resultSet.getLong("userId");
            Insert insert = new Insert(new Table("FR_T_CUSTOMROLE_USER"));
            insert.addColumn("id", 4, new Long(l8));
            insert.addColumn("customroleId", 4, new Long(l9));
            insert.addColumn("userId", 4, new Long(l10));
            insert.execute(connection);
        } else if (ComparatorUtils.equals(string, "FR_T_COMPANYROLE_MODULE")) {
            long l11 = resultSet.getLong("companyroleId");
            long l12 = resultSet.getLong("moduleid");
            Insert insert = new Insert(new Table("FR_T_CompanyRoleModulePrivilege"));
            insert.addColumn("roleid", -5, new Long(l11));
            insert.addColumn("moduleid", -5, new Long(l12));
            insert.addColumn("view", -5, new Long(1L));
            insert.addColumn("authorized", -5, new Long(0L));
            insert.execute(connection);
        } else if (ComparatorUtils.equals(string, "FR_T_CUSTOMROLE_MODULE")) {
            long l13 = resultSet.getLong("customroleId");
            long l14 = resultSet.getLong("moduleid");
            Insert insert = new Insert(new Table("FR_T_CustomRoleModulePrivilege"));
            insert.addColumn("roleid", -5, new Long(l13));
            insert.addColumn("moduleid", -5, new Long(l14));
            insert.addColumn("view", -5, new Long(1L));
            insert.addColumn("authorized", -5, new Long(0L));
            insert.execute(connection);
        }
    }

    private static void deletJSRoleTable(Connection connection) {
        int n2;
        String[] stringArray = new String[JSRoleTableName.JSROLETABLENAMES.length + 2];
        stringArray[0] = "FR_T_JROLE_PROCESSOB";
        stringArray[1] = "FR_T_PROCESSOB_SROLE";
        for (n2 = 2; n2 < JSRoleTableName.JSROLETABLENAMES.length + 2; ++n2) {
            stringArray[n2] = JSRoleTableName.JSROLETABLENAMES[n2 - 2];
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string = "drop table " + stringArray[n2];
            try {
                Statement statement = connection.createStatement();
                statement.execute(string);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void dealWithUnnecessaryModules(Connection connection) {
        Table table = new Table("FR_T_MODULE");
        Where where = new Where();
        where.addColumn("ID", 13);
        Update update = new Update(table, where, DialectFactory.generateDialect(connection));
        update.addColumn("PARENTID", -5, 0);
        try {
            update.execute(connection);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                manager = null;
            }
        });
    }

    private static class CRoleModuleTableName {
        public static final String[] TABLENAMES = new String[]{"FR_T_COMPANYROLE_MODULE", "FR_T_CUSTOMROLE_MODULE"};

        private CRoleModuleTableName() {
        }
    }

    private static class CRoleEntryTableName {
        public static final String[] TABLENAMES = new String[]{"FR_T_CompanyRoleEntryPrivilege", "FR_T_CustomRoleEntryPrivilege"};

        private CRoleEntryTableName() {
        }
    }

    private static class EntryTableName {
        public static final String[] ENTRYTABLENAMES = new String[]{"fr_folderentry", "fr_analysisentry", "fr_bireportentry", "fr_fastqueryentry", "fr_fileentry", "fr_processentry", "fr_reportletentry", "fr_urlentry", "fr_reportprocessentry"};

        private EntryTableName() {
        }
    }

    private static class JSRoleTableName {
        public static final String[] JSROLETABLENAMES = new String[]{"FR_T_JROLEENTRYPRIVILEGE", "FR_T_SROLEENTRYPRIVILEGE", "FR_T_JROLE_MODULE", "FR_T_MODULE_SROLE", "FR_T_SROLE_USER", "FR_T_JROLE", "FR_T_SROLE"};

        private JSRoleTableName() {
        }
    }
}

