/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DAOSession;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.dao.FSDAO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HSQLDepartmentDAO
extends FSDAO
implements DepartmentDAO {
    private static HSQLDepartmentDAO SC;

    public static HSQLDepartmentDAO getInstance() {
        if (SC == null) {
            SC = new HSQLDepartmentDAO();
        }
        return SC;
    }

    private HSQLDepartmentDAO() {
    }

    public void save(Department department) throws Exception {
        this.createSession().save(department);
    }

    public boolean delete(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        return this.deleteByID(department.getId());
    }

    public boolean deleteByID(long l2) throws Exception {
        boolean bl;
        if (l2 < 0L) {
            return false;
        }
        DAOSession dAOSession = null;
        try {
            dAOSession = this.createSession();
            dAOSession.beginTransaction();
            boolean bl2 = dAOSession.deleteByPrimaryKey(Department.class, l2);
            dAOSession.commit();
            bl = bl2;
            Object var7_6 = null;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dAOSession);
                throw exception;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.closeSession(dAOSession);
                throw throwable;
            }
        }
        this.closeSession(dAOSession);
        return bl;
    }

    public Department findByID(long l2) throws Exception {
        return (Department)this.createSession().load(Department.class, l2);
    }

    public List findAll() throws Exception {
        return this.createSession().list(Department.class);
    }

    public boolean updateDepartmentName(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(Department.class, l2, hashMap);
    }

    public Department findByNameAndPid(String string, long l2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("pid", l2);
        List list = this.createSession().listByFieldValues(Department.class, hashMap);
        if (!list.isEmpty()) {
            return (Department)list.get(0);
        }
        return null;
    }

    public Iterator getUserAndPostIterator(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), EntityDAOConstants.DEPARTMENT.USER_POST_RELATION_MAPPER, Department.class, new Long(l2));
        return dAOHashSet.iterator(bl);
    }
}

