/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache.tabledata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.bi.fs.BIReportNode;
import com.fr.bi.fs.TableDataBIReportNode;
import com.fr.bi.fs.TableDataBISharedReportNode;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.RecursionTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSContext;
import com.fr.fs.PlateFactory;
import com.fr.fs.adhoc.ADHOCReportNode;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CompanyRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CompanyRoleESPrivilege;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CompanyRoleModulePrivilege;
import com.fr.fs.base.entity.CompanyRoleTemplatePrivilege;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.tabledata.TableDataADHOCReportNode;
import com.fr.fs.cache.tabledata.TableDataDAOBean;
import com.fr.fs.cache.tabledata.TableDataFavoriteNode;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataSRole_User;
import com.fr.fs.cache.tabledata.TableDataTask;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.dao.TaskInfoUser;
import com.fr.fs.web.FSConstants;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataSyncDB {
    private static final long DEFAULT_PID = -1L;
    public static final long SYNCROLEIDSTARTINGID = -1000L;
    private static TableDataSyncDB tdc;
    private static Department ALL_DEPARTMENT;
    private Map deparIdMap = new HashMap();
    private Set excludeIdMap = new HashSet();
    private Map unrepeatUseridMap = new HashMap();
    private Set companyRoleIdGen = new HashSet();
    private Map tdUser_idListMap = new Hashtable();
    private Map tdUser_NameListMap = new Hashtable();
    private Map dp_idMap = new Hashtable();
    private Map dp_nameMap = new Hashtable();
    private Map id_postMap = new Hashtable();
    private Map customRoleIDListMap = new Hashtable();
    private Map customRoleNameListMap = new Hashtable();
    private Map customRoleUserIDMap = new Hashtable();
    private Map customRolePrivilegeIDMap = new Hashtable();
    private Map customRoleESPrivilegeIDMap = new Hashtable();
    private Map customRoleModuleIDMap = new Hashtable();
    private Map customRolePlateIDMap = new HashMap();
    private Map customRoleDepAndCRoleIDMap = new HashMap();
    private Map customRoleTemplateIDMap = new HashMap();
    private Map customRoleDataConnectionIDMap = new HashMap();
    private Map tmpCompanyRoleIDListMap = new Hashtable();
    private Map companyRoleIDListMap = new Hashtable();
    private Map companyRolePrivilegeIDMap = new Hashtable();
    private Map companyRoleESPrivilegeIDMap = new Hashtable();
    private Map companyRoleModuleIDMap = new Hashtable();
    private Map companyRolePlateIDMap = new HashMap();
    private Map companyRoleDepAndCRoleIDMap = new HashMap();
    private Map companyRoleTemplateIDMap = new HashMap();
    private Map companyRoleDataConnectionIDMap = new HashMap();
    private Map tdFavorite_idMap = new Hashtable();
    private Map tdTask_idMap = new Hashtable();
    private Map tdADHOCReport_idMap = new Hashtable();
    private Map tdBIReport_idMap = new Hashtable();
    private Map tdBISharedReport_idMap = new Hashtable();
    private Map<Long, Set<RelationObject>> roleObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private Map<Long, Set<RelationObject>> roleNonObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private static volatile long reInitTime;
    private final Object lock = new Object();
    private long initGapTime = 10000L;
    private Set noPidDepSet = new HashSet();

    private TableDataSyncDB() {
    }

    public static synchronized TableDataSyncDB getInstance() {
        if (tdc == null) {
            tdc = new TableDataSyncDB();
        }
        return tdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit() throws Exception {
        Map map = this.tdUser_idListMap;
        synchronized (map) {
            this.customRoleIDListMap.clear();
            this.customRoleNameListMap.clear();
            this.customRoleUserIDMap.clear();
            this.customRolePrivilegeIDMap.clear();
            this.customRoleESPrivilegeIDMap.clear();
            this.customRoleModuleIDMap.clear();
            this.customRoleTemplateIDMap.clear();
            this.customRoleDataConnectionIDMap.clear();
            this.initCustomRole();
            this.initUser();
            this.companyRolePrivilegeIDMap.clear();
            this.companyRoleESPrivilegeIDMap.clear();
            this.companyRoleModuleIDMap.clear();
            this.companyRoleDepAndCRoleIDMap.clear();
            this.companyRoleTemplateIDMap.clear();
            this.companyRoleDataConnectionIDMap.clear();
            this.initCompanyRolePrivilege();
            this.roleObjSet_idMap.clear();
            this.roleNonObjSet_idMap.clear();
            this.tdFavorite_idMap.clear();
            this.initFavorite();
            this.tdADHOCReport_idMap.clear();
            this.initADHOCReport();
            this.tdBIReport_idMap.clear();
            this.initBIReport();
            this.tdBISharedReport_idMap.clear();
            this.initBISharedReport();
            this.tdTask_idMap.clear();
            this.initTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRolePlateIDMap() {
        HashMap hashMap;
        String string;
        Iterator<String> iterator;
        Map map = this.customRolePlateIDMap;
        synchronized (map) {
            iterator = PlateFactory.plateNameIterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                hashMap = new HashMap();
                this.initRole_privilege(TableDataDAOControl.getInstance().getCustomRoleTableDataByPlateName(string), hashMap, true);
                this.customRolePlateIDMap.put(string, hashMap);
            }
        }
        map = this.companyRolePlateIDMap;
        synchronized (map) {
            iterator = PlateFactory.plateNameIterator();
            while (iterator.hasNext()) {
                string = iterator.next().toString();
                hashMap = new HashMap();
                this.initRole_privilege(TableDataDAOControl.getInstance().getCompanyRoleTableDataByPlateName(string), hashMap, true);
                this.companyRolePlateIDMap.put(string, hashMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADHOCReport() {
        Map map = this.tdADHOCReport_idMap;
        synchronized (map) {
            if (this.tdADHOCReport_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getADHOCReportTabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                    TableDataADHOCReportNode tableDataADHOCReportNode = new TableDataADHOCReportNode(l2);
                    tableDataADHOCReportNode.setUserName(embeddedTableData.getValueAt(i2, 1).toString());
                    tableDataADHOCReportNode.setPath(embeddedTableData.getValueAt(i2, 2).toString());
                    tableDataADHOCReportNode.setReportName(embeddedTableData.getValueAt(i2, 3).toString());
                    Object object = embeddedTableData.getValueAt(i2, 5);
                    if (object != Primitive.NULL && object != null) {
                        tableDataADHOCReportNode.setDescription(object.toString());
                    }
                    this.tdADHOCReport_idMap.put(l2, tableDataADHOCReportNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBIReport() {
        Map map = this.tdBIReport_idMap;
        synchronized (map) {
            if (this.tdBIReport_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getBIReportTabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                        TableDataBIReportNode tableDataBIReportNode = new TableDataBIReportNode(l2);
                        tableDataBIReportNode.setUserName(embeddedTableData.getValueAt(i2, 1).toString());
                        tableDataBIReportNode.setPath(embeddedTableData.getValueAt(i2, 2).toString());
                        tableDataBIReportNode.setReportName(embeddedTableData.getValueAt(i2, 3).toString());
                        tableDataBIReportNode.setCreateTime(new Date(Long.parseLong((String)embeddedTableData.getValueAt(i2, 4))));
                        tableDataBIReportNode.setModifyTime(new Date(Long.parseLong((String)embeddedTableData.getValueAt(i2, 5))));
                        Object object = embeddedTableData.getValueAt(i2, 7);
                        if (object != Primitive.NULL && object != null) {
                            tableDataBIReportNode.setDescription(object.toString());
                        }
                        this.tdBIReport_idMap.put(l2, tableDataBIReportNode);
                        continue;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBISharedReport() {
        Map map = this.tdBISharedReport_idMap;
        synchronized (map) {
            if (this.tdBISharedReport_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getBISharedReportTableData();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                        TableDataBISharedReportNode tableDataBISharedReportNode = new TableDataBISharedReportNode(l2);
                        tableDataBISharedReportNode.setTemplateId(new Long(embeddedTableData.getValueAt(i2, 1).toString()));
                        tableDataBISharedReportNode.setUserId(new Long(embeddedTableData.getValueAt(i2, 2).toString()));
                        this.tdBISharedReport_idMap.put(l2, tableDataBISharedReportNode);
                        continue;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFavorite() {
        Map map = this.tdFavorite_idMap;
        synchronized (map) {
            if (this.tdFavorite_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getFavoriteNodeTableData();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                    TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(l2);
                    tableDataFavoriteNode.setUserName(embeddedTableData.getValueAt(i2, 1).toString());
                    tableDataFavoriteNode.setType((Integer)embeddedTableData.getValueAt(i2, 2));
                    tableDataFavoriteNode.setEntryid(Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString()));
                    this.tdFavorite_idMap.put(l2, tableDataFavoriteNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTask() {
        Map map = this.tdTask_idMap;
        synchronized (map) {
            if (this.tdTask_idMap.isEmpty()) {
                EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getTaskTabledata();
                int n2 = embeddedTableData.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
                    TableDataTask tableDataTask = new TableDataTask();
                    tableDataTask.setId(l2);
                    tableDataTask.setUserName(embeddedTableData.getValueAt(i2, 1).toString());
                    tableDataTask.setTaskInfoId((Long)embeddedTableData.getValueAt(i2, 2));
                    this.tdTask_idMap.put(l2, tableDataTask);
                }
            }
        }
    }

    private void clearUserMap() {
        this.tdUser_idListMap.clear();
        this.tdUser_NameListMap.clear();
        this.dp_idMap.clear();
        this.dp_nameMap.clear();
        this.id_postMap.clear();
        this.tmpCompanyRoleIDListMap.clear();
        this.companyRoleIDListMap.clear();
        this.companyRoleIdGen.clear();
        this.noPidDepSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUser() throws Exception {
        Map map = this.tdUser_idListMap;
        synchronized (map) {
            this.clearUserMap();
            this.initCompanyRole();
            this.addDepartOrPostAll();
            if (this.tdUser_idListMap.isEmpty() && TableDataDAOControl.getInstance().hasSetTableDataSync()) {
                Object object;
                TableData tableData = DatasourceManager.getInstance().getTableData(TableDataDAOControl.getInstance().getDsName());
                int n2 = TableDataDAOControl.getInstance().getUserNameIndex();
                int n3 = TableDataDAOControl.getInstance().getPasswordIndex();
                int n4 = TableDataDAOControl.getInstance().getDepartmentIndex();
                int n5 = TableDataDAOControl.getInstance().getPostIndex();
                int n6 = TableDataDAOControl.getInstance().getRoleIndex();
                int n7 = TableDataDAOControl.getInstance().getNameIndex();
                int n8 = TableDataDAOControl.getInstance().getEmailIndex();
                int n9 = TableDataDAOControl.getInstance().getMobileIndex();
                boolean bl = n7 > -1;
                boolean bl2 = n8 > -1;
                boolean bl3 = n9 > -1;
                boolean bl4 = n6 > -1;
                boolean bl5 = n5 > -1;
                boolean bl6 = n4 > -1;
                DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
                boolean bl7 = tableData instanceof RecursionTableData;
                int n10 = dataModel.getRowCount();
                for (int i2 = 0; i2 < n10; ++i2) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5 = dataModel.getValueAt(i2, n3);
                    object = dataModel.getValueAt(i2, n2).toString();
                    TableDataUser tableDataUser = new TableDataUser(this.generateUnreportUserid((String)object), (String)object, object5 != null ? object5.toString() : "");
                    if (bl) {
                        object4 = dataModel.getValueAt(i2, n7);
                        tableDataUser.setName(object4 != null ? object4.toString() : "");
                    }
                    if (bl2) {
                        object4 = dataModel.getValueAt(i2, n8);
                        tableDataUser.setEmail(object4 != null ? object4.toString() : "");
                    }
                    if (bl3) {
                        object4 = dataModel.getValueAt(i2, n9);
                        tableDataUser.setMobile(object4 != null ? object4.toString() : "");
                    }
                    if (bl6 && bl5) {
                        object4 = dataModel.getValueAt(i2, n4);
                        object3 = dataModel.getValueAt(i2, n5);
                        if (object4 != null && object3 != null) {
                            object2 = object4.toString();
                            String string = object3.toString();
                            Department department = new Department((String)object2, "", -1L);
                            Object object6 = object2;
                            if (bl7) {
                                int n11 = ((RecursionTableData)tableData).getMarkFieldIndex();
                                object6 = dataModel.getValueAt(i2, n11).toString();
                                this.initRecursionTableDataDepartment(department, (RecursionTableData)tableData, (RecursionDataModel)dataModel, i2);
                                if (this.dp_idMap.get(department.getPid()) == null) {
                                    this.noPidDepSet.add(department.getId());
                                }
                                this.dp_idMap.put(department.getId(), department);
                                this.dp_nameMap.put(department.getName(), department);
                                this.saveDepartmentPost(department, (String)object6, FSConstants.COMPANYROLE.POST_ALL_NAME);
                            } else if (!this.dp_nameMap.containsKey(object2)) {
                                long l2 = new Long(this.dp_idMap.size());
                                department.setId(l2);
                                this.dp_idMap.put(department.getId(), department);
                                this.dp_nameMap.put(department.getName(), department);
                                this.saveDepartmentPost(department, (String)object6, FSConstants.COMPANYROLE.POST_ALL_NAME);
                            } else {
                                department = (Department)this.dp_nameMap.get(object2);
                            }
                            if (!this.id_postMap.containsKey(string)) {
                                this.id_postMap.put(string, new Long(this.id_postMap.size()));
                                this.saveDepartmentPost(ALL_DEPARTMENT, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, string);
                            }
                            this.saveDepartmentPost(department, (String)object6, string);
                            tableDataUser.setDepartmentValue((String)object2);
                            tableDataUser.setDepartmentPid(department.getPid());
                            tableDataUser.setPostValue(string);
                            tableDataUser.addJob((String)object2, string, department.getPid());
                        }
                    }
                    if (bl4 && (object4 = dataModel.getValueAt(i2, n6)) != null && StringUtils.isNotBlank(object4.toString())) {
                        object3 = object4.toString();
                        object2 = new CustomRole((String)object3, null);
                        long l3 = this.generateNegativeID(this.customRoleIDListMap);
                        if (!this.customRoleNameListMap.containsKey(object3)) {
                            ((DAOBean)object2).setId(l3);
                            this.customRoleIDListMap.put(l3, object2);
                            this.customRoleNameListMap.put(object3, object2);
                        } else {
                            object2 = (CustomRole)this.customRoleNameListMap.get(object3);
                        }
                        long l4 = this.generateID(this.customRoleUserIDMap);
                        TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l4, ((DAOBean)object2).getId(), tableDataUser.getUserName());
                        this.customRoleUserIDMap.put(l4, tableDataSRole_User);
                        tableDataUser.setRoleValue((String)object3);
                        tableDataUser.addSrole((String)object3);
                    }
                    if ((object3 = (TableDataUser)this.tdUser_NameListMap.get(object4 = tableDataUser.getUserName())) == null) {
                        this.tdUser_NameListMap.put(object4, tableDataUser);
                        this.tdUser_idListMap.put(tableDataUser.getId(), tableDataUser);
                        continue;
                    }
                    object2 = (TableDataUser)this.tdUser_NameListMap.get(tableDataUser.getUserName());
                    if (bl6) {
                        ((TableDataUser)object2).addJob(tableDataUser.getDepartmentValue(), tableDataUser.getPostValue(), tableDataUser.getDepartmentPid());
                    }
                    if (bl4) {
                        ((TableDataUser)object2).addSrole(tableDataUser.getRoleValue());
                    }
                    this.tdUser_NameListMap.put(tableDataUser.getUserName(), object2);
                    this.tdUser_idListMap.put(new Long(((TableDataDAOBean)object2).getId()), object2);
                }
                Iterator iterator = this.noPidDepSet.iterator();
                while (iterator.hasNext()) {
                    long l5 = (Long)iterator.next();
                    object = (Department)this.dp_idMap.get(l5);
                    if (object == null || this.dp_idMap.get(((Department)object).getPid()) != null) continue;
                    ((Department)object).setPid(-1L);
                }
                TableDataDAOControl.getInstance().writeJRoleTableData(this.companyRoleIDListMap.entrySet().iterator());
            }
        }
    }

    private void saveDepartmentPost(Department department, String string, String string2) {
        long l2 = this.generateCompanyRoleID(this.companyRoleIdGen);
        TableDataJRole tableDataJRole = new TableDataJRole(l2);
        tableDataJRole.setDpName(department.getName());
        tableDataJRole.setDpMarkValue(string);
        tableDataJRole.setDpId(department.getId());
        tableDataJRole.setPostName(string2);
        Iterator iterator = this.tmpCompanyRoleIDListMap.entrySet().iterator();
        TableDataDAOBean tableDataDAOBean = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataJRole tableDataJRole2 = (TableDataJRole)entry.getValue();
            if (tableDataJRole2.getDpMarkValue() == null && ComparatorUtils.equals(department.getName(), tableDataJRole2.getDpName())) {
                tableDataJRole2.setDpMarkValue(department.getName());
            }
            if (!ComparatorUtils.equals(string, tableDataJRole2.getDpMarkValue()) || !ComparatorUtils.equals(string2, tableDataJRole2.getPostName())) continue;
            tableDataDAOBean = tableDataJRole2;
            break;
        }
        if (tableDataDAOBean != null) {
            tableDataJRole.setId(tableDataDAOBean.getId());
        } else {
            this.companyRoleIdGen.add(tableDataJRole.getId());
        }
        this.companyRoleIDListMap.put(tableDataJRole.getId(), tableDataJRole);
        this.excludeIdMap.add(department.getId());
    }

    private long generateCompanyRoleID(Set set) {
        long l2 = 1L;
        while (set.contains(new Long(l2))) {
            ++l2;
        }
        return l2;
    }

    private Long generateUnreportUserid(String string) {
        Long l2 = (Long)this.unrepeatUseridMap.get(string);
        if (l2 == null) {
            l2 = new Long(this.unrepeatUseridMap.size() + 1);
            this.unrepeatUseridMap.put(string, l2);
        }
        return l2;
    }

    private void addDepartOrPostAll() {
        this.dp_idMap.put(ALL_DEPARTMENT.getId(), ALL_DEPARTMENT);
        this.dp_nameMap.put(ALL_DEPARTMENT.getName(), ALL_DEPARTMENT);
        this.id_postMap.put(FSConstants.COMPANYROLE.POST_ALL_NAME, new Long(this.id_postMap.size()));
        this.saveDepartmentPost(ALL_DEPARTMENT, ALL_DEPARTMENT.getName(), FSConstants.COMPANYROLE.POST_ALL_NAME);
    }

    public void initRecursionTableDataDepartment(Department department, RecursionTableData recursionTableData, RecursionDataModel recursionDataModel, int n2) throws Exception {
        int n3 = recursionDataModel.getMarkField();
        int n4 = recursionDataModel.getParentMarkField();
        if (n4 < 0) {
            String string = recursionDataModel.getValueAt(n2, n3).toString();
            String string2 = recursionDataModel.getParentValue(n2);
            if (StringUtils.isEmpty(string2)) {
                string2 = "-1";
            }
            department.setId(this.genIdFromString(string));
            department.setPid(this.genIdFromString(string2));
        } else {
            String string;
            String string3 = recursionDataModel.getValueAt(n2, n3).toString();
            Object object = recursionDataModel.getValueAt(n2, n4);
            String string4 = string = object == null ? "-1" : object.toString();
            if (StringUtils.isEmpty(string)) {
                string = "-1";
            }
            department.setId(this.genIdFromString(string3));
            department.setPid(this.genIdFromString(string));
        }
    }

    private long genIdFromString(String string) {
        try {
            long l2 = Long.parseLong(string);
            if (!this.excludeIdMap.contains(l2)) {
                this.deparIdMap.put(string, new Long(l2));
                return l2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Long l3 = (Long)this.deparIdMap.get(string);
        if (l3 != null) {
            return l3;
        }
        long l4 = this.deparIdMap.size() + 1;
        while (this.deparIdMap.containsValue(new Long(l4))) {
            ++l4;
        }
        this.excludeIdMap.add(new Long(l4));
        this.deparIdMap.put(string, new Long(l4));
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCustomRole() {
        Object object;
        Object object2;
        Object object3;
        Long l2;
        int n2;
        int n3;
        EmbeddedTableData embeddedTableData;
        Map map = this.customRoleNameListMap;
        synchronized (map) {
            embeddedTableData = TableDataDAOControl.getInstance().getSRoleTableData();
            n3 = embeddedTableData.getRowCount();
            for (n2 = 0; n2 < n3; ++n2) {
                l2 = new Long(embeddedTableData.getValueAt(n2, 0).toString());
                object3 = new CustomRole(l2);
                object2 = embeddedTableData.getValueAt(n2, 1);
                if (object2 == null || StringUtils.isBlank(object2.toString())) continue;
                ((CustomRole)object3).setRolename(object2.toString());
                object = embeddedTableData.getValueAt(n2, 2);
                if (object != Primitive.NULL && object != null) {
                    ((CustomRole)object3).setDescription(object.toString());
                }
                this.customRoleIDListMap.put(l2, object3);
                this.customRoleNameListMap.put(((CustomRole)object3).getRolename(), object3);
            }
        }
        map = this.customRoleUserIDMap;
        synchronized (map) {
            embeddedTableData = TableDataDAOControl.getInstance().getSRole_UserTableData();
            n3 = embeddedTableData.getRowCount();
            for (n2 = 0; n2 < n3; ++n2) {
                l2 = new Long(embeddedTableData.getValueAt(n2, 0).toString());
                object3 = new Long(embeddedTableData.getValueAt(n2, 1).toString());
                object2 = embeddedTableData.getValueAt(n2, 2).toString();
                object = new TableDataSRole_User(l2, (Long)object3, (String)object2);
                this.customRoleUserIDMap.put(l2, object);
            }
        }
        map = this.customRolePrivilegeIDMap;
        synchronized (map) {
            this.initRole_privilege(TableDataDAOControl.getInstance().getSRolePrivilegeTableData(), this.customRolePrivilegeIDMap, false);
        }
        map = this.customRoleESPrivilegeIDMap;
        synchronized (map) {
            this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getSRoleESPrivilegeTableData(), this.customRoleESPrivilegeIDMap, false);
        }
        map = this.customRoleModuleIDMap;
        synchronized (map) {
            this.initRole_Moduleprivilege(TableDataDAOControl.getInstance().getSRole_ModuleTableData(), this.customRoleModuleIDMap, false);
        }
        map = this.customRoleDepAndCRoleIDMap;
        synchronized (map) {
            this.initRole_DepAndCRoleprivilege(TableDataDAOControl.getInstance().getCustomRoleDepAndCRolePrivilegeTableData(), this.customRoleDepAndCRoleIDMap, false);
        }
        map = this.customRoleTemplateIDMap;
        synchronized (map) {
            this.initRole_TmplatePrivilege(TableDataDAOControl.getInstance().getSRoleTemplatePrivilegeTableData(), this.customRoleTemplateIDMap, false);
        }
        map = this.customRoleDataConnectionIDMap;
        synchronized (map) {
            this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getSRoleDataConnectionPrivilegeTableData(), this.customRoleDataConnectionIDMap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCompanyRole() {
        Map map = this.tmpCompanyRoleIDListMap;
        synchronized (map) {
            EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getJRoleTableData();
            int n2 = embeddedTableData.getRowCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                Object object2;
                Long l2 = new Long((String)embeddedTableData.getValueAt(i2, 0));
                TableDataJRole tableDataJRole = new TableDataJRole(l2);
                Object object3 = embeddedTableData.getValueAt(i2, 1);
                Object object4 = embeddedTableData.getValueAt(i2, 2);
                if (object3 == null || object4 == null) continue;
                tableDataJRole.setDpName(object3.toString());
                tableDataJRole.setPostName(object4.toString());
                Object object5 = embeddedTableData.getValueAt(i2, 3);
                if (object5 != Primitive.NULL && object5 != null) {
                    tableDataJRole.setDescription(object5.toString());
                }
                if ((object2 = embeddedTableData.getValueAt(i2, 4)) != Primitive.NULL && object2 != null) {
                    tableDataJRole.setDpId(Long.valueOf(object2.toString()));
                }
                if ((object = embeddedTableData.getValueAt(i2, 5)) != Primitive.NULL && object != null) {
                    tableDataJRole.setDpMarkValue(object.toString());
                }
                this.tmpCompanyRoleIDListMap.put(l2, tableDataJRole);
                this.companyRoleIdGen.add(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCompanyRolePrivilege() {
        Map map = this.companyRolePrivilegeIDMap;
        synchronized (map) {
            this.initRole_privilege(TableDataDAOControl.getInstance().getJRolePrivilegeTableData(), this.companyRolePrivilegeIDMap, true);
        }
        map = this.companyRoleESPrivilegeIDMap;
        synchronized (map) {
            this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getJRoleESPrivilegeTableData(), this.companyRoleESPrivilegeIDMap, true);
        }
        map = this.companyRoleModuleIDMap;
        synchronized (map) {
            this.initRole_Moduleprivilege(TableDataDAOControl.getInstance().getJRole_ModuleTableData(), this.companyRoleModuleIDMap, true);
        }
        map = this.companyRoleDepAndCRoleIDMap;
        synchronized (map) {
            this.initRole_DepAndCRoleprivilege(TableDataDAOControl.getInstance().getCompanyRoleDepAndCRolePrivilegeTableData(), this.companyRoleDepAndCRoleIDMap, true);
        }
        map = this.companyRoleTemplateIDMap;
        synchronized (map) {
            this.initRole_TmplatePrivilege(TableDataDAOControl.getInstance().getJRoleTemplatePrivilegeTableData(), this.companyRoleTemplateIDMap, true);
        }
        map = this.companyRoleDataConnectionIDMap;
        synchronized (map) {
            this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getJRoleDataConnectionPrivilegeTableData(), this.companyRoleDataConnectionIDMap, true);
        }
    }

    private void initRole_privilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            int n3 = (Integer)embeddedTableData.getValueAt(i2, 2);
            long l4 = Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            long l5 = embeddedTableData.getValueAt(i2, 4) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i2, 4).toString());
            long l6 = embeddedTableData.getValueAt(i2, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 5).toString());
            long l7 = embeddedTableData.getValueAt(i2, 6) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 6).toString());
            RoleEntryPrivilege roleEntryPrivilege = bl ? new CompanyRoleEntryPrivilege(l2) : new CustomRoleEntryPrivilege(l2);
            roleEntryPrivilege.setRoleId(l3);
            roleEntryPrivilege.setType(n3);
            roleEntryPrivilege.setEntryid(l4);
            roleEntryPrivilege.setView(l5);
            roleEntryPrivilege.setAuthorized(l6);
            roleEntryPrivilege.setEdit(l7);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i2, 7) == null ? "" : embeddedTableData.getValueAt(i2, 7).toString();
                ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(string);
            }
            map.put(l2, roleEntryPrivilege);
        }
    }

    private void initRole_Moduleprivilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            long l4 = Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            long l5 = embeddedTableData.getValueAt(i2, 4) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i2, 4).toString());
            long l6 = embeddedTableData.getValueAt(i2, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 5).toString());
            RoleModulePrivilege roleModulePrivilege = bl ? new CompanyRoleModulePrivilege(l2) : new CustomRoleModulePrivilege(l2);
            roleModulePrivilege.setRoleId(l3);
            roleModulePrivilege.setModuleid(l4);
            roleModulePrivilege.setView(l5);
            roleModulePrivilege.setAuthorized(l6);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i2, 6) == null ? "" : embeddedTableData.getValueAt(i2, 6).toString();
                ((CustomRoleModulePrivilege)roleModulePrivilege).setRoleName(string);
            }
            map.put(l2, roleModulePrivilege);
        }
    }

    private void initRole_TmplatePrivilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            String string = embeddedTableData.getValueAt(i2, 2).toString();
            long l4 = embeddedTableData.getValueAt(i2, 3) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            long l5 = embeddedTableData.getValueAt(i2, 4) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 4).toString());
            long l6 = embeddedTableData.getValueAt(i2, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 5).toString());
            RoleTemplatePrivilege roleTemplatePrivilege = bl ? new CompanyRoleTemplatePrivilege(l2) : new CustomRoleTemplatePrivilege(l2);
            roleTemplatePrivilege.setRoleId(l3);
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setPage(l4);
            roleTemplatePrivilege.setWrite(l5);
            roleTemplatePrivilege.setDesign(l6);
            if (!bl) {
                String string2 = embeddedTableData.getValueAt(i2, 6) == null ? "" : embeddedTableData.getValueAt(i2, 6).toString();
                ((CustomRoleTemplatePrivilege)roleTemplatePrivilege).setRoleName(string2);
            }
            map.put(l2, roleTemplatePrivilege);
        }
    }

    private void initRole_DataConnectionPrivilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = Long.parseLong(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            String string = embeddedTableData.getValueAt(i2, 2).toString();
            long l4 = embeddedTableData.getValueAt(i2, 3) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = bl ? new CompanyRoleDataConnectionPrivilege(l2) : new CustomRoleDataConnectionPrivilege(l2);
            roleDataConnectionPrivilege.setRoleId(l3);
            roleDataConnectionPrivilege.setName(string);
            roleDataConnectionPrivilege.setView(l4);
            if (!bl) {
                String string2 = embeddedTableData.getValueAt(i2, 4) == null ? "" : embeddedTableData.getValueAt(i2, 4).toString();
                ((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).setRoleName(string2);
            }
            map.put(l2, roleDataConnectionPrivilege);
        }
    }

    private void initRole_DepAndCRoleprivilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            int n3 = Integer.parseInt(embeddedTableData.getValueAt(i2, 2).toString());
            long l4 = Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = bl ? new CompanyRoleDepAndCRolePrivilege(l2) : new CustomRoleDepAndCRolePrivilege(l2);
            roleDepAndCRolePrivilege.setRoleid(l3);
            roleDepAndCRolePrivilege.setType(n3);
            roleDepAndCRolePrivilege.setDeporcroleid(l4);
            if (!bl) {
                String string = embeddedTableData.getValueAt(i2, 4) == null ? "" : embeddedTableData.getValueAt(i2, 4).toString();
                ((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).setRoleName(string);
            }
            map.put(l2, roleDepAndCRolePrivilege);
        }
    }

    private void initRole_ESPrivilege(EmbeddedTableData embeddedTableData, Map map, boolean bl) {
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = new Long(embeddedTableData.getValueAt(i2, 0).toString());
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            int n3 = (Integer)embeddedTableData.getValueAt(i2, 2);
            long l4 = Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l2) : new CustomRoleESPrivilege(l2);
            roleESPrivilege.setRoleId(l3);
            roleESPrivilege.setType(n3);
            roleESPrivilege.setEntryid(l4);
            map.put(l2, roleESPrivilege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReInit() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (reInitTime == 0L || reInitTime + this.initGapTime < new Date().getTime()) {
                TableDataDAOControl.getInstance().init();
                FSContext.resetDataOn();
                FSContext.initData();
                reInitTime = new Date().getTime();
            }
        }
    }

    public static void release() {
        tdc = null;
    }

    public CustomRole findSRoleBySRoleName(String string) throws CloneNotSupportedException {
        CustomRole customRole = (CustomRole)this.customRoleNameListMap.get(string);
        return customRole == null ? customRole : (CustomRole)customRole.clone();
    }

    public CustomRole findSRoleBySRoleID(long l2) throws CloneNotSupportedException {
        CustomRole customRole = (CustomRole)this.customRoleIDListMap.get(new Long(l2));
        return customRole == null ? customRole : (CustomRole)customRole.clone();
    }

    public Set findSRoleByUserName(String string) throws CloneNotSupportedException {
        Iterator iterator = this.customRoleUserIDMap.entrySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataSRole_User tableDataSRole_User = (TableDataSRole_User)entry.getValue();
            if (!ComparatorUtils.equals(tableDataSRole_User.getUserName(), string)) continue;
            long l2 = tableDataSRole_User.getsRoleId();
            arrayList.add(this.customRoleIDListMap.get(new Long(l2)));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance(new Class[]{CustomRole.class}), false);
    }

    public User findUserByUserId(long l2) {
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            return tableDataUser.getUser();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllUser() {
        TableDataSyncDB tableDataSyncDB = this;
        synchronized (tableDataSyncDB) {
            try {
                this.checkReInit();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
            Iterator iterator = this.tdUser_idListMap.entrySet().iterator();
            ArrayList<User> arrayList = new ArrayList<User>();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TableDataUser tableDataUser = (TableDataUser)entry.getValue();
                arrayList.add(tableDataUser.getUser());
            }
            return arrayList;
        }
    }

    public List getAllTableDataUsers() {
        Iterator iterator = this.tdUser_idListMap.entrySet().iterator();
        ArrayList<TableDataUser> arrayList = new ArrayList<TableDataUser>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataUser tableDataUser = (TableDataUser)entry.getValue();
            arrayList.add(tableDataUser);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserByUserName(String string) {
        TableDataSyncDB tableDataSyncDB = this;
        synchronized (tableDataSyncDB) {
            if (string == null) {
                return null;
            }
            try {
                this.checkReInit();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
            TableDataUser tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(string);
            if (tableDataUser != null) {
                return tableDataUser.getUser();
            }
            return null;
        }
    }

    public Iterator findJobsByUserId(long l2) {
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        return tableDataUser.getJobIterator();
    }

    public String findPostNameById(long l2) {
        for (Map.Entry entry : this.id_postMap.entrySet()) {
            long l3 = (Long)entry.getValue();
            if (l3 != l2) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public Set findUserSetByDpAndpost(Department department, String string) throws CloneNotSupportedException {
        Iterator iterator = this.tdUser_NameListMap.entrySet().iterator();
        HashSet<Long> hashSet = new HashSet<Long>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataUser tableDataUser = (TableDataUser)entry.getValue();
            if (!this.hasDepartAndPost(tableDataUser, department, string)) continue;
            hashSet.add(new Long(tableDataUser.getUser().getId()));
        }
        return hashSet;
    }

    private boolean hasDepartAndPost(TableDataUser tableDataUser, Department department, String string) {
        Iterator iterator = tableDataUser.getJobIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Job job = (Job)iterator.next();
                if (!this.departEqual(job, department) || !this.postEqual(job, string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean departEqual(Job job, Department department) {
        return department == null || ComparatorUtils.equals(job.getDepartmentid(), department.getId());
    }

    private boolean postEqual(Job job, String string) {
        return string == null || ComparatorUtils.equals(job.getPostid(), this.findPostByPostName(string).getId());
    }

    public boolean addSRole(String string, CustomRole customRole) {
        if (customRole == null) {
            return false;
        }
        this.addSRoleToMap(string, customRole);
        return true;
    }

    public boolean addSRole(CustomRole customRole) {
        if (this.customRoleNameListMap.containsKey(customRole.getRolename())) {
            return false;
        }
        customRole.setId(this.generateID(this.customRoleIDListMap));
        this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        this.customRoleIDListMap.put(new Long(customRole.getId()), customRole);
        TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet().iterator());
        return true;
    }

    private long generateID(Map map) {
        long l2 = 1L;
        while (map.get(l2) != null) {
            ++l2;
        }
        return l2;
    }

    private long generateNegativeID(Map map) {
        long l2 = -1000L;
        while (map.get(l2) != null) {
            --l2;
        }
        return l2;
    }

    private void addSRoleToMap(String string, CustomRole customRole) {
        long l2 = this.generateID(this.customRoleUserIDMap);
        TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l2, customRole.getId(), string);
        this.customRoleUserIDMap.put(new Long(l2), tableDataSRole_User);
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet().iterator());
    }

    public boolean removeSRole(String string, CustomRole customRole) {
        for (Map.Entry entry : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = (TableDataSRole_User)entry.getValue();
            if (!ComparatorUtils.equals(string, tableDataSRole_User.getUserName()) || customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            this.customRoleNameListMap.remove(string);
            this.customRoleUserIDMap.remove(entry.getKey());
            break;
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet().iterator());
        return true;
    }

    public boolean removeSRole(CustomRole customRole) {
        this.customRoleNameListMap.remove(customRole.getRolename());
        this.customRoleIDListMap.remove(new Long(customRole.getId()));
        this.removeUsersFromSRole(customRole);
        this.saveSRole();
        return true;
    }

    private void removeUsersFromSRole(CustomRole customRole) {
        Iterator iterator = this.customRoleUserIDMap.entrySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataSRole_User tableDataSRole_User = (TableDataSRole_User)entry.getValue();
            if (customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(entry.getKey());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.customRoleUserIDMap.remove(iterator.next());
        }
    }

    private void saveSRole() {
        TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet().iterator());
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet().iterator());
    }

    private Set getSetFromList(List list, ClassArrayKey classArrayKey, boolean bl) throws CloneNotSupportedException {
        Iterator iterator = list.iterator();
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        while (iterator.hasNext()) {
            DAOBean[] dAOBeanArray = new DAOBean[]{(DAOBean)((DAOBean)iterator.next()).clone()};
            hashSet.add(RelationObject.getInstance(dAOBeanArray[0].getId(), classArrayKey, dAOBeanArray, bl));
        }
        return hashSet;
    }

    public boolean updateSRoleName(long l2, String string) throws CloneNotSupportedException {
        CustomRole customRole = (CustomRole)this.customRoleIDListMap.get(new Long(l2));
        if (customRole != null && this.findSRoleBySRoleName(string) == null) {
            this.customRoleNameListMap.remove(customRole.getRolename());
            customRole.setRolename(string);
            this.customRoleNameListMap.put(string, customRole);
            TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    public List findAllSRole() throws CloneNotSupportedException {
        Iterator iterator = this.customRoleNameListMap.entrySet().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(((CustomRole)entry.getValue()).clone());
        }
        return arrayList;
    }

    public Set findUserSetBySRoleId(long l2, boolean bl) throws CloneNotSupportedException {
        List list = this.getUserNameListBySRoleId(l2);
        Iterator iterator = list.iterator();
        if (bl) {
            ArrayList<User> arrayList = new ArrayList<User>();
            while (iterator.hasNext()) {
                User user = this.findUserByUserName(iterator.next().toString());
                if (user == null) continue;
                arrayList.add(user);
            }
            return this.getSetFromList(arrayList, ClassArrayKey.getInstance(new Class[]{User.class}), bl);
        }
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        while (iterator.hasNext()) {
            User user = this.findUserByUserName(iterator.next().toString());
            DAOBean[] dAOBeanArray = new User[]{user};
            hashSet.add(RelationObject.getInstance(user.getId(), ClassArrayKey.getInstance(new Class[]{User.class}), dAOBeanArray, bl));
        }
        return hashSet;
    }

    private List getUserNameListBySRoleId(long l2) {
        Iterator iterator = this.customRoleUserIDMap.entrySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataSRole_User tableDataSRole_User = (TableDataSRole_User)entry.getValue();
            if (l2 != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(tableDataSRole_User.getUserName());
        }
        return arrayList;
    }

    public void addUsersToSRole(CustomRole customRole, Set set) {
        Iterator iterator = set.iterator();
        List list = this.getUserNameListBySRoleId(customRole.getId());
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(user.getId()));
            if (tableDataUser == null || list.contains(tableDataUser.getUserName())) continue;
            long l2 = this.generateID(this.customRoleUserIDMap);
            TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l2, customRole.getId(), tableDataUser.getUserName());
            this.customRoleUserIDMap.put(l2, tableDataSRole_User);
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet().iterator());
    }

    public void removeUsersFromSRole(CustomRole customRole, Set set) {
        TableDataDAOBean tableDataDAOBean;
        Iterator<Object> iterator = set.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        while (iterator.hasNext()) {
            User object = (User)iterator.next();
            tableDataDAOBean = (TableDataUser)this.tdUser_idListMap.get(new Long(object.getId()));
            if (tableDataDAOBean == null) continue;
            arrayList.add(((TableDataUser)tableDataDAOBean).getUserName());
        }
        for (Map.Entry entry : this.customRoleUserIDMap.entrySet()) {
            tableDataDAOBean = (TableDataSRole_User)entry.getValue();
            if (!arrayList.contains(((TableDataSRole_User)tableDataDAOBean).getUserName())) continue;
            arrayList2.add(entry.getKey());
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            this.customRoleUserIDMap.remove(iterator.next());
        }
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet().iterator());
    }

    public Post findPostById(long l2) {
        String string = this.findPostNameById(l2);
        if (string != null) {
            Post post = new Post(l2);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    public List findAllPost() {
        ArrayList<Post> arrayList = new ArrayList<Post>();
        for (Map.Entry entry : this.id_postMap.entrySet()) {
            Post post = new Post((Long)entry.getValue());
            post.setPostname(entry.getKey().toString());
            arrayList.add(post);
        }
        return arrayList;
    }

    public Post findPostByPostName(String string) {
        Long l2 = (Long)this.id_postMap.get(string);
        if (l2 != null) {
            Post post = new Post(l2);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    public Department findDepartmentByID(long l2) {
        return (Department)this.dp_idMap.get(l2);
    }

    public List findAllDepartment() throws CloneNotSupportedException {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        for (Map.Entry entry : this.dp_idMap.entrySet()) {
            Department department = (Department)((Department)entry.getValue()).clone();
            arrayList.add(department);
        }
        return arrayList;
    }

    public Department findDepartmentByDPNameAndPid(String string, long l2) throws CloneNotSupportedException {
        for (Department department : this.dp_idMap.values()) {
            if (!ComparatorUtils.equals(department.getName(), string) || !ComparatorUtils.equals(department.getPid(), l2)) continue;
            return department;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator findUserAndPostIterator(long l2, boolean bl) {
        Set<RelationObject> set;
        Set<RelationObject> set2 = set = bl ? this.roleObjSet_idMap.get(l2) : this.roleNonObjSet_idMap.get(l2);
        if (set == null) {
            Map map = this.tdUser_idListMap;
            synchronized (map) {
                set = this.findDeptRoleSet(l2, bl);
                if (bl) {
                    this.roleObjSet_idMap.put(l2, set);
                } else {
                    this.roleNonObjSet_idMap.put(l2, set);
                }
            }
        }
        return set.iterator();
    }

    private Set<RelationObject> findDeptRoleSet(long l2, boolean bl) {
        Department department = this.findDepartmentByID(l2);
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        if (department != null) {
            for (Map.Entry entry : this.tdUser_idListMap.entrySet()) {
                TableDataUser tableDataUser = (TableDataUser)entry.getValue();
                Iterator iterator = tableDataUser.getJobIterator();
                while (iterator.hasNext()) {
                    Job job = (Job)iterator.next();
                    if (l2 != job.getDepartmentid()) continue;
                    Post post = this.findPostById(job.getPostid());
                    User user = tableDataUser.getUser();
                    if (post == null || user == null) continue;
                    DAOBean[] dAOBeanArray = new DAOBean[]{post, user};
                    hashSet.add(RelationObject.getInstance(tableDataUser.getId(), ClassArrayKey.getInstance(new Class[]{Post.class, User.class}), dAOBeanArray, bl));
                }
            }
        }
        return hashSet;
    }

    public void saveTask(TaskInfoUser taskInfoUser) {
        long l2 = this.generateID(this.tdTask_idMap);
        taskInfoUser.setId(l2);
        long l3 = taskInfoUser.getUserID();
        User user = this.findUserByUserId(l3);
        if (user != null) {
            TableDataTask tableDataTask = new TableDataTask(user.getUsername(), taskInfoUser);
            this.tdTask_idMap.put(new Long(l2), tableDataTask);
            TableDataDAOControl.getInstance().writeTaskMap(this.tdTask_idMap.entrySet().iterator());
        }
    }

    public List findTaskByTaskId(long l2) {
        ArrayList<TaskInfoUser> arrayList = new ArrayList<TaskInfoUser>();
        for (Map.Entry entry : this.tdTask_idMap.entrySet()) {
            User user;
            TableDataTask tableDataTask = (TableDataTask)entry.getValue();
            if (l2 != tableDataTask.getTaskInfoId() || (user = this.findUserByUserName(tableDataTask.getUserName())) == null) continue;
            long l3 = user.getId();
            arrayList.add(tableDataTask.getTaskInfoUser(l3));
        }
        return arrayList;
    }

    public List findTaskByUserId(long l2) {
        ArrayList<TaskInfoUser> arrayList = new ArrayList<TaskInfoUser>();
        for (Map.Entry entry : this.tdTask_idMap.entrySet()) {
            TableDataTask tableDataTask = (TableDataTask)entry.getValue();
            User user = this.findUserByUserId(l2);
            if (user == null || !ComparatorUtils.equals(user.getUsername(), tableDataTask.getUserName())) continue;
            arrayList.add(tableDataTask.getTaskInfoUser(l2));
        }
        return arrayList;
    }

    public List findAllTask() {
        ArrayList<TaskInfoUser> arrayList = new ArrayList<TaskInfoUser>();
        for (Map.Entry entry : this.tdTask_idMap.entrySet()) {
            TableDataTask tableDataTask = (TableDataTask)entry.getValue();
            User user = this.findUserByUserName(tableDataTask.getUserName());
            if (user == null) continue;
            long l2 = user.getId();
            arrayList.add(tableDataTask.getTaskInfoUser(l2));
        }
        return arrayList;
    }

    public void saveFavoriteNode(FavoriteNode favoriteNode) {
        long l2 = this.generateID(this.tdFavorite_idMap);
        favoriteNode.setId(l2);
        long l3 = favoriteNode.getUserId();
        User user = this.findUserByUserId(l3);
        if (user != null) {
            TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(user.getUsername(), favoriteNode);
            this.tdFavorite_idMap.put(new Long(l2), tableDataFavoriteNode);
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet().iterator());
        }
    }

    public void removeTask(long l2) {
        this.tdTask_idMap.remove(new Long(l2));
        TableDataDAOControl.getInstance().writeTaskMap(this.tdTask_idMap.entrySet().iterator());
    }

    public FavoriteNode findFavoriteById(long l2) {
        TableDataUser tableDataUser;
        TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)this.tdFavorite_idMap.get(new Long(l2));
        if (tableDataFavoriteNode != null && (tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(tableDataFavoriteNode.getUserName())) != null) {
            return tableDataFavoriteNode.getFavoriteNode(tableDataUser.getId());
        }
        return null;
    }

    public void deleteFavoriteNode(FavoriteNode favoriteNode) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.tdFavorite_idMap.entrySet().iterator();
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(favoriteNode.getUserId()));
        if (tableDataUser != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)entry.getValue();
                if (!ComparatorUtils.equals(tableDataUser.getUserName(), tableDataFavoriteNode.getUserName()) || favoriteNode.getEntryid() != tableDataFavoriteNode.getEntryid()) continue;
                arrayList.add(entry.getKey());
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.tdFavorite_idMap.remove(iterator.next());
        }
        TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet().iterator());
    }

    public List findFavoriteNodes(long l2) {
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        ArrayList<FavoriteNode> arrayList = new ArrayList<FavoriteNode>();
        if (tableDataUser != null) {
            for (Map.Entry entry : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)entry.getValue();
                if (!ComparatorUtils.equals(tableDataUser.getUserName(), tableDataFavoriteNode.getUserName())) continue;
                arrayList.add(tableDataFavoriteNode.getFavoriteNode(l2));
            }
        }
        return arrayList;
    }

    public void deleteFavoriteNode(long l2, int n2, long l3) {
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)entry.getValue();
                if (!ComparatorUtils.equals(tableDataUser.getUserName(), tableDataFavoriteNode.getUserName()) || l3 != tableDataFavoriteNode.getEntryid() || tableDataFavoriteNode.getType() != n2) continue;
                arrayList.add(entry.getKey());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.tdFavorite_idMap.remove(iterator.next());
            }
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet().iterator());
        }
    }

    public void saveADHOCReportNode(ADHOCReportNode aDHOCReportNode) {
        long l2 = aDHOCReportNode.getUserId();
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            long l3 = this.generateID(this.tdADHOCReport_idMap);
            aDHOCReportNode.setId(l3);
            TableDataADHOCReportNode tableDataADHOCReportNode = new TableDataADHOCReportNode(tableDataUser.getUserName(), aDHOCReportNode);
            this.tdADHOCReport_idMap.put(new Long(l3), tableDataADHOCReportNode);
            TableDataDAOControl.getInstance().writeTableDataADHOCReportMap(this.tdADHOCReport_idMap.entrySet().iterator());
        }
    }

    public List findADHOCReportNodeByUserId(long l2) {
        ArrayList<ADHOCReportNode> arrayList = new ArrayList<ADHOCReportNode>();
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            for (Map.Entry entry : this.tdADHOCReport_idMap.entrySet()) {
                TableDataADHOCReportNode tableDataADHOCReportNode = (TableDataADHOCReportNode)entry.getValue();
                if (!ComparatorUtils.equals(tableDataUser.getUserName(), tableDataADHOCReportNode.getUserName())) continue;
                arrayList.add(tableDataADHOCReportNode.getADHOCReportNode(l2));
            }
        }
        return arrayList;
    }

    public ADHOCReportNode findADHOCReportNodeById(long l2) {
        TableDataADHOCReportNode tableDataADHOCReportNode = (TableDataADHOCReportNode)this.tdADHOCReport_idMap.get(new Long(l2));
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(tableDataADHOCReportNode.getUserName());
        if (tableDataADHOCReportNode != null && tableDataUser != null) {
            return tableDataADHOCReportNode.getADHOCReportNode(tableDataUser.getId());
        }
        return null;
    }

    public void deleteADHOCReportNodeById(long l2) {
        this.tdADHOCReport_idMap.remove(new Long(l2));
        TableDataDAOControl.getInstance().writeTableDataADHOCReportMap(this.tdADHOCReport_idMap.entrySet().iterator());
    }

    public void saveOrUpdateBIReportNode(BIReportNode bIReportNode) {
        long l2 = bIReportNode.getUserId();
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            long l3 = bIReportNode.getId() < 0L ? this.generateID(this.tdBIReport_idMap) : bIReportNode.getId();
            bIReportNode.setId(l3);
            TableDataBIReportNode tableDataBIReportNode = new TableDataBIReportNode(tableDataUser.getUserName(), bIReportNode);
            this.tdBIReport_idMap.put(new Long(l3), tableDataBIReportNode);
            TableDataDAOControl.getInstance().writeTableDataBIReportMap(this.tdBIReport_idMap.entrySet().iterator());
        }
    }

    public List findBIReportNodeByUserId(long l2) {
        ArrayList<BIReportNode> arrayList = new ArrayList<BIReportNode>();
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_idListMap.get(new Long(l2));
        if (tableDataUser != null) {
            for (Map.Entry entry : this.tdBIReport_idMap.entrySet()) {
                TableDataBIReportNode tableDataBIReportNode = (TableDataBIReportNode)entry.getValue();
                if (!ComparatorUtils.equals(tableDataUser.getUserName(), tableDataBIReportNode.getUserName())) continue;
                arrayList.add(tableDataBIReportNode.getBIReportNode(l2));
            }
        }
        return arrayList;
    }

    public List findAllBIReportNode() {
        ArrayList<BIReportNode> arrayList = new ArrayList<BIReportNode>();
        for (Map.Entry entry : this.tdBIReport_idMap.entrySet()) {
            TableDataBIReportNode tableDataBIReportNode = (TableDataBIReportNode)entry.getValue();
            TableDataUser tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(tableDataBIReportNode.getUserName());
            if (tableDataUser == null) continue;
            arrayList.add(tableDataBIReportNode.getBIReportNode(tableDataUser.getId()));
        }
        return arrayList;
    }

    public BIReportNode findBIReportNodeByName(String string) {
        Iterator iterator = this.tdBIReport_idMap.entrySet().iterator();
        BIReportNode bIReportNode = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TableDataBIReportNode tableDataBIReportNode = (TableDataBIReportNode)entry.getValue();
            if (!ComparatorUtils.equals(string, tableDataBIReportNode.getReportName())) continue;
            if (bIReportNode != null) {
                return null;
            }
            TableDataUser tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(tableDataBIReportNode.getUserName());
            if (tableDataBIReportNode == null || tableDataUser == null) continue;
            bIReportNode = tableDataBIReportNode.getBIReportNode(tableDataUser.getId());
        }
        return bIReportNode;
    }

    public BIReportNode findBIReportNodeById(long l2) {
        TableDataBIReportNode tableDataBIReportNode = (TableDataBIReportNode)this.tdBIReport_idMap.get(new Long(l2));
        TableDataUser tableDataUser = (TableDataUser)this.tdUser_NameListMap.get(tableDataBIReportNode.getUserName());
        if (tableDataBIReportNode != null && tableDataUser != null) {
            return tableDataBIReportNode.getBIReportNode(tableDataUser.getId());
        }
        return null;
    }

    public void deleteBIReportNodeById(long l2) {
        this.tdBIReport_idMap.remove(new Long(l2));
        TableDataDAOControl.getInstance().writeTableDataBIReportMap(this.tdBIReport_idMap.entrySet().iterator());
    }

    public synchronized void resetSharedByReportIdAndUsers(long l2, long[] lArray) {
        TableDataBISharedReportNode tableDataBISharedReportNode;
        long[] lArray2 = lArray;
        Iterator iterator = this.tdBISharedReport_idMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            tableDataBISharedReportNode = (TableDataBISharedReportNode)entry.getValue();
            if (tableDataBISharedReportNode.getTemplateId() != l2) continue;
            long l3 = tableDataBISharedReportNode.getUserId();
            int n2 = ArrayUtils.indexOf(lArray2, l3);
            if (n2 >= 0) {
                lArray2 = ArrayUtils.remove(lArray2, n2);
                continue;
            }
            iterator.remove();
        }
        for (int i2 = 0; i2 < lArray2.length; ++i2) {
            tableDataBISharedReportNode = new TableDataBISharedReportNode(this.generateID(this.tdBISharedReport_idMap));
            tableDataBISharedReportNode.setTemplateId(l2);
            tableDataBISharedReportNode.setUserId(lArray2[i2]);
            this.tdBISharedReport_idMap.put(new Long(tableDataBISharedReportNode.getId()), tableDataBISharedReportNode);
        }
        TableDataDAOControl.getInstance().writeTableDataBISharedReportMap(this.tdBISharedReport_idMap.entrySet().iterator());
    }

    public synchronized User[] findUsersAccessableOfTemplateId(long l2) {
        ArrayList<User> arrayList = new ArrayList<User>();
        for (Map.Entry entry : this.tdBISharedReport_idMap.entrySet()) {
            long l3;
            User user;
            TableDataBISharedReportNode tableDataBISharedReportNode = (TableDataBISharedReportNode)entry.getValue();
            if (tableDataBISharedReportNode.getTemplateId() != l2 || (user = this.findUserByUserId(l3 = tableDataBISharedReportNode.getUserId())) == null) continue;
            arrayList.add(user);
        }
        return arrayList.toArray(new User[arrayList.size()]);
    }

    public long[] findTemplateIdsAccessable4UserId(long l2) {
        long[] lArray = new long[]{};
        for (Map.Entry entry : this.tdBISharedReport_idMap.entrySet()) {
            TableDataBISharedReportNode tableDataBISharedReportNode = (TableDataBISharedReportNode)entry.getValue();
            if (tableDataBISharedReportNode.getUserId() != l2) continue;
            lArray = ArrayUtils.add(lArray, tableDataBISharedReportNode.getTemplateId());
        }
        return lArray;
    }

    public CompanyRole findJRoleByCompanyRoleID(long l2) {
        TableDataJRole tableDataJRole = (TableDataJRole)this.companyRoleIDListMap.get(new Long(l2));
        return this.getJRoleByTdJRole(tableDataJRole);
    }

    private CompanyRole getJRoleByTdJRole(TableDataJRole tableDataJRole) {
        Long l2;
        if (tableDataJRole != null && (l2 = tableDataJRole.getDpId()) != null) {
            Department department = (Department)this.dp_idMap.get(l2);
            Long l3 = (Long)this.id_postMap.get(tableDataJRole.getPostName());
            if (department != null && l3 != null) {
                CompanyRole companyRole = new CompanyRole(tableDataJRole.getId());
                companyRole.setDepartmentId(l2);
                companyRole.setPostId(l3);
                companyRole.setDescription(tableDataJRole.getDescription());
                return companyRole;
            }
        }
        return null;
    }

    public List findAllJRole() {
        Iterator iterator = this.companyRoleIDListMap.entrySet().iterator();
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CompanyRole companyRole = this.getJRoleByTdJRole((TableDataJRole)entry.getValue());
            if (companyRole == null) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    public void saveJRole(CompanyRole companyRole) {
        Department department = this.findDepartmentByID(companyRole.getDepartmentId());
        String string = this.findPostNameById(companyRole.getPostId());
        if (department != null && string != null) {
            Iterator iterator = this.companyRoleIDListMap.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TableDataJRole tableDataJRole = (TableDataJRole)entry.getValue();
                if (!ComparatorUtils.equals(department.getId(), tableDataJRole.getDpId()) || !ComparatorUtils.equals(string, tableDataJRole.getPostName())) continue;
                bl = true;
            }
            if (!bl) {
                long l2 = this.generateID(this.companyRoleIDListMap);
                companyRole.setId(l2);
                TableDataJRole tableDataJRole = new TableDataJRole(l2);
                tableDataJRole.setDpName(department.getName());
                tableDataJRole.setPostName(string);
                tableDataJRole.setDpId(department.getId());
                tableDataJRole.setDescription(companyRole.getDescription());
                this.companyRoleIDListMap.put(new Long(l2), tableDataJRole);
                TableDataDAOControl.getInstance().writeJRoleTableData(this.companyRoleIDListMap.entrySet().iterator());
            }
        }
    }

    public List findJRoleByPost(Post post) {
        long l2;
        String string;
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (post != null && (string = this.findPostNameById(l2 = post.getId())) != null) {
            for (Map.Entry entry : this.companyRoleIDListMap.entrySet()) {
                CompanyRole companyRole;
                TableDataJRole tableDataJRole = (TableDataJRole)entry.getValue();
                if (!ComparatorUtils.equals(string, tableDataJRole.getPostName()) || (companyRole = this.getJRoleByTdJRole(tableDataJRole)) == null) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    public List findJRoleByDepartment(Long l2) {
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (l2 != null) {
            for (Map.Entry entry : this.companyRoleIDListMap.entrySet()) {
                TableDataJRole tableDataJRole = (TableDataJRole)entry.getValue();
                CompanyRole companyRole = this.getJRoleByTdJRole(tableDataJRole);
                if (companyRole == null || !ComparatorUtils.equals(l2, companyRole.getDepartmentId())) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    public List<CompanyRole> findJRoleByPostAndDepartment(Long l2, Long[] longArray) {
        List list = this.findJRoleByPost(new Post(l2));
        Iterator iterator = list.iterator();
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        while (iterator.hasNext()) {
            CompanyRole companyRole = (CompanyRole)iterator.next();
            boolean bl = false;
            int n2 = longArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (companyRole.getDepartmentId() != longArray[i2].longValue()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    public Set findEntryPrivilegesByJRoleId(long l2) {
        return this.getEntryPrivilegeByRoleId(this.companyRolePrivilegeIDMap.entrySet().iterator(), l2);
    }

    public Set findDepAndCRolePrivilegeByCompanyRoleId(long l2) {
        return this.getDepAndCRolePrivilegeByRoleId(this.companyRoleDepAndCRoleIDMap.entrySet().iterator(), l2);
    }

    public Set findTemplatePrivilegeByCompanyRoleId(long l2) {
        return this.getTemplatePrivilegeByRoleId(this.companyRoleTemplateIDMap.entrySet().iterator(), l2);
    }

    public Set findDataConnectionPrivilegesByCompanyRoleId(long l2) {
        return this.getDataConnectionPrivilegeByRoleId(this.companyRoleDataConnectionIDMap.entrySet().iterator(), l2);
    }

    public Set findTemplatePrivilegeByCustomRoleId(long l2) {
        return this.getTemplatePrivilegeByRoleId(this.customRoleTemplateIDMap.entrySet().iterator(), l2);
    }

    public Set findTemplatePrivilegeByCustomRoleName(String string) {
        return this.getTemplatePrivilegeByRoleName(this.customRoleTemplateIDMap.entrySet().iterator(), string);
    }

    public Set findDataConnectionPrivilegesByCustomRoleId(long l2) {
        return this.getDataConnectionPrivilegeByRoleId(this.customRoleDataConnectionIDMap.entrySet().iterator(), l2);
    }

    public Set findDataConnectionPrivilegesByCustomRoleName(String string) {
        return this.getDataConnectionPrivilegeByRoleName(this.customRoleDataConnectionIDMap.entrySet().iterator(), string);
    }

    public Set findDepAndCRolePrivilegeByCustomRoleId(long l2) {
        return this.getDepAndCRolePrivilegeByRoleId(this.customRoleDepAndCRoleIDMap.entrySet().iterator(), l2);
    }

    public Set findDepAndCRolePrivilegeByCustomRoleName(String string) {
        return this.getDepAndCRolePrivilegeByRoleName(this.customRoleDepAndCRoleIDMap.entrySet().iterator(), string);
    }

    public Set findESPrivilegesByJRoleId(long l2) {
        return this.getESPrivilegeByRoleId(this.companyRoleESPrivilegeIDMap.entrySet().iterator(), l2);
    }

    public Set findEntryPrivilegesBySRoleId(long l2) {
        return this.getEntryPrivilegeByRoleId(this.customRolePrivilegeIDMap.entrySet().iterator(), l2);
    }

    public Set findEntryPrivilegesBySRoleName(String string) {
        return this.getEntryPrivilegeByRoleName(this.customRolePrivilegeIDMap.entrySet().iterator(), string);
    }

    public Set findESPrivilegesBySRoleId(long l2) {
        return this.getESPrivilegeByRoleId(this.customRoleESPrivilegeIDMap.entrySet().iterator(), l2);
    }

    private Set getEntryPrivilegeByRoleId(Iterator iterator, long l2) {
        HashSet<RoleEntryPrivilege> hashSet = new HashSet<RoleEntryPrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l2) continue;
            hashSet.add(roleEntryPrivilege);
        }
        return hashSet;
    }

    private Set getEntryPrivilegeByRoleName(Iterator iterator, String string) {
        HashSet<CustomRoleEntryPrivilege> hashSet = new HashSet<CustomRoleEntryPrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRoleEntryPrivilege customRoleEntryPrivilege = (CustomRoleEntryPrivilege)entry.getValue();
            if (!ComparatorUtils.equals(customRoleEntryPrivilege.getRoleName(), string)) continue;
            hashSet.add(customRoleEntryPrivilege);
        }
        return hashSet;
    }

    private Set getESPrivilegeByRoleId(Iterator iterator, long l2) {
        HashSet<RoleESPrivilege> hashSet = new HashSet<RoleESPrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleESPrivilege roleESPrivilege = (RoleESPrivilege)entry.getValue();
            if (roleESPrivilege.getRoleId() != l2) continue;
            hashSet.add(roleESPrivilege);
        }
        return hashSet;
    }

    private Set getDepAndCRolePrivilegeByRoleId(Iterator iterator, long l2) {
        HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)entry.getValue();
            if (roleDepAndCRolePrivilege.getRoleid() != l2) continue;
            hashSet.add(roleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    private Set getDepAndCRolePrivilegeByRoleName(Iterator iterator, String string) {
        HashSet<CustomRoleDepAndCRolePrivilege> hashSet = new HashSet<CustomRoleDepAndCRolePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRoleDepAndCRolePrivilege customRoleDepAndCRolePrivilege = (CustomRoleDepAndCRolePrivilege)entry.getValue();
            if (!ComparatorUtils.equals(customRoleDepAndCRolePrivilege.getRoleName(), string)) continue;
            hashSet.add(customRoleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    private Set getDataConnectionPrivilegeByRoleId(Iterator iterator, long l2) {
        HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = (RoleDataConnectionPrivilege)entry.getValue();
            if (roleDataConnectionPrivilege.getRoleId() != l2) continue;
            hashSet.add(roleDataConnectionPrivilege);
        }
        return hashSet;
    }

    private Set getDataConnectionPrivilegeByRoleName(Iterator iterator, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRoleDataConnectionPrivilege customRoleDataConnectionPrivilege = (CustomRoleDataConnectionPrivilege)entry.getValue();
            if (!ComparatorUtils.equals(customRoleDataConnectionPrivilege.getRoleName(), string)) continue;
            hashSet.add(customRoleDataConnectionPrivilege.getName());
        }
        return hashSet;
    }

    private Set getTemplatePrivilegeByRoleId(Iterator iterator, long l2) {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)entry.getValue();
            if (roleTemplatePrivilege.getRoleId() != l2) continue;
            hashSet.add(roleTemplatePrivilege);
        }
        return hashSet;
    }

    private Set getTemplatePrivilegeByRoleName(Iterator iterator, String string) {
        HashSet<CustomRoleTemplatePrivilege> hashSet = new HashSet<CustomRoleTemplatePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRoleTemplatePrivilege customRoleTemplatePrivilege = (CustomRoleTemplatePrivilege)entry.getValue();
            if (!ComparatorUtils.equals(customRoleTemplatePrivilege.getRoleName(), string)) continue;
            hashSet.add(customRoleTemplatePrivilege);
        }
        return hashSet;
    }

    public Set findModulePrivilegesByJRoleId(long l2) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.companyRoleModuleIDMap.entrySet().iterator(), l2);
    }

    public Set findModulePrivilegesBySRoleId(long l2) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.customRoleModuleIDMap.entrySet().iterator(), l2);
    }

    public Set findModulePrivilegeBySRoleName(String string) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoleName(this.customRoleModuleIDMap.entrySet().iterator(), string);
    }

    private Set getModulePrivilegeByRoleName(Iterator iterator, String string) {
        HashSet<CustomRoleModulePrivilege> hashSet = new HashSet<CustomRoleModulePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CustomRoleModulePrivilege customRoleModulePrivilege = (CustomRoleModulePrivilege)entry.getValue();
            if (!ComparatorUtils.equals(customRoleModulePrivilege.getRoleName(), string)) continue;
            hashSet.add(customRoleModulePrivilege);
        }
        return hashSet;
    }

    private Set getModulePrivilegeByRoldId(Iterator iterator, long l2) throws CloneNotSupportedException {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleModulePrivilege roleModulePrivilege = (RoleModulePrivilege)entry.getValue();
            if (roleModulePrivilege.getRoleId() != l2) continue;
            hashSet.add(roleModulePrivilege);
        }
        return hashSet;
    }

    public Set findPrivilegesByCompanyRoleIDWithPlateName(long l2, String string) throws CloneNotSupportedException {
        Map map = (Map)this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet().iterator(), l2, string);
    }

    public Set findPrivilegesByCustomRoleIDWithPlateName(long l2, String string) throws CloneNotSupportedException {
        Map map = (Map)this.customRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet().iterator(), l2, string);
    }

    private Set getPrivilegesByRoleIdWithPlateName(Iterator iterator, long l2, String string) throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l2) continue;
            arrayList.add(PlateFactory.createPrivilegeObject4Plate(roleEntryPrivilege.getEntryid(), string));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance(new Class[]{PlateFactory.getRelationClassWithPlateName(string)}), false);
    }

    public boolean updateJRoleEntryPrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        return this.updateRoleEntryPrivileges(companyRole, list, list2, this.companyRolePrivilegeIDMap, true);
    }

    public boolean updateJRoleTemplatePrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        return this.updateRoleTemplatePrivileges(companyRole, list, list2, this.companyRoleTemplateIDMap, true);
    }

    public boolean updateSRoleTemplatePrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    public boolean updateJRoleDataConnectionPrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        return this.updateRoleDataConnectionPrivileges(companyRole, list, list2, this.companyRoleDataConnectionIDMap, true);
    }

    public boolean updateSRoleDataConnectionPrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    public boolean updateSRoleDataConnectionPrivileges(String string, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    public boolean updateSRoleTemplatePrivileges(String string, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    public boolean updateJRoleESPrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        return this.updateRoleESPrivileges(companyRole, list, list2, this.companyRoleESPrivilegeIDMap, true);
    }

    public boolean updateSRoleEntryPrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    public boolean updateSRoleEntryPrivileges(String string, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    public boolean updateSRoleESPrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        return this.updateRoleESPrivileges(customRole, list, list2, this.customRoleESPrivilegeIDMap, false);
    }

    public boolean updateCompanyRoleDepAndCRolePrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        if (this.updateRoleDepAndCRolePrivileges(companyRole, list, list2, this.companyRoleDepAndCRoleIDMap, true)) {
            TableDataDAOControl.getInstance().writeCompanyRoleDepAndCRolePrivilegeTableData(this.companyRoleDepAndCRoleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    public boolean updateCustomRoleDepAndCRolePrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    public boolean updateCustomRoleDepAndCRolePrivileges(String string, List list, List list2) throws Exception {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    private boolean updateRoleTemplatePrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTemplateTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleTemplatePrivilegeTableData(map.entrySet().iterator());
            } else {
                TableDataDAOControl.getInstance().writeSRoleTemplatePrivilegeTableData(map.entrySet().iterator());
            }
            return true;
        }
        return false;
    }

    private boolean updateRoleDataConnectionPrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeDataConnectionTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleDataConnectionPrivilegeTableData(map.entrySet().iterator());
            } else {
                TableDataDAOControl.getInstance().writeSRoleDataConnectionPrivilegeTableData(map.entrySet().iterator());
            }
            return true;
        }
        return false;
    }

    private boolean updateRoleEntryPrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleEnrtyPrivilegeTableData(map.entrySet().iterator());
            } else {
                TableDataDAOControl.getInstance().writeSRoleEnrtyPrivilegeTableData(map.entrySet().iterator());
            }
            return true;
        }
        return false;
    }

    private boolean updateRoleDepAndCRolePrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            this.removeDepAndCRolePrivilege(dAOBean, list2, map, bl);
            this.addRoleDepAndCRolePrivilege(dAOBean, list, map, bl);
            return true;
        }
        return false;
    }

    private void addRoleDepAndCRolePrivilege(DAOBean dAOBean, List list, Map map, boolean bl) {
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = String.valueOf(iterator.next());
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = new RoleDepAndCRolePrivilege();
                long l2 = this.generateID(map);
                roleDepAndCRolePrivilege.setId(l2);
                roleDepAndCRolePrivilege.setRoleid(dAOBean.getId());
                roleDepAndCRolePrivilege.setType(Integer.parseInt(string.substring(0, 1)));
                if (string.substring(1).startsWith("-")) {
                    roleDepAndCRolePrivilege.setDeporcroleid(0L - Long.parseLong(string.substring(2)));
                } else {
                    roleDepAndCRolePrivilege.setDeporcroleid(Long.parseLong(string.substring(1)));
                }
                if (!bl) {
                    roleDepAndCRolePrivilege = new CustomRoleDepAndCRolePrivilege(roleDepAndCRolePrivilege.getRoleid(), roleDepAndCRolePrivilege.getType(), roleDepAndCRolePrivilege.getDeporcroleid(), ((CustomRole)dAOBean).getRolename());
                    roleDepAndCRolePrivilege.setId(l2);
                }
                map.put(l2, roleDepAndCRolePrivilege);
            }
        }
    }

    private void removeDepAndCRolePrivilege(DAOBean dAOBean, List list, Map map, boolean bl) {
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry entry : map.entrySet()) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)entry.getValue();
                if (!this.isSameRole(roleDepAndCRolePrivilege, dAOBean)) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long l2;
                    long l3;
                    String string = String.valueOf(iterator.next());
                    if (string.startsWith("2")) {
                        l3 = 2L;
                        l2 = string.substring(1).startsWith("-") ? 0L - Long.parseLong(string.substring(2)) : Long.parseLong(string.substring(1));
                    } else {
                        l3 = 1L;
                        l2 = Long.parseLong(string.substring(1));
                    }
                    if (roleDepAndCRolePrivilege.getDeporcroleid() != l2 || (long)roleDepAndCRolePrivilege.getType() != l3) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
    }

    private boolean updateRoleESPrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeESTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleESPrivilegeTableData(map.entrySet().iterator());
            } else {
                TableDataDAOControl.getInstance().writeSRoleESPrivilegeTableData(map.entrySet().iterator());
            }
            return true;
        }
        return false;
    }

    private Map makeDataConnectionTable(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        Iterator iterator;
        Object object;
        if (list2 != null && !list2.isEmpty()) {
            object = new ArrayList();
            block0: for (Map.Entry entry : map.entrySet()) {
                RoleDataConnectionPrivilege roleDataConnectionPrivilege = (RoleDataConnectionPrivilege)entry.getValue();
                if (!this.isSameRole(roleDataConnectionPrivilege, dAOBean)) continue;
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    String string = String.valueOf(iterator2.next());
                    if (!ComparatorUtils.equals(roleDataConnectionPrivilege.getName(), string)) continue;
                    object.add(entry.getKey());
                    continue block0;
                }
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                Map.Entry entry;
                iterator = String.valueOf(object.next());
                entry = new RoleDataConnectionPrivilege();
                long l2 = this.generateID(map);
                ((DAOBean)((Object)entry)).setId(l2);
                ((RoleDataConnectionPrivilege)((Object)entry)).setRoleId(dAOBean.getId());
                ((RoleDataConnectionPrivilege)((Object)entry)).setName((String)((Object)iterator));
                ((RoleDataConnectionPrivilege)((Object)entry)).setView(1L);
                if (!bl) {
                    entry = new CustomRoleDataConnectionPrivilege(dAOBean.getId(), (String)((Object)iterator), 1L, ((CustomRole)dAOBean).getRolename());
                    ((DAOBean)((Object)entry)).setId(l2);
                }
                map.put(l2, entry);
            }
        }
        return map;
    }

    private Map makeTemplateTable(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry entry : map.entrySet()) {
                RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)entry.getValue();
                if (!this.isSameRole(roleTemplatePrivilege, dAOBean)) continue;
                for (RoleTemplatePrivilege roleTemplatePrivilege2 : list2) {
                    if (!ComparatorUtils.equals(roleTemplatePrivilege.getPath(), roleTemplatePrivilege2.getPath())) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                map.remove(object.next());
            }
        }
        if (list != null && !list.isEmpty()) {
            for (Object object : list) {
                long l2 = this.generateID(map);
                ((DAOBean)object).setId(l2);
                ((RoleTemplatePrivilege)object).setRoleId(dAOBean.getId());
                if (!bl) {
                    object = new CustomRoleTemplatePrivilege(dAOBean.getId(), ((RoleTemplatePrivilege)object).getPath(), ((RoleTemplatePrivilege)object).getPage(), ((RoleTemplatePrivilege)object).getWrite(), ((RoleTemplatePrivilege)object).getDesign(), ((CustomRole)dAOBean).getRolename());
                    ((DAOBean)object).setId(l2);
                }
                map.put(l2, object);
            }
        }
        return map;
    }

    private boolean isSameRole(RoleEntryPrivilege roleEntryPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleEntryPrivilege instanceof CustomRoleEntryPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals(((CustomRoleEntryPrivilege)roleEntryPrivilege).getRoleName(), ((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleEntryPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleModulePrivilege roleModulePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleModulePrivilege instanceof CustomRoleModulePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals(((CustomRoleModulePrivilege)roleModulePrivilege).getRoleName(), ((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleModulePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleTemplatePrivilege roleTemplatePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleTemplatePrivilege instanceof CustomRoleTemplatePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals(((CustomRoleTemplatePrivilege)roleTemplatePrivilege).getRoleName(), ((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleTemplatePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDataConnectionPrivilege roleDataConnectionPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDataConnectionPrivilege instanceof CustomRoleDataConnectionPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals(((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).getRoleName(), ((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDataConnectionPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDepAndCRolePrivilege roleDepAndCRolePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDepAndCRolePrivilege instanceof CustomRoleDepAndCRolePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals(((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).getRoleName(), ((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDepAndCRolePrivilege.getRoleid();
    }

    private Map makeTable(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry entry : map.entrySet()) {
                RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)entry.getValue();
                if (!this.isSameRole(roleEntryPrivilege, dAOBean)) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleEntryPrivilege.getEntryid() || entryTypeAndID.getType() != roleEntryPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
        if (list != null && !list.isEmpty()) {
            for (Iterator iterator : list) {
                long l2 = this.generateID(map);
                RoleEntryPrivilege roleEntryPrivilege = bl ? new CompanyRoleEntryPrivilege(l2) : new CustomRoleEntryPrivilege(l2);
                roleEntryPrivilege.setEntryid(((EntryTypeAndID)((Object)iterator)).getId());
                roleEntryPrivilege.setRoleId(dAOBean.getId());
                roleEntryPrivilege.setType(((EntryTypeAndID)((Object)iterator)).getType());
                roleEntryPrivilege.setView(((EntryTypeAndID)((Object)iterator)).getView());
                roleEntryPrivilege.setAuthorized(((EntryTypeAndID)((Object)iterator)).getAuthorized());
                roleEntryPrivilege.setEdit(((EntryTypeAndID)((Object)iterator)).getEdit());
                if (!bl) {
                    ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(((CustomRole)dAOBean).getRolename());
                }
                map.put(l2, roleEntryPrivilege);
            }
        }
        return map;
    }

    private Map makeESTable(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry entry : map.entrySet()) {
                RoleESPrivilege roleESPrivilege = (RoleESPrivilege)entry.getValue();
                if (roleESPrivilege.getRoleId() != dAOBean.getId()) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleESPrivilege.getEntryid() || entryTypeAndID.getType() != roleESPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
        if (list != null && !list.isEmpty()) {
            for (Iterator iterator : list) {
                long l2 = this.generateID(map);
                RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l2) : new CustomRoleESPrivilege(l2);
                roleESPrivilege.setEntryid(((EntryTypeAndID)((Object)iterator)).getId());
                roleESPrivilege.setRoleId(dAOBean.getId());
                roleESPrivilege.setType(((EntryTypeAndID)((Object)iterator)).getType());
                map.put(new Long(l2), roleESPrivilege);
            }
        }
        return map;
    }

    public boolean updateJRoleModulePrivileges(long l2, List list, List list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        if (this.updateRoleModuleAndPlatesPrivileges(companyRole, list, list2, this.companyRoleModuleIDMap, true)) {
            TableDataDAOControl.getInstance().writeJRole_ModulePrivilegeTableData(this.companyRoleModuleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    public boolean updateSRoleModulePrivileges(long l2, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        if (this.updateRoleModuleAndPlatesPrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    public boolean updateSRoleModulePrivileges(String string, List list, List list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleModuleAndPlatesPrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet().iterator());
            return true;
        }
        return false;
    }

    private boolean updateRoleModuleAndPlatesPrivileges(DAOBean dAOBean, List list, List list2, Map map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry entry : map.entrySet()) {
                    RoleModulePrivilege roleModulePrivilege = (RoleModulePrivilege)entry.getValue();
                    if (!this.isSameRole(roleModulePrivilege, dAOBean)) continue;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        long l2 = ((RoleModulePrivilege)iterator.next()).getModuleid();
                        if (l2 != roleModulePrivilege.getModuleid()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    map.remove(object.next());
                }
            }
            if (list != null && !list.isEmpty()) {
                for (Object object : list) {
                    long l3 = this.generateID(map);
                    ((DAOBean)object).setId(l3);
                    ((RoleModulePrivilege)object).setRoleId(dAOBean.getId());
                    if (!bl) {
                        object = new CustomRoleModulePrivilege(((RoleModulePrivilege)object).getRoleId(), ((RoleModulePrivilege)object).getModuleid(), ((RoleModulePrivilege)object).getView(), ((RoleModulePrivilege)object).getAuthorized(), ((CustomRole)dAOBean).getRolename());
                        ((DAOBean)object).setId(l3);
                    }
                    map.put(l3, object);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateCompanyRolePlatePrivileges(long l2, List list, List list2, String string) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l2);
        Map map = (Map)this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRoleModuleAndPlatesPrivileges(companyRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeJRole_PlatePrivilegeTableData(map.entrySet().iterator(), string);
            return true;
        }
        return false;
    }

    public boolean updateCustomRolePlatePrivileges(long l2, List list, List list2, String string) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l2);
        Map map = (Map)this.customRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRoleModuleAndPlatesPrivileges(customRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeSRole_PlatePrivilegeTableData(map.entrySet().iterator(), string);
            return true;
        }
        return false;
    }

    static {
        ALL_DEPARTMENT = new Department(0L, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, "", -2L);
    }
}

