/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.UserCacheInfo;
import com.fr.fs.cache.UserCacheMap;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.general.ComparatorUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCache {
    private static final IDLockCreator USERIDLOCKCREATOR = new IDLockCreator();
    private static Map historyMap = new Hashtable();
    private static UserCacheMap userMap = new UserCacheMap(128);
    private static final HashSet<Long> noRoleUsers = new HashSet();
    private static List duplicatedUsers;

    public static void addToHistory(long l2, IDText iDText) {
        Long l3 = new Long(l2);
        ArrayList<IDText> arrayList = (ArrayList<IDText>)historyMap.get(l3);
        if (arrayList == null) {
            arrayList = new ArrayList<IDText>();
            historyMap.put(l3, arrayList);
        }
        if (!arrayList.contains(iDText)) {
            arrayList.add(iDText);
        }
    }

    public static int getHistoryCount(long l2) {
        List list = (List)historyMap.get(new Long(l2));
        return list == null ? 0 : list.size();
    }

    public static IDText getHistory(long l2, int n2) {
        List list = (List)historyMap.get(new Long(l2));
        if (n2 < 0 || n2 > UserCache.getHistoryCount(l2) - 1) {
            return null;
        }
        return (IDText)list.get(n2);
    }

    public static void removeHistory(long l2, IDText iDText) {
        List list = (List)historyMap.get(new Long(l2));
        if (list != null) {
            list.remove(iDText);
        }
    }

    public static boolean checkHistory(long l2, IDText iDText) {
        List list = (List)historyMap.get(new Long(l2));
        if (list == null) {
            return false;
        }
        return list.contains(iDText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cache(long l2) throws Exception {
        if (l2 < 0L) {
            if (l2 != UserControl.getInstance().getSuperManagerID()) return;
        }
        Object object = USERIDLOCKCREATOR.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                if (userMap.containsKey(l2)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var3_2
                    Object var7_3 = null;
                    USERIDLOCKCREATOR.releaseIDLock();
                    return;
                }
                UserCacheInfo userCacheInfo = UserCache.createUserCacheInfo(l2);
                if (userCacheInfo.companyRoleSet.size() == 0 && userCacheInfo.customRoleSet.size() == 0) {
                    UserCache.addNoRoleUser(l2);
                }
                if (userCacheInfo != null) {
                    userMap.put(l2, userCacheInfo);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            USERIDLOCKCREATOR.releaseIDLock();
            throw throwable;
        }
        Object var7_4 = null;
        USERIDLOCKCREATOR.releaseIDLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheJob(long l2, long l3, long l4) throws Exception {
        if (!UserCache.isValidate(l2, l3, l4)) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                List<CompanyRole> list;
                if (userCacheInfo.jobSet.add(new Job(l3, l4)) && (list = CompanyRoleControl.getInstance().getJRole(l3, l4)) != null) {
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CompanyRole companyRole = list.get(i2);
                        userCacheInfo.companyRoleSet.add(companyRole);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCacheJob(long l2) throws Exception {
        if (l2 < 0L) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.jobSet.clear();
                userCacheInfo.companyRoleSet.clear();
                Set set = FSConfig.getInstance().getControl().getUserDAO().getJobSet(l2);
                for (RelationObject relationObject : set) {
                    long l3 = (Long)relationObject.getValue(Post.class);
                    long l4 = (Long)relationObject.getValue(Department.class);
                    userCacheInfo.jobSet.add(new Job(l4, l3));
                    List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l4, l3);
                    if (list == null) continue;
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CompanyRole companyRole = list.get(i2);
                        userCacheInfo.companyRoleSet.add(companyRole);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheSRole(long l2, CustomRole customRole) {
        if (customRole == null) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.add(new Long(customRole.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterAddSRole(long[] lArray, long l2) {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(lArray[i2]);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.add(l2);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelSRoleUser(long[] lArray, long l2) {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(lArray[i2]);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(l2);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCacheSRole(long l2, CustomRole customRole) {
        if (customRole == null || customRole.getId() == -999L) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(new Long(customRole.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNoRoleUser(long l2) {
        HashSet<Long> hashSet = noRoleUsers;
        synchronized (hashSet) {
            noRoleUsers.add(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNoRoleUser(long l2) {
        HashSet<Long> hashSet = noRoleUsers;
        synchronized (hashSet) {
            if (noRoleUsers.contains(l2)) {
                noRoleUsers.remove(l2);
            }
        }
    }

    public static boolean isUserNoRole(long l2) throws Exception {
        return noRoleUsers.contains(l2);
    }

    public static void checkAndAddNoRoleUser(long l2) throws Exception {
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(l2);
        if (userCacheInfo.companyRoleSet.size() == 0 && userCacheInfo.customRoleSet.size() == 0) {
            UserCache.addNoRoleUser(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<User> getNoRoleUsers() throws Exception {
        HashSet<User> hashSet = new HashSet<User>();
        HashSet<Long> hashSet2 = noRoleUsers;
        synchronized (hashSet2) {
            for (Long l2 : noRoleUsers) {
                UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(l2);
                User user = userCacheInfo.getUser();
                if (user == null) continue;
                hashSet.add(user);
            }
        }
        return hashSet;
    }

    private static UserCacheInfo createUserCacheInfo(long l2) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            UserCacheInfo userCacheInfo = new UserCacheInfo();
            userCacheInfo.customRoleSet.add(new Long(CustomRoleControl.getInstance().getSuperCustomRoleID()));
            return userCacheInfo;
        }
        User user = FSConfig.getInstance().getControl().getUserDAO().findByID(l2);
        if (user != null) {
            UserCacheInfo userCacheInfo = new UserCacheInfo();
            userCacheInfo.setUser(user);
            Set set = FSConfig.getInstance().getControl().getUserDAO().getSRoleSet(user.getId());
            for (RelationObject relationObject : set) {
                userCacheInfo.customRoleSet.add(relationObject.getValue(CustomRole.class));
            }
            List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(CompanyRoleControl.getInstance().getDepartmentAllID(), CompanyRoleControl.getInstance().getPostAllID());
            if (!list.isEmpty()) {
                userCacheInfo.companyRoleSet.add(list.get(0));
            }
            set = FSConfig.getInstance().getControl().getUserDAO().getJobSet(user.getId());
            for (RelationObject relationObject : set) {
                long l3 = (Long)relationObject.getValue(Post.class);
                long l4 = (Long)relationObject.getValue(Department.class);
                userCacheInfo.jobSet.add(new Job(l4, l3));
                List<CompanyRole> list2 = CompanyRoleControl.getInstance().getJRole(l4, l3);
                if (list2 == null) continue;
                int n2 = list2.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    CompanyRole companyRole = list2.get(i2);
                    userCacheInfo.companyRoleSet.add(companyRole);
                }
            }
            return userCacheInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllCache() {
        Cloneable cloneable = userMap;
        synchronized (cloneable) {
            userMap.clear();
        }
        cloneable = noRoleUsers;
        synchronized (cloneable) {
            noRoleUsers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        Object object = USERIDLOCKCREATOR.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                historyMap.remove(l2);
                userMap.remove(new Long(l2));
                UserCache.removeNoRoleUser(l2);
            }
            Object var6_4 = null;
            USERIDLOCKCREATOR.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            USERIDLOCKCREATOR.releaseIDLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getUserById(long l2) throws Exception {
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(l2);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                return userCacheInfo.getUser();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getSRoles(long l2) throws Exception {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return null;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<CustomRole> hashSet = new HashSet<CustomRole>();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    CustomRole customRole;
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if ((customRole = CustomRoleControl.getInstance().getCustomRole(l3)) == null) continue;
                    hashSet.add(customRole);
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getAllCompanyRoleIDs(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return new HashSet<Long>();
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<Long> hashSet = new HashSet<Long>();
                Iterator iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    hashSet.add(companyRole.getId());
                }
                return hashSet;
            }
        }
        return new HashSet<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllCompanyRoleNames(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return new HashSet();
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    hashSet.add(companyRole.toString());
                }
                return hashSet;
            }
        }
        return new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllCustomRoleIDs(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return new HashSet();
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<Long> hashSet = new HashSet<Long>();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    hashSet.add(new Long(l3));
                }
                return hashSet;
            }
        }
        return new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllPlatePrivileges(long l2, String string) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return null;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n2;
                List list;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if ((list = CustomRoleControl.getInstance().getAllPlatePrivileges(l3, string)) == null) continue;
                    n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllPrivilegesWithPlateName(companyRole.getId(), string)) == null) continue;
                    int n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        hashSet.add(list.get(n2));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    private static boolean examineId(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return false;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllEntryPrivileges(long l2) throws Exception {
        if (!UserCache.examineId(l2)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Object object;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                List<EntryTypeAndID> list = new ArrayList();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if (l3 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l3).getRolename();
                        Set set = TableDataCustomRoleDAO.getInstance().getEntryPrivileges((String)object);
                        for (CustomRoleEntryPrivilege customRoleEntryPrivilege : set) {
                            list.add(EntryTypeAndID.getInstance(customRoleEntryPrivilege.getType(), customRoleEntryPrivilege.getEntryid(), customRoleEntryPrivilege.getView(), customRoleEntryPrivilege.getAuthorized(), customRoleEntryPrivilege.getEdit()));
                        }
                    } else {
                        list = CustomRoleControl.getInstance().getAllEntryPrivileges4Obj(l3);
                    }
                    if (list == null) continue;
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(((DAOBean)object).getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllEntryPrivileges(((DAOBean)object).getId(), true)) == null) continue;
                    int n3 = list.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        hashSet.add(list.get(i3));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllTemplatePrivileges(long l2) throws Exception {
        if (!UserCache.examineId(l2)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(l2);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n2;
                Object object;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                List list = new ArrayList();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if (l3 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l3).getRolename();
                        list.addAll(TableDataCustomRoleDAO.getInstance().getTemplatePrivileges((String)object));
                    } else {
                        list = CustomRoleControl.getInstance().getAllTemplatePrivileges(l3);
                    }
                    if (list == null) continue;
                    n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(((DAOBean)object).getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllTemplatePrivileges(((DAOBean)object).getId())) == null) continue;
                    int n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        hashSet.add(list.get(n2));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllDepAndCRolePrivileges(long l2) throws Exception {
        if (!UserCache.examineId(l2)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n2;
                List list;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if ((list = CustomRoleControl.getInstance().getAllDepAndCRolePrivileges(l3, true)) == null) continue;
                    n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllDepAndCRolePrivileges(companyRole.getId(), true)) == null) continue;
                    int n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        hashSet.add(list.get(n2));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllDataConnectionPrivileges(long l2) throws Exception {
        if (!UserCache.examineId(l2)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n2;
                Object object;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                List list = new ArrayList();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if (l3 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l3).getRolename();
                        list.addAll(TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges((String)object));
                    } else {
                        list = CustomRoleControl.getInstance().getAllDataConnectionPrivileges(l3);
                    }
                    if (list == null) continue;
                    n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(((DAOBean)object).getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllDataConnectionPrivileges(((DAOBean)object).getId())) == null) continue;
                    int n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        hashSet.add(list.get(n2));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllModulePrivileges(long l2) throws Exception {
        if (!UserCache.examineId(l2)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n2;
                Object object;
                HashSet hashSet = new HashSet();
                Iterator iterator = userCacheInfo.customRoleSet.iterator();
                List list = new ArrayList();
                while (iterator.hasNext()) {
                    Long l3 = (Long)iterator.next();
                    if (l3.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l3)) {
                        iterator.remove();
                    }
                    if (l3 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l3).getRolename();
                        list.addAll(TableDataCustomRoleDAO.getInstance().getModulePrivileges((String)object));
                    } else {
                        list = CustomRoleControl.getInstance().getAllModulePrivileges(l3);
                    }
                    if (list == null) continue;
                    n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashSet.add(list.get(i2));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)iterator.next();
                    if (!CompanyRoleCache.containCache(((DAOBean)object).getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllModulePrivileges(((DAOBean)object).getId())) == null) continue;
                    int n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        hashSet.add(list.get(n2));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containModulePrivilege(long l2, long l3) {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L || l3 < 0L) {
            return false;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                for (Long l4 : userCacheInfo.customRoleSet) {
                    if (l4 <= -1000L) {
                        try {
                            Object object = CustomRoleControl.getInstance().getCustomRole(l4).getRolename();
                            Set set = TableDataCustomRoleDAO.getInstance().getModulePrivileges((String)object);
                            for (CustomRoleModulePrivilege customRoleModulePrivilege : set) {
                                if (customRoleModulePrivilege.getModuleid() != l3) continue;
                                return true;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (!CustomRoleControl.getInstance().containModulePrivilege(l4, l3)) continue;
                    return true;
                }
                for (Object object : userCacheInfo.companyRoleSet) {
                    if (!CompanyRoleCache.containModulePrivilege(((DAOBean)object).getId(), l3)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No user exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containPlatePrivilege(long l2, long l3, String string) {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L || l3 < 0L) {
            return false;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                for (Long l4 : userCacheInfo.customRoleSet) {
                    if (!CustomRoleControl.getInstance().containPlatePrivilege(l4, l3, string)) continue;
                    return true;
                }
                for (CompanyRole companyRole : userCacheInfo.companyRoleSet) {
                    if (!CompanyRoleCache.containPlatePrivilege(companyRole.getId(), l3, string)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No user exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containEntryPrivilege(long l2, int n2, long l3) {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l2 < 0L || l3 < -1L) {
            return false;
        }
        try {
            UserCache.cache(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l2));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                return UserCache.containPrivilegeInCache(userCacheInfo, n2, l3);
            }
        }
        throw new RuntimeException("No user exist!");
    }

    private static boolean containPrivilegeInCache(UserCacheInfo userCacheInfo, int n2, long l2) {
        for (Long l3 : userCacheInfo.customRoleSet) {
            if (!CustomRoleControl.getInstance().containEntryPrivilege(l3, n2, l2)) continue;
            return true;
        }
        for (CompanyRole companyRole : userCacheInfo.companyRoleSet) {
            if (!CompanyRoleCache.containEntryPrivilege(companyRole.getId(), n2, l2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelDepartment(long l2) {
        List list = UserCache.getAllCacheList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                CompanyRole companyRole;
                Set set = userCacheInfo.jobSet;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Job job = (Job)iterator.next();
                    if (job.getDepartmentid() != l2) continue;
                    iterator.remove();
                }
                Set set2 = userCacheInfo.companyRoleSet;
                Iterator iterator2 = set2.iterator();
                if (iterator2.hasNext() && (companyRole = (CompanyRole)iterator2.next()).getDepartmentId() == l2) {
                    set2.remove(companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelPost(long l2) {
        List list = UserCache.getAllCacheList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                CompanyRole companyRole;
                Set set = userCacheInfo.jobSet;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Job job = (Job)iterator.next();
                    if (job.getPostid() != l2) continue;
                    iterator.remove();
                }
                Set set2 = userCacheInfo.companyRoleSet;
                Iterator iterator2 = set2.iterator();
                if (iterator2.hasNext() && (companyRole = (CompanyRole)iterator2.next()).getPostId() == l2) {
                    set2.remove(companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAllCacheList() {
        UserCacheMap userCacheMap = userMap;
        synchronized (userCacheMap) {
            ArrayList arrayList = new ArrayList(userMap.size());
            Set set = userMap.entrySet();
            for (Map.Entry entry : set) {
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDeleteCompanyRole(long l2) {
        if (l2 < 0L) {
            return;
        }
        CompanyRole companyRole = new CompanyRole(l2);
        List list = UserCache.getAllCacheList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Set set = userCacheInfo.companyRoleSet;
                set.remove(companyRole);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterUpdateJRole(CompanyRole companyRole) {
        if (companyRole == null) {
            return;
        }
        List list = UserCache.getAllCacheList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                boolean bl = false;
                Set set = userCacheInfo.jobSet;
                for (Job job : set) {
                    if (!UserCache.isJRoleMatch(companyRole, job)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    userCacheInfo.companyRoleSet.add(companyRole);
                } else {
                    userCacheInfo.companyRoleSet.remove(companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelSRole(long l2) {
        List list = UserCache.getAllCacheList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(new Long(l2));
                continue;
            }
        }
    }

    public static List getDuplicatedUsers() {
        return duplicatedUsers;
    }

    public static void setDuplicatedUsers(List list) {
        duplicatedUsers = list;
    }

    private static boolean isValidate(long l2, long l3, long l4) {
        return l2 >= 0L && l3 >= 0L && l4 >= 0L;
    }

    private static boolean isJRoleMatch(CompanyRole companyRole, Job job) {
        return companyRole.getDepartmentId() == 0L && job.getPostid() == companyRole.getPostId() || companyRole.getPostId() == 0L && job.getDepartmentid() == companyRole.getDepartmentId() || job.getDepartmentid() == companyRole.getDepartmentId() && job.getPostid() == companyRole.getPostId() || companyRole.getPostId() == 0L && companyRole.getDepartmentId() == 0L;
    }

    public static class IDText {
        private String id;
        private String text;
        private long showType;

        public IDText(String string) {
            this(string, "", -1L);
        }

        public IDText(String string, String string2, long l2) {
            this.id = string;
            this.text = string2;
            this.showType = l2;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public long getShowType() {
            return this.showType;
        }

        public boolean equals(Object object) {
            return object instanceof IDText && ComparatorUtils.equals(((IDText)object).id, this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

