/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.Module;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.FSConstants;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModuleTreeNode
implements Comparable {
    private Module module;
    private Map nodeMap = new TreeMap();
    private int sortindex;

    protected ModuleTreeNode(Module module) {
        this.module = module;
        Integer n2 = (Integer)FSConstants.MODULEID.ModuleSort.get((int)module.getId());
        this.sortindex = n2 == null ? 0 : n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(long l2, ModuleTreeNode moduleTreeNode) {
        Map map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.put(new Long(l2), moduleTreeNode);
        }
    }

    private ModuleTreeNode[] getNodes() {
        return (ModuleTreeNode[])this.getNodes(true);
    }

    public int getSortindex() {
        return this.sortindex;
    }

    public void setSortindex(int n2) {
        this.sortindex = n2;
    }

    protected Long[] getNodeIDs() {
        return (Long[])this.getNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getNodes(boolean bl) {
        Map map = this.nodeMap;
        synchronized (map) {
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl) {
                    arrayList.add(entry.getValue());
                    continue;
                }
                arrayList.add(entry.getKey());
            }
            if (bl) {
                Collections.sort(arrayList);
                return arrayList.toArray(new ModuleTreeNode[arrayList.size()]);
            }
            return arrayList.toArray(new Long[arrayList.size()]);
        }
    }

    protected Module getModule() {
        return this.module;
    }

    public JSONArray createShowModuleConfig(long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return jSONArray;
        }
        Set set = UserControl.getInstance().getAllModulePrivileges(l2);
        if (set == null) {
            return jSONArray;
        }
        ModuleTreeNode[] moduleTreeNodeArray = this.getNodes();
        for (int i2 = 0; i2 < moduleTreeNodeArray.length; ++i2) {
            if (!moduleTreeNodeArray[i2].isVisible(set)) continue;
            jSONArray.put(moduleTreeNodeArray[i2].module.createJSONConfig());
        }
        return jSONArray;
    }

    private boolean isVisible(Set set) {
        Object object2;
        if (set == null) {
            return false;
        }
        for (Object object2 : set) {
            if (object2.getModuleid() != this.module.getId()) continue;
            return true;
        }
        object2 = this.getNodes();
        if (!ArrayUtils.isEmpty(object2)) {
            for (int i2 = 0; i2 < ((Object[])object2).length; ++i2) {
                if (!super.isVisible(set)) continue;
                return true;
            }
        }
        return false;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = this.module.createJSONConfig();
        Object[] objectArray = this.getNodes();
        if (!ArrayUtils.isEmpty(objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                jSONArray.put(((ModuleTreeNode)objectArray[i2]).createJSONConfig());
            }
            jSONObject.put("ChildNodes", jSONArray);
        } else {
            jSONObject.put("leaf", true);
        }
        return jSONObject;
    }

    public JSONArray createAllChildrenJSONConfig() throws JSONException {
        Object[] objectArray = this.getNodes();
        JSONArray jSONArray = new JSONArray();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                jSONArray.put(((ModuleTreeNode)objectArray[i2]).createJSONConfig());
            }
        }
        return jSONArray;
    }

    public JSONObject createShowJSONConfig(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllModulePrivileges(l2);
        JSONObject jSONObject = this.createShowJSONConfig(set, false);
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    private JSONObject createShowJSONConfig(Set set, boolean bl) throws JSONException {
        Object object2;
        if (!bl && set == null) {
            return null;
        }
        for (Object object2 : set) {
            if (((RoleModulePrivilege)object2).getModuleid() != this.module.getId()) continue;
            bl = true;
            break;
        }
        object2 = null;
        Object[] objectArray = this.getNodes();
        if (!ArrayUtils.isEmpty(objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                JSONObject jSONObject = super.createShowJSONConfig(set, bl);
                if (jSONObject == null) continue;
                jSONArray.put(jSONObject);
            }
            if (bl || jSONArray.length() > 0) {
                object2 = this.module.createJSONConfig();
                ((JSONObject)object2).put("ChildNodes", jSONArray);
            }
        } else if (bl) {
            object2 = this.module.createJSONConfig();
            ((JSONObject)object2).put("leaf", true);
        }
        return object2;
    }

    public int compareTo(Object object) {
        return this.sortindex - ((ModuleTreeNode)object).getSortindex();
    }
}

