/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.RoleCacheInfo;
import com.fr.fs.cache.RoleCacheUtils;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.json.JSONException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomRoleCache {
    private static Map roleMap = new Hashtable(128);
    private static final IDLockCreator SROLE_ID_LOCK_CREATOR = new IDLockCreator();

    public static boolean containCache(long l2) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roleMap.containsKey(new Long(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCache() throws Exception {
        Map map = roleMap;
        synchronized (map) {
            if (roleMap.isEmpty()) {
                try {
                    List list = FSConfig.getInstance().getControl().getCustomRoleDAO().findAll();
                    if (list != null) {
                        int n2 = list.size();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            CustomRoleCache.cache((CustomRole)list.get(i2));
                        }
                    }
                }
                catch (Exception exception) {
                    roleMap.clear();
                    throw exception;
                }
            }
        }
    }

    private static void cache(CustomRole customRole) throws Exception {
        if (customRole != null) {
            RoleCacheInfo roleCacheInfo = CustomRoleCache.createSRoleCacheInfo(customRole);
            roleMap.put(new Long(customRole.getId()), roleCacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cacheNew(CustomRole customRole) throws Exception {
        if (customRole == null) return;
        Object object = SROLE_ID_LOCK_CREATOR.getIDLock(customRole.getId());
        try {
            Object object2 = object;
            synchronized (object2) {
                if (roleMap.containsKey(new Long(customRole.getId()))) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    Object var6_3 = null;
                    SROLE_ID_LOCK_CREATOR.releaseIDLock();
                    return;
                }
                RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
                roleCacheInfo.name = customRole.getRolename();
                roleMap.put(new Long(customRole.getId()), roleCacheInfo);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SROLE_ID_LOCK_CREATOR.releaseIDLock();
            throw throwable;
        }
        Object var6_4 = null;
        SROLE_ID_LOCK_CREATOR.releaseIDLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSRoleName(long l2) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                return roleCacheInfo.name;
            }
        }
        return null;
    }

    private static RoleCacheInfo createSRoleCacheInfo(CustomRole customRole) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Set set;
        RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
        roleCacheInfo.name = customRole.getRolename();
        CustomRoleDAO customRoleDAO = FSConfig.getInstance().getControl().getCustomRoleDAO();
        Boolean bl = customRole.getId() < -1000L;
        Set set2 = set = bl != false ? TableDataCustomRoleDAO.getInstance().getEntryPrivileges(customRole.getRolename()) : customRoleDAO.getEntryPrivileges(customRole.getId());
        if (set != null) {
            object5 = set.iterator();
            while (object5.hasNext()) {
                object4 = (RoleEntryPrivilege)object5.next();
                roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleEntryPrivilege)object4).getType(), ((RoleEntryPrivilege)object4).getEntryid(), ((RoleEntryPrivilege)object4).getView(), ((RoleEntryPrivilege)object4).getAuthorized(), ((RoleEntryPrivilege)object4).getEdit()));
            }
        }
        if ((object5 = customRoleDAO.getESPrivileges(customRole.getId())) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (RoleESPrivilege)object4.next();
                roleCacheInfo.ESPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleESPrivilege)object3).getType(), ((RoleESPrivilege)object3).getEntryid()));
            }
        }
        Object object6 = object4 = bl != false ? TableDataCustomRoleDAO.getInstance().getModulePrivileges(customRole.getRolename()) : customRoleDAO.getModulePrivileges(customRole.getId());
        if (object4 != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                roleCacheInfo.moduleSet.add(object3.next());
            }
        }
        Object object7 = object3 = bl != false ? TableDataCustomRoleDAO.getInstance().getDepAndCrolePrivileges(customRole.getRolename()) : customRoleDAO.getDepAndCrolePrivileges(customRole.getId());
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                roleCacheInfo.depandcrolePrivilegeSet.add(object2.next());
            }
        }
        Object object8 = object2 = bl != false ? TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(customRole.getRolename()) : customRoleDAO.getTemplatePrivileges(customRole.getId());
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                roleCacheInfo.templateSet.add(object.next());
            }
        }
        Object object9 = object = bl != false ? TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(customRole.getRolename()) : customRoleDAO.getDataConnectionPrivileges(customRole.getId());
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                roleCacheInfo.dataConnectionSet.add(iterator.next());
            }
        }
        roleCacheInfo.addPrivileges4Plates(customRole.getId(), false);
        return roleCacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInitCache() throws Exception {
        Map map = roleMap;
        synchronized (map) {
            roleMap.clear();
            CustomRoleCache.initCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map map = roleMap;
        synchronized (map) {
            roleMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l2) {
        Object object = SROLE_ID_LOCK_CREATOR.getIDLock(l2);
        try {
            Object object2 = object;
            synchronized (object2) {
                roleMap.remove(new Long(l2));
            }
            Object var6_4 = null;
            SROLE_ID_LOCK_CREATOR.releaseIDLock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SROLE_ID_LOCK_CREATOR.releaseIDLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllEntryPrivileges(long l2, boolean bl) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.entryPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    if (bl) {
                        arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId(), entryTypeAndID.getView(), entryTypeAndID.getAuthorized(), entryTypeAndID.getEdit()));
                        continue;
                    }
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllDataConnectionPrivileges(long l2) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(l2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.dataConnectionSet;
                for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                    arrayList.add(roleDataConnectionPrivilege.getName());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllTemplatePrivileges(long l2) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(l2);
        ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.templateSet;
                for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                    arrayList.add(roleTemplatePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllDepAndCRolePrivileges(long l2, boolean bl) throws JSONException {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.depandcrolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (bl) {
                        arrayList.add(roleDepAndCRolePrivilege);
                        continue;
                    }
                    arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllESPrivileges(long l2, boolean bl) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.ESPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    if (bl) {
                        arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId()));
                        continue;
                    }
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllModulePrivileges(long l2) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.moduleSet;
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    arrayList.add(roleModulePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllPrivilegesWithPlateName(long l2, String string) {
        try {
            CustomRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList arrayList = new ArrayList();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.getPlatePrivilege(string);
                if (set == null) {
                    return null;
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCustomRoleName(long l2, String string) {
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                roleCacheInfo.name = string;
            }
        }
    }

    public static void refreshModulePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshModulePrivileges(roleMap, l2, set);
    }

    public static void refreshModulePrivileges(String string, Set set) {
        RoleCacheUtils.refreshModulePrivileges(roleMap, string, set);
    }

    public static void refreshPrivilegesWithPlateName(long l2, Set set, String string) {
        RoleCacheUtils.refreshPlatePrivileges(roleMap, l2, set, string);
    }

    public static void refreshEntryPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshEntryPrivileges(roleMap, l2, set);
    }

    public static void refreshEntryPrivileges(String string, Set set) {
        RoleCacheUtils.refreshEntryPrivileges(roleMap, string, set);
    }

    public static void refreshTemplatePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshTemplatePrivileges(roleMap, l2, set);
    }

    public static void refreshTemplatePrivileges(String string, Set set) {
        RoleCacheUtils.refreshTemplatePrivileges(roleMap, string, set);
    }

    public static void refreshDepAndCRolePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(roleMap, l2, set);
    }

    public static void refreshDepAndCRolePrivileges(String string, Set set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(roleMap, string, set);
    }

    public static void refreshDataConnectionPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(roleMap, l2, set);
    }

    public static void refreshDataConnectionPrivileges(String string, Set set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(roleMap, string, set);
    }

    public static void refreshESPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshESPrivileges(roleMap, l2, set);
    }

    public static boolean containModulePrivilege(long l2, long l3) {
        return RoleCacheUtils.containModulePrivilege(roleMap, l2, l3);
    }

    public static boolean containPlatePrivilege(long l2, long l3, String string) {
        return RoleCacheUtils.containPlatePrivilege(roleMap, l2, l3, string);
    }

    public static boolean containEntryPrivilege(long l2, int n2, long l3) {
        return RoleCacheUtils.containEntryPrivilege(roleMap, l2, n2, l3);
    }

    public static void refreshEntryPrivileges(long l2, int n2, long l3, long l4) {
        RoleCacheUtils.refreshEntryPrivileges(roleMap, l2, n2, l3, l4);
    }
}

