/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.data.impl.ArrayTableData;
import com.fr.data.impl.RecursionTableData;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.web.service.FSMainModuleGetRootsAction;
import com.fr.fs.web.service.FSManagerModuleImportUserAction;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportWebUtils;
import com.fr.web.platform.TransmitParameters;

public class FSUtils {
    private static boolean addOrUpdateEntryFolder(String string, Long l2, Long l3) {
        FolderEntry folderEntry = new FolderEntry(string, "");
        if (l2 != null) {
            folderEntry.setId(l2);
        }
        folderEntry.setParentId(l3);
        try {
            return EntryControl.getInstance().saveOrUpdateEntry(folderEntry);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean addEntryFolder(String string, Long l2) {
        return FSUtils.addOrUpdateEntryFolder(string, null, l2);
    }

    public static boolean updateEntryFolder(String string, Long l2, Long l3) {
        if (l2 == null) {
            return false;
        }
        return FSUtils.addOrUpdateEntryFolder(string, l2, l3);
    }

    public static boolean deleteEntryFolder(Long l2) {
        try {
            return EntryControl.getInstance().deleteEntry(0, l2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static JSONObject getEntryFolderTree() {
        try {
            return FSMainModuleGetRootsAction.getCatalogInfo(UserControl.getInstance().getSuperManagerID());
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public static JSONArray getReportletTree(String string) {
        if (string == null) {
            string = "cpt,frm";
        }
        String string2 = string;
        IdGenerator idGenerator = new IdGenerator();
        return ReportWebUtils.getAllReportletsOfCurrentEnv("reportlets", idGenerator, string2);
    }

    private static boolean isFRFile(String string) {
        return ComparatorUtils.equals(string, ".cpt") || ComparatorUtils.equals(string, ".frm") || ComparatorUtils.equals(string, ".form");
    }

    private static boolean addOrUpdateReportInFolder(Long l2, Long l3, String string, int n2, JSONArray jSONArray) {
        boolean bl = false;
        try {
            int n3 = string.lastIndexOf(".");
            if (n3 >= 0 && FSUtils.isFRFile(string.substring(n3))) {
                ReportletEntry reportletEntry = new ReportletEntry(string);
                reportletEntry.setShowType(n2);
                if (l2 != null) {
                    reportletEntry.setId(l2);
                }
                if (jSONArray != null) {
                    reportletEntry.setTransmitParameters(TransmitParameters.parseJSON(jSONArray));
                }
                bl = EntryControl.getInstance().saveOrUpdateEntry(reportletEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean addReportInFolder(Long l2, String string, int n2, JSONArray jSONArray) {
        return FSUtils.addOrUpdateReportInFolder(null, l2, string, n2, jSONArray);
    }

    public static boolean updateReportInFolder(Long l2, Long l3, String string, int n2, JSONArray jSONArray) {
        if (l2 == null) {
            return false;
        }
        return FSUtils.addOrUpdateReportInFolder(l2, l3, string, n2, jSONArray);
    }

    public static boolean deleteReportInFolder(int n2, Long l2) {
        try {
            return EntryControl.getInstance().deleteEntry(n2, l2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean importUser(String[] stringArray, Object[][] objectArray, int n2, int n3, int n4, int n5, int n6) {
        ArrayTableData arrayTableData = new ArrayTableData(stringArray, objectArray);
        if (arrayTableData != null) {
            try {
                if (arrayTableData instanceof RecursionTableData) {
                    FSManagerModuleImportUserAction.clearTables();
                }
                FSManagerModuleImportUserAction.doImport(arrayTableData, n2, n4, n3, -1, -1, n5, n6, -1);
                DepartmentCache.reInit();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

