/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.fs.FSPlate;
import com.fr.fs.base.entity.Module;
import com.fr.general.ComparatorUtils;

public class FSPlateConfig {
    private String plateName;
    private String plateDescription;
    private String plateClassName;
    private long moduleId;
    private long moduleParentId;

    public FSPlateConfig() {
    }

    public FSPlateConfig(String string, String string2, String string3, long l2, long l3) {
        this.plateName = string;
        this.plateDescription = string2;
        this.plateClassName = string3;
        this.moduleId = l2;
        this.moduleParentId = l3;
    }

    public String getPlateName() {
        return this.plateName;
    }

    public String getPlateDescription() {
        return this.plateDescription;
    }

    public String getPlateClassName() {
        return this.plateClassName;
    }

    public FSPlate toFSPlate() {
        FSPlate fSPlate = null;
        try {
            fSPlate = (FSPlate)Class.forName(this.plateClassName).newInstance();
        }
        catch (Exception exception) {
            FRContext.getLogger().info(this.plateClassName + " not support.");
        }
        if (fSPlate != null) {
            fSPlate.setModule(this.toFSModule());
        }
        return fSPlate;
    }

    public Module toFSModule() {
        return new Module(this.plateName, this.plateDescription, this.moduleId, this.moduleParentId);
    }

    public boolean equals(Object object) {
        return object instanceof FSPlateConfig && ComparatorUtils.equals(((FSPlateConfig)object).plateName, this.plateName);
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(long l2) {
        this.moduleId = l2;
    }

    public long getModuleParentId() {
        return this.moduleParentId;
    }

    public void setModuleParentId(long l2) {
        this.moduleParentId = l2;
    }
}

