/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.file.XMLFileManager;
import com.fr.fs.FSHelper;
import com.fr.fs.FSPlate;
import com.fr.fs.FSPlateConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.UserCache;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.Control;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.mobile.FMobileDeviceInfo;
import com.fr.fs.privilege.auth.UserNamePassWordFSAuthenticationProvider;
import com.fr.fs.web.FSConstants;
import com.fr.fs.web.service.FSLoadLoginAction;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.VT4FR;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.ReportDispatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSConfig
extends XMLFileManager {
    private static final String XML_TAG = "fsconfig";
    private static final String SUN_DEFAULT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String AUTH_SIMPLE = "simple";
    public static final String REFERRAL_FOLLOW = "follow";
    public static final String DEFAULT_AUTHENTICATION_TYPE = "default";
    public static final String LDAP_AUTHENTICATION_TYPE = "ldap";
    public static final String HTTP_AUTHENTICATION_TYPE = "http";
    public static final int ERROR_LDAP_LENGTH = 100;
    private boolean useFS = false;
    private static FSConfig SC = null;
    private Control control = HSQLDBDAOControl.getInstance();
    private TableDataDAOControl tdControl = TableDataDAOControl.getInstance();
    private HSQLDBDAOControl hsqlControl = HSQLDBDAOControl.getInstance();
    private JSONArray navigationImages4FS = new JSONArray();
    private SystemManagerFavoriteAndADHOC sysManagerFvAndAD = SystemManagerFavoriteAndADHOC.getInstance();
    private String loginImageID4FS;
    private String bgImageID4FS;
    private String loginUrl4FS;
    private String loginTitle4FS;
    private boolean isLoginPageImg;
    private String homePageURL;
    private boolean hasNavigation = false;
    private boolean needUpdate = true;
    private List<FSPlateConfig> plateList = new ArrayList<FSPlateConfig>();
    private AuthenticationProvider currentAuthenticationProvider;
    private String authenticateType;
    private String ldapUrl = "";
    private String ldapSearchBase = "";
    private String authentication = "simple";
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String referral = "follow";
    private String principalSuffix = "";
    private String ldapSystemName = "";
    private String ldapSystemPassword = "";
    private String httpUrl = "";
    private boolean mobiledevbind = false;
    private JSONObject mobileDevInfo = new JSONObject();
    private ActionNoSessionCMD loginAction = new FSLoadLoginAction();
    private String style = "lightblue";
    private boolean hasGradeAuth = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.MULTI_PRIVILEGE.support();
    private boolean gradeAuthority = false;
    private boolean editReportAuthority = false;
    private boolean dataConnectionAuthority = false;
    private boolean hasUpdated = false;
    private long xmlVersion;

    public void addPlateConfig(FSPlateConfig fSPlateConfig) {
        if (this.plateList.contains(fSPlateConfig)) {
            return;
        }
        this.plateList.add(fSPlateConfig);
        PlateFactory.putPlate2Factory(fSPlateConfig.getPlateName(), fSPlateConfig.toFSPlate());
    }

    public Iterator<FSPlateConfig> plateConfigIterator() {
        return this.plateList.iterator();
    }

    public void clearPlateConfig() {
        this.plateList.clear();
    }

    public static FSConfig getInstance() {
        if (SC != null) {
            return SC;
        }
        FSConfig.refreshFSConfig();
        FSConfig.addFSPlate();
        return SC;
    }

    public static void release() {
        SC = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFSConfig() {
        Class<FSConfig> clazz = FSConfig.class;
        synchronized (FSConfig.class) {
            if (SC == null) {
                SC = new FSConfig();
            }
            SC.readXMLFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void addFSPlate() {
        HashSet<FSPlateConfig> hashSet = new HashSet<FSPlateConfig>();
        HashSet<FSPlateConfig> hashSet2 = new HashSet<FSPlateConfig>();
        hashSet.add(new FSPlateConfig(FSConstants.PLATE.PROCESS, "process", "com.fr.process.ProcessPlate", 13L, 1L));
        hashSet.add(new FSPlateConfig(FSConstants.PLATE.SCHEDULE, "schedule", "com.fr.schedule.SchedulePlate", 16L, 1L));
        hashSet.add(new FSPlateConfig(FSConstants.PLATE.BIS, "BI", "com.fr.bi.BIPlate", 15L, 1L));
        hashSet.add(new FSPlateConfig(FSConstants.PLATE.MOBILE, "MOBILE", "com.fr.mobile.FMobilePlate", 17L, 1L));
        hashSet.add(new FSPlateConfig(FSConstants.PLATE.BSDESIGNER, "bsdesigner", "com.fr.adhoc.AdhocPlate", 7L, 1L));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            FSConfig.addPlateByConfig((FSPlateConfig)iterator.next(), hashSet2);
        }
        FSConfig.registerPlateMapperAndService();
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            PlateFactory.deletePlateModule(FSDAOManager.createSession(), (FSPlateConfig)iterator.next());
        }
        if (FSConfig.getInstance().control instanceof TableDataDAOControl) {
            TableDataSyncDB.getInstance().initRolePlateIDMap();
        }
    }

    private static void addPlateByConfig(FSPlateConfig fSPlateConfig, HashSet<FSPlateConfig> hashSet) {
        FSPlate fSPlate = fSPlateConfig.toFSPlate();
        if (fSPlate == null || !fSPlate.isSupport()) {
            hashSet.add(fSPlateConfig);
            return;
        }
        FSHelper.addColumnFieldMappers4Company(fSPlate.columnMappers4Company());
        FSHelper.putColumnFieldMappers4Custom(fSPlate.columnMappers4Custom());
        SC.addPlateConfig(fSPlateConfig);
    }

    private static void registerPlateMapperAndService() {
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            FSPlate fSPlate = PlateFactory.getPlateWithPlateName(iterator.next());
            FSHelper.registerNecessaryMappers(fSPlate.mappers4Register());
            fSPlate.refreshManager();
            ReportDispatcher.registerGroupService(fSPlate.service4Register());
        }
    }

    private XMLReadable getNavigationImagesReader() {
        return new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = null;
                    String string2 = null;
                    byte[] byArray = null;
                    String string3 = null;
                    JSONObject jSONObject = new JSONObject();
                    String string4 = xMLableReader.getTagName();
                    if (ComparatorUtils.equals("navigationImg", string4)) {
                        string = xMLableReader.getAttrAsString("id", null);
                        string2 = xMLableReader.getAttrAsString("cls", null);
                        string3 = xMLableReader.getAttrAsString("type", null);
                        byArray = GeneralXMLTools.readByteArray(xMLableReader);
                        if (StringUtils.isNotBlank(string) && byArray != null) {
                            AttachmentSource.putAttachment(string, new Attachment(string, "image", string, byArray));
                        }
                        try {
                            jSONObject.put("id", string).put("cls", string2).put("type", string3);
                            FSConfig.this.navigationImages4FS.put(jSONObject);
                        }
                        catch (JSONException jSONException) {
                            FRLogger.getLogger().error(jSONException.getMessage());
                        }
                    }
                }
            }
        };
    }

    private XMLReadable getMobileDevReader() {
        return new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    try {
                        String string = null;
                        final JSONArray jSONArray = new JSONArray();
                        String string2 = xMLableReader.getTagName();
                        if (ComparatorUtils.equals("userdev", string2)) {
                            string = xMLableReader.getAttrAsString("username", null);
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (ComparatorUtils.equals(FMobileDeviceInfo.XML_TAG, xMLableReader.getTagName())) {
                                        FMobileDeviceInfo fMobileDeviceInfo = new FMobileDeviceInfo();
                                        xMLableReader.readXMLObject(fMobileDeviceInfo);
                                        jSONArray.put(fMobileDeviceInfo);
                                    }
                                }
                            });
                        }
                        if (StringUtils.isNotBlank(string) && jSONArray.length() > 0) {
                            FSConfig.this.getMobileDevInfo().put(string, jSONArray);
                        }
                    }
                    catch (JSONException jSONException) {
                        FRLogger.getLogger().error(jSONException.getMessage());
                    }
                }
            }
        };
    }

    private void readAttr(XMLableReader xMLableReader) {
        this.useFS = xMLableReader.getAttrAsBoolean("useFS", false);
        this.hasNavigation = xMLableReader.getAttrAsBoolean("hasNavigation", false);
        this.setLoginPageImg(xMLableReader.getAttrAsBoolean("isLoginPageImg", true));
        this.loginUrl4FS = xMLableReader.getAttrAsString("loginUrl", null);
        this.loginTitle4FS = xMLableReader.getAttrAsString("loginTitle", null);
        int n2 = xMLableReader.getAttrAsInt("controlType", 0);
        this.authenticateType = xMLableReader.getAttrAsString("authenticateType", null);
        this.style = xMLableReader.getAttrAsString("style", "darkblue");
        if (ComparatorUtils.equals(LDAP_AUTHENTICATION_TYPE, this.authenticateType)) {
            this.ldapUrl = xMLableReader.getAttrAsString("ldapUrl", null);
            this.referral = xMLableReader.getAttrAsString("referral", null);
            this.ldapSearchBase = xMLableReader.getAttrAsString("ldapSearchBase", null);
            this.authentication = xMLableReader.getAttrAsString("authentication", null);
            this.contextFactory = xMLableReader.getAttrAsString("contextFactory", null);
            this.principalSuffix = xMLableReader.getAttrAsString("principalSuffix", null);
            this.ldapSystemName = xMLableReader.getAttrAsString("ldapSystemName", null);
            this.ldapSystemPassword = xMLableReader.getAttrAsString("ldapSystemPassword", null);
        } else if (ComparatorUtils.equals(HTTP_AUTHENTICATION_TYPE, this.authenticateType)) {
            this.httpUrl = xMLableReader.getAttrAsString("httpUrl", null);
        }
        this.control = n2 == 1 ? TableDataDAOControl.getInstance() : HSQLDBDAOControl.getInstance();
        this.setHomePageURL(xMLableReader.getAttrAsString("homePageURL", null));
        this.setNeedUpdate(xMLableReader.getXMLVersion().needVersionUpdate());
        this.setLoginTitle4FS(xMLableReader.getAttrAsString("loginTitle", null));
        this.setMobiledevbind(xMLableReader.getAttrAsBoolean("mobiledevbind", false));
        this.setGradeAuthority(xMLableReader.getAttrAsBoolean("gradeAuthority", false));
        this.setEditReportAuthority(xMLableReader.getAttrAsBoolean("editReportAuthority", false));
        this.setDataConnectionAuthority(xMLableReader.getAttrAsBoolean("dataConnectionAuthority", false));
        this.setXmlVersion(xMLableReader.getAttrAsLong("xmlVersion", 0L));
        this.clearPlateConfig();
    }

    private void readChild(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals("tabledataConrol", string)) {
            xMLableReader.readXMLObject(this.tdControl);
            this.control.init();
        } else if (ComparatorUtils.equals("hsqlControl", string)) {
            xMLableReader.readXMLObject(this.hsqlControl);
            this.control.init();
        } else if (ComparatorUtils.equals("systemManagerFavoriteAndADHOCReport", string)) {
            xMLableReader.readXMLObject(this.sysManagerFvAndAD);
            this.sysManagerFvAndAD.init();
        } else if (ComparatorUtils.equals("loginImage", string)) {
            String string2 = xMLableReader.getAttrAsString("id", null);
            byte[] byArray = GeneralXMLTools.readByteArray(xMLableReader);
            if (StringUtils.isNotBlank(string2) && byArray != null) {
                this.setLoginImageID4FS(string2);
                AttachmentSource.putAttachment(string2, new Attachment(string2, "image", string2, byArray));
            }
        } else if (ComparatorUtils.equals("BGImage", string)) {
            String string3 = xMLableReader.getAttrAsString("id", null);
            byte[] byArray = GeneralXMLTools.readByteArray(xMLableReader);
            if (StringUtils.isNotBlank(string3) && byArray != null) {
                this.setBgImageID4FS(string3);
                AttachmentSource.putAttachment(string3, new Attachment(string3, "image", string3, byArray));
            }
        } else if (ComparatorUtils.equals("mobileDevs", string)) {
            xMLableReader.readXMLObject(this.getMobileDevReader());
        } else if (ComparatorUtils.equals("navigationImages", string)) {
            xMLableReader.readXMLObject(this.getNavigationImagesReader());
        }
    }

    private void writeControlXML(XMLPrintWriter xMLPrintWriter) {
        if (this.tdControl.hasSetTableDataSync()) {
            xMLPrintWriter.startTAG("tabledataConrol");
            this.tdControl.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (ComparatorUtils.equals(this.control.getControlType(), 0)) {
            xMLPrintWriter.startTAG("hsqlControl");
            this.hsqlControl.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    private void writeNavigationImagesXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getNavigationImages4FS().length() > 0) {
            xMLPrintWriter.startTAG("navigationImages");
            JSONArray jSONArray = this.getNavigationImages4FS();
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    xMLPrintWriter.startTAG("navigationImg");
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    xMLPrintWriter.attr("type", jSONObject.getString("type"));
                    xMLPrintWriter.attr("cls", jSONObject.getString("cls"));
                    xMLPrintWriter.attr("id", jSONObject.getString("id"));
                    if (StringUtils.isNotBlank(jSONObject.getString("id"))) {
                        GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(jSONObject.getString("id")).getBytes());
                    }
                    xMLPrintWriter.end();
                    continue;
                }
                catch (JSONException jSONException) {
                    FRLogger.getLogger().error(jSONException.getMessage());
                }
            }
            xMLPrintWriter.end();
        }
    }

    private void writeLoginImageIDXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getLoginImageID4FS())) {
            xMLPrintWriter.startTAG("loginImage");
            xMLPrintWriter.attr("id", this.getLoginImageID4FS());
            GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(this.getLoginImageID4FS()).getBytes());
            xMLPrintWriter.end();
        }
    }

    private void writeBGImageIDXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getBgImageID4FS())) {
            xMLPrintWriter.startTAG("BGImage");
            xMLPrintWriter.attr("id", this.getBgImageID4FS());
            GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(this.getBgImageID4FS()).getBytes());
            xMLPrintWriter.end();
        }
    }

    private void writeMobileDevXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getMobileDevInfo().length() > 0) {
            xMLPrintWriter.startTAG("mobileDevs");
            JSONObject jSONObject = this.getMobileDevInfo();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                xMLPrintWriter.startTAG("userdev");
                xMLPrintWriter.attr("username", string);
                try {
                    JSONArray jSONArray = jSONObject.getJSONArray(string);
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        FMobileDeviceInfo fMobileDeviceInfo = (FMobileDeviceInfo)jSONArray.get(i2);
                        fMobileDeviceInfo.writeXML(xMLPrintWriter);
                    }
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    private void writeHomePageURLXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getHomePageURL())) {
            xMLPrintWriter.attr("homePageURL", this.getHomePageURL());
        }
    }

    private void writeLoginTitleURLXML(XMLPrintWriter xMLPrintWriter) {
        if (null != this.loginTitle4FS) {
            xMLPrintWriter.attr("loginTitle", this.loginTitle4FS);
        }
    }

    private void writeSMFavoriteAndADHOCReportXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("systemManagerFavoriteAndADHOCReport");
        this.sysManagerFvAndAD.writeXML(xMLPrintWriter);
    }

    private FSConfig() {
    }

    public boolean isUseFS() {
        return this.useFS;
    }

    public void setUseFS(boolean bl) {
        this.useFS = bl;
    }

    @Override
    public String fileName() {
        return "fsconfig.xml";
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.readAttr(xMLableReader);
        }
        if (xMLableReader.isChildNode()) {
            this.readChild(xMLableReader);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("useFS", this.useFS);
        xMLPrintWriter.attr("loginUrl", this.loginUrl4FS);
        this.writeHomePageURLXML(xMLPrintWriter);
        this.writeLoginTitleURLXML(xMLPrintWriter);
        xMLPrintWriter.attr("isLoginPageImg", this.isLoginPageImg);
        xMLPrintWriter.attr("hasNavigation", this.hasNavigation);
        xMLPrintWriter.attr("mobiledevbind", this.mobiledevbind);
        xMLPrintWriter.attr("style", this.style);
        xMLPrintWriter.attr("gradeAuthority", this.gradeAuthority);
        xMLPrintWriter.attr("editReportAuthority", this.editReportAuthority);
        xMLPrintWriter.attr("dataConnectionAuthority", this.dataConnectionAuthority);
        if (StringUtils.isNotEmpty(this.authenticateType)) {
            xMLPrintWriter.attr("authenticateType", this.authenticateType);
            if (ComparatorUtils.equals(LDAP_AUTHENTICATION_TYPE, this.authenticateType)) {
                xMLPrintWriter.attr("ldapUrl", this.ldapUrl);
                xMLPrintWriter.attr("ldapSearchBase", this.ldapSearchBase);
                xMLPrintWriter.attr("authentication", this.authentication);
                xMLPrintWriter.attr("contextFactory", this.contextFactory);
                xMLPrintWriter.attr("referral", this.referral);
                xMLPrintWriter.attr("principalSuffix", this.principalSuffix);
                xMLPrintWriter.attr("ldapSystemName", this.ldapSystemName);
                xMLPrintWriter.attr("ldapSystemPassword", this.ldapSystemPassword);
            } else if (ComparatorUtils.equals(HTTP_AUTHENTICATION_TYPE, this.authenticateType)) {
                xMLPrintWriter.attr("httpUrl", this.httpUrl);
            }
        }
        xMLPrintWriter.attr("controlType", this.control.getControlType());
        this.writeControlXML(xMLPrintWriter);
        this.writeSMFavoriteAndADHOCReportXML(xMLPrintWriter);
        xMLPrintWriter.end();
        this.writeNavigationImagesXML(xMLPrintWriter);
        this.writeLoginImageIDXML(xMLPrintWriter);
        this.writeBGImageIDXML(xMLPrintWriter);
        this.writeMobileDevXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public Control getControl() {
        return this.control;
    }

    public boolean setControl(Control control) {
        this.control = control;
        boolean bl = control.init();
        if (bl) {
            try {
                FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public String getHomePageURL() {
        return this.homePageURL != null ? this.homePageURL : "http://www.finereport.com";
    }

    public void setHomePageURL(String string) {
        this.homePageURL = string;
    }

    public void clearCache() {
        UserCache.removeAllCache();
        try {
            CustomRoleCache.clearCache();
            CompanyRoleCache.clearCache();
            DepartmentCache.clearCache();
            CompanyRoleControl.getInstance().reset();
            CustomRoleControl.getInstance().reset();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    public String getLoginImageID4FS() {
        return this.loginImageID4FS;
    }

    public void setLoginImageID4FS(String string) {
        this.loginImageID4FS = string;
    }

    public String getBgImageID4FS() {
        return this.bgImageID4FS;
    }

    public void setBgImageID4FS(String string) {
        this.bgImageID4FS = string;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void setHttpUrl(String string) {
        this.httpUrl = string;
    }

    public String getLoginUrl4FS() {
        return this.loginUrl4FS;
    }

    public void setLoginUrl4FS(String string) {
        this.loginUrl4FS = string;
    }

    public boolean needUpdate() {
        return this.needUpdate;
    }

    public void setNeedUpdate(boolean bl) {
        this.needUpdate = bl;
    }

    public String getLoginTitle4FS() {
        if (StringUtils.isBlank(this.loginTitle4FS)) {
            return FRContext.getCompanyName() + Inter.getLocText("FS_Name");
        }
        return this.loginTitle4FS;
    }

    public String getRealLoginTitle4FS() {
        return this.loginTitle4FS;
    }

    public void setLoginTitle4FS(String string) {
        this.loginTitle4FS = string;
    }

    public void setCurrentAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.currentAuthenticationProvider = authenticationProvider;
    }

    public AuthenticationProvider getCurrentAuthenticationProvider() {
        if (this.currentAuthenticationProvider == null) {
            return UserNamePassWordFSAuthenticationProvider.getInstance();
        }
        return this.currentAuthenticationProvider;
    }

    public String getAuthenticateType() {
        if (StringUtils.isEmpty(this.authenticateType)) {
            return DEFAULT_AUTHENTICATION_TYPE;
        }
        return this.authenticateType;
    }

    public void setAuthenticateType(String string) {
        this.authenticateType = string;
    }

    public String getLdapUrl() {
        if (StringUtils.isNotEmpty(this.ldapUrl) && this.ldapUrl.length() > 100) {
            this.ldapUrl = "";
        }
        return this.ldapUrl;
    }

    public void setLdapUrl(String string) {
        this.ldapUrl = string;
    }

    public String getLdapSearchBase() {
        if (StringUtils.isNotEmpty(this.ldapSearchBase) && this.ldapSearchBase.length() > 100) {
            this.ldapSearchBase = "";
        }
        return this.ldapSearchBase;
    }

    public void setLdapSearchBase(String string) {
        this.ldapSearchBase = string;
    }

    public String getAuthentication() {
        if (StringUtils.isEmpty(this.authentication)) {
            this.authentication = AUTH_SIMPLE;
        }
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getContextFactory() {
        if (StringUtils.isEmpty(this.contextFactory)) {
            this.contextFactory = SUN_DEFAULT_CONTEXT_FACTORY;
        }
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getReferral() {
        if (StringUtils.isEmpty(this.referral)) {
            this.referral = REFERRAL_FOLLOW;
        }
        return this.referral;
    }

    public void setReferral(String string) {
        this.referral = string;
    }

    public String getPrincipalSuffix() {
        if (StringUtils.isNotEmpty(this.principalSuffix) && this.principalSuffix.length() > 100) {
            this.principalSuffix = "";
        }
        return this.principalSuffix;
    }

    public void setPrincipalSuffix(String string) {
        this.principalSuffix = string;
    }

    public String getLdapSystemName() {
        if (StringUtils.isNotEmpty(this.ldapSystemName) && this.ldapSystemName.length() > 100) {
            this.ldapSystemName = "";
        }
        return this.ldapSystemName;
    }

    public void setLdapSystemName(String string) {
        this.ldapSystemName = string;
    }

    public String getLdapSystemPassword() {
        if (StringUtils.isNotEmpty(this.ldapSystemPassword) && this.ldapSystemPassword.length() > 100) {
            this.ldapSystemPassword = "";
        }
        return this.ldapSystemPassword;
    }

    public void setLdapSystemPassword(String string) {
        this.ldapSystemPassword = string;
    }

    public boolean isMobiledevbind() {
        return this.mobiledevbind;
    }

    public void setMobiledevbind(boolean bl) {
        this.mobiledevbind = bl;
    }

    public JSONObject getMobileDevInfo() {
        return this.mobileDevInfo;
    }

    public void setMobileDevInfo(JSONObject jSONObject) {
        this.mobileDevInfo = jSONObject;
    }

    public boolean isLoginPageImg() {
        return this.isLoginPageImg;
    }

    public void setLoginPageImg(boolean bl) {
        this.isLoginPageImg = bl;
    }

    public boolean hasNavigation() {
        return this.hasNavigation;
    }

    public void setNavigation(boolean bl) {
        this.hasNavigation = bl;
    }

    public JSONArray getNavigationImages4FS() {
        return this.navigationImages4FS;
    }

    public void setNavigationImages4FS(JSONArray jSONArray) {
        this.navigationImages4FS = jSONArray;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public ActionNoSessionCMD getLoginAction() {
        return this.loginAction;
    }

    public void setLoginAction(ActionNoSessionCMD actionNoSessionCMD) {
        this.loginAction = actionNoSessionCMD;
    }

    public boolean hasMultiPrivilege() {
        return this.hasGradeAuth;
    }

    public boolean isGradeAuthority() {
        return this.hasGradeAuth && this.gradeAuthority;
    }

    public void setGradeAuthority(boolean bl) {
        this.gradeAuthority = this.hasGradeAuth && bl;
    }

    public boolean isEditReportAuthority() {
        return this.hasGradeAuth && this.editReportAuthority;
    }

    public void setEditReportAuthority(boolean bl) {
        this.editReportAuthority = this.hasGradeAuth && bl;
    }

    public boolean isDataConnectionAuthority() {
        return this.dataConnectionAuthority;
    }

    public void setDataConnectionAuthority(boolean bl) {
        this.dataConnectionAuthority = bl;
    }

    public long getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(long l2) {
        this.xmlVersion = l2;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                SC = null;
            }
        });
    }
}

