/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.dao.RelationObject;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.NameTableData;
import com.fr.fs.FSConfig;
import com.fr.fs.FSRegisterForBI;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.hsqldb.HSQLCompanyRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLCustomRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataCompanyRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.privilege.auth.AuthorityControlFilter;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.json.JSONObject;
import com.fr.privilege.Authority;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.allocation.Allocation;
import com.fr.privilege.allocation.AuthorityAllocation;
import com.fr.privilege.allocation.FileFrag;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.privilege.base.PrivilegeFilterRegister;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.HttpAuthenticationProvider;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.DaoAuthenticationProvider;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.ldap.LDAPAuthenticationProvider;
import com.fr.stable.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.util.HashTable;

public class FSCompatible {
    private static FSCompatible fsCompatible = new FSCompatible();

    private FSCompatible() {
    }

    public static FSCompatible getInstance() {
        return fsCompatible;
    }

    public void makeCompatible() throws Exception {
        this.makePlatFormRoleCompatible();
        this.initTemplateAndDataConnectionPrivilegeCompatible();
    }

    public void makePlatFormCompatible() throws Exception {
        this.makePrivilegeManagerCompatible();
    }

    public void makeFSCompatible() throws Exception {
        this.makeCompanyRoleCompatible();
        this.makeModulePrivilegeCompatible();
    }

    public void makePlatFormRoleCompatible() {
        Authority[] authorityArray;
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider instanceof DaoAuthenticationProvider) {
            authorityArray = (Authority[])authenticationProvider;
            if (!FSRegisterForBI.isSupportFS() && ComparatorUtils.equals(authorityArray.getUserConfig().tableDataName, authorityArray.getRoleConfig().tableDataName)) {
                return;
            }
        }
        try {
            authorityArray = authenticationProvider.listAuthorities();
            int n2 = authorityArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = authorityArray[i2].getName();
                CustomRole customRole = new CustomRole(string, "");
                if (CustomRoleControl.getInstance().findByCustomRoleName(string) != null) continue;
                CustomRoleControl.getInstance().addCustomRole(customRole);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void makeCompanyRoleCompatible() {
        if (!FSRegisterForBI.isSupportFS() || FSConfig.getInstance().getControl().getControlType() == 1) {
            return;
        }
        try {
            List list = UserControl.getInstance().findAllUserWithoutSort();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                User user = (User)list.get(i2);
                Set set = UserControl.getInstance().getJobs(user.getId());
                for (RelationObject relationObject : set) {
                    long l2 = (Long)relationObject.getValue(Post.class);
                    long l3 = (Long)relationObject.getValue(Department.class);
                    CompanyRoleControl.getInstance().addCompanyRole(new CompanyRole(l2, l3, ""));
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void makePrivilegeManagerCompatible() throws Exception {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        FSConfig fSConfig = FSConfig.getInstance();
        if (authenticationProvider instanceof DaoAuthenticationProvider) {
            DaoAuthenticationProvider daoAuthenticationProvider = (DaoAuthenticationProvider)authenticationProvider;
            this.combineTableData(daoAuthenticationProvider);
        } else if (authenticationProvider instanceof LDAPAuthenticationProvider) {
            LDAPAuthenticationProvider lDAPAuthenticationProvider = (LDAPAuthenticationProvider)authenticationProvider;
            fSConfig.setLdapUrl(lDAPAuthenticationProvider.getUrl());
            fSConfig.setReferral(lDAPAuthenticationProvider.getReferral());
            fSConfig.setContextFactory(lDAPAuthenticationProvider.getContextFactory());
            fSConfig.setAuthentication(lDAPAuthenticationProvider.getRoleAttribute());
            fSConfig.setLdapSearchBase(lDAPAuthenticationProvider.getSearchBase());
            fSConfig.setPrincipalSuffix(lDAPAuthenticationProvider.getPrincipalSuffix());
            fSConfig.setLdapSystemName(lDAPAuthenticationProvider.getSystemUsername());
            fSConfig.setLdapSystemPassword(lDAPAuthenticationProvider.getSystemPassword());
            fSConfig.setAuthenticateType("ldap");
        } else if (authenticationProvider instanceof HttpAuthenticationProvider) {
            HttpAuthenticationProvider httpAuthenticationProvider = (HttpAuthenticationProvider)authenticationProvider;
            fSConfig.setAuthenticateType("http");
            fSConfig.setHttpUrl(httpAuthenticationProvider.getUrl());
        } else {
            fSConfig.setAuthenticateType("default");
        }
    }

    private void makeModulePrivilegeCompatible() throws Exception {
        if (FSConfig.getInstance().getControl().getControlType() == 0) {
            this.hsqlGradeAuthorityCompatible();
        } else {
            this.syncModulePrivilegeCompatible(true);
            this.syncModulePrivilegeCompatible(false);
        }
    }

    private void syncModulePrivilegeCompatible(boolean bl) throws Exception {
        EmbeddedTableData embeddedTableData = bl ? TableDataDAOControl.getInstance().getJRole_ModuleTableData() : TableDataDAOControl.getInstance().getSRole_ModuleTableData();
        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        int n2 = embeddedTableData.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cloneable cloneable;
            long l2;
            long l3 = Long.parseLong(embeddedTableData.getValueAt(i2, 3).toString());
            long l4 = Long.parseLong(embeddedTableData.getValueAt(i2, 1).toString());
            long l5 = embeddedTableData.getValueAt(i2, 4) == null ? 1L : Long.parseLong(embeddedTableData.getValueAt(i2, 4).toString());
            long l6 = l2 = embeddedTableData.getValueAt(i2, 5) == null ? 0L : Long.parseLong(embeddedTableData.getValueAt(i2, 5).toString());
            if (l3 == 3L) {
                FSConfig.getInstance().setGradeAuthority(true);
                cloneable = new RoleModulePrivilege(18L, l5, l2);
                LinkedList<RoleModulePrivilege> linkedList = new LinkedList<RoleModulePrivilege>();
                linkedList.add((RoleModulePrivilege)cloneable);
                this.updateModulePrivilege(l4, linkedList, new LinkedList(), bl);
            }
            if (!this.needSystemMonitorRemove(l3)) continue;
            if (hashMap.get(l4) == null) {
                hashMap.put(l4, false);
            }
            if (l2 == 1L) {
                hashMap.put(l4, true);
            }
            cloneable = new LinkedList();
            cloneable.add(new RoleModulePrivilege(l4, l3, l5, l2));
            this.updateModulePrivilege(l4, new LinkedList(), (List)((Object)cloneable), bl);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l7 = (Long)iterator.next();
            boolean bl2 = (Boolean)hashMap.get(l7);
            RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(9L, 1L, 0L);
            if (bl2) {
                roleModulePrivilege.setAuthorized(1L);
            }
            LinkedList<RoleModulePrivilege> linkedList = new LinkedList<RoleModulePrivilege>();
            linkedList.add(roleModulePrivilege);
            this.updateModulePrivilege(l7, linkedList, new LinkedList(), bl);
        }
    }

    private void updateModulePrivilege(long l2, List list, List list2, boolean bl) throws Exception {
        if (bl) {
            TableDataCompanyRoleDAO.getInstance().updateModulePrivileges(l2, list, list2);
            try {
                CompanyRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(l2));
            }
            catch (Exception exception) {
                CompanyRoleCache.reinitCache();
            }
        } else {
            TableDataCustomRoleDAO.getInstance().updateModulePrivileges(l2, list, list2);
            try {
                CustomRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(l2));
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
        }
    }

    private boolean needSystemMonitorRemove(long l2) {
        return l2 == 9L || l2 == 10L || l2 == 11L || l2 == 12L;
    }

    private void hsqlGradeAuthorityCompatible() throws Exception {
        this.hsqlCompanyRoleModulePrivilgeCompatible();
        this.hsqlCustomRoleModulePrivilegeCompatible();
    }

    private void hsqlCompanyRoleModulePrivilgeCompatible() throws Exception {
        List list = HSQLCompanyRoleDAO.getInstance().findAll();
        for (CompanyRole companyRole : list) {
            Cloneable cloneable2;
            Set set = HSQLCompanyRoleDAO.getInstance().getModulePrivileges(companyRole.getId());
            boolean bl = false;
            boolean bl2 = false;
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            for (Cloneable cloneable2 : set) {
                if (((RoleModulePrivilege)cloneable2).getModuleid() == 3L) {
                    FSConfig.getInstance().setGradeAuthority(true);
                    long l2 = ((RoleModulePrivilege)cloneable2).getRoleId();
                    RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(l2, 18L, ((RoleModulePrivilege)cloneable2).getView(), ((RoleModulePrivilege)cloneable2).getAuthorized());
                    LinkedList<RoleModulePrivilege> linkedList2 = new LinkedList<RoleModulePrivilege>();
                    linkedList2.add(roleModulePrivilege);
                    HSQLCompanyRoleDAO.getInstance().updateModulePrivileges(l2, linkedList2, new LinkedList());
                    try {
                        CompanyRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(l2));
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                        CompanyRoleCache.reinitCache();
                    }
                    continue;
                }
                if (!this.needSystemMonitorRemove(((RoleModulePrivilege)cloneable2).getModuleid())) continue;
                bl = true;
                if (((RoleModulePrivilege)cloneable2).getAuthorized() == 1L) {
                    bl2 = true;
                }
                linkedList.add(cloneable2);
            }
            if (!bl) continue;
            RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(9L, 1L, 0L);
            if (bl2) {
                roleModulePrivilege.setAuthorized(1L);
            }
            cloneable2 = new LinkedList();
            cloneable2.add(roleModulePrivilege);
            HSQLCompanyRoleDAO.getInstance().updateModulePrivileges(companyRole.getId(), (List)((Object)cloneable2), linkedList);
            try {
                CompanyRoleCache.refreshModulePrivileges(companyRole.getId(), FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(companyRole.getId()));
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                CompanyRoleCache.reinitCache();
            }
        }
    }

    private void hsqlCustomRoleModulePrivilegeCompatible() throws Exception {
        List list = HSQLCustomRoleDAO.getInstance().findAll();
        for (CustomRole customRole : list) {
            Cloneable cloneable2;
            Set set = HSQLCustomRoleDAO.getInstance().getModulePrivileges(customRole.getId());
            boolean bl = false;
            boolean bl2 = false;
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            for (Cloneable cloneable2 : set) {
                if (((RoleModulePrivilege)cloneable2).getModuleid() == 3L) {
                    FSConfig.getInstance().setGradeAuthority(true);
                    long l2 = ((RoleModulePrivilege)cloneable2).getRoleId();
                    RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(l2, 18L, ((RoleModulePrivilege)cloneable2).getView(), ((RoleModulePrivilege)cloneable2).getAuthorized());
                    LinkedList<RoleModulePrivilege> linkedList2 = new LinkedList<RoleModulePrivilege>();
                    linkedList2.add(roleModulePrivilege);
                    HSQLCustomRoleDAO.getInstance().updateModulePrivileges(l2, linkedList2, new LinkedList());
                    try {
                        CustomRoleCache.refreshModulePrivileges(l2, FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(l2));
                    }
                    catch (Exception exception) {
                        CustomRoleCache.reInitCache();
                    }
                    continue;
                }
                if (!this.needSystemMonitorRemove(((RoleModulePrivilege)cloneable2).getModuleid())) continue;
                bl = true;
                if (((RoleModulePrivilege)cloneable2).getAuthorized() == 1L) {
                    bl2 = true;
                }
                linkedList.add(cloneable2);
            }
            if (!bl) continue;
            RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(9L, 1L, 0L);
            if (bl2) {
                roleModulePrivilege.setAuthorized(1L);
            }
            cloneable2 = new LinkedList();
            cloneable2.add(roleModulePrivilege);
            HSQLCustomRoleDAO.getInstance().updateModulePrivileges(customRole.getId(), (List)((Object)cloneable2), linkedList);
            try {
                CustomRoleCache.refreshModulePrivileges(customRole.getId(), FSConfig.getInstance().getControl().getCustomRoleDAO().getModulePrivileges(customRole.getId()));
            }
            catch (Exception exception) {
                CustomRoleCache.reInitCache();
            }
        }
    }

    private void initTemplateAndDataConnectionPrivilegeCompatible() throws Exception {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        PrivilegeFilter privilegeFilter = privilegeManager.getPrivilegeFilter();
        if (privilegeFilter instanceof com.fr.privilege.filter.AuthorityControlFilter) {
            com.fr.privilege.filter.AuthorityControlFilter authorityControlFilter = (com.fr.privilege.filter.AuthorityControlFilter)privilegeFilter;
            Iterator iterator = authorityControlFilter.authorityAllocationIterator();
            while (iterator.hasNext()) {
                AuthorityAllocation authorityAllocation = (AuthorityAllocation)((Map.Entry)iterator.next()).getValue();
                String string = authorityAllocation.getAuthority().getName();
                Allocation allocation = authorityAllocation.getAllocation();
                if (StringUtils.isBlank(string)) continue;
                LinkedList linkedList = new LinkedList();
                this.addPagePrivilege(allocation, linkedList);
                this.addWritePrivilege(allocation, linkedList);
                this.addDesignPrivilege(allocation, linkedList);
                HashSet<String> hashSet = allocation.getDSPrivilege();
                if (!hashSet.isEmpty()) {
                    FSConfig.getInstance().setDataConnectionAuthority(true);
                }
                LinkedList<String> linkedList2 = new LinkedList<String>();
                linkedList2.addAll(hashSet);
                CustomRole customRole = CustomRoleControl.getInstance().findByCustomRoleName(string);
                if (customRole.getId() <= -1000L) {
                    TableDataCustomRoleDAO.getInstance().updateTemplatePrivileges(string, linkedList, new LinkedList());
                    TableDataCustomRoleDAO.getInstance().updateDataConnectionPrivileges(string, linkedList2, new LinkedList());
                    try {
                        CustomRoleCache.refreshTemplatePrivileges(string, TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(string));
                        CustomRoleCache.refreshDataConnectionPrivileges(string, TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(string));
                    }
                    catch (Exception exception) {
                        CustomRoleCache.reInitCache();
                    }
                    continue;
                }
                HashSet hashSet2 = new HashSet();
                HashSet<String> hashSet3 = new HashSet<String>();
                hashSet2.addAll(linkedList);
                hashSet3.addAll(linkedList2);
                CustomRoleControl.getInstance().updateTemplatePrivileges(customRole.getId(), hashSet2, new HashSet());
                CustomRoleControl.getInstance().updateDataConnectionPrivileges(customRole.getId(), hashSet3, new HashSet());
            }
            privilegeManager.setPrivilegeFilter(new AuthorityControlFilter());
            PrivilegeFilterRegister.registPrivilegeFilter(privilegeManager.getPrivilegeFilter());
            FRContext.getCurrentEnv().writeResource(privilegeManager);
        }
    }

    private void addPagePrivilege(Allocation allocation, List list) {
        int n2 = allocation.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileFrag fileFrag = allocation.getView(i2);
            String string = fileFrag.getPath().substring(1);
            RoleTemplatePrivilege roleTemplatePrivilege = this.getRoleTemplatePrivilegeFromSet(list, string);
            boolean bl = true;
            if (!StringUtils.isBlank(roleTemplatePrivilege.getPath())) {
                bl = false;
            }
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setPage(1L);
            if (!bl) continue;
            list.add(roleTemplatePrivilege);
        }
    }

    private void addWritePrivilege(Allocation allocation, List list) {
        int n2 = allocation.getWriteCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileFrag fileFrag = allocation.getWrite(i2);
            String string = fileFrag.getPath().substring(1);
            RoleTemplatePrivilege roleTemplatePrivilege = this.getRoleTemplatePrivilegeFromSet(list, string);
            boolean bl = true;
            if (!StringUtils.isBlank(roleTemplatePrivilege.getPath())) {
                bl = false;
            }
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setWrite(1L);
            if (!bl) continue;
            list.add(roleTemplatePrivilege);
        }
    }

    private void addDesignPrivilege(Allocation allocation, List list) {
        int n2 = allocation.getDesignCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileFrag fileFrag = allocation.getDesign(i2);
            String string = fileFrag.getPath().substring(1);
            RoleTemplatePrivilege roleTemplatePrivilege = this.getRoleTemplatePrivilegeFromSet(list, string);
            boolean bl = true;
            if (!StringUtils.isBlank(roleTemplatePrivilege.getPath())) {
                bl = false;
            }
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setDesign(1L);
            if (!bl) continue;
            list.add(roleTemplatePrivilege);
        }
    }

    private RoleTemplatePrivilege getRoleTemplatePrivilegeFromSet(List list, String string) {
        for (Object e2 : list) {
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)e2;
            if (!ComparatorUtils.equals(roleTemplatePrivilege.getPath(), string)) continue;
            return roleTemplatePrivilege;
        }
        return new RoleTemplatePrivilege();
    }

    private void combineTableData(DaoAuthenticationProvider daoAuthenticationProvider) throws Exception {
        JSONObject jSONObject = new JSONObject();
        String string = daoAuthenticationProvider.getUserConfig().tableDataName;
        jSONObject.put("dsName", string);
        NameTableData nameTableData = new NameTableData(string);
        DataModel dataModel = nameTableData == null ? null : nameTableData.createDataModel(null);
        HashTable hashTable = new HashTable();
        int n2 = dataModel.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            hashTable.put((Object)dataModel.getColumnName(i2), (Object)i2);
        }
        jSONObject.put("userName", hashTable.get((Object)daoAuthenticationProvider.getUserConfig().usernameField));
        jSONObject.put("name", -1);
        jSONObject.put("password", hashTable.get((Object)daoAuthenticationProvider.getUserConfig().authenticationField));
        if (ComparatorUtils.equals(daoAuthenticationProvider.getRoleConfig().tableDataName, daoAuthenticationProvider.getUserConfig().tableDataName)) {
            jSONObject.put("role", hashTable.get((Object)daoAuthenticationProvider.getRoleConfig().authenticationField));
        } else {
            jSONObject.put("role", -1);
        }
        jSONObject.put("mobile", -1);
        if (ComparatorUtils.equals(daoAuthenticationProvider.getUserConfig().tableDataName, ConfigManager.getInstance().getEmailManager().getContactsTableDataName())) {
            jSONObject.put("email", hashTable.get((Object)ConfigManager.getInstance().getEmailManager().getContactsAddressCol()));
        } else {
            jSONObject.put("email", -1);
        }
        if (daoAuthenticationProvider.getPasswordValidator() instanceof ClassPasswordValidator) {
            ClassPasswordValidator classPasswordValidator = (ClassPasswordValidator)daoAuthenticationProvider.getPasswordValidator();
            jSONObject.put("encrypt", 1);
            jSONObject.put("myencrypt", classPasswordValidator.getClassName());
        } else if (daoAuthenticationProvider.getPasswordValidator() instanceof MessageDigestPasswordValidator) {
            jSONObject.put("encrypt", 2);
        } else {
            jSONObject.put("encrypt", 0);
        }
        TableDataDAOControl tableDataDAOControl = TableDataDAOControl.getInstance();
        tableDataDAOControl.parseJSON(jSONObject);
        FSConfig fSConfig = FSConfig.getInstance();
        if (tableDataDAOControl.hasSetTableDataSync()) {
            fSConfig.setControl(tableDataDAOControl);
        }
        fSConfig.setAuthenticateType("default");
    }
}

