/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Utils;
import com.fr.data.core.DataCoreUtils;
import com.fr.form.data.DataBinding;
import com.fr.form.data.DataTableConfig;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FCloneable;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

public class WidgetValue
implements XMLable {
    private static final long serialVersionUID = -2725281684697677231L;
    public static final String XML_TAG = "widgetValue";
    private Object value;
    private Object calculatedValue;
    private boolean calculated;

    public WidgetValue() {
    }

    public WidgetValue(Object object) {
        this.value = object;
    }

    public static Object text2Config(String string, CalculatorProvider calculatorProvider) {
        if (StringUtils.isNotEmpty(string) && string.charAt(0) == '=') {
            try {
                return calculatorProvider.eval(string);
            }
            catch (UtilEvalError utilEvalError) {
                return string;
            }
        }
        return string;
    }

    public static void convertWidgetValue(DataControl dataControl, Object object) {
        WidgetValue widgetValue = new WidgetValue(object);
        int[] nArray = dataControl.getValueType();
        if (!WidgetValue.containConvertType(nArray, widgetValue, dataControl)) {
            widgetValue = new WidgetValue();
        }
        dataControl.setWidgetValue(widgetValue);
    }

    private static boolean containConvertType(int[] nArray, WidgetValue widgetValue, DataControl dataControl) {
        return ArrayUtils.contains(nArray, 3) && widgetValue.castToFormula() || ArrayUtils.contains(nArray, 0) && widgetValue.castToDouble() || ArrayUtils.contains(nArray, 5) && widgetValue.castToBoolean() || ArrayUtils.contains(nArray, 4) && widgetValue.castToDate(((DateEditor)dataControl).getFormatText()) || ArrayUtils.contains(nArray, 1) && widgetValue.castToString();
    }

    private boolean castToDouble() {
        if (this.value instanceof Double) {
            return true;
        }
        Double d2 = null;
        try {
            d2 = Double.valueOf(this.value.toString());
        }
        catch (Exception exception) {
            return false;
        }
        this.value = d2;
        return true;
    }

    private boolean castToFormula() {
        if (this.value instanceof Formula) {
            return true;
        }
        if (StableUtils.canBeFormula(this.value.toString())) {
            this.value = new Formula(this.value.toString());
            return true;
        }
        return false;
    }

    private boolean castToBoolean() {
        if (this.value instanceof Boolean) {
            return true;
        }
        if (ComparatorUtils.equals(this.value.toString(), "true") || ComparatorUtils.equals(this.value.toString(), "false")) {
            this.value = new Boolean(this.value.toString());
            return true;
        }
        return false;
    }

    private boolean castToDate(String string) {
        if (this.value instanceof Date) {
            return true;
        }
        try {
            Date date = new SimpleDateFormat(string).parse(this.value.toString());
            if (date == null) {
                return false;
            }
            this.value = date;
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private boolean castToString() {
        this.value = this.value.toString();
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public String[] getDependence(Calculator calculator) {
        return BaseUtils.getDependence(this.value, calculator);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.value instanceof DataBinding) {
            xMLPrintWriter.startTAG("databinding").textNode(this.getValue().toString()).end();
        } else if (this.value instanceof DataTableConfig) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, (DataTableConfig)this.value, "tableDataConfig");
            ((DataTableConfig)this.value).writeXML(xMLPrintWriter);
        } else {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.value);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("O".equals(string)) {
                this.value = GeneralXMLTools.readObject(xMLableReader);
            } else if (ComparatorUtils.equals("tableDataConfig", string)) {
                this.value = new DataTableConfig();
                xMLableReader.readXMLObject((XMLReadable)this.value);
            } else if ("databinding".equals(string)) {
                this.value = DataBinding.String2DataBinding(xMLableReader.getElementValue());
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof WidgetValue && ComparatorUtils.equals(this.value, ((WidgetValue)object).value);
    }

    public Object clone() throws CloneNotSupportedException {
        WidgetValue widgetValue = (WidgetValue)super.clone();
        if (this.value instanceof FCloneable) {
            widgetValue.value = ((FCloneable)this.value).clone();
        }
        return widgetValue;
    }

    public void createJSONConfig(JSONObject jSONObject, Calculator calculator) {
        if (this.calculated) {
            this.calculated = false;
            try {
                jSONObject.put("value", this.calculatedValue);
                Object[] objectArray = this.getDependence(calculator);
                if (!ArrayUtils.isEmpty(objectArray)) {
                    jSONObject.put("valueDependence", objectArray);
                }
                if (this.value instanceof DataBinding) {
                    jSONObject.put("Databinding", new JSONObject(this.getValue().toString()));
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException.getCause());
            }
        } else {
            try {
                if (this.value instanceof DataBinding) {
                    jSONObject.put("Databinding", new JSONObject(this.getValue().toString()));
                } else if (this.value instanceof Formula) {
                    jSONObject.put("value", WidgetValue.text2Config(((Formula)this.value).getContent(), calculator));
                } else if (this.value != null) {
                    jSONObject.put("value", this.value);
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException.getCause());
            }
        }
    }

    public Object createAttrResult(WidgetValueInfo widgetValueInfo, Calculator calculator, JSONObject jSONObject) {
        Object object = null;
        Object object2 = null;
        try {
            LinkedList linkedList = calculator.getNameSpaceList();
            for (int i2 = 0; i2 < linkedList.size(); ++i2) {
                if (!(linkedList.get(i2) instanceof ParameterMapNameSpace)) continue;
                object2 = ((NameSpace)linkedList.get(i2)).getVariable("$" + widgetValueInfo.widgetName, calculator);
            }
            object = object2 != null && !StringUtils.isEmpty(Utils.objectToString(object2)) ? object2 : (this.getValue() != null && !StringUtils.isEmpty(Utils.objectToString(this.getValue())) ? (this.value instanceof DataBinding ? this.calculatorDataBinding((DataBinding)this.value, calculator, jSONObject, widgetValueInfo) : (this.value instanceof DataTableConfig ? ((DataTableConfig)this.value).createAttrResult(calculator) : (this.value instanceof String ? BaseUtils.textToString((String)this.value) : this.value))) : calculator.eval("$" + widgetValueInfo.widgetName));
        }
        catch (UtilEvalError utilEvalError) {
            FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        return this.setAttrResult(widgetValueInfo, calculator, jSONObject, object);
    }

    private Object setAttrResult(WidgetValueInfo widgetValueInfo, Calculator calculator, JSONObject jSONObject, Object object) {
        if (object instanceof Formula) {
            try {
                object = calculator.eval((Formula)object);
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        }
        this.calculatedValue = object == null ? "" : object;
        this.calculated = true;
        return object;
    }

    public void renameTableData(String string, String string2) {
        DataTableConfig dataTableConfig;
        if (this.value instanceof DataBinding) {
            DataBinding dataBinding = (DataBinding)this.value;
            if (ComparatorUtils.equals(dataBinding.getDataSourceName(), string)) {
                dataBinding.setDataSourceName(string2);
            }
        } else if (this.value instanceof DataTableConfig && ComparatorUtils.equals((dataTableConfig = (DataTableConfig)this.value).getTableDataName(), string)) {
            dataTableConfig.setTableName(string2);
        }
    }

    public String getDisplayValue() {
        if (this.value instanceof String) {
            return BaseUtils.textToString((String)this.value);
        }
        return this.value == null ? "" : this.value.toString();
    }

    private boolean isValueEmpty(Object object) {
        return object == null || ComparatorUtils.equals(object, "") || object == Primitive.NULL;
    }

    private Object calculatorDataBinding(DataBinding dataBinding, Calculator calculator, JSONObject jSONObject, WidgetValueInfo widgetValueInfo) {
        if (dataBinding.validate()) {
            String string = dataBinding.getDataSourceName();
            if (!jSONObject.has(string)) {
                this.setDataBindingValue(string, calculator, jSONObject);
            }
            try {
                DataModel dataModel = (DataModel)jSONObject.get(string);
                try {
                    int n2 = dataModel.getRowCount();
                    if (n2 > 0) {
                        int n3 = dataModel.getColumnCount();
                        for (int i2 = 0; i2 < n3; ++i2) {
                            if (!ComparatorUtils.equals(dataModel.getColumnName(i2).trim(), dataBinding.getDataBindingKey())) continue;
                            if (widgetValueInfo.returnArray && n2 > 1) {
                                if (widgetValueInfo.removeRepeat) {
                                    HashSet<Object> hashSet = new HashSet<Object>();
                                    for (int i3 = 0; i3 < n2; ++i3) {
                                        Object object = dataModel.getValueAt(i3, i2);
                                        if (this.isValueEmpty(object)) continue;
                                        hashSet.add(object);
                                    }
                                    return hashSet.toArray();
                                }
                                Object[] objectArray = new Object[n2];
                                for (int i4 = 0; i4 < n2; ++i4) {
                                    objectArray[i4] = dataModel.getValueAt(i4, i2);
                                }
                                return objectArray;
                            }
                            return dataModel.getValueAt(0, i2);
                        }
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception.getCause());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private void setDataBindingValue(String string, Calculator calculator, JSONObject jSONObject) {
        try {
            DataModel dataModel = DataCoreUtils.getLiveDataModel(calculator, string);
            if (dataModel == null) {
                dataModel = DataModel.EMPTY_DATAMODEL;
            }
            jSONObject.put(string, dataModel);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    public static String[] getWidgetDependence(DataControl dataControl, Calculator calculator) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = dataControl.getWidgetValue() == null ? new String[]{} : dataControl.getWidgetValue().getDependence(calculator);
        if (dataControl instanceof FieldEditor) {
            return (String[])ArrayUtils.addAll(objectArray, ((FieldEditor)((Object)dataControl)).dependence(calculator));
        }
        return objectArray;
    }

    public static void createWidgetValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        if (dataControl.getWidgetValue() == null) {
            return;
        }
        WidgetValueInfo widgetValueInfo = new WidgetValueInfo(((Widget)((Object)dataControl)).getWidgetName());
        Object object = dataControl.getWidgetValue().createAttrResult(widgetValueInfo, calculator, jSONObject2);
        try {
            jSONObject.put(widgetValueInfo.widgetName, object == null ? "" : object);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    public static class WidgetValueInfo {
        private String widgetName;
        private boolean returnArray;
        private boolean removeRepeat;

        public WidgetValueInfo(String string) {
            this(string, false, false);
        }

        public WidgetValueInfo(String string, boolean bl, boolean bl2) {
            this.widgetName = string.toUpperCase();
            this.returnArray = bl;
            this.removeRepeat = bl2;
        }

        public String getWidgetName() {
            return this.widgetName;
        }
    }
}

