/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.Style;
import com.fr.form.event.Observer;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.finegrain.AbstractPrivilegeControl;
import com.fr.privilege.finegrain.WidgetPrivilegeControl;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public abstract class Widget
extends Observer
implements XMLable,
Serializable {
    public static int DEFAULT_FONT_SIZE = 12;
    public static final String EVENT_CLICK = "click";
    public static final String AFTERINIT = "afterinit";
    public static final String BEFOREEDIT = "beforeedit";
    public static final String AFTEREDIT = "afteredit";
    public static final String CHANGE = "change";
    public static final String STOPEDIT = "stopedit";
    public static final String EVENT_STATECHANGE = "statechange";
    public static final String XML_TAG = "Widget";
    protected boolean disabled;
    protected boolean invisible;
    protected String widgetName;
    private WidgetPrivilegeControl widgetPrivilegeControl;
    private boolean isChartRelated = false;

    public abstract String getXType();

    public abstract boolean isEditor();

    public String getWidgetName() {
        return this.widgetName == null ? "" : this.widgetName;
    }

    public void setWidgetName(String string) {
        this.widgetName = string;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
    }

    public boolean isVisible() {
        return !this.invisible;
    }

    public boolean hasDataOnInit() {
        return false;
    }

    public void setVisible(boolean bl) {
        this.invisible = !bl;
    }

    public boolean isDoneVisibleAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getWidgetPrivilegeControl().checkInvisible(string);
    }

    public boolean isDoneUsableAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getWidgetPrivilegeControl().checkUnusable(string);
    }

    public void changeVisibleAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getWidgetPrivilegeControl().removeInvisibleRole(string);
        } else {
            this.getWidgetPrivilegeControl().addInvisibleRole(string);
            this.getWidgetPrivilegeControl().addUnusableRole(string);
        }
    }

    public void changeOnlyVisibleAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getWidgetPrivilegeControl().removeInvisibleRole(string);
        } else {
            this.getWidgetPrivilegeControl().addInvisibleRole(string);
        }
    }

    public void changeUsableAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getWidgetPrivilegeControl().removeUnusableRole(string);
        } else {
            this.getWidgetPrivilegeControl().addUnusableRole(string);
        }
    }

    public void cleanAuthority(String string) {
        if (string == null) {
            return;
        }
        if (this.getWidgetPrivilegeControl().checkInvisible(string)) {
            this.getWidgetPrivilegeControl().removeInvisibleRole(string);
        }
        if (this.getWidgetPrivilegeControl().checkUnusable(string)) {
            this.getWidgetPrivilegeControl().removeUnusableRole(string);
        }
    }

    public void setChartRelated(boolean bl) {
        this.isChartRelated = bl;
    }

    public boolean isChartRelated() {
        return this.isChartRelated;
    }

    public boolean supportMobile() {
        return true;
    }

    public WidgetPrivilegeControl getWidgetPrivilegeControl() {
        if (this.widgetPrivilegeControl == null) {
            this.widgetPrivilegeControl = new WidgetPrivilegeControl();
        }
        return this.widgetPrivilegeControl;
    }

    public void setWidgetPrivilegeControl(WidgetPrivilegeControl widgetPrivilegeControl) {
        this.widgetPrivilegeControl = widgetPrivilegeControl;
    }

    public Object clone() throws CloneNotSupportedException {
        Widget widget = (Widget)super.clone();
        widget.setWidgetPrivilegeControl((WidgetPrivilegeControl)this.getWidgetPrivilegeControl().clone());
        return widget;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        Object object;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", this.getXType());
        if (this.widgetName != null) {
            jSONObject.put("widgetName", this.widgetName.toUpperCase());
        }
        String[] stringArray = PrivilegeManager.getRoleFromCalculator(calculator);
        boolean bl = this.invisible;
        boolean bl2 = this.disabled;
        if (stringArray.length > 0) {
            object = this.getWidgetPrivilegeControl();
            if (this.isVisible()) {
                bl = ((AbstractPrivilegeControl)object).checkInvisible(stringArray);
            }
            if (this.isEnabled()) {
                bl2 = ((WidgetPrivilegeControl)object).checkUnusable(stringArray);
            }
        }
        jSONObject.put("disabled", bl2);
        jSONObject.put("invisible", bl);
        if (this instanceof DataControl) {
            jSONObject.put("needSubmit", true);
            object = ((DataControl)((Object)this)).getWidgetValue();
            if (object != null) {
                ((WidgetValue)object).createJSONConfig(jSONObject, calculator);
            }
        }
        jSONObject.put("widgetUrl", repository.checkoutObject(this.widgetName, "widget"));
        object = this.createJSONListener(repository);
        if (((JSONArray)object).length() > 0) {
            jSONObject.put("listeners", object);
        }
        return jSONObject;
    }

    public Object value2Config(Object object, CalculatorProvider calculatorProvider) {
        return object;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public void readXML(XMLableReader xMLableReader) {
        block2: {
            String string;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                super.readXML(xMLableReader);
                                if (!xMLableReader.isChildNode()) break block2;
                                string = xMLableReader.getTagName();
                                if (!string.equals("Disable")) break block3;
                                this.disabled = Boolean.valueOf(xMLableReader.getElementValue());
                                break block2;
                            }
                            if (!string.equals("WidgetName")) break block4;
                            this.widgetName = xMLableReader.getAttrAsString("name", null);
                            break block2;
                        }
                        if (!string.equals("WidgetAttr")) break block5;
                        this.disabled = xMLableReader.getAttrAsBoolean("disabled", false);
                        this.invisible = xMLableReader.getAttrAsBoolean("invisible", false);
                        break block2;
                    }
                    if (!string.equals("PrivilegeControl")) break block6;
                    WidgetPrivilegeControl widgetPrivilegeControl = new WidgetPrivilegeControl();
                    xMLableReader.readXMLObject(widgetPrivilegeControl);
                    this.setWidgetPrivilegeControl(widgetPrivilegeControl);
                    break block2;
                }
                if (!string.equals("PrivilegeInvisible")) break block7;
                String[] stringArray = xMLableReader.getAttrAsString("privilegeInvisibleSet", "").split(",");
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.getWidgetPrivilegeControl().addInvisibleRole(stringArray[i2]);
                }
                break block2;
            }
            if (!string.equals("PrivilegeUnusable")) break block2;
            String[] stringArray = xMLableReader.getAttrAsString("privilegeUnusableSet", "").split(",");
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.getWidgetPrivilegeControl().addUnusableRole(stringArray[i3]);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        WidgetPrivilegeControl widgetPrivilegeControl;
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.widgetName)) {
            xMLPrintWriter.startTAG("WidgetName").attr("name", this.widgetName).end();
        }
        xMLPrintWriter.startTAG("WidgetAttr");
        if (this.disabled) {
            xMLPrintWriter.attr("disabled", this.disabled);
        }
        if (this.invisible) {
            xMLPrintWriter.attr("invisible", this.invisible);
        }
        if ((widgetPrivilegeControl = this.getWidgetPrivilegeControl()) != null) {
            widgetPrivilegeControl.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 89 * n2 + (this.disabled ? 1 : 0);
        n2 = 89 * n2 + (this.invisible ? 1 : 0);
        n2 = 89 * n2 + (this.widgetName != null ? this.widgetName.hashCode() : 0);
        return n2;
    }

    public boolean equals(Object object) {
        return object instanceof Widget && super.equals(object) && ComparatorUtils.equals(((Widget)object).widgetName, this.widgetName) && this.disabled == ((Widget)object).disabled && this.invisible == ((Widget)object).invisible;
    }

    public BufferedImage toImage(Object object, int n2, int n3, Style style) {
        return null;
    }
}

