/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.form.data.DataBinding;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.WaterMark;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.reg.CustomReg;
import com.fr.form.ui.reg.RegExp;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class TextEditor
extends FieldEditor
implements WaterMark,
DataControl {
    private RegExp regex;
    private String waterMark;
    private WidgetValue widgetValue;
    private int defaultHash = 7;
    private int hashFactor = 88;

    public String getXType() {
        return "text";
    }

    public RegExp getRegex() {
        return this.regex;
    }

    public void setRegex(RegExp regExp) {
        this.regex = regExp;
    }

    public int[] getValueType() {
        return new int[]{1, 2, 3};
    }

    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(String string) {
        this.waterMark = string;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "beforeedit", "afteredit", "stopedit"};
    }

    public int hashCode() {
        int n2 = this.defaultHash;
        if (this.regex != null) {
            n2 = this.regex.hashCode() * this.hashFactor;
        }
        if (this.waterMark != null) {
            n2 = this.waterMark.hashCode() * this.hashFactor;
        }
        if (this.widgetValue != null) {
            n2 = this.widgetValue.hashCode() * this.hashFactor;
        }
        return n2 += super.hashCode();
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        if (dataControl.getWidgetValue() == null) {
            this.setWidgetValue(new WidgetValue());
        }
        WidgetValue.WidgetValueInfo widgetValueInfo = new WidgetValue.WidgetValueInfo(((Widget)((Object)dataControl)).getWidgetName());
        Object object = dataControl.getWidgetValue().createAttrResult(widgetValueInfo, calculator, jSONObject2);
        try {
            jSONObject.put(widgetValueInfo.getWidgetName(), object == null ? "" : object);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("render", true);
        if (this.regex != null) {
            jSONObject.put("regex", this.getRegex().toRegText());
        }
        if (this.waterMark != null) {
            FieldEditor.setWaterMarkConfig(this.waterMark, jSONObject, calculator);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("TextAttr") || "Attributes".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("allowBlank", null);
                if (string2 != null) {
                    this.setAllowBlank(Boolean.valueOf(string2));
                }
            } else if (string.equals("Reg")) {
                this.regex = WidgetXmlUtils.readXMLReg(xMLableReader);
            } else if (string.equals("Regexp")) {
                this.setRegex(new CustomReg(xMLableReader.getElementValue()));
            } else if ("watermark".equals(string)) {
                this.setWaterMark(xMLableReader.getElementValue());
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            } else if ("text".equals(string)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("TextAttr");
        if (!this.isAllowBlank()) {
            xMLPrintWriter.attr("allowBlank", this.isAllowBlank());
        }
        xMLPrintWriter.end();
        if (this.regex != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.regex, "Reg");
        }
        if (StringUtils.isNotBlank(this.waterMark)) {
            xMLPrintWriter.startTAG("watermark").textNode(this.waterMark).end();
        }
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        this.widgetValue.writeXML(xMLPrintWriter);
    }

    public boolean equals(Object object) {
        return object instanceof TextEditor && super.equals(object) && ComparatorUtils.equals(this.regex, ((TextEditor)object).regex) && ComparatorUtils.equals(this.widgetValue, ((TextEditor)object).widgetValue);
    }
}

