/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Formula;
import com.fr.form.data.DataBinding;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Font;

public class Label
extends Widget
implements DataControl {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    private WidgetValue widgetValue = new WidgetValue();
    private boolean autoLine = true;
    public int textalign;
    public FRFont font = FRFont.getInstance();
    public boolean noWrap;
    public boolean verticalCenter = true;
    private float fontRate = 0.75f;

    public String getXType() {
        return "label";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "click", "change"};
    }

    public int[] getValueType() {
        return new int[]{1, 3, 2};
    }

    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    public boolean isVerticalCenter() {
        return this.verticalCenter;
    }

    public void setVerticalCenter(boolean bl) {
        this.verticalCenter = bl;
    }

    public int getTextalign() {
        return this.textalign;
    }

    public void setTextalign(int n2) {
        if (n2 == 2 || n2 == 0 || n2 == 4) {
            this.textalign = n2;
        }
    }

    public boolean isAutoLine() {
        return this.autoLine;
    }

    public void setAutoLine(boolean bl) {
        this.autoLine = bl;
    }

    public FRFont getFont() {
        return this.font;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public void setWrap(boolean bl) {
        this.noWrap = bl;
    }

    public boolean isWrap() {
        return this.noWrap;
    }

    public static String decorationStr(FRFont fRFont) {
        String string = "none";
        if (fRFont.isStrikethrough()) {
            string = "line-through";
        }
        switch (fRFont.getUnderline()) {
            case 0: {
                return string;
            }
        }
        return "underline";
    }

    private String asAlignString(int n2) {
        switch (n2) {
            case 4: {
                return "right";
            }
            case 0: {
                return "center";
            }
        }
        return "left";
    }

    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 89 * n2 + this.textalign;
        n2 = 89 * n2 + (this.widgetValue != null ? this.widgetValue.hashCode() : 0);
        return n2;
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        WidgetValue.createWidgetValueResult(this, calculator, jSONObject, jSONObject2);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("verticalcenter", this.verticalCenter);
        jSONObject.put("textalign", this.asAlignString(this.textalign));
        if (this.font != null) {
            jSONObject.put("decoration", Label.decorationStr(this.font));
            jSONObject.put("color", StableUtils.javaColorToCSSColor(this.font.getForeground()));
            jSONObject.put("textColor", StableUtils.javaColor2String(this.font.getForeground()));
            jSONObject.put("fontsize", this.font.getShowSize(repository.getResolution()));
            if (this.font.isBold()) {
                jSONObject.put("fontweight", "bold");
            }
            if (this.font.isItalic()) {
                jSONObject.put("fontstyle", "italic");
            }
            if (StringUtils.isNotEmpty(this.font.getName())) {
                jSONObject.put("fontfamily", this.font.getName());
            }
        }
        jSONObject.put("wrap", this.noWrap);
        jSONObject.put("autoline", this.isAutoLine());
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("LabelAttr")) {
                String string2 = xMLableReader.getAttrAsString("text", null);
                if (string2 != null) {
                    if (string2.charAt(0) == '=') {
                        this.widgetValue.setValue(new Formula(string2));
                    } else {
                        this.widgetValue.setValue(string2);
                    }
                }
                this.verticalCenter = xMLableReader.getAttrAsBoolean("verticalcenter", false);
                this.textalign = xMLableReader.getAttrAsInt("textalign", 0);
                this.noWrap = xMLableReader.getAttrAsBoolean("noWrap", false);
                this.setAutoLine(xMLableReader.getAttrAsBoolean("autoline", false));
            } else if (string.equals("LabelFont")) {
                this.font = FRFont.getInstance(new Font(xMLableReader.getAttrAsString("fontfamily", null), xMLableReader.getAttrAsInt("fontstyle", 0), xMLableReader.getAttrAsInt("fontsize", 0)));
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION()) {
                    this.font = this.font.applySize((float)this.font.getSize() * this.fontRate);
                }
            } else if (string.equals("FRFont")) {
                this.font = BaseXMLUtils.readFRFont(xMLableReader);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION()) {
                    this.font = this.font.applySize((float)this.font.getSize() * this.fontRate);
                }
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            } else if ("text".equals(string)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("LabelAttr");
        if (this.verticalCenter) {
            xMLPrintWriter.attr("verticalcenter", this.verticalCenter);
        }
        xMLPrintWriter.attr("textalign", this.textalign);
        if (this.noWrap) {
            xMLPrintWriter.attr("noWrap", this.noWrap);
        }
        xMLPrintWriter.attr("autoline", this.isAutoLine()).end();
        if (this.font != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.font);
        }
        if (this.widgetValue != null) {
            this.widgetValue.writeXML(xMLPrintWriter);
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Label && super.equals(object) && ((Label)object).verticalCenter == this.verticalCenter && ((Label)object).textalign == this.textalign && ComparatorUtils.equals(((Label)object).font, this.font) && ((Label)object).noWrap == this.noWrap && ComparatorUtils.equals(((Label)object).widgetValue, this.widgetValue);
    }
}

