/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Icon;
import com.fr.base.TemplateUtils;
import com.fr.base.background.ImageBackground;
import com.fr.form.event.Listener;
import com.fr.form.ui.Button;
import com.fr.form.ui.Label;
import com.fr.form.ui.WidgetManager;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.js.JavaScriptImpl;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;

public class FreeButton
extends Button {
    private int buttonWidth;
    private int buttonHeight;
    protected Background initialBackground;
    protected Background overBackground;
    protected Background clickBackground;
    protected FRFont font;
    protected boolean toggle;
    protected String group;
    protected boolean isCustomStyle;
    private static float fontSizeRate = 0.75f;
    private static final String FTPL = TemplateUtils.readTemplate2String("/com/fr/form/parameter/formsubmitbutton_old.tpl", "GBK");
    private static final String FTPLT = FTPL.replaceAll("\\r", "");

    public FreeButton() {
    }

    public FreeButton(String string) {
        super(string);
    }

    public FreeButton(Button button) {
        this.text = button.text;
        this.widgetName = button.widgetName;
        this.disabled = button.disabled;
        this.invisible = button.invisible;
        this.hotkeys = button.hotkeys;
        this.iconName = button.iconName;
        for (int i2 = 0; i2 < button.getListenerSize(); ++i2) {
            this.addListener(button.getListener(i2));
        }
    }

    public String getXType() {
        return this.isCustomStyle ? "freebutton" : "button";
    }

    public FreeButton getCustomButton() {
        return this;
    }

    public void setCustomButton(FreeButton freeButton) {
        this.initialBackground = freeButton.initialBackground;
        this.overBackground = freeButton.overBackground;
        this.clickBackground = freeButton.clickBackground;
        this.iconName = freeButton.iconName;
        this.font = freeButton.font;
        this.toggle = freeButton.toggle;
        this.group = freeButton.group;
    }

    public void setCustomStyle(boolean bl) {
        this.isCustomStyle = bl;
    }

    public boolean isCustomStyle() {
        return this.isCustomStyle;
    }

    public Background getInitialBackground() {
        return this.initialBackground;
    }

    public void setInitialBackground(Background background) {
        this.initialBackground = background;
        if (background instanceof ImageBackground && ((ImageBackground)background).getImage() != null) {
            this.setButtonSize(((ImageBackground)background).getImage().getWidth(null), ((ImageBackground)background).getImage().getHeight(null));
        }
    }

    private void setButtonSize(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            this.buttonWidth = n2;
            this.buttonHeight = n3;
        }
    }

    public Background getOverBackground() {
        return this.overBackground;
    }

    public void setOverBackground(Background background) {
        this.overBackground = background;
    }

    public Background getClickBackground() {
        return this.clickBackground;
    }

    public void setClickBackground(Background background) {
        this.clickBackground = background;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public int getButtonHeight() {
        return this.buttonHeight;
    }

    public FRFont getFont() {
        return this.font;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        if (this.isCustomStyle) {
            jSONObject.put("isCustomStyle", this.isCustomStyle);
            if (this.initialBackground != null) {
                jSONObject.put("initial", BaseHTMLWriterUtils.jsonBackground(this.initialBackground, repository));
            }
            if (this.overBackground != null) {
                jSONObject.put("over", BaseHTMLWriterUtils.jsonBackground(this.overBackground, repository));
            }
            if (this.clickBackground != null) {
                jSONObject.put("click", BaseHTMLWriterUtils.jsonBackground(this.clickBackground, repository));
            }
            if (this.iconName != null) {
                try {
                    Icon icon = WidgetManager.getInstance().getIconManager().getIcon(this.iconName);
                    if (icon != null) {
                        jSONObject.put("icon", BaseHTMLWriterUtils.jsonBackground(new ImageBackground(icon.getImage()), repository));
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        if (this.font != null) {
            jSONObject.put("decoration", Label.decorationStr(this.font));
            jSONObject.put("color", StableUtils.javaColorToCSSColor(this.font.getForeground()));
            jSONObject.put("fontsize", this.font.getShowSize(repository.getResolution()));
            if (this.font.isBold()) {
                jSONObject.put("fontweight", "bold");
            }
            if (this.font.isItalic()) {
                jSONObject.put("fontstyle", "italic");
            }
            if (StringUtils.isNotEmpty(this.font.getName())) {
                jSONObject.put("fontfamily", this.font.getName());
            }
        }
        jSONObject.put("isToggle", this.toggle);
        if (StringUtils.isNotEmpty(this.group)) {
            jSONObject.put("group", this.group);
        }
        return jSONObject;
    }

    public Background readBackground(XMLableReader xMLableReader) {
        Object var3_2 = null;
        XMLObject xMLObject = new XMLObject(var3_2){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isChildNode() && "Background".equals(string = xMLableReader.getTagName())) {
                    this.obj = BaseXMLUtils.readBackground(xMLableReader);
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Background)xMLObject.getObject();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("initial")) {
                this.setInitialBackground(this.readBackground(xMLableReader));
                this.isCustomStyle = true;
            } else if (string.equals("over")) {
                this.overBackground = this.readBackground(xMLableReader);
            } else if (string.equals("click")) {
                this.clickBackground = this.readBackground(xMLableReader);
            } else if (string.equals("FRFont")) {
                this.font = BaseXMLUtils.readFRFont(xMLableReader);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION()) {
                    this.font = this.font.applySize((float)this.font.getSize() * fontSizeRate);
                }
            } else if (string.equals("isToggle")) {
                this.toggle = xMLableReader.getAttrAsBoolean("isToggle", false);
            } else if (string.endsWith("isCustomType")) {
                this.isCustomStyle = xMLableReader.getAttrAsBoolean("isCustomType", false);
            } else if (string.equals("group")) {
                this.group = xMLableReader.getAttrAsString("group", null);
            } else if (string.equals("text")) {
                this.text = xMLableReader.getAttrAsString("text", null);
            }
        }
    }

    protected void dealWithListener4Compatible(Listener listener) {
        JavaScriptImpl javaScriptImpl;
        if (listener != null && listener.getAction() instanceof JavaScriptImpl && this.isNotEmptyJS(javaScriptImpl = (JavaScriptImpl)listener.getAction())) {
            javaScriptImpl.setContent(TemplateUtils.readTemplate2String("/com/fr/form/parameter/formsubmitbutton.tpl", "GBK"));
        }
    }

    private boolean isNotEmptyJS(JavaScriptImpl javaScriptImpl) {
        return javaScriptImpl != null && StringUtils.isNotBlank(javaScriptImpl.getContent()) && (ComparatorUtils.equals(FTPLT, javaScriptImpl.getContent()) || ComparatorUtils.equals(FTPL, javaScriptImpl.getContent()));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.isCustomStyle) {
            if (this.initialBackground != null) {
                xMLPrintWriter.startTAG("initial");
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.initialBackground);
                xMLPrintWriter.end();
            }
            if (this.overBackground != null) {
                xMLPrintWriter.startTAG("over");
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.overBackground);
                xMLPrintWriter.end();
            }
            if (this.clickBackground != null) {
                xMLPrintWriter.startTAG("click");
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.clickBackground);
                xMLPrintWriter.end();
            }
            if (this.font != null) {
                BaseXMLUtils.writeFRFont(xMLPrintWriter, this.font);
            }
        }
        if (this.isCustomStyle) {
            xMLPrintWriter.startTAG("isCustomType").attr("isCustomType", this.isCustomStyle).end();
        }
        if (this.toggle) {
            xMLPrintWriter.startTAG("isToggle").attr("isToggle", this.toggle).end();
        }
        if (StringUtils.isNotEmpty(this.group)) {
            xMLPrintWriter.startTAG("group").attr("group", this.group).end();
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof FreeButton && super.equals(object) && ComparatorUtils.equals(this.initialBackground, ((FreeButton)object).initialBackground) && ComparatorUtils.equals(this.overBackground, ((FreeButton)object).overBackground) && ComparatorUtils.equals(this.clickBackground, ((FreeButton)object).clickBackground) && ComparatorUtils.equals(this.font, ((FreeButton)object).font) && ComparatorUtils.equals(this.text, ((FreeButton)object).text) && this.toggle == ((FreeButton)object).toggle && ComparatorUtils.equals(this.group, ((FreeButton)object).group);
    }
}

