/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.file.FunctionDef;
import com.fr.file.XMLFileManager;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FunctionManager
extends XMLFileManager {
    private static FunctionManager functionManager;
    private List functionDefList = new ArrayList();

    public static synchronized FunctionManager getInstance() {
        if (functionManager == null) {
            functionManager = new FunctionManager();
            functionManager.readXMLFile();
        }
        return functionManager;
    }

    private FunctionManager() {
    }

    public String fileName() {
        return "functions.xml";
    }

    public void addFunctionDef(FunctionDef functionDef) {
        this.functionDefList.add(functionDef);
    }

    public int getFunctionDefCount() {
        return this.functionDefList.size();
    }

    public FunctionDef getFunctionDef(int n2) {
        return (FunctionDef)this.functionDefList.get(n2);
    }

    public void removeFunctionDef(int n2) {
        this.functionDefList.remove(n2);
    }

    public void clearAllFunctionDef() {
        this.functionDefList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("XMLVersion")) {
                String string = "";
                string = xMLableReader.getElementValue();
                if (string != null) {
                    xMLableReader.setXmlVersionByString(string);
                }
            } else if (xMLableReader.getTagName().equals("FunctionDefList")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("FunctionDef".equals(xMLableReader.getTagName())) {
                            final FunctionDef functionDef = new FunctionDef();
                            FunctionManager.this.functionDefList.add(functionDef);
                            String string = xMLableReader.getAttrAsString("name", null);
                            if (string != null) {
                                functionDef.setName(string);
                            }
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode()) {
                                        String string;
                                        String string2 = xMLableReader.getTagName();
                                        if ("Description".equals(string2)) {
                                            String string3 = xMLableReader.getElementValue();
                                            if (string3 != null) {
                                                functionDef.setDescription(string3);
                                            }
                                        } else if ("Class".equals(string2) && (string = xMLableReader.getAttrAsString("className", null)) != null) {
                                            functionDef.setClassName(string);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FunctionManager");
        if (this.functionDefList != null && this.functionDefList.size() > 0) {
            xMLPrintWriter.startTAG("FunctionDefList");
            for (int i2 = 0; i2 < this.functionDefList.size(); ++i2) {
                FunctionDef functionDef = (FunctionDef)this.functionDefList.get(i2);
                if (functionDef == null) continue;
                xMLPrintWriter.startTAG("FunctionDef").attr("name", functionDef.getName()).startTAG("Class").attr("className", functionDef.getClassName()).end().startTAG("Description").textNode(functionDef.getDescription()).end().end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        FunctionManager functionManager = new FunctionManager();
        XMLTools.readInputStreamXML(functionManager, inputStream);
        FunctionManager.functionManager = functionManager;
        GeneralContext.getEnvProvider().writeResource(FunctionManager.functionManager);
    }

    private static synchronized void envChanged() {
        functionManager = null;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                FunctionManager.envChanged();
            }
        });
    }
}

