/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.file.ClusterService;
import com.fr.file.XMLFileManager;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class ClusterConfigManager
extends XMLFileManager {
    private static ClusterConfigManager clusterConfigManager = null;
    private boolean useCluster = false;
    private boolean useShare = false;
    private List serviceList = new ArrayList();

    public static ClusterConfigManager getInstance() {
        if (clusterConfigManager == null) {
            clusterConfigManager = new ClusterConfigManager();
            clusterConfigManager.readXMLFile();
        }
        return clusterConfigManager;
    }

    private static synchronized void envChanged() {
        clusterConfigManager = null;
    }

    private ClusterConfigManager() {
    }

    public String fileName() {
        return "cluster.xml";
    }

    public ClusterService getService(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!string.equals(((ClusterService)this.serviceList.get(i2)).getServiceName())) continue;
            return (ClusterService)this.serviceList.get(i2);
        }
        return null;
    }

    public List getOtherServices(ClusterService clusterService) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (clusterService != null && clusterService.equals(this.serviceList.get(i2))) continue;
            arrayList.add(this.serviceList.get(i2));
        }
        return arrayList;
    }

    public ClusterService resolveSelfServices() {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!((ClusterService)this.serviceList.get(i2)).isSelf()) continue;
            return (ClusterService)this.serviceList.get(i2);
        }
        return null;
    }

    public ClusterService resolveMainServices() {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            if (!((ClusterService)this.serviceList.get(i2)).isMain()) continue;
            return (ClusterService)this.serviceList.get(i2);
        }
        return this.serviceList.size() > 0 ? (ClusterService)this.serviceList.get(0) : null;
    }

    public ClusterService resolveSelfServicesByIPAndPort(String string, String string2) {
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            ClusterService clusterService = (ClusterService)this.serviceList.get(i2);
            if (!string.equals(clusterService.getIp()) || !string2.equals(clusterService.getPort())) continue;
            return clusterService;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            if (this.serviceList == null) {
                this.serviceList = new ArrayList();
            } else {
                this.serviceList.clear();
            }
            this.setUseCluster(xMLableReader.getAttrAsBoolean("useCluster", false));
            this.setUseShare(xMLableReader.getAttrAsBoolean("useShare", false));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("ClusterService".equals(string)) {
                ClusterService clusterService = new ClusterService();
                xMLableReader.readXMLObject(clusterService);
                this.serviceList.add(clusterService);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ClusterConfig").attr("useCluster", this.useCluster).attr("useShare", this.useShare);
        for (int i2 = 0; i2 < this.serviceList.size(); ++i2) {
            ((ClusterService)this.serviceList.get(i2)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    public void setUseCluster(boolean bl) {
        this.useCluster = bl;
    }

    public boolean isUseShare() {
        return this.useShare;
    }

    public void setUseShare(boolean bl) {
        this.useShare = bl;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ClusterConfigManager.envChanged();
            }
        });
    }
}

