/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.impl.sap.SAPDatabaseConnection;
import com.fr.data.impl.sap.SAPFunction;
import com.fr.data.impl.sap.SAPInput;
import com.fr.data.impl.sap.SAPOutput;
import com.fr.file.DatasourceManager;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAPUtils {
    private static final Map TYPEMAP = new HashMap(){
        {
            this.put("CHAR", "String");
            this.put("BYTE", "byte[]");
            this.put("INT", "Integer");
            this.put("INT1", "Integer");
            this.put("INT2", "Integer");
            this.put("FLOAT", "Double");
            this.put("BCD", "BigDecimal");
            this.put("DATE", "Date");
            this.put("NUM", "String");
            this.put("STRING", "String");
            this.put("XSTRING", "byte[]");
            this.put("DECF16", "Double");
            this.put("DECF34", "Double");
            this.put("TIME", "Date");
        }
    };

    public static Object getConnection(String string) throws Exception {
        SAPDatabaseConnection sAPDatabaseConnection = (SAPDatabaseConnection)DatasourceManager.getInstance().getConnection(string);
        return sAPDatabaseConnection.getConnection();
    }

    public static Object getRepository(Object object) throws Exception {
        return new JCO.Repository("Repository", (JCO.Client)object);
    }

    public static Object getFunctionTemplate(Object object, String string) throws Exception {
        return object.getClass().getMethod("getFunctionTemplate", String.class).invoke(object, string);
    }

    public static Object getFunction(Object object) throws Exception {
        return object.getClass().getMethod("getFunction", new Class[0]).invoke(object, new Object[0]);
    }

    public static Object getImportParameterList(Object object) throws Exception {
        return object.getClass().getMethod("getImportParameterList", new Class[0]).invoke(object, new Object[0]);
    }

    public static Object getTableParameterList(Object object) throws Exception {
        return object.getClass().getMethod("getTableParameterList", new Class[0]).invoke(object, new Object[0]);
    }

    public static void executeFunction(Object object, Object object2) throws Exception {
        try {
            ((JCO.Client)object2).execute((JCO.Function)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void quitConnection(Object object, Object object2) throws Exception {
        ((JCO.Client)object).disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAPInput[] getBapiInput4DifferentJDK(String string, String string2) throws Exception {
        Object object = SAPUtils.getConnection(string);
        Object object2 = SAPUtils.getRepository(object);
        try {
            Object object3 = SAPUtils.getFunctionTemplate(object2, string2);
            Object object4 = SAPUtils.getFunction(object3);
            Object object5 = SAPUtils.getImportParameterList(object4);
            if (object5 != null) {
                Object object6 = object5.getClass().getMethod("getFieldCount", new Class[0]).invoke(object5, new Object[0]);
                int n2 = (Integer)object6;
                ArrayList<SAPInput> arrayList = new ArrayList<SAPInput>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    SAPInput sAPInput = new SAPInput();
                    sAPInput.setNo(Integer.toString(i2 + 1));
                    Object object7 = object5.getClass().getMethod("getMetaData", new Class[0]).invoke(object5, new Object[0]);
                    Object object8 = object7.getClass().getMethod("getName", Integer.TYPE).invoke(object7, new Integer(i2));
                    String string3 = (String)object7.getClass().getMethod("getTypeAsString", Integer.TYPE).invoke(object7, new Integer(i2));
                    sAPInput.setParaName((String)object8);
                    sAPInput.setType(string3);
                    sAPInput.setReturnName("");
                    String string4 = (String)TYPEMAP.get(string3);
                    sAPInput.setDataType(string4 == null ? "INVALID" : string4);
                    sAPInput.setCorresPara("saparam" + i2);
                    arrayList.add(sAPInput);
                }
                SAPInput[] sAPInputArray = arrayList.toArray(new SAPInput[arrayList.size()]);
                return sAPInputArray;
            }
            SAPInput[] sAPInputArray = new SAPInput[]{};
            return sAPInputArray;
        }
        finally {
            SAPUtils.quitConnection(object, object2);
        }
    }

    public static SAPInput[] getBapiInput(String string, String string2) {
        try {
            return SAPUtils.getBapiInput4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    public static SAPFunction[] searchFunction(String string, String string2) {
        try {
            return SAPUtils.searchFunction4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAPFunction[] searchFunction4DifferentJDK(String string, String string2) throws Exception {
        Object object = SAPUtils.getConnection(string2);
        Object object2 = SAPUtils.getRepository(object);
        try {
            SAPFunction[] sAPFunctionArray;
            Object object3 = SAPUtils.getFunctionTemplate(object2, "RFC_FUNCTION_SEARCH");
            Object object4 = SAPUtils.getFunction(object3);
            String string3 = "*" + string.toUpperCase().trim() + "*";
            JCO.ParameterList parameterList = (JCO.ParameterList)SAPUtils.getImportParameterList(object4);
            JCO.ParameterList parameterList2 = (JCO.ParameterList)SAPUtils.getTableParameterList(object4);
            parameterList.setValue(string3, "FUNCNAME");
            JCO.Table table = parameterList2.getTable("FUNCTIONS");
            SAPUtils.executeFunction(object4, object);
            int n2 = 0;
            if (table != null) {
                n2 = table.getNumRows();
            }
            SAPFunction[] sAPFunctionArray2 = sAPFunctionArray = SAPUtils.getFunctionsValue(n2, table);
            return sAPFunctionArray2;
        }
        finally {
            SAPUtils.quitConnection(object, object2);
        }
    }

    private static SAPFunction[] getFunctionsValue(int n2, Object object) {
        SAPFunction[] sAPFunctionArray = new SAPFunction[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ((JCO.Table)object).setRow(i2);
            sAPFunctionArray[i2] = new SAPFunction();
            sAPFunctionArray[i2].setNO(String.valueOf(i2 + 1));
            sAPFunctionArray[i2].setName(((JCO.Table)object).getValue("FUNCNAME").toString());
            sAPFunctionArray[i2].setGroup(((JCO.Table)object).getValue("GROUPNAME").toString());
            sAPFunctionArray[i2].setApplication(((JCO.Table)object).getValue("APPL").toString());
            sAPFunctionArray[i2].setDescription(((JCO.Table)object).getValue("STEXT").toString());
        }
        return sAPFunctionArray;
    }

    private static String[] getBapiTablesName4DifferentJDK(String string, String string2) throws Exception {
        Object object = SAPUtils.getConnection(string);
        Object object2 = SAPUtils.getRepository(object);
        Object object3 = SAPUtils.getFunctionTemplate(object2, string2);
        Object object4 = SAPUtils.getFunction(object3);
        Object object5 = SAPUtils.getTableParameterList(object4);
        if (object5 != null) {
            Object object6 = object5.getClass().getMethod("getFieldCount", new Class[0]).invoke(object5, new Object[0]);
            int n2 = (Integer)object6;
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object7 = object5.getClass().getMethod("getMetaData", new Class[0]).invoke(object5, new Object[0]);
                Object object8 = object7.getClass().getMethod("getName", Integer.TYPE).invoke(object7, new Integer(i2));
                stringArray[i2] = (String)object8;
            }
            return stringArray;
        }
        return new String[0];
    }

    public static SAPOutput[] getBapiTablesColumnNames(String string, String string2, Map map, String string3) {
        try {
            if (string3 != null) {
                ArrayList arrayList = new ArrayList();
                SAPUtils.getBapiTableData4DifferentJDK(string, string2, map, string3, null, arrayList, null);
                return arrayList.toArray(new SAPOutput[0]);
            }
            return null;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getBapiTableData4DifferentJDK(String string, String string2, Map map, String string3, String[] stringArray, List list, List list2) throws Exception {
        Object object = SAPUtils.getConnection(string);
        Object object2 = SAPUtils.getRepository(object);
        try {
            Object object3;
            Object object4 = SAPUtils.getFunctionTemplate(object2, string2);
            Object object5 = SAPUtils.getFunction(object4);
            Object object6 = SAPUtils.getImportParameterList(object5);
            if (map != null) {
                SAPUtils.setBapiInput(object6, map);
            }
            Object object7 = SAPUtils.getTableParameterList(object5);
            SAPUtils.executeFunction(object5, object);
            Object object8 = object7.getClass().getMethod("getTable", String.class).invoke(object7, string3);
            Object object9 = object8.getClass().getMethod("getNumRows", new Class[0]).invoke(object8, new Object[0]);
            int n2 = (Integer)object9;
            Object object10 = object8.getClass().getMethod("getFieldCount", new Class[0]).invoke(object8, new Object[0]);
            int n3 = (Integer)object10;
            String[] stringArray2 = new String[n3];
            String[] stringArray3 = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object11 = object8.getClass().getMethod("getMetaData", new Class[0]).invoke(object8, new Object[0]);
                object3 = object11.getClass().getMethod("getName", Integer.TYPE).invoke(object11, new Integer(i2));
                stringArray2[i2] = (String)object3;
                stringArray3[i2] = (String)object11.getClass().getMethod("getTypeAsString", Integer.TYPE).invoke(object11, new Integer(i2));
            }
            if (list2 != null) {
                SAPUtils.saveTableData(object8, n2, stringArray, list2);
            }
            if (list != null) {
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    SAPOutput sAPOutput = new SAPOutput();
                    sAPOutput.setNo(Integer.toString(i3 + 1));
                    sAPOutput.setColName(stringArray2[i3]);
                    sAPOutput.setType(stringArray3[i3]);
                    object3 = (String)TYPEMAP.get(stringArray3[i3]);
                    sAPOutput.setDataType((String)(object3 == null ? "INVALID" : object3));
                    list.add(sAPOutput);
                }
            }
        }
        finally {
            SAPUtils.quitConnection(object, object2);
        }
    }

    private static void saveTableData(Object object, int n2, String[] stringArray, List list) throws Exception {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = new Object[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                object.getClass().getMethod("setRow", Integer.TYPE).invoke(object, new Integer(i2));
                objectArray[i3] = object.getClass().getMethod("getValue", Integer.TYPE).invoke(object, new Integer(i3));
                if (objectArray[i3] != null) continue;
                objectArray[i3] = "";
            }
            list.add(objectArray);
        }
    }

    public static String[] getBapiTablesNameByCon(String string, String string2) {
        try {
            return SAPUtils.getBapiTablesName4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    private static void setBapiInput(Object object, Map map) throws Exception {
        try {
            if (object != null) {
                Object object2;
                int n2;
                int n3 = ((JCO.ParameterList)object).getFieldCount();
                String[] stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    String string;
                    object2 = ((JCO.ParameterList)object).getMetaData();
                    stringArray[n2] = string = object2.getName(n2);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!map.containsKey(stringArray[n2])) continue;
                    object2 = map.get(stringArray[n2]);
                    if (object2 instanceof FormulaProvider) {
                        object2 = Calculator.createCalculator().eval(String.valueOf(object2));
                    }
                    ((JCO.ParameterList)object).setValue(object2, stringArray[n2]);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public static String[] getTransparentTableColumnNames(String string, String string2) {
        try {
            Object object = SAPUtils.getConnection(string);
            Object object2 = SAPUtils.getRepository(object);
            Object object3 = SAPUtils.getFunctionTemplate(object2, "RFC_READ_TABLE");
            Object object4 = SAPUtils.getFunction(object3);
            JCO.ParameterList parameterList = (JCO.ParameterList)SAPUtils.getImportParameterList(object4);
            JCO.ParameterList parameterList2 = (JCO.ParameterList)SAPUtils.getTableParameterList(object4);
            JCO.Table table = parameterList2.getTable("FIELDS");
            parameterList.setValue(string2, "QUERY_TABLE");
            SAPUtils.executeFunction(object4, object);
            int n2 = table.getNumRows();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3;
                table.setRow(i2);
                stringArray[i2] = string3 = table.getString(0);
            }
            SAPUtils.quitConnection(object, object2);
            return stringArray;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTransparentTable(String string, String string2, String[] stringArray, String[] stringArray2, List list) throws Exception {
        Object object = null;
        object = SAPUtils.getConnection(string);
        Object object2 = SAPUtils.getRepository(object);
        try {
            Object object3 = SAPUtils.getFunctionTemplate(object2, "RFC_READ_TABLE");
            Object object4 = SAPUtils.getFunction(object3);
            Object object5 = SAPUtils.getImportParameterList(object4);
            Object object6 = SAPUtils.getTableParameterList(object4);
            SAPUtils.setValueOfInput(object5, string2);
            Object object7 = object6.getClass().getMethod("getTable", String.class).invoke(object6, "OPTIONS");
            Object object8 = object6.getClass().getMethod("getTable", String.class).invoke(object6, "FIELDS");
            Object object9 = object6.getClass().getMethod("getTable", String.class).invoke(object6, "DATA");
            SAPUtils.setClauses(object7, object8, object9, stringArray, stringArray2);
            SAPUtils.executeFunction(object4, object);
            SAPUtils.saveTableData(object9, list);
        }
        finally {
            SAPUtils.quitConnection(object, object2);
        }
    }

    private static void setValueOfInput(Object object, String string) throws Exception {
        ((JCO.ParameterList)object).setValue(string, "QUERY_TABLE");
        ((JCO.ParameterList)object).setValue("100000000", "ROWCOUNT");
        ((JCO.ParameterList)object).setValue("|", "DELIMITER");
    }

    private static void setClauses(Object object, Object object2, Object object3, String[] stringArray, String[] stringArray2) throws Exception {
        int n2;
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                ((JCO.Table)object).appendRow();
                ((JCO.Table)object).setValue(stringArray[n2], "TEXT");
            }
        }
        if (stringArray2 != null) {
            ((JCO.Table)object3).clear();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                ((JCO.Table)object2).appendRow();
                ((JCO.Table)object2).setValue(stringArray2[n2], "FIELDNAME");
            }
        }
    }

    public static void saveTableData(Object object, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        int n2 = ((JCO.Table)object).getNumRows();
        if (n2 > 0) {
            boolean bl;
            do {
                JCO.FieldIterator fieldIterator = ((JCO.Table)object).fields();
                JCO.Field field = fieldIterator.nextField();
                String string = field.getString();
                int n3 = 0;
                SAPUtils.addRow(n3, string, arrayList);
                list.add(arrayList.toArray(new String[0]));
                arrayList.clear();
            } while (bl = ((JCO.Table)object).nextRow());
        }
    }

    private static void addRow(int n2, String string, ArrayList arrayList) {
        int n3;
        do {
            String string2;
            if ((n3 = string.indexOf("|", n2)) < 0) {
                string2 = string.substring(n2);
            } else {
                string2 = string.substring(n2, n3);
                n2 = n3 + 1;
            }
            string2 = string2.trim();
            arrayList.add(string2);
        } while (n3 > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractTableData(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, List list) throws Exception {
        Object object = SAPUtils.getConnection(string);
        Object object2 = SAPUtils.getRepository(object);
        try {
            Object object3 = SAPUtils.getFunctionTemplate(object2, "EXTRACT_TABLE_DATA");
            Object object4 = SAPUtils.getFunction(object3);
            Object object5 = SAPUtils.getTableParameterList(object4);
            SAPUtils.populateTable(object5, "FROMCLAUSE", stringArray2);
            SAPUtils.populateTable(object5, "FIELDS", stringArray);
            if (stringArray3 != null && stringArray3.length > 0) {
                SAPUtils.populateTable(object5, "WHERECLAUSE", stringArray3);
            }
            SAPUtils.executeFunction(object4, object);
            Object object6 = object5.getClass().getMethod("getTable", String.class).invoke(object5, "DATA");
            SAPUtils.saveDataForV6(object6, list);
        }
        finally {
            SAPUtils.quitConnection(object, object2);
        }
    }

    private static void populateTable(Object object, String string, String[] stringArray) throws Exception {
        int n2 = 0;
        JCO.Table table = null;
        try {
            boolean bl;
            table = ((JCO.ParameterList)object).getTable(string);
            table.appendRows(stringArray.length);
            do {
                table.setValue(stringArray[n2], 0);
                ++n2;
            } while (bl = table.nextRow());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    private static void saveDataForV6(Object object, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        int n2 = ((JCO.Table)object).getNumRows();
        if (n2 > 0) {
            boolean bl;
            do {
                JCO.FieldIterator fieldIterator = ((JCO.Table)object).fields();
                JCO.Field field = fieldIterator.nextField();
                String string = field.getString();
                int n3 = 1;
                SAPUtils.addRow(n3, string, arrayList);
                list.add(arrayList.toArray(new String[0]));
                arrayList.clear();
            } while (bl = ((JCO.Table)object).nextRow());
        }
    }
}

