/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.impl.sap.SAPTransfer;
import com.fr.file.XMLFileManager;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.Iterator;

public class SAPTransferManager
extends XMLFileManager
implements XMLable {
    private static SAPTransferManager manager = null;
    public static final String XML_TAG = "SAPTransferManager";
    private ListMap transferMap = new ListMap();

    public static SAPTransferManager getInstance() {
        if (manager == null) {
            manager = new SAPTransferManager();
            manager.readXMLFile();
        }
        return manager;
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        SAPTransferManager sAPTransferManager = new SAPTransferManager();
        XMLTools.readInputStreamXML(sAPTransferManager, inputStream);
        manager = sAPTransferManager;
        GeneralContext.getEnvProvider().writeResource(manager);
    }

    private static synchronized void envChanged() {
        manager = null;
    }

    private SAPTransferManager() {
    }

    public String fileName() {
        return "saptransfer.xml";
    }

    public Iterator getSAPTransferNameIterator() {
        return this.transferMap.keySet().iterator();
    }

    private SAPTransfer getStoredSAPTransfer(String string) {
        return (SAPTransfer)this.transferMap.get(string);
    }

    public SAPTransfer getSAPTransfer(String string) {
        SAPTransfer sAPTransfer = this.getStoredSAPTransfer(string);
        try {
            return sAPTransfer == null ? null : (SAPTransfer)sAPTransfer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public void putSAPTransfer(String string, SAPTransfer sAPTransfer) {
        if (sAPTransfer == null) {
            this.transferMap.remove(string);
        }
        this.transferMap.put(string, sAPTransfer);
    }

    public boolean renameSAPTransfer(String string, String string2) {
        if (!this.transferMap.containsKey(string) || this.transferMap.containsKey(string2)) {
            return false;
        }
        int n2 = this.transferMap.indexOf(string);
        this.transferMap.put(n2, string2, this.transferMap.get(string));
        return true;
    }

    public void removeWidgetConfig(String string) {
        this.transferMap.remove(string);
    }

    public void clearAllSAPTransfer() {
        this.transferMap.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.clearAllSAPTransfer();
        }
        if (xMLableReader.isChildNode() && "SAPTransferElement".equals(string = xMLableReader.getTagName())) {
            final String string2 = xMLableReader.getAttrAsString("name", null);
            if (string2 == null) {
                return;
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("SAPTRANSFER")) {
                        SAPTransfer sAPTransfer = new SAPTransfer();
                        xMLableReader.readXMLObject(sAPTransfer);
                        SAPTransferManager.this.putSAPTransfer(string2, sAPTransfer);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Iterator iterator = this.getSAPTransferNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SAPTransfer sAPTransfer = this.getStoredSAPTransfer(string);
            if (sAPTransfer == null) continue;
            xMLPrintWriter.startTAG("SAPTransferElement");
            if (string != null) {
                xMLPrintWriter.attr("name", string);
            }
            sAPTransfer.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                SAPTransferManager.envChanged();
            }
        });
    }
}

