/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.core.db.dml.Table;
import com.fr.data.impl.sap.SAPTransferColumnConfig;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class SAPTransfer
implements XMLable {
    public static final String XML_TAG = "SAPTRANSFER";
    public static final int SUBMIT_TYPE_INSERT = 0;
    public static final int SUBMIT_TYPE_INTELLI = 1;
    public static final int SUBMIT_TYPE_UPDATE = 2;
    public static final int SUBMIT_TYPE_DELETE = 3;
    private String SAPTableDataName;
    private String exportDataBaseName;
    private Table exportTable;
    private int submitType = 0;
    private List columnConfigList = new ArrayList();

    public String getSAPTableDataName() {
        return this.SAPTableDataName;
    }

    public void setSAPTableDataName(String string) {
        this.SAPTableDataName = string;
    }

    public String getExportDataBaseName() {
        return this.exportDataBaseName;
    }

    public void setExportDataBaseName(String string) {
        this.exportDataBaseName = string;
    }

    public Table getExportTable() {
        return this.exportTable;
    }

    public void setExportTable(Table table) {
        this.exportTable = table;
    }

    public int getColumnConfigCount() {
        return this.columnConfigList.size();
    }

    public void addColumnConfig(SAPTransferColumnConfig sAPTransferColumnConfig) {
        this.columnConfigList.add(sAPTransferColumnConfig);
    }

    public SAPTransferColumnConfig getColumnConfig(int n2) {
        return (SAPTransferColumnConfig)this.columnConfigList.get(n2);
    }

    public void removeAllColumnConfig() {
        this.columnConfigList.clear();
    }

    public SAPTransferColumnConfig[] getColumnConfigs() {
        return this.columnConfigList.toArray(new SAPTransferColumnConfig[0]);
    }

    public int getSubmitType() {
        return this.submitType;
    }

    public void setSubmitType(int n2) {
        this.submitType = n2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.removeAllColumnConfig();
            this.SAPTableDataName = xMLableReader.getAttrAsString("sapname", null);
            this.exportDataBaseName = xMLableReader.getAttrAsString("dbname", null);
            this.submitType = xMLableReader.getAttrAsInt("stype", 0);
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Table".equals(string)) {
                this.exportTable = new Table();
                xMLableReader.readXMLObject(this.exportTable);
            } else if ("SAPCC".equals(string)) {
                SAPTransferColumnConfig sAPTransferColumnConfig = new SAPTransferColumnConfig();
                xMLableReader.readXMLObject(sAPTransferColumnConfig);
                this.addColumnConfig(sAPTransferColumnConfig);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("sapname", this.SAPTableDataName).attr("dbname", this.exportDataBaseName).attr("stype", this.submitType);
        if (this.exportTable != null) {
            this.exportTable.writeXML(xMLPrintWriter);
        }
        for (int i2 = 0; i2 < this.columnConfigList.size(); ++i2) {
            ((SAPTransferColumnConfig)this.columnConfigList.get(i2)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        SAPTransfer sAPTransfer = (SAPTransfer)super.clone();
        sAPTransfer.columnConfigList = new ArrayList();
        for (int i2 = 0; i2 < this.columnConfigList.size(); ++i2) {
            sAPTransfer.columnConfigList.add(this.columnConfigList.get(i2));
        }
        if (this.exportTable != null) {
            sAPTransfer.exportTable = (Table)this.exportTable.clone();
        }
        return super.clone();
    }
}

