/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.xmla;

import com.fr.data.condition.XMLATreeNodeField;
import com.fr.data.impl.multidimensional.xmla.SAPHANAQueryXMLADataModel;
import com.fr.data.impl.multidimensional.xmla.XMLATableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAPHANAQueryXMLATableData
extends XMLATableData {
    private static final long serialVersionUID = -7974463315098929480L;
    private String mdx;
    private String whereState = "";
    private List<String> sliceDm = new ArrayList<String>();
    private int sameDmPosition;

    @Override
    public DataModel createDataModel(Calculator calculator) {
        String string = this.getConnectionName();
        if (StringUtils.isNotBlank(this.getUserDefinedMdx())) {
            this.sliceDm = null;
            ParameterProvider[] parameterProviderArray = this.processParameters(calculator);
            String string2 = this.dealParameter(this.getUserDefinedMdx(), parameterProviderArray);
            return new SAPHANAQueryXMLADataModel(string, string2, true);
        }
        String string3 = this.getCube();
        String string4 = this.getSelectMeasure();
        String string5 = this.getSelectDimension();
        if (StringUtils.isBlank(string4) || StringUtils.isBlank(string5)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = this.createColumnMdx(string4);
        XMLATreeNodeField xMLATreeNodeField = this.getFilterStatement();
        if (xMLATreeNodeField == null) {
            this.mdx = stringBuilder.append("select ").append(string6).append(this.createRowMdx(string5)).append(" on rows from ").append(string3).toString();
        } else {
            this.dealFilterStatement(xMLATreeNodeField);
            stringBuilder.append(this.GetWithState()).append(" select ");
            String string7 = !this.isChangedAxisDmName() ? this.createRowMdx(this.getSelectDimension()) : this.createRowMdxAfterFiltered(this.getRowAfterFilter());
            stringBuilder.append(string6).append(string7).append(" on rows ");
            if (StringUtils.isNotBlank(this.whereState)) {
                this.whereState = this.whereState.replaceAll(";", ",");
            }
            stringBuilder.append("from ").append(string3).append(this.whereState);
            this.mdx = stringBuilder.toString();
        }
        this.sliceDm = null;
        FRLogger.getLogger().info("MDX: " + this.mdx);
        return new SAPHANAQueryXMLADataModel(string, this.mdx, false);
    }

    private boolean isJustSelectOneDm(String string) {
        String[] stringArray = string.trim().split(",");
        if (stringArray.length == 1) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getHierarchyFromLevel(stringArray[0]));
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String string2 = this.getHierarchyFromLevel(stringArray[i2]);
            if (arrayList.indexOf(string2) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String createRowMdx(String string) {
        int n2;
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.trim().split(",");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isJustSelectOneDm(string)) {
            stringBuilder.append("{");
            for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                stringBuilder.append(stringArray[i2]).append(",");
            }
            return stringBuilder.append(stringArray[stringArray.length - 1]).append("}").toString();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string2 = this.getHierarchyFromLevel(stringArray[n2]);
            if (arrayList.indexOf(string2) != -1) {
                int n3 = arrayList.indexOf(string2);
                String string3 = (String)arrayList2.get(n3) + "," + stringArray[n2];
                arrayList2.set(n3, string3);
                continue;
            }
            arrayList.add(string2);
            arrayList2.add(stringArray[n2]);
        }
        stringBuilder.append("Non Empty(");
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            stringBuilder.append("{").append((String)arrayList2.get(n2)).append("}");
            if (n2 >= arrayList2.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    protected String createRowMdxAfterFiltered(String string) {
        int n2;
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length == 1) {
            return string;
        }
        String[] stringArray2 = this.getSelectRowAxisDm(this.getSelectDimension());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string2;
            String[] stringArray3 = stringArray[n2].split("\\.");
            String string3 = this.getHierarchyFromLevel(stringArray2[n2]);
            String string4 = string2 = stringArray3.length == 1 ? stringArray[n2] : stringArray2[n2] + ",members";
            if (arrayList.indexOf(string3) != -1) {
                int n3 = arrayList.indexOf(string3);
                String string5 = (String)arrayList2.get(n3) + "," + string2;
                arrayList2.set(n3, string5);
                continue;
            }
            arrayList.add(string3);
            arrayList2.add(string2);
        }
        stringBuilder.append("Non Empty(");
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            stringBuilder.append("{").append((String)arrayList2.get(n2)).append("}");
            if (n2 >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    protected void dealSlice(XMLATreeNodeField xMLATreeNodeField) {
        if (this.isNotValidFilterState(xMLATreeNodeField)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Integer n2 = xMLATreeNodeField.getFirstCompare();
        String string = xMLATreeNodeField.getFirstEditValue().toString();
        String string2 = this.getHierarchyFromLevel(string);
        Object object = this.dealWithCompareValue(xMLATreeNodeField.getEditValues()[0]);
        if (ComparatorUtils.equals(n2, 0)) {
            stringBuilder.append(string).append(".[").append(object).append("]");
        } else if (ComparatorUtils.equals(n2, 1)) {
            stringBuilder.append(string).append("-").append(string).append(".[").append(object).append("]");
        } else if (ComparatorUtils.equals(n2, 2)) {
            stringBuilder.append("{").append(string).append(".[").append(object).append("].NextMember : ").append(string).append(".[").append(object).append("].LastSibling} ");
        } else if (ComparatorUtils.equals(n2, 3)) {
            stringBuilder.append("{").append(string).append(".[").append(object).append("] : ").append(string).append(".[").append(object).append("].LastSibling} ");
        } else if (ComparatorUtils.equals(n2, 4)) {
            stringBuilder.append("{").append(string).append(".[").append(object).append("].FirstSibling : ").append(string).append(".[").append(object).append("].PrevMember}  ");
        } else if (ComparatorUtils.equals(n2, 5)) {
            stringBuilder.append("{").append(string).append(".[").append(object).append("].FirstSibling : ").append(string).append(".[").append(object).append("]}  ");
        } else if (ComparatorUtils.equals(n2, 10)) {
            stringBuilder.append("{Filter(").append(string).append(";Instr(").append(string2).append(".CurrentMember.name;\"").append(object).append("\")>=1)} ");
        } else if (ComparatorUtils.equals(n2, 11)) {
            stringBuilder.append("{Filter(").append(string).append(";Instr(").append(string2).append(".CurrentMember.name;\"").append(object).append("\")=0)} ");
        } else if (ComparatorUtils.equals(n2, 6)) {
            stringBuilder.append("{Filter(").append(string).append(";Instr(").append(string2).append(".CurrentMember.name;\"").append(object).append("\")=1)} ");
        } else if (ComparatorUtils.equals(n2, 12)) {
            stringBuilder.append("{").append(this.dealWithSliceDmConditionIn(object.toString(), string)).append("} ");
        } else if (ComparatorUtils.equals(n2, 13)) {
            stringBuilder.append("{").append(this.dealWithDmConditionNotIn(object.toString(), string)).append("} ");
        }
        if (this.isHasSameDm(string)) {
            this.dealWithSliceDm(stringBuilder.toString());
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n3 = this.whereState.length() - 1;
            this.whereState = StringUtils.isBlank(this.whereState) ? stringBuilder2.append(" where (").append(stringBuilder.toString()).append(")").toString() : stringBuilder2.append(this.whereState).insert(n3, stringBuilder.insert(0, ",").toString()).toString();
        }
    }

    private void dealWithSliceDm(String string) {
        CharSequence charSequence;
        String[] stringArray = this.whereState.split("[\\(\\)]");
        String[] stringArray2 = stringArray[stringArray.length - 1].split(",");
        if (this.sameDmPosition > stringArray2.length - 1) {
            return;
        }
        String string2 = stringArray2[this.sameDmPosition].trim();
        String string3 = "^\\{.*\\}$";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            string = string.replaceAll("[\\{\\}]", "");
        }
        Matcher matcher2 = pattern.matcher(string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (matcher2.matches()) {
            charSequence = string2.substring(1, string2.length() - 1);
            stringBuilder.append("{").append((String)charSequence).append(";").append(string).append("}").toString();
        } else {
            stringBuilder.append("{").append(string2).append(";").append(string).append("}").toString();
        }
        stringArray2[this.sameDmPosition] = stringBuilder.toString();
        charSequence = new StringBuilder(" where (");
        ((StringBuilder)charSequence).append(stringArray2[0]);
        for (int i2 = 1; i2 < stringArray2.length; ++i2) {
            ((StringBuilder)charSequence).append(",").append(stringArray2[i2]);
        }
        this.whereState = ((StringBuilder)charSequence).append(")").toString();
    }

    private boolean isHasSameDm(String string) {
        String[] stringArray;
        Object object;
        if (StringUtils.isBlank(string)) {
            return false;
        }
        String string2 = "^\\{.*\\}$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            object = string.replaceAll("[\\{\\}]", "").split(";");
            String[] stringArray2 = object[0].split("[\\(\\)]");
            stringArray = stringArray2[stringArray2.length - 1].split("\\.");
        } else {
            stringArray = string.split("\\.");
        }
        object = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            if (i2 > 0) {
                ((StringBuilder)object).append(".");
            }
            ((StringBuilder)object).append(stringArray[i2]);
        }
        if (this.sliceDm.isEmpty()) {
            this.sliceDm.add(((StringBuilder)object).toString());
            return false;
        }
        String string3 = ((StringBuilder)object).toString();
        if (this.sliceDm.indexOf(string3) != -1) {
            this.sameDmPosition = this.sliceDm.indexOf(string3);
            return true;
        }
        this.sliceDm.add(((StringBuilder)object).toString());
        return false;
    }

    public String getMdx() {
        return this.mdx;
    }

    public void setMdx(String string) {
        this.mdx = string;
    }

    @Override
    protected void dealSelectRowDm(XMLATreeNodeField xMLATreeNodeField, List<String> list) {
        if (this.isNotValidFilterState(xMLATreeNodeField)) {
            return;
        }
        String string = xMLATreeNodeField.getFirstEditValue().toString();
        int n2 = list.indexOf(string);
        String string2 = "set" + String.valueOf(n2);
        this.modifySelectDimension(string2, n2);
        this.setChangedAxisDmName(true);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" set ").append(string2).append(" as ");
        Integer n3 = xMLATreeNodeField.getFirstCompare();
        String string3 = this.getHierarchyFromLevel(string);
        Object object = this.dealWithCompareValue(xMLATreeNodeField.getEditValues()[0]);
        if (ComparatorUtils.equals(n3, 0)) {
            stringBuilder.append(string).append(".[").append(object).append("] ");
        } else if (ComparatorUtils.equals(n3, 1)) {
            stringBuilder.append(string).append("-").append(string).append(".[").append(object).append("] ");
        } else if (ComparatorUtils.equals(n3, 2)) {
            stringBuilder.append(string).append(".[").append(object).append("].NextMember : ").append(string).append(".[").append(object).append("].LastSibling ");
        } else if (ComparatorUtils.equals(n3, 3)) {
            stringBuilder.append(string).append(".[").append(object).append("] : ").append(string).append(".[").append(object).append("].LastSibling ");
        } else if (ComparatorUtils.equals(n3, 4)) {
            stringBuilder.append(string).append(".[").append(object).append("].FirstSibling : ").append(string).append(".[").append(object).append("].PrevMember  ");
        } else if (ComparatorUtils.equals(n3, 5)) {
            stringBuilder.append(string).append(".[").append(object).append("].FirstSibling : ").append(string).append(".[").append(object).append("] ");
        } else if (ComparatorUtils.equals(n3, 10)) {
            stringBuilder.append("'Filter(").append(string).append(",Instr(").append(string3).append(".CurrentMember.name,\"").append(object).append("\")>=1)' ");
        } else if (ComparatorUtils.equals(n3, 11)) {
            stringBuilder.append("'Filter(").append(string).append(",Instr(").append(string3).append(".CurrentMember.name,\"").append(object).append("\")=0)' ");
        } else if (ComparatorUtils.equals(n3, 6)) {
            stringBuilder.append("'Filter(").append(string).append(",Instr(").append(string3).append(".CurrentMember.name,\"").append(object).append("\")=1)' ");
        } else if (ComparatorUtils.equals(n3, 12)) {
            stringBuilder.append("{").append(this.dealWithDmConditionIn(object.toString(), string)).append("} ");
        } else if (ComparatorUtils.equals(n3, 13)) {
            stringBuilder.append("{").append(this.dealWithDmConditionNotIn(object.toString(), string)).append("} ");
        }
        String string4 = this.GetWithState();
        this.setWithState(StringUtils.isBlank(string4) ? stringBuilder.insert(0, "with").toString() : stringBuilder.insert(0, string4).toString());
    }

    @Override
    protected String dealDimensionMember(String string) {
        return string;
    }

    @Override
    protected String[] getSelectRowAxisDm(String string) {
        if (StringUtils.isBlank(string)) {
            return new String[0];
        }
        return string.split(",");
    }
}

