/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.finebi;

import com.fr.base.Parameter;
import com.fr.data.condition.XMLATreeNodeField;
import com.fr.data.impl.multidimensional.MultiDimensionTableData;
import com.fr.data.impl.multidimensional.finebi.FineBiCubeDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FineBiCubeTableData
extends MultiDimensionTableData {
    private static final long serialVersionUID = 3613990513813670479L;
    public static final String FINEBI_TABLE_TAG = "FINEBITableDataAttr";

    public void setParams(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(FINEBI_TABLE_TAG, string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttrAsString("connectionName", null);
            if (string2 != null) {
                this.setConnectionName(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("cube", null)) != null) {
                this.setCube(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("selectMeasure", null)) != null) {
                this.setSelectMeasure(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("selectDimension", null)) != null) {
                this.setSelectDimension(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("queryMode", null)) != null) {
                this.setQueryMode(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("class", null)) != null) {
                XMLATreeNodeField xMLATreeNodeField = null;
                try {
                    xMLATreeNodeField = (XMLATreeNodeField)GeneralUtils.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
                if (xMLATreeNodeField != null) {
                    xMLableReader.readXMLObject(xMLATreeNodeField);
                    this.setFilterStatement(xMLATreeNodeField);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(FINEBI_TABLE_TAG);
        xMLPrintWriter.attr("connectionName", this.getConnectionName());
        xMLPrintWriter.attr("cube", this.getCube());
        xMLPrintWriter.attr("selectMeasure", this.getSelectMeasure());
        xMLPrintWriter.attr("selectDimension", this.getSelectDimension());
        xMLPrintWriter.attr("queryMode", this.getQueryMode());
        if (this.getFilterStatement() != null) {
            xMLPrintWriter.attr("class", this.getFilterStatement().getClass().getName());
            this.getFilterStatement().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public DataModel createDataModel(Calculator calculator) {
        ParameterProvider[] parameterProviderArray = this.processParameters(calculator);
        return new FineBiCubeDataModel(this.getCube(), this.getSelectDimension(), this.getSelectMeasure(), this.getFilterStatement(), this.getConnectionName(), parameterProviderArray);
    }

    public boolean isXMLAData() {
        return false;
    }

    public boolean isFineBIData() {
        return true;
    }
}

