/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.finebi;

import com.fr.base.ParameterHelper;
import com.fr.base.TemplateUtils;
import com.fr.data.condition.XMLAListField;
import com.fr.data.condition.XMLATreeNodeField;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.http.HttpClient;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FineBiCubeDatabaseConnection
implements Connection {
    public static final int BI_TARGET_NUMBER = 0;
    public static final int BI_TARGET_COUNT = 4;
    public static final int BI_SUMMARY_SUM = 0;
    public static final int BI_SORT_ASC = 0;
    public static final int BI_SORT_DESC = 1;
    public static final int BI_DATEGROUP_YMD = 0;
    public static final int BI_DATEGROUP_Y = 1;
    public static final int BI_DATEGROUP_S = 2;
    public static final int BI_DATEGROUP_M = 3;
    public static final int BI_DATEGROUP_W = 4;
    public static final String FINEBI_TAG = "FINEBIDatabaseAttr";
    private static final int BI_STRING_TYPE_LIKE = 4;
    private static final int BI_STRING_TYPE_NOTLIKE = 5;
    private static final int BI_STRING_TYPE_START = 6;
    private static final int BI_STRING_TYPE_END = 7;
    private String hostName = "";
    private String conPort = "";
    private String webName = "";
    private String servletName = "";
    private String user = "";
    private String password = "";
    private String path = "";
    private String sessionID = null;

    public FineBiCubeDatabaseConnection() {
    }

    public FineBiCubeDatabaseConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        this.hostName = string;
        this.conPort = string2;
        this.webName = string3;
        this.servletName = string4;
        this.user = string5;
        this.password = string6;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && FINEBI_TAG.equals(xMLableReader.getTagName())) {
            String string = xMLableReader.getAttrAsString("hostname", null);
            if (string != null) {
                this.setHostName(string);
            }
            if ((string = xMLableReader.getAttrAsString("conport", null)) != null) {
                this.setConPort(string);
            }
            if ((string = xMLableReader.getAttrAsString("webname", null)) != null) {
                this.setWebName(string);
            }
            if ((string = xMLableReader.getAttrAsString("servletname", null)) != null) {
                this.setServletName(string);
            }
            if ((string = xMLableReader.getAttrAsString("user", null)) != null) {
                this.setUser(string);
            }
            if ((string = xMLableReader.getAttrAsString("password", null)) != null) {
                this.setPassword(CodeUtils.passwordDecode(string));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(FINEBI_TAG).attr("hostname", this.hostName).attr("conport", this.conPort).attr("webname", this.webName).attr("servletname", this.servletName).attr("user", this.user).attr("password", this.password);
        xMLPrintWriter.end();
    }

    @Override
    public void setOriginalCharsetName(String string) {
    }

    @Override
    public String getNewCharsetName() {
        return null;
    }

    @Override
    public String getDriver() {
        return null;
    }

    @Override
    public void setNewCharsetName(String string) {
    }

    @Override
    public void testConnection() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "test_connection");
        String string = this.getResponseMessage(hashMap);
        if (ComparatorUtils.equals(string, "ERROR_LOGIN")) {
            throw new Exception("ERROR_LOGIN");
        }
        if (ComparatorUtils.equals(string, "-1")) {
            throw new Exception("CONNECT REFUSED");
        }
    }

    @Override
    public java.sql.Connection createConnection() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "create_session");
        String string = this.getResponseMessage(hashMap);
        if (ComparatorUtils.equals(string, "ERROR_LOGIN")) {
            throw new Exception("ERROR_LOGIN");
        }
        if (ComparatorUtils.equals(string, "ERROR_CREATE_SESSION")) {
            throw new Exception("ERROR_CREATE_SESSION");
        }
        if (ComparatorUtils.equals(string, "-1")) {
            throw new Exception("CONNECT REFUSED");
        }
        this.sessionID = new JSONObject(string).optString("sessionID", null);
        return null;
    }

    public void closeConnection() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "close_session");
        hashMap.put("sessionID", this.sessionID);
        HttpClient httpClient = new HttpClient(this.path, hashMap);
        int n2 = httpClient.getResponseCode();
        if (n2 != 200) {
            throw new Exception("Method failed: " + n2);
        }
    }

    public void updateConnection() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "update_session");
        hashMap.put("sessionID", this.sessionID);
        HttpClient httpClient = new HttpClient(this.path, hashMap);
        int n2 = httpClient.getResponseCode();
        if (n2 != 200) {
            throw new Exception("Method failed: " + n2);
        }
    }

    public JSONArray getAllPackages() throws Exception {
        this.createConnection();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "get_all_package");
        hashMap.put("sessionID", this.sessionID);
        return this.getJSONData(hashMap);
    }

    public JSONArray getAllTargets(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        try {
            if (StringUtils.isBlank(this.sessionID)) {
                this.createConnection();
            } else {
                this.updateConnection();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "get_all_targets");
        hashMap.put("sessionID", this.sessionID);
        hashMap.put("package_name", string);
        return this.getJSONData(hashMap);
    }

    public JSONArray getAllDimensions(String string, String string2) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return null;
        }
        String string3 = null;
        try {
            this.updateConnection();
            string3 = this.createTargets(string2, string).toString();
        }
        catch (JSONException jSONException) {
            string3 = null;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "get_all_dimensions");
        hashMap.put("sessionID", this.sessionID);
        hashMap.put("package_name", string);
        hashMap.put("targets", string3);
        return this.getJSONData(hashMap);
    }

    public JSONArray getAllFields(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        try {
            if (StringUtils.isBlank(this.sessionID)) {
                this.createConnection();
            } else {
                this.updateConnection();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("op", "fr_bi_third");
        hashMap.put("fsusername", this.user);
        hashMap.put("fspassword", this.password);
        hashMap.put("cmd", "get_all_fields");
        hashMap.put("sessionID", this.sessionID);
        hashMap.put("package_name", string);
        return this.getJSONData(hashMap);
    }

    public JSONArray createTargets(String string, String string2) throws JSONException {
        JSONObject jSONObject;
        Object object;
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object = stringArray[i2].split("\\.");
            if (((String[])object).length >= 2) continue;
            stringArray[i2] = object[0] + "." + object[0];
        }
        JSONArray jSONArray = this.getAllFieldDatas(this.getAllTargets(string2));
        object = new JSONArray();
        block1: for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String[] stringArray2 = stringArray[i3].split("\\.");
            for (int i4 = 0; i4 < jSONArray.length(); ++i4) {
                boolean bl;
                jSONObject = jSONArray.getJSONObject(i4);
                boolean bl2 = ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject, "table_name"), stringArray2[0]);
                boolean bl3 = bl = ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject, "field_name"), stringArray2[1]) || ComparatorUtils.equals(stringArray2[1], Inter.getLocText("Record-Number"));
                if (!bl2 || !bl) continue;
                ((JSONArray)object).put(jSONObject);
                continue block1;
            }
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i5 = 0; i5 < ((JSONArray)object).length(); ++i5) {
            String string3 = StringUtils.isBlank(stringArray[i5]) ? ((JSONArray)object).getJSONObject(i5).optString("field_name", null) : stringArray[i5];
            jSONObject = new JSONObject();
            jSONObject.put("name", string3);
            String[] stringArray3 = string3.split("\\.");
            if (ComparatorUtils.equals(stringArray3[1], Inter.getLocText("Record-Number"))) {
                this.createJsonObjectRecordNumber(jSONObject, ((JSONArray)object).getJSONObject(i5));
            } else {
                jSONObject.put("type", 0);
                jSONObject.put("statistics_element", ((JSONArray)object).getJSONObject(i5));
                jSONObject.put("summary", 0);
            }
            jSONArray2.put(jSONObject);
        }
        return jSONArray2;
    }

    private void createJsonObjectRecordNumber(JSONObject jSONObject, JSONObject jSONObject2) throws JSONException {
        JSONObject jSONObject3 = new JSONObject();
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            jSONObject3.put(string, jSONObject2.opt(string));
        }
        jSONObject.put("type", 4);
        jSONObject.put("table_infor", jSONObject3);
    }

    public static String getEscapeName(JSONObject jSONObject, String string) {
        String string2 = jSONObject.optString(string, "");
        try {
            String string3 = jSONObject.getString(string + "_text");
            return StringUtils.isNotBlank(string3) ? string3 : string2;
        }
        catch (JSONException jSONException) {
            return string2;
        }
    }

    public JSONArray getAllFieldDatas(JSONArray jSONArray) {
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                JSONArray jSONArray3 = jSONArray.getJSONObject(i2).getJSONArray("fields");
                for (int i3 = 0; i3 < jSONArray3.length(); ++i3) {
                    jSONArray2.put(jSONArray3.getJSONObject(i3));
                }
                continue;
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return jSONArray2;
    }

    public JSONArray createDimensions(String string, JSONArray jSONArray) throws JSONException {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.split(",");
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = this.getAllFieldDatas(jSONArray);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split("\\.");
            JSONObject jSONObject = new JSONObject();
            for (int i3 = 0; i3 < jSONArray3.length(); ++i3) {
                JSONObject jSONObject2 = jSONArray3.getJSONObject(i3);
                boolean bl = ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject2, "table_name"), stringArray2[0]);
                if (!bl || !ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject2, "field_name"), stringArray2[1])) continue;
                jSONObject.put("name", stringArray[i2]);
                jSONObject.put("type", jSONObject2.get("field_type"));
                jSONObject.put("statistics_element", jSONObject2);
                jSONObject.put("sort", new JSONObject().put("type", 0));
                if (stringArray2.length != 3) break;
                int n2 = ComparatorUtils.equals(stringArray2[2], Inter.getLocText("Year")) ? 1 : (ComparatorUtils.equals(stringArray2[2], Inter.getLocText("Month")) ? 3 : (ComparatorUtils.equals(stringArray2[2], Inter.getLocText("Quarter")) ? 2 : (ComparatorUtils.equals(stringArray2[2], Inter.getLocText("Sche-Week")) ? 4 : 0)));
                jSONObject.put("group", n2);
                break;
            }
            jSONArray2.put(jSONObject);
        }
        return jSONArray2;
    }

    public JSONObject createSelectConditions(XMLATreeNodeField xMLATreeNodeField, JSONArray jSONArray, ParameterProvider[] parameterProviderArray) throws JSONException {
        if (xMLATreeNodeField == null) {
            return new JSONObject();
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("andor", "and");
        JSONArray jSONArray2 = this.getAllFieldDatas(jSONArray);
        JSONArray jSONArray3 = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        boolean bl = xMLATreeNodeField.isNode();
        int n2 = bl ? 1 : ((XMLAListField)xMLATreeNodeField).getJoinFieldCount();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    XMLATreeNodeField xMLATreeNodeField2 = bl ? xMLATreeNodeField : ((XMLAListField)xMLATreeNodeField).getJoinField(i2).getField();
                    String[] stringArray = xMLATreeNodeField2.getFirstEditValue().toString().split("\\.");
                    JSONObject jSONObject3 = jSONArray2.getJSONObject(i3);
                    boolean bl2 = ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject3, "table_name"), stringArray[0]);
                    if (!bl2 || !ComparatorUtils.equals(FineBiCubeDatabaseConnection.getEscapeName(jSONObject3, "field_name"), stringArray[1])) continue;
                    int n3 = jSONObject3.getInt("field_type");
                    jSONObject2.put("field_type", n3);
                    jSONObject2.put("statistics_element", jSONObject3);
                    if (n3 == 0) {
                        this.dealWithNumberField(jSONObject2, xMLATreeNodeField2, parameterProviderArray);
                        break;
                    }
                    if (n3 == 1) {
                        this.dealWithStringField(jSONObject2, xMLATreeNodeField2, parameterProviderArray);
                        break;
                    }
                    if (n3 != 3) break;
                    this.dealWithDateField(jSONObject2, xMLATreeNodeField2, parameterProviderArray);
                    break;
                }
                jSONArray3.put(jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage());
        }
        jSONObject.put("condition", jSONArray3);
        return jSONObject;
    }

    private void dealWithNumberField(JSONObject jSONObject, XMLATreeNodeField xMLATreeNodeField, ParameterProvider[] parameterProviderArray) throws JSONException {
        int n2 = 0;
        JSONObject jSONObject2 = new JSONObject();
        if (ComparatorUtils.equals(xMLATreeNodeField.getFirstCompare(), 12)) {
            n2 = 0;
            this.putDataWhenContainOrNot(jSONObject2, xMLATreeNodeField, parameterProviderArray);
        } else if (ComparatorUtils.equals(xMLATreeNodeField.getFirstCompare(), 13)) {
            n2 = 1;
            this.putDataWhenContainOrNot(jSONObject2, xMLATreeNodeField, parameterProviderArray);
        } else if (ComparatorUtils.equals(xMLATreeNodeField.getFirstCompare(), 14)) {
            n2 = 2;
        } else if (ComparatorUtils.equals(xMLATreeNodeField.getFirstCompare(), 15)) {
            n2 = 3;
        }
        jSONObject.put("type", n2);
        jSONObject.put("value", jSONObject2);
    }

    private void putDataWhenContainOrNot(JSONObject jSONObject, XMLATreeNodeField xMLATreeNodeField, ParameterProvider[] parameterProviderArray) throws JSONException {
        Object[] objectArray = xMLATreeNodeField.getEditValues();
        Integer[] integerArray = xMLATreeNodeField.getCompares();
        jSONObject.put("min", this.dealWithNumber(objectArray[0], parameterProviderArray));
        jSONObject.put("closemin", ComparatorUtils.equals(5, integerArray[0]));
        jSONObject.put("max", this.dealWithNumber(objectArray[1], parameterProviderArray));
        jSONObject.put("closemax", ComparatorUtils.equals(5, integerArray[1]));
    }

    private Object dealWithNumber(Object object, ParameterProvider[] parameterProviderArray) {
        Object object2 = null;
        if (object instanceof ParameterProvider) {
            object2 = ParameterHelper.analyze4Templatee(object.toString(), parameterProviderArray);
        } else {
            if (object instanceof Double) {
                return object;
            }
            if (object instanceof Integer) {
                return Double.parseDouble(object.toString());
            }
            if (object instanceof FormulaProvider) {
                String string = ((FormulaProvider)object).getContent();
                try {
                    object2 = Calculator.createCalculator().evalValue(string);
                }
                catch (UtilEvalError utilEvalError) {
                    object2 = string;
                }
            }
        }
        if (ComparatorUtils.equals(object2.toString(), "")) {
            return 0.0;
        }
        return Double.parseDouble(object2.toString());
    }

    private void dealWithStringField(JSONObject jSONObject, XMLATreeNodeField xMLATreeNodeField, ParameterProvider[] parameterProviderArray) throws JSONException {
        int n2 = 0;
        String string = null;
        Integer n3 = xMLATreeNodeField.getFirstCompare();
        Object object = xMLATreeNodeField.getEditValues()[0];
        if (object instanceof FormulaProvider) {
            try {
                string = TemplateUtils.render(ParameterHelper.analyze4Templatee(object.toString(), parameterProviderArray), Calculator.createCalculator());
            }
            catch (Exception exception) {
                string = object.toString();
            }
        } else if (object instanceof Date) {
            string = ((Date)object).toGMTString();
        } else if (object instanceof ParameterProvider) {
            String string2 = "${" + ((ParameterProvider)object).getName() + "}";
            string = ParameterHelper.analyze4Templatee(string2, parameterProviderArray);
        } else {
            string = String.valueOf(object);
        }
        if (ComparatorUtils.equals(n3, 12)) {
            n2 = 0;
            jSONObject.put("value", string.replaceAll("[()]", "").split(","));
        } else if (ComparatorUtils.equals(n3, 13)) {
            n2 = 1;
            jSONObject.put("value", string.replaceAll("[()]", "").split(","));
        } else if (ComparatorUtils.equals(n3, 10)) {
            n2 = 4;
            jSONObject.put("value", string);
        } else if (ComparatorUtils.equals(n3, 11)) {
            n2 = 5;
            jSONObject.put("value", string);
        } else if (ComparatorUtils.equals(n3, 14)) {
            n2 = 2;
        } else if (ComparatorUtils.equals(n3, 15)) {
            n2 = 3;
        } else if (ComparatorUtils.equals(n3, 6)) {
            n2 = 6;
            jSONObject.put("value", string);
        } else if (ComparatorUtils.equals(n3, 8)) {
            n2 = 7;
            jSONObject.put("value", string);
        }
        jSONObject.put("type", n2);
    }

    private void dealWithDateField(JSONObject jSONObject, XMLATreeNodeField xMLATreeNodeField, ParameterProvider[] parameterProviderArray) throws JSONException {
        int n2 = 0;
        JSONObject jSONObject2 = new JSONObject();
        Integer n3 = xMLATreeNodeField.getFirstCompare();
        if (ComparatorUtils.equals(n3, 12)) {
            n2 = 0;
            this.dealWithDateNumber(jSONObject2, xMLATreeNodeField, parameterProviderArray);
        } else if (ComparatorUtils.equals(n3, 13)) {
            n2 = 1;
            this.dealWithDateNumber(jSONObject2, xMLATreeNodeField, parameterProviderArray);
        } else if (ComparatorUtils.equals(n3, 14)) {
            n2 = 2;
        } else if (ComparatorUtils.equals(n3, 15)) {
            n2 = 3;
        }
        jSONObject.put("type", n2);
        jSONObject.put("value", jSONObject2);
    }

    private void dealWithDateNumber(JSONObject jSONObject, XMLATreeNodeField xMLATreeNodeField, ParameterProvider[] parameterProviderArray) throws JSONException {
        Object[] objectArray = xMLATreeNodeField.getEditValues();
        if (objectArray[0] != null) {
            jSONObject.put("start", objectArray[0]);
        }
        if (objectArray.length > 1 && objectArray[1] != null) {
            jSONObject.put("end", objectArray[1]);
        }
    }

    @Override
    public boolean isDatabaseConnection() {
        return false;
    }

    @Override
    public boolean isXMLAConnection() {
        return false;
    }

    @Override
    public boolean isFineBIConnection() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public String getConPort() {
        return this.conPort;
    }

    public void setConPort(String string) {
        this.conPort = string;
    }

    public String getWebName() {
        return this.webName;
    }

    public void setWebName(String string) {
        this.webName = string;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String string) {
        this.servletName = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getOriginalCharsetName() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FineBiCubeDatabaseConnection)) {
            return false;
        }
        FineBiCubeDatabaseConnection fineBiCubeDatabaseConnection = (FineBiCubeDatabaseConnection)object;
        return ComparatorUtils.equals(this.hostName, fineBiCubeDatabaseConnection.hostName) && ComparatorUtils.equals(this.conPort, fineBiCubeDatabaseConnection.conPort) && ComparatorUtils.equals(this.webName, fineBiCubeDatabaseConnection.webName) && ComparatorUtils.equals(this.servletName, fineBiCubeDatabaseConnection.servletName) && ComparatorUtils.equals(this.user, fineBiCubeDatabaseConnection.user) && ComparatorUtils.equals(this.password, fineBiCubeDatabaseConnection.password);
    }

    public String[] getAllCube() throws Exception {
        JSONArray jSONArray = this.getAllPackages();
        String[] stringArray = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                stringArray[i2] = jSONArray.getString(i2);
                continue;
            }
            catch (JSONException jSONException) {
                stringArray[i2] = null;
            }
        }
        return stringArray;
    }

    private String getResponseMessage(HashMap<String, String> hashMap) throws Exception {
        if (StringUtils.isBlank(this.path)) {
            this.path = "http://" + this.hostName + ":" + this.conPort + "/" + this.webName + "/" + this.servletName + "?";
        }
        HttpClient httpClient = new HttpClient(this.path, hashMap);
        return httpClient.getResponseText("GBK");
    }

    private JSONArray getJSONData(HashMap<String, String> hashMap) {
        JSONArray jSONArray;
        String string;
        try {
            string = this.getResponseMessage(hashMap);
            if (ComparatorUtils.equals(string, "\u201cERROR_LOGIN") || ComparatorUtils.equals(string, "ERROR_SESSION_TIMEOUT")) {
                return null;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
        try {
            jSONArray = new JSONArray(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return jSONArray;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }
}

