/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.base.TableData;
import com.fr.data.AbstractTableDataSource;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.XMLOPTableDataSource;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class RecursionTableData
implements TableData,
XMLable {
    private String originalTableDataName;
    private String markField = "";
    private String markFieldName = "";
    private String parentmarkField = "";
    private String parentmarkFieldName = "";
    private String separator = ",";
    private int limitGeneration = -1;
    private Connection con = null;
    private String query = "";
    private ParameterProvider[] parameters;
    private TableDataSource source;

    public DataModel createDataModel(Calculator calculator) {
        TableData tableData = this.createTableData(this.getOriginalTableDataName());
        if (tableData == null && this.getCon() != null) {
            tableData = new DBTableData(this.getCon(), this.getQuery());
            if (this.getParameters() != null) {
                ((DBTableData)tableData).setParameters(this.getParameters());
            }
        }
        DataModel dataModel = tableData.createDataModel(calculator);
        int n2 = -1;
        int n3 = -1;
        n2 = StringUtils.isNotEmpty(this.markFieldName) ? this.getIndexByColumnName(dataModel, this.markFieldName) : this.getIndexByColumnName(dataModel, this.markField);
        n3 = StringUtils.isNotEmpty(this.parentmarkFieldName) ? this.getIndexByColumnName(dataModel, this.parentmarkFieldName) : this.getIndexByColumnName(dataModel, this.parentmarkField);
        if (n2 == -1) {
            try {
                n2 = Integer.parseInt(this.markField);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (n3 == -1) {
            try {
                n3 = Integer.parseInt(this.parentmarkField);
            }
            catch (Exception exception) {
                n3 = -1;
            }
        }
        return new RecursionDataModel(dataModel, n2, n3);
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n2) {
        return this.createDataModel(calculator);
    }

    private int getIndexByColumnName(DataModel dataModel, String string) {
        try {
            int n2 = dataModel.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!ComparatorUtils.equals(dataModel.getColumnName(i2), string)) continue;
                return i2;
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return -1;
    }

    protected TableData createTableData(String string) {
        TableData tableData;
        if (StringUtils.isBlank(string)) {
            return null;
        }
        TableData tableData2 = tableData = this.source == null ? null : this.source.getTableData(string);
        if (tableData == null) {
            try {
                tableData = DataCoreUtils.getClonedTableData(DatasourceManager.getInstance(), string);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else {
            try {
                tableData = (TableData)tableData.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                tableData = null;
            }
        }
        return tableData;
    }

    public String getMarkFieldName() {
        return this.markFieldName;
    }

    public String getParentmarkFieldName() {
        return this.parentmarkFieldName;
    }

    public void setMarkFieldName(String string) {
        this.markFieldName = string;
    }

    public void setParentmarkFieldName(String string) {
        this.parentmarkFieldName = string;
    }

    public int getMarkFieldIndex() {
        try {
            return Integer.parseInt(this.markField);
        }
        catch (Exception exception) {
            TableData tableData = this.createTableData(this.getOriginalTableDataName());
            if (tableData == null && this.getCon() != null) {
                tableData = new DBTableData(this.getCon(), this.getQuery());
                if (this.getParameters() != null) {
                    ((DBTableData)tableData).setParameters(this.getParameters());
                }
            }
            if (tableData == null) {
                return -1;
            }
            DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
            return this.getIndexByColumnName(dataModel, this.markField);
        }
    }

    public void setMarkFields(String string) {
        this.markField = string;
    }

    public String getParentmarkFields() {
        return this.parentmarkField;
    }

    public int getParentmarkFieldIndex() {
        try {
            return Integer.parseInt(this.parentmarkField);
        }
        catch (Exception exception) {
            TableData tableData = this.createTableData(this.getOriginalTableDataName());
            if (tableData == null && this.getCon() != null) {
                tableData = new DBTableData(this.getCon(), this.getQuery());
                if (this.getParameters() != null) {
                    ((DBTableData)tableData).setParameters(this.getParameters());
                }
            }
            if (tableData == null) {
                return -1;
            }
            DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
            return this.getIndexByColumnName(dataModel, this.parentmarkField);
        }
    }

    public void setParentmarkFields(String string) {
        this.parentmarkField = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("markFields".equals(string)) {
                this.markField = xMLableReader.getElementValue();
            }
            if ("parentmarkFields".equals(string)) {
                this.parentmarkField = xMLableReader.getElementValue();
            }
            if ("markFieldsName".equals(string)) {
                this.markFieldName = xMLableReader.getElementValue();
            }
            if ("parentmarkFieldsName".equals(string)) {
                this.parentmarkFieldName = xMLableReader.getElementValue();
            }
            if ("originalTableDataName".equals(string)) {
                this.setOriginalTableDataName(xMLableReader.getElementValue());
            }
            if (("Connection".equals(string) || "Database".equals(string)) && xMLableReader.getAttrAsString("class", null) != null) {
                this.setCon(DataCoreXmlUtils.readXMLConnection(xMLableReader));
            }
            if ("Query".equals(string)) {
                this.setQuery(xMLableReader.getElementValue());
            }
            if ("Parameters".equals(string)) {
                this.setParameters(StableXMLUtils.readParameters(xMLableReader));
            }
            if ("limitGeneration".equals(string)) {
                this.limitGeneration = xMLableReader.getAttrAsInt("value", -1);
            }
            if ("TableDataMap".equals(string)) {
                this.source = new SimpleTableDataSource();
                this.source.readXML(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotEmpty(this.markField)) {
            xMLPrintWriter.startTAG("markFields");
            xMLPrintWriter.textNode(this.markField + "");
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotEmpty(this.parentmarkField)) {
            xMLPrintWriter.startTAG("parentmarkFields");
            xMLPrintWriter.textNode(this.parentmarkField + "");
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotEmpty(this.markFieldName)) {
            xMLPrintWriter.startTAG("markFieldsName");
            xMLPrintWriter.textNode(this.markFieldName);
            xMLPrintWriter.end();
        }
        if (StringUtils.isNotEmpty(this.parentmarkFieldName)) {
            xMLPrintWriter.startTAG("parentmarkFieldsName");
            xMLPrintWriter.textNode(this.parentmarkFieldName);
            xMLPrintWriter.end();
        }
        if (!StringUtils.isEmpty(this.getOriginalTableDataName())) {
            xMLPrintWriter.startTAG("originalTableDataName");
            xMLPrintWriter.textNode(this.getOriginalTableDataName());
            xMLPrintWriter.end();
        }
        if (this.limitGeneration > 0) {
            xMLPrintWriter.startTAG("limitGeneration").attr("value", this.limitGeneration).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof RecursionTableData && ComparatorUtils.equals(((RecursionTableData)object).markField, this.markField) && ComparatorUtils.equals(((RecursionTableData)object).parentmarkField, this.parentmarkField) && ComparatorUtils.equals(((RecursionTableData)object).separator, this.separator) && ComparatorUtils.equals(((RecursionTableData)object).originalTableDataName, this.originalTableDataName) && ((RecursionTableData)object).limitGeneration == this.limitGeneration;
    }

    public void writeXMLWithSource(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter);
        if (this.source != null) {
            new XMLOPTableDataSource(this.source).writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RecursionTableData recursionTableData = (RecursionTableData)super.clone();
        recursionTableData.setMarkFields(this.markField);
        recursionTableData.setParentmarkFields(this.parentmarkField);
        recursionTableData.separator = this.separator;
        recursionTableData.limitGeneration = this.limitGeneration;
        recursionTableData.setCon(this.getCon());
        recursionTableData.setQuery(this.getQuery());
        return recursionTableData;
    }

    public ParameterProvider[] getParameters(Calculator calculator) {
        if (this.source != null && this.source.getTableData(this.originalTableDataName) != null) {
            return this.source.getTableData(this.originalTableDataName).getParameters(calculator);
        }
        return new Parameter[0];
    }

    public void setTableDataSource(TableDataSource tableDataSource) {
        this.source = tableDataSource;
    }

    public String getOriginalTableDataName() {
        return this.originalTableDataName;
    }

    public void setOriginalTableDataName(String string) {
        this.originalTableDataName = string;
    }

    public Connection getCon() {
        return this.con;
    }

    public void setCon(Connection connection) {
        this.con = connection;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public ParameterProvider[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        this.parameters = parameterProviderArray;
    }

    private static class SimpleTableDataSource
    extends AbstractTableDataSource {
        private SimpleTableDataSource() {
        }
    }
}

