/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.BaseScriptUtils;
import com.fr.data.AbstractDict;
import com.fr.data.Dictionary;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.script.CurrentValueNameSpace;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FormulaDictionary
extends AbstractDict {
    public static final String XML_TAG = "FormulaDict";
    public static final String E_XML_TAG = "EFormulaDict";
    private String produceFormula;
    private String excuteFormula;
    private transient List kvs;

    public String getProduceFormula() {
        return this.produceFormula;
    }

    public void setProduceFormula(String string) {
        this.produceFormula = string;
    }

    public String getExcuteFormula() {
        return this.excuteFormula;
    }

    public void setExcuteFormula(String string) {
        this.excuteFormula = string;
    }

    public String[] getDependence(Calculator calculator) {
        Object[] objectArray = new String[]{};
        if (StringUtils.isNotEmpty(this.excuteFormula)) {
            objectArray = BaseScriptUtils.getDependenceByFormula(this.excuteFormula.substring(1));
        }
        Object[] objectArray2 = new String[]{};
        if (StringUtils.isNotEmpty(this.produceFormula)) {
            objectArray2 = BaseScriptUtils.getDependenceByFormula(this.produceFormula.substring(1));
        }
        Object[] objectArray3 = (String[])ArrayUtils.addAll(objectArray, objectArray2);
        return (String[])ArrayUtils.addAll(super.getDependence(calculator), objectArray3);
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public Iterator entrys(Calculator calculator, int n2, int n3) {
        return this.entrys(calculator);
    }

    public Object get(Object object, Calculator calculator) {
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(object);
        calculator.pushNameSpace(currentValueNameSpace);
        this.createKVS(calculator);
        calculator.removeNameSpace(currentValueNameSpace);
        int n2 = this.kvs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i2);
            if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    public void reset() {
        this.kvs = null;
    }

    private void createKVS(Calculator calculator) {
        List list = this.keyProduce(calculator);
        this.kvs = new ArrayList(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = list.get(i2);
            if (n2 > 0) {
                calculator.set("$$$", e2);
            }
            this.kvs.add(new Dictionary.MV(e2, this.valueProduce(e2, calculator)));
        }
        calculator.remove("$$$");
    }

    private List keyProduce(Calculator calculator) {
        if (calculator == null) {
            calculator = Calculator.createCalculator();
        }
        FArray fArray = null;
        Object object = null;
        try {
            if (!StringUtils.isEmpty(this.produceFormula)) {
                object = calculator.evalValue(this.produceFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        fArray = object instanceof FArray ? (FArray)object : new FArray(new Object[]{object});
        return fArray.toList();
    }

    private Object valueProduce(Object object, Calculator calculator) {
        Object object2 = object;
        try {
            if (!StringUtils.isEmpty(this.excuteFormula)) {
                object2 = calculator.evalValue(this.excuteFormula);
            }
        }
        catch (UtilEvalError utilEvalError) {
            FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        return object2;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        exTool.setCreateRelation(true);
        if (StringUtils.isNotEmpty(this.produceFormula)) {
            calculatorProvider.exStatement(columnRow, this.getPureFormulaContent(this.produceFormula));
        }
        if (StringUtils.isNotEmpty(this.excuteFormula)) {
            calculatorProvider.exStatement(columnRow, this.getPureFormulaContent(this.excuteFormula));
        }
        exTool.setCreateRelation(false);
    }

    private String getPureFormulaContent(String string) {
        return string.startsWith("=") ? string.substring(1) : string;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (XML_TAG.equals(xMLableReader.getTagName())) {
                this.setProduceFormula(xMLableReader.getElementValue());
            } else if (E_XML_TAG.equals(xMLableReader.getTagName())) {
                this.setExcuteFormula(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.produceFormula)) {
            xMLPrintWriter.startTAG(XML_TAG).textNode(this.produceFormula).end();
        }
        if (!StringUtils.isEmpty(this.excuteFormula)) {
            xMLPrintWriter.startTAG(E_XML_TAG).textNode(this.excuteFormula).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FormulaDictionary && ComparatorUtils.equals(((FormulaDictionary)object).excuteFormula, this.excuteFormula) && ComparatorUtils.equals(((FormulaDictionary)object).produceFormula, this.produceFormula);
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < FormulaDictionary.this.kvs.size();
        }

        public Object next() {
            Object e2 = FormulaDictionary.this.kvs.get(this.next);
            ++this.next;
            return e2;
        }

        public void remove() {
        }
    }
}

