/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.impl.Node;
import com.fr.data.impl.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Forest {
    private ArrayList trees = new ArrayList();
    private int newAddTreeCount = 0;
    private Map nodeMap = new HashMap();
    private Object[] bufferedRow;

    Forest() {
    }

    void mergeTrees() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.trees);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = this.mergeTree((Tree)arrayList.get(i2));
            if (!bl) continue;
            this.trees.remove(arrayList.get(i2));
            this.removeSame(((Tree)arrayList.get(i2)).getRoot());
        }
    }

    private void removeSame(Node node) {
        List list = this.getNodeList(node);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2) != node) continue;
            list.remove(i2);
            return;
        }
    }

    public void addNewTree(Tree tree) {
        this.trees.add(tree);
        this.putTreeNode(tree);
        ++this.newAddTreeCount;
        if (this.newAddTreeCount > Integer.MAX_VALUE) {
            this.mergeTrees();
            this.newAddTreeCount = 0;
        }
    }

    private void putTreeNode(Tree tree) {
        Node node = tree.getRoot();
        this.putTreeNode(node);
    }

    private void putTreeNode(Node node) {
        this.putNode(node);
        int n2 = node.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.putTreeNode(node.getChild(i2));
        }
    }

    private boolean mergeTree(Tree tree) {
        Node node = tree.getRoot();
        Node node2 = this.findMountNode(tree);
        if (node2 != Node.NULL) {
            node2.addGivedChildren(node);
            return true;
        }
        return false;
    }

    public void addNodePair(Node node, Node node2) {
        boolean bl = this.addToExist(node, node2);
        if (bl) {
            return;
        }
        this.addNewTree(node, node2);
    }

    private void addNewTree(Node node, Node node2) {
        if (Node.isNULL(node2)) {
            return;
        }
        if (Node.isNULL(node)) {
            this.addNewTree(node2);
            return;
        }
        Tree tree = new Tree(node);
        tree.addNode(node, node2);
        this.addNewTree(tree);
    }

    private void putNode(Node node) {
        ArrayList<Node> arrayList = (ArrayList<Node>)this.nodeMap.get(node.getId());
        if (arrayList == null) {
            arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            this.nodeMap.put(node.getId(), arrayList);
        } else {
            arrayList.add(node);
        }
    }

    private boolean addToExist(Node node, Node node2) {
        if (Node.isNULL(node)) {
            return false;
        }
        Node node3 = this.getNode(node);
        if (Node.isNULL(node3)) {
            return false;
        }
        node3.addChild(node2);
        this.putNode(node2);
        return true;
    }

    private void addNewTree(Node node) {
        if (Node.isNULL(node)) {
            return;
        }
        Tree tree = new Tree(node);
        this.addNewTree(tree);
    }

    public int getTreeSize() {
        return this.trees.size();
    }

    int getNodeSize() {
        int n2 = 0;
        int n3 = this.getTreeSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += this.getTree(i2).getSize();
        }
        return n2;
    }

    int getDeep() {
        int n2 = 0;
        int n3 = this.getTreeSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Math.max(n2, this.getTree(i2).getDeep());
        }
        return n2;
    }

    Object[][] toTableArray() {
        return this.toTableArray(this.getNodeSize());
    }

    Object[][] toTableArray(int n2) {
        int n3 = this.getDeep();
        Object[][] objectArray = new Object[n2][n3];
        this.bufferedRow = new Object[n3];
        int n4 = this.getTreeSize();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.putTreeToData(objectArray, this.getTree(i2).getRoot());
        }
        return objectArray;
    }

    String[] createQNodeIdArray(int n2) {
        String[] stringArray = new String[n2];
        int n3 = this.getTreeSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string;
            Node node = this.getTree(i2).getRoot();
            if (!node.hasIdentifyRow()) continue;
            stringArray[node.getRow()] = string = i2 + 1 + "";
            this.putQNodeIdTree(stringArray, node, string);
        }
        return stringArray;
    }

    Node[] getNodeArrayOrderByRow(int n2) {
        Node[] nodeArray = new Node[n2];
        int n3 = this.getTreeSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            Node node = this.getTree(i2).getRoot();
            this.putNodeToArr(nodeArray, node);
        }
        return nodeArray;
    }

    private void putNodeToArr(Node[] nodeArray, Node node) {
        if (node.hasIdentifyRow()) {
            nodeArray[node.getRow()] = node;
        }
        int n2 = node.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.putNodeToArr(nodeArray, node.getChild(i2));
        }
    }

    private void putQNodeIdTree(String[] stringArray, Node node, String string) {
        int n2 = node.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = string + "-" + (i2 + 1);
            Node node2 = node.getChild(i2);
            if (!node2.hasIdentifyRow()) continue;
            stringArray[node2.getRow()] = string2;
            this.putQNodeIdTree(stringArray, node.getChild(i2), string2);
        }
    }

    private void putTreeToData(Object[][] objectArray, Node node) {
        this.putNodeToData(objectArray, node);
        int n2 = node.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.putTreeToData(objectArray, node.getChild(i2));
        }
    }

    private void putNodeToData(Object[][] objectArray, Node node) {
        if (!node.hasIdentifyRow()) {
            return;
        }
        this.putNodePathToBufferedRow(node);
        int n2 = node.getRow();
        this.filledByBufferedRow(objectArray[n2]);
    }

    private void filledByBufferedRow(Object[] objectArray) {
        int n2 = this.getLastNotNullIndex(this.bufferedRow);
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            objectArray[i2] = this.bufferedRow[n2 - i2];
        }
    }

    private int getLastNotNullIndex(Object[] objectArray) {
        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
            if (objectArray[i2] == null) continue;
            return i2;
        }
        return -1;
    }

    private void putNodePathToBufferedRow(Node node) {
        this.reSetBufferedRow();
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            if (!node2.hasIdentifyRow()) {
                this.reSetBufferedRow();
                return;
            }
            this.bufferedRow[n2++] = node2.getId();
        }
    }

    private void reSetBufferedRow() {
        for (int i2 = 0; i2 < this.bufferedRow.length; ++i2) {
            this.bufferedRow[i2] = null;
        }
    }

    public boolean contains(Node node) {
        return this.find(node) != Node.NULL;
    }

    Node find(Node node) {
        return this.find(node, true);
    }

    private Node findMountNode(Tree tree) {
        List list = this.getNodeList(tree.getRoot());
        if (list == null || list.size() < 1) {
            return Node.NULL;
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (tree.containsSame((Node)list.get(i2))) continue;
            return (Node)list.get(i2);
        }
        return Node.NULL;
    }

    private Node findMountNod_bak(Tree tree) {
        int n2 = this.getTreeSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node;
            if (tree == this.getTree(i2) || (node = this.getTree(i2).find(tree.getRoot())) == Node.NULL) continue;
            return node;
        }
        return Node.NULL;
    }

    private Node find(Node node, boolean bl) {
        int n2 = this.getTreeSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = this.getTree(i2).find(node);
            if (!bl && node2 == node || node2 == Node.NULL) continue;
            return node2;
        }
        return Node.NULL;
    }

    private Node getNode(Node node) {
        List list = this.getNodeList(node);
        if (list != null && !list.isEmpty()) {
            return (Node)list.get(0);
        }
        return Node.NULL;
    }

    private List getNodeList(Node node) {
        return (List)this.nodeMap.get(node.getId());
    }

    private Tree getTree(int n2) {
        return (Tree)this.trees.get(n2);
    }
}

