/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.BaseScriptUtils;
import com.fr.base.ParameterHelper;
import com.fr.base.TableData;
import com.fr.base.TemplateUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class DynamicSQLDict
extends FormulaDisplayDictionary {
    private Connection databaseConnection;
    private String sqlFormula;

    public void setDatabaseConnection(Connection connection) {
        this.databaseConnection = connection;
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setSqlFormula(String string) {
        this.sqlFormula = string;
    }

    public String getSqlFormula() {
        return this.sqlFormula;
    }

    protected TableData asTableData(Calculator calculator) {
        return new DBTableData(this.databaseConnection, TemplateUtils.renderTpl(calculator, this.sqlFormula));
    }

    public String[] getDependence(Calculator calculator) {
        return (String[])ArrayUtils.addAll(super.getDependence(calculator), BaseScriptUtils.getDependenceByParameter(ParameterHelper.analyze4Parameters(this.sqlFormula, true)));
    }

    public boolean equlas(Object object) {
        return object instanceof DynamicSQLDict && super.equals(object) && ComparatorUtils.equals(((DynamicSQLDict)object).databaseConnection, this.databaseConnection);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if ("Formula".equals(xMLableReader.getTagName())) {
                this.setSqlFormula(xMLableReader.getElementValue());
            } else if ("Connection".equals(xMLableReader.getTagName())) {
                Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                this.setDatabaseConnection(connection);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.sqlFormula)) {
            xMLPrintWriter.startTAG("Formula").textNode(this.sqlFormula).end();
        }
        if (this.getDatabaseConnection() != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.getDatabaseConnection());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicSQLDict dynamicSQLDict = (DynamicSQLDict)super.clone();
        if (this.databaseConnection != null) {
            dynamicSQLDict.databaseConnection = (Connection)this.databaseConnection.clone();
        }
        if (this.condition != null) {
            dynamicSQLDict.condition = (Condition)this.condition.clone();
        }
        return dynamicSQLDict;
    }
}

