/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class AbstractDatabaseConnection
implements Connection {
    private String originalCharsetName = null;
    private String newCharsetName = null;

    public String getOriginalCharsetName() {
        return this.originalCharsetName;
    }

    public void setOriginalCharsetName(String string) {
        this.originalCharsetName = string;
    }

    public String getNewCharsetName() {
        return this.newCharsetName;
    }

    public void setNewCharsetName(String string) {
        this.newCharsetName = string;
    }

    public boolean isDatabaseConnection() {
        return true;
    }

    public boolean isXMLAConnection() {
        return false;
    }

    public boolean isFineBIConnection() {
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractDatabaseConnection)) {
            return false;
        }
        return ComparatorUtils.equals(this.getOriginalCharsetName(), ((Connection)object).getOriginalCharsetName()) && ComparatorUtils.equals(this.getNewCharsetName(), ((Connection)object).getNewCharsetName());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DatabaseAttr".equals(xMLableReader.getTagName())) {
            this.setOriginalCharsetName(xMLableReader.getAttrAsString("originalCharsetName", null));
            this.setNewCharsetName(xMLableReader.getAttrAsString("newCharsetName", null));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DatabaseAttr");
        if (this.getOriginalCharsetName() != null) {
            xMLPrintWriter.attr("originalCharsetName", this.getOriginalCharsetName());
        }
        if (this.getNewCharsetName() != null) {
            xMLPrintWriter.attr("newCharsetName", this.getNewCharsetName());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

