/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractParameterTableData;
import com.fr.data.Semantic;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.json.JSONTransform;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class ADHOCTableData
extends AbstractParameterTableData
implements JSONTransform {
    private Semantic semantic = null;
    private String description = null;

    public abstract int getType();

    public String getIconClass() {
        return "adhoc_design_list_icon_" + this.getType();
    }

    public ADHOCTableData() {
    }

    public ADHOCTableData(String string, Semantic semantic) {
        this.description = string;
        this.setSemantic(semantic);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Semantic getSemantic() {
        return this.semantic;
    }

    public void setSemantic(Semantic semantic) {
        this.semantic = semantic;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Description".equals(string)) {
                this.setDescription(xMLableReader.getElementValue());
            } else if ("Semantic".equals(string)) {
                this.semantic = new Semantic();
                xMLableReader.readXMLObject(this.semantic);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotEmpty(this.description)) {
            xMLPrintWriter.startTAG("Description").textNode(this.description).end();
        }
        if (this.semantic != null) {
            xMLPrintWriter.startTAG("Semantic");
            this.semantic.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("description")) {
            this.setDescription(jSONObject.getString("description"));
        } else {
            this.setDescription(null);
        }
        if (jSONObject.has("semantic")) {
            Semantic semantic = new Semantic();
            semantic.parseJSON(jSONObject.getJSONObject("semantic"));
            this.setSemantic(semantic);
        } else {
            this.setSemantic(null);
        }
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        if (StringUtils.isNotEmpty(this.description)) {
            jSONObject.put("description", this.getDescription());
        }
        if (this.semantic != null) {
            jSONObject.put("semantic", this.semantic.createJSON());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof ADHOCTableData && ComparatorUtils.equals(this.description, ((ADHOCTableData)object).description) && ComparatorUtils.equals(this.semantic, ((ADHOCTableData)object).semantic);
    }

    public Object clone() throws CloneNotSupportedException {
        ADHOCTableData aDHOCTableData = (ADHOCTableData)super.clone();
        aDHOCTableData.setDescription(this.description);
        if (this.getSemantic() != null) {
            aDHOCTableData.setSemantic((Semantic)this.getSemantic().clone());
        }
        return aDHOCTableData;
    }
}

