/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.Semantic;
import com.fr.data.impl.ADHOCDataModel;
import com.fr.data.impl.ADHOCTableData;
import com.fr.data.impl.DBTableData;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class ADHOCSQLTableData
extends ADHOCTableData {
    public static int TYPE = 1;
    private String dbConnectionName = null;
    private String query = null;

    public int getType() {
        return TYPE;
    }

    public ADHOCSQLTableData() {
    }

    public ADHOCSQLTableData(String string, String string2, String string3, Semantic semantic) {
        this.dbConnectionName = string;
        this.query = string2;
        this.setDescription(string3);
        this.setSemantic(semantic);
    }

    public DataModel createDataModel(Calculator calculator) {
        DatasourceManager datasourceManager = DatasourceManager.getInstance();
        if (StringUtils.isNotEmpty(this.query) && StringUtils.isNotEmpty(this.dbConnectionName)) {
            DBTableData dBTableData = new DBTableData(datasourceManager.getConnection(this.dbConnectionName), this.query);
            return new ADHOCDataModel(dBTableData.createDataModel(calculator), this.getSemantic());
        }
        return DataModel.EMPTY_DATAMODEL;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void setDbConnectionName(String string) {
        this.dbConnectionName = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DBConnectionName".equals(string)) {
                this.setDbConnectionName(xMLableReader.getElementValue());
            } else if ("Query".equals(string)) {
                this.setQuery(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.dbConnectionName)) {
            xMLPrintWriter.startTAG("DBConnectionName").textNode(this.dbConnectionName).end();
        }
        if (StringUtils.isNotEmpty(this.query)) {
            xMLPrintWriter.startTAG("Query").textNode(this.query).end();
        }
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        super.parseJSON(jSONObject);
        if (jSONObject.has("dbConnectionName")) {
            this.setDbConnectionName(jSONObject.getString("dbConnectionName"));
        }
        if (jSONObject.has("query")) {
            this.setQuery(jSONObject.getString("query"));
        }
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        jSONObject.put("type", TYPE);
        if (StringUtils.isNotEmpty(this.dbConnectionName)) {
            jSONObject.put("dbConnectionName", this.getDbConnectionName());
        }
        if (StringUtils.isNotEmpty(this.query)) {
            jSONObject.put("query", this.getQuery());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof ADHOCSQLTableData && ComparatorUtils.equals(this.dbConnectionName, ((ADHOCSQLTableData)object).dbConnectionName) && ComparatorUtils.equals(this.query, ((ADHOCSQLTableData)object).query) && ComparatorUtils.equals(this.getDescription(), ((ADHOCSQLTableData)object).getDescription()) && ComparatorUtils.equals(this.getSemantic(), ((ADHOCSQLTableData)object).getSemantic());
    }

    public Object clone() throws CloneNotSupportedException {
        ADHOCSQLTableData aDHOCSQLTableData = (ADHOCSQLTableData)super.clone();
        aDHOCSQLTableData.setDbConnectionName(this.dbConnectionName);
        aDHOCSQLTableData.setQuery(this.query);
        return aDHOCSQLTableData;
    }
}

