/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DaoMapperUtils;
import com.fr.data.dao.DirectRelationFCMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ForeignKeyFCMapper;
import com.fr.data.dao.JDBCDAOManager;
import com.fr.data.dao.JdbcDaoTemplate;
import com.fr.data.dao.MapFVG;
import com.fr.data.dao.ObjectFVG;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.RelationObject;
import com.fr.data.dao.ResultSetExtractor;
import com.fr.data.dao.SortInfo;
import com.fr.data.dao.UniqueViolationException;
import com.fr.general.FRLogger;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JDBCDAOSession
implements DAOSession {
    private Connection conn = null;
    private JDBCDAOManager manager;
    private JdbcDaoTemplate jdbcDaoTemplate = null;
    private Dialect dialect = null;

    public JDBCDAOSession(JDBCDAOManager jDBCDAOManager) {
        this.manager = jDBCDAOManager;
    }

    public void beginTransaction() throws Exception {
        if (this.conn != null) {
            throw new DAOException("Session already started!");
        }
        this.conn = this.manager.createConnection();
        this.conn.setAutoCommit(false);
    }

    public void commit() throws Exception {
        if (this.conn == null) {
            throw new DAOException("No transaction started!");
        }
        this.conn.commit();
    }

    public void rollback() throws Exception {
        if (this.conn == null) {
            throw new DAOException("No transaction started!");
        }
        this.conn.rollback();
    }

    public void closeTransaction() {
        DBUtils.closeConnection(this.conn);
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        JDBCDAOSession jDBCDAOSession = this;
        synchronized (jDBCDAOSession) {
            super.finalize();
            DBUtils.closeConnection(this.conn);
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect getDialect() {
        if (this.dialect == null) {
            Connection connection = null;
            try {
                connection = this.manager.createConnection();
                Dialect dialect = this.dialect = DialectFactory.generateDialect(connection);
                return dialect;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
            finally {
                if (connection != null) {
                    DBUtils.closeConnection(connection);
                }
            }
            return DialectFactory.getDefaultDialect();
        }
        return this.dialect;
    }

    private JdbcDaoTemplate getJDBCTemplate() throws Exception {
        if (this.jdbcDaoTemplate == null) {
            this.jdbcDaoTemplate = new JdbcDaoTemplate();
        }
        if (this.conn != null) {
            this.jdbcDaoTemplate.setConn(this.conn);
            this.jdbcDaoTemplate.setTransaction(true);
        } else {
            this.jdbcDaoTemplate.setConn(this.manager.createConnection());
            this.jdbcDaoTemplate.setTransaction(false);
        }
        this.jdbcDaoTemplate.setDialect(this.getDialect());
        return this.jdbcDaoTemplate;
    }

    public long save(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        Serializable serializable = null;
        try {
            boolean bl = this.manager.isOracleDatabaseConnection();
            Insert insert = DaoMapperUtils.createInsert(this.manager.getObjectMapper(clazz), new ObjectFVG(object), bl, this);
            serializable = this.getJDBCTemplate().execute(insert, true);
        }
        catch (SQLException sQLException) {
            Dialect dialect = this.getDialect();
            if (dialect.supportsUniqueViolationExceptionCheck()) {
                if (dialect.isUniqueViolationException(sQLException)) {
                    return 0L;
                }
                throw new DAOException(sQLException);
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        if (serializable == null) {
            throw new DAOException("Unknown Error, can not get the identifier!");
        }
        try {
            long l2 = ((Number)serializable).longValue();
            StableUtils.setPrivateFieldValue(object, "id", new Long(l2));
            return l2;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public boolean saveOrUpdate(Object object) throws DAOException {
        long l2 = -1L;
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper != null) {
            try {
                l2 = ((Number)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName())).longValue();
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        if (l2 < 0L) {
            return this.save(object) >= 0L;
        }
        return this.update(object);
    }

    public boolean update(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        try {
            Update update = DaoMapperUtils.createUpdate(object, this.manager.getObjectMapper(clazz), this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public boolean updateRelation(Class clazz, RelationFCMapper relationFCMapper, long l2, Map map) throws DAOException {
        if (l2 < 0L || map == null || map.size() <= 0) {
            return false;
        }
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        Long l3 = new Long(l2);
        HashMap hashMap = new HashMap(map.size());
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            hashMap.put(DAOUtils.getClassNameWithOutPath((Class)entry.getKey()), entry.getValue());
        }
        try {
            Update update = DaoMapperUtils.createUpdate(objectTableMapper, hashMap, fieldColumnMapper, l3, this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public boolean update(Class clazz, long l2, Map map) throws DAOException {
        if (map == null || map.size() <= 0) {
            return false;
        }
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        Long l3 = new Long(l2);
        try {
            Update update = DaoMapperUtils.createUpdate(objectTableMapper, map, fieldColumnMapper, l3, this);
            return this.getJDBCTemplate().executeUpdate(update) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public Object load(final Class clazz, long l2) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        Object object = null;
        Long l3 = new Long(l2);
        try {
            Select select = DaoMapperUtils.createLoadSelect(fieldColumnMapper, l3, objectTableMapper, this);
            object = this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        return DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return object;
    }

    private List __list_by_sql__(final Class clazz, Select select) throws DAOException {
        List list;
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            list = (List)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (resultSet.next()) {
                        arrayList.add(DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return list;
    }

    public List listByFieldsAndSort(Class clazz, String[] stringArray, Object[] objectArray, int[] nArray, String string, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        SortInfo sortInfo = new SortInfo();
        if (string != null) {
            sortInfo.addSortInfo(string, bl);
        }
        if (this.isNullGroup(stringArray, objectArray, nArray)) {
            return this.list(clazz, sortInfo);
        }
        if (!this.isValidGroup(stringArray, objectArray, nArray)) {
            return new ArrayList();
        }
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Select select = DaoMapperUtils.createAllSelect(objectTableMapper, sortInfo);
        Where where = new Where();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(stringArray[i2]);
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), nArray[i2], objectArray[i2]);
        }
        select.setWhere(where);
        return this.__list_by_sql__(clazz, select);
    }

    private boolean isNullGroup(String[] stringArray, Object[] objectArray, int[] nArray) {
        return stringArray == null || objectArray == null || nArray == null;
    }

    private boolean isValidGroup(String[] stringArray, Object[] objectArray, int[] nArray) {
        return stringArray.length == objectArray.length && stringArray.length == nArray.length;
    }

    public List listFieldValue(Class clazz, String string) throws Exception {
        int n2;
        this.manager.assertIsInMapping(clazz);
        if (string == null) {
            return new ArrayList();
        }
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        final FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        int n3 = -1;
        for (n2 = 0; n2 < fieldColumnMapperArray.length; ++n2) {
            if (!string.equalsIgnoreCase(fieldColumnMapperArray[n2].getColumnName())) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return new ArrayList();
        }
        n2 = n3;
        String string2 = "SELECT " + string + " FROM " + this.getDialect().table2SQL(objectTableMapper.getTable());
        return (List)this.getJDBCTemplate().query(string2, new ResultSetExtractor(){

            public Object extractData(ResultSet resultSet) throws Exception {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (resultSet.next()) {
                    Object object = fieldColumnMapperArray[n2].getType() == 12 ? resultSet.getString(fieldColumnMapperArray[n2].getColumnName()) : resultSet.getObject(fieldColumnMapperArray[n2].getColumnName());
                    if ((object = fieldColumnMapperArray[n2].value2Field(object, JDBCDAOSession.this.manager.startSession())) != null) {
                        object = JDBCDAOSession.this.convertDBValueToFieldValue(object, fieldColumnMapperArray[n2].getType());
                    }
                    arrayList.add(object);
                }
                return arrayList;
            }
        });
    }

    public List listByFieldValue(Class clazz, String string, Object object) throws DAOException {
        return this.listByFieldValue(clazz, string, object, 0);
    }

    public List listByFieldValue(Class clazz, String string, Object object, int n2) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Select select = null;
        try {
            select = DaoMapperUtils.createSelectByField(string, object, n2, objectTableMapper, this, false);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return this.__list_by_sql__(clazz, select);
    }

    public List listByFieldValues(Class clazz, Map map) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Select select = null;
        try {
            select = DaoMapperUtils.createSelectAllByMoreInfo(objectTableMapper, map, this);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return this.__list_by_sql__(clazz, select);
    }

    public List listByFieldValues4MVFilter(final Class clazz, Map map) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            String string = DaoMapperUtils.createSelectSQLByListFiledValue(map, objectTableMapper, this.getDialect(), this);
            if (string == null) {
                return new ArrayList(2);
            }
            return (List)this.getJDBCTemplate().query(string, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (resultSet.next()) {
                        arrayList.add(DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public List list(Class clazz) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        return this.__list_by_sql__(clazz, DaoMapperUtils.createAllSelect(objectTableMapper, null));
    }

    public List list(Class clazz, SortInfo sortInfo) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        return this.__list_by_sql__(clazz, DaoMapperUtils.createAllSelect(objectTableMapper, sortInfo));
    }

    public Set listSetByRelationField(Class clazz, Object object, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        if (clazz == null || object == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            return this.listSetByDirectRelationField(clazz, object, (DirectRelationFCMapper)relationFCMapper);
        }
        return this.listSetByIndirectRelationField(clazz, object, relationFCMapper, bl);
    }

    private Set listSetByDirectRelationField(Class clazz, Object object, DirectRelationFCMapper directRelationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        final Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        final ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        Set set = new HashSet();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            return set;
        }
        try {
            Select select = DaoMapperUtils.createSelectByColumn(directRelationFCMapper.getRelatedColumnName(), object, 0, objectTableMapper2, this, false);
            set = (Set)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    while (resultSet.next()) {
                        hashSet.add(DaoMapperUtils.extractResultSet(resultSet, clazz2, objectTableMapper2, JDBCDAOSession.this));
                    }
                    return hashSet;
                }
            });
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return set;
    }

    private Set listSetByIndirectRelationField(Class clazz, Object object, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        int n2 = objectTableMapper2.getFieldColumnMapperCount() - 2;
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            return hashSet;
        }
        try {
            Select select = DaoMapperUtils.createSelectByColumn(DAOUtils.getClassNameWithOutPath(clazz) + "id", object, 0, objectTableMapper2, this, true);
            List list = this.makeIdResult(select, n2);
            if (bl) {
                this.listSetByIndirectRelationFieldToObj(clazz, list, hashSet, n2, objectTableMapper2, relationFCMapper);
            } else {
                FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper2.getFieldColumnMappers();
                ArrayList<Class> arrayList = new ArrayList<Class>(n2);
                for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                    if (fieldColumnMapperArray[i2].isPrimaryKey() || fieldColumnMapperArray[i2].getFieldName().startsWith(DAOUtils.getClassNameWithOutPath(clazz))) continue;
                    arrayList.add(((ForeignKeyFCMapper)fieldColumnMapperArray[i2]).getRelatedClass());
                }
                ClassArrayKey classArrayKey2 = ClassArrayKey.getInstance(relationFCMapper.getIndirectRelatedClass());
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Long[] longArray = (Long[])list.get(i3);
                    DAOBean[] dAOBeanArray = new DAOBean[n2];
                    for (int i4 = 0; i4 < n2; ++i4) {
                        Class clazz2 = (Class)arrayList.get(i4);
                        dAOBeanArray[i4] = (DAOBean)clazz2.newInstance();
                        dAOBeanArray[i4].setId(longArray[i4 + 1]);
                    }
                    RelationObject relationObject = RelationObject.getInstance(longArray[0], classArrayKey2, dAOBeanArray, bl);
                    hashSet.add(relationObject);
                }
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return hashSet;
    }

    private List makeIdResult(Select select, final int n2) throws Exception {
        return (List)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

            public Object extractData(ResultSet resultSet) throws Exception {
                ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
                while (resultSet.next()) {
                    Long[] longArray = new Long[n2 + 1];
                    for (int i2 = 0; i2 < n2 + 1; ++i2) {
                        longArray[i2] = new Long(resultSet.getLong(i2 + 1));
                    }
                    arrayList.add(longArray);
                }
                return arrayList;
            }
        });
    }

    private void listSetByIndirectRelationFieldToObj(Class clazz, List list, Set set, int n2, ObjectTableMapper objectTableMapper, RelationFCMapper relationFCMapper) throws Exception {
        int n3;
        Set[] setArray = new Set[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            setArray[i2] = new HashSet();
        }
        int n4 = list.size();
        for (int i3 = 0; i3 < n4; ++i3) {
            Long[] longArray = (Long[])list.get(i3);
            for (n3 = 0; n3 < n2; ++n3) {
                setArray[n3].add(longArray[n3 + 1]);
            }
        }
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        ArrayList<Class> arrayList = new ArrayList<Class>(n2);
        for (n3 = 0; n3 < fieldColumnMapperArray.length; ++n3) {
            if (fieldColumnMapperArray[n3].isPrimaryKey() || fieldColumnMapperArray[n3].getFieldName().startsWith(DAOUtils.getClassNameWithOutPath(clazz))) continue;
            arrayList.add(((ForeignKeyFCMapper)fieldColumnMapperArray[n3]).getRelatedClass());
        }
        Map[] mapArray = new HashMap[n2];
        this.makeValueMaps(mapArray, n2, setArray, arrayList);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(relationFCMapper.getIndirectRelatedClass());
        int n5 = list.size();
        block4: for (int i4 = 0; i4 < n5; ++i4) {
            Long[] longArray = (Long[])list.get(i4);
            DAOBean[] dAOBeanArray = new DAOBean[n2];
            for (int i5 = 0; i5 < n2; ++i5) {
                dAOBeanArray[i5] = (DAOBean)mapArray[i5].get(longArray[i5 + 1]);
                if (dAOBeanArray[i5] == null) continue block4;
            }
            RelationObject relationObject = RelationObject.getInstance(longArray[0], classArrayKey, dAOBeanArray, true);
            set.add(relationObject);
        }
    }

    private void makeValueMaps(Map[] mapArray, int n2, Set[] setArray, List list) throws Exception {
        for (int i2 = 0; i2 < n2; ++i2) {
            Long[] longArray = setArray[i2].toArray(new Long[setArray[i2].size()]);
            final Class clazz = (Class)list.get(i2);
            this.manager.assertIsInMapping(clazz);
            final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
            HashMap<String, Long[]> hashMap = new HashMap<String, Long[]>(2);
            hashMap.put(objectTableMapper.getPrimaryKey().getFieldName(), longArray);
            String string = DaoMapperUtils.createSelectSQLByListFiledValue(hashMap, objectTableMapper, this.getDialect(), this);
            mapArray[i2] = string != null ? (HashMap)this.getJDBCTemplate().query(string, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
                    while (resultSet.next()) {
                        hashMap.put(new Long(resultSet.getLong(1)), DaoMapperUtils.extractResultSet(resultSet, clazz, objectTableMapper, JDBCDAOSession.this));
                    }
                    return hashMap;
                }
            }) : new HashMap(2);
        }
    }

    public void addRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper) throws DAOException {
        this.addOrRemoveRelation(object, clazz, object2, relationFCMapper, true);
    }

    public List getRelationByMap(Class clazz, RelationFCMapper relationFCMapper, Map map) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        try {
            Select select = DaoMapperUtils.createSelectAllByMoreInfo(objectTableMapper, map, this);
            List list = (List)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    ArrayList<RelationObject> arrayList = new ArrayList<RelationObject>();
                    while (resultSet.next()) {
                        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
                        long l2 = -1L;
                        DAOBean[] dAOBeanArray = new DAOBean[fieldColumnMapperArray.length - 1];
                        int n2 = 0;
                        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                            if (fieldColumnMapperArray[i2].isPrimaryKey()) {
                                l2 = resultSet.getLong(fieldColumnMapperArray[i2].getColumnName());
                                continue;
                            }
                            ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapperArray[i2];
                            DAOBean dAOBean = (DAOBean)foreignKeyFCMapper.getRelatedClass().newInstance();
                            dAOBean.setId(resultSet.getLong(fieldColumnMapperArray[i2].getColumnName()));
                            dAOBeanArray[n2] = dAOBean;
                            ++n2;
                        }
                        RelationObject relationObject = RelationObject.getInstance(dAOBeanArray);
                        relationObject.setId(l2);
                        arrayList.add(relationObject);
                    }
                    return arrayList;
                }
            });
            return list;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public RelationObject getRelation(Class clazz, RelationFCMapper relationFCMapper, long l2) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        final ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + classArrayKey.toString() + "'s Mapping info.");
        }
        try {
            Select select = DaoMapperUtils.createLoadSelect(fieldColumnMapper, new Long(l2), objectTableMapper, this);
            RelationObject relationObject = (RelationObject)this.getJDBCTemplate().executeQuery(select, new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
                        long l2 = -1L;
                        DAOBean[] dAOBeanArray = new DAOBean[fieldColumnMapperArray.length - 1];
                        int n2 = 0;
                        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                            if (fieldColumnMapperArray[i2].isPrimaryKey()) {
                                l2 = resultSet.getLong(fieldColumnMapperArray[i2].getColumnName());
                                continue;
                            }
                            ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapperArray[i2];
                            DAOBean dAOBean = (DAOBean)foreignKeyFCMapper.getRelatedClass().newInstance();
                            dAOBean.setId(resultSet.getLong(fieldColumnMapperArray[i2].getColumnName()));
                            dAOBeanArray[n2] = dAOBean;
                            ++n2;
                        }
                        RelationObject relationObject = RelationObject.getInstance(dAOBeanArray);
                        relationObject.setId(l2);
                        return relationObject;
                    }
                    return null;
                }
            });
            return relationObject;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public boolean removeRelation(Class clazz, RelationFCMapper relationFCMapper, long l2) throws DAOException {
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(classArrayKey);
        boolean bl = false;
        try {
            Delete delete = DaoMapperUtils.createDeleteByPrimaryKey(l2, objectTableMapper);
            bl = this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return bl;
    }

    public void removeRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper) throws DAOException {
        this.addOrRemoveRelation(object, clazz, object2, relationFCMapper, false);
    }

    private void addOrRemoveRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        if (clazz == null || object2 == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            this.addOrRemoveDirectRelation(object, clazz, object2, (DirectRelationFCMapper)relationFCMapper, bl);
        } else {
            this.addOrRemoveIndirectRelation(object, clazz, object2, relationFCMapper, bl);
        }
    }

    private void addOrRemoveDirectRelation(Object object, Class clazz, Object object2, DirectRelationFCMapper directRelationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        try {
            FieldColumnMapper fieldColumnMapper2 = objectTableMapper2.findFCMapperByColumnName(directRelationFCMapper.getRelatedColumnName());
            if (fieldColumnMapper2 == null || !fieldColumnMapper2.isForeignKey()) {
                throw new DAOException("No foreign Key(" + directRelationFCMapper.getRelatedColumnName() + ")in " + clazz2.getName() + "'s Mapping info.");
            }
            if (bl) {
                StableUtils.setPrivateFieldValue(object, fieldColumnMapper2.getFieldName(), object2);
                this.saveOrUpdate(object);
            } else {
                ForeignKeyFCMapper foreignKeyFCMapper = (ForeignKeyFCMapper)fieldColumnMapper2;
                if (foreignKeyFCMapper.isDelCascade() && foreignKeyFCMapper.getCascadeType() == 0) {
                    this.delete(object);
                } else {
                    StableUtils.setPrivateFieldValue(object, fieldColumnMapper2.getFieldName(), new Long(-1L));
                    this.saveOrUpdate(object);
                }
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    private void addOrRemoveIndirectRelation(Object object, Class clazz, Object object2, RelationFCMapper relationFCMapper, boolean bl) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DAOUtils.getClassNameWithOutPath(clazz), object2);
        Object[] objectArray = relationFCMapper.getIndirectRelatedClass();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object3;
                this.manager.assertIsInMapping((Class)objectArray[i2]);
                if (objectArray.length > 1) {
                    object3 = ((RelationObject)object).getValue((Class)objectArray[i2]);
                    if (((RelationObject)object).isToObj()) {
                        object3 = new Long(((DAOBean)object3).getId());
                    }
                } else {
                    this.manager.assertIsInMapping((Class)objectArray[i2]);
                    ObjectTableMapper objectTableMapper3 = this.manager.getObjectMapper((Class)objectArray[i2]);
                    FieldColumnMapper fieldColumnMapper2 = objectTableMapper3.getPrimaryKey();
                    if (fieldColumnMapper2 == null) {
                        throw new DAOException("No Primary Key in " + ((Class)objectArray[i2]).getName() + "'s Mapping info.");
                    }
                    try {
                        object3 = StableUtils.getPrivateFieldValue(object, fieldColumnMapper2.getFieldName());
                    }
                    catch (Exception exception) {
                        throw new DAOException(exception);
                    }
                }
                hashMap.put(DAOUtils.getClassNameWithOutPath((Class)objectArray[i2]), object3);
            }
        } else {
            throw new DAOException("Error Mapping info : Null Related Classes for " + clazz.getName());
        }
        this.doAddOrRemoveIndirectRelation(bl, objectTableMapper2, hashMap, object);
    }

    private void doAddOrRemoveIndirectRelation(boolean bl, ObjectTableMapper objectTableMapper, Map map, Object object) throws DAOException {
        boolean bl2 = this.manager.isOracleDatabaseConnection();
        if (bl) {
            try {
                Insert insert = DaoMapperUtils.createInsert(objectTableMapper, new MapFVG(map), bl2, this);
                Serializable serializable = this.getJDBCTemplate().execute(insert, true);
                if (serializable == null) {
                    throw new DAOException("Unknown Error, can not get the identifier!");
                }
                long l2 = ((Number)serializable).longValue();
                StableUtils.setPrivateFieldValue(object, objectTableMapper.getPrimaryKey().getFieldName(), new Long(l2));
            }
            catch (SQLException sQLException) {
                if (this.dialect.supportsUniqueViolationExceptionCheck()) {
                    if (this.dialect.isUniqueViolationException(sQLException)) {
                        throw new UniqueViolationException(sQLException);
                    }
                    throw new DAOException(sQLException);
                }
                throw new DAOException(sQLException);
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByInfo(objectTableMapper, map, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public boolean deleteByPrimaryKey(Class clazz, long l2) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        boolean bl = false;
        try {
            Delete delete = DaoMapperUtils.createDeleteByPrimaryKey(l2, objectTableMapper);
            bl = this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        return bl;
    }

    public boolean deleteByFields(Class clazz, Map map) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            Delete delete = DaoMapperUtils.createDeleteByInfo(objectTableMapper, map, this);
            return this.getJDBCTemplate().executeDelete(delete) > 0;
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public void delete(Class clazz) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        try {
            Delete delete = DaoMapperUtils.createAllDelete(objectTableMapper);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public void delete(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        long l2 = -1L;
        if (fieldColumnMapper != null) {
            try {
                l2 = ((Number)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName())).longValue();
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        } else {
            throw new DAOException("No Primary Key in " + clazz.getName() + "'s Mapping info.");
        }
        if (l2 < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        try {
            FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
            for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                if (!(fieldColumnMapperArray[i2] instanceof CompatiableIDFCMapper)) continue;
                Object object2 = StableUtils.getPrivateFieldValue(object, fieldColumnMapperArray[i2].getFieldName());
                ((CompatiableIDFCMapper)fieldColumnMapperArray[i2]).delete(object2, this);
            }
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
        this.deleteByPrimaryKey(clazz, l2);
    }

    public void deleteAllRelation(Class clazz, Object object, RelationFCMapper relationFCMapper) throws DAOException {
        if (clazz == null || object == null || relationFCMapper == null) {
            throw new DAOException("Arguments is null!");
        }
        if (relationFCMapper.isDirectRelated()) {
            this.deleteAllDirectRelation(clazz, object, (DirectRelationFCMapper)relationFCMapper);
        } else {
            this.deleteAllIndirectRelation(clazz, object, relationFCMapper);
        }
    }

    private void deleteAllDirectRelation(Class clazz, Object object, DirectRelationFCMapper directRelationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        Class clazz2 = directRelationFCMapper.getRelatedClass();
        this.manager.assertIsInMapping(clazz2);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(clazz2);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No PrimaryKey in " + clazz.getName() + "'s mapping table.");
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByColumn(directRelationFCMapper.getRelatedColumnName(), object, objectTableMapper2, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    private void deleteAllIndirectRelation(Class clazz, Object object, RelationFCMapper relationFCMapper) throws DAOException {
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        ClassArrayKey classArrayKey = ClassArrayKey.getInstance(clazz, relationFCMapper.getIndirectRelatedClass());
        this.manager.assertIsInMapping(classArrayKey);
        ObjectTableMapper objectTableMapper2 = this.manager.getObjectMapper(classArrayKey);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper == null) {
            throw new DAOException("No PrimaryKey in " + clazz.getName() + "'s mapping table.");
        }
        try {
            Delete delete = DaoMapperUtils.createDeleteByField(DAOUtils.getClassNameWithOutPath(clazz), object, objectTableMapper2, this);
            this.getJDBCTemplate().execute(delete);
        }
        catch (Exception exception) {
            throw new DAOException(exception);
        }
    }

    public Long getPrimaryKeyValue(Object object) throws DAOException {
        Class<?> clazz = object.getClass();
        this.manager.assertIsInMapping(clazz);
        ObjectTableMapper objectTableMapper = this.manager.getObjectMapper(clazz);
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        if (fieldColumnMapper != null) {
            try {
                return (Long)StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName());
            }
            catch (Exception exception) {
                throw new DAOException(exception);
            }
        }
        return null;
    }

    public Object convertDBValueToFieldValue(Object object, int n2) {
        Dialect dialect = this.getDialect();
        return dialect.parseValue(object, n2);
    }

    public JDBCDAOManager getManager() {
        return this.manager;
    }
}

