/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.cache.list.IntList;
import com.fr.data.core.db.DBConstants;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Fragment;
import com.fr.data.core.db.dml.SQLUtils;
import com.fr.data.core.db.dml.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Where
implements Fragment {
    private List columnNameList = new ArrayList();
    private IntList columnTypeList = new IntList();
    private IntList compareTypeList = new IntList();
    private List columnValueList = new ArrayList();
    private IntList relationTypeList = new IntList();
    private ArrayList ignoreList = new ArrayList();

    public void addColumn(String string, Object object) {
        this.addColumn(string, 12, 0, object, 0);
    }

    public void addColumn(String string, int n2, int n3, Object object) {
        this.addColumn(string, n2, n3, object, 0);
    }

    public void addColumn(String string, int n2, int n3, Object object, int n4) {
        if (string != null) {
            if (this.getColumnSize() > 0) {
                this.relationTypeList.add(n4);
            }
            this.columnNameList.add(string);
            this.columnTypeList.add(n2);
            this.compareTypeList.add(n3);
            this.columnValueList.add(object);
        }
    }

    public int getColumnSize() {
        return this.columnNameList == null ? 0 : this.columnNameList.size();
    }

    public static boolean validate(Where where) {
        return where != null && where.getColumnSize() > 0;
    }

    public String toStatementSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getColumnSize();
        if (n2 > 0) {
            stringBuffer.append(" WHERE ");
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray;
                if (i2 != 0) {
                    int n3 = this.relationTypeList.get(i2 - 1);
                    stringBuffer.append(n3 == 0 ? " AND " : " OR ");
                }
                stringBuffer.append(dialect.column2SQL4WhereSQL((String)this.columnNameList.get(i2), this.columnTypeList.get(i2)));
                int n4 = this.compareTypeList.get(i2);
                if (DBUtils.isNULL(this.columnValueList.get(i2)) && n4 == 0) {
                    this.ignoreList.add(new Integer(i2));
                    stringArray = new String[]{" is ", "null"};
                } else {
                    stringArray = SQLUtils.getOPAndValueString(n4, "?");
                }
                n4 = this.compareTypeList.get(i2);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append(stringArray[1]);
            }
        }
        return stringBuffer.toString();
    }

    public int applyColumnTypeValue(Dialect dialect, Connection connection, Table table, PreparedStatement preparedStatement, int n2) throws SQLException {
        if (preparedStatement == null || n2 <= 0) {
            return n2;
        }
        int n3 = this.columnNameList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.ignoreList.contains(new Integer(i2))) continue;
            DBUtils.applyColumnTypeValue(dialect, connection, table, (String)this.columnNameList.get(i2), preparedStatement, n2 + i2, this.columnTypeList.get(i2), this.columnValueList.get(i2));
        }
        return n2 + n3;
    }

    public String toNormalSQLString(Dialect dialect) {
        if (dialect == null) {
            dialect = DialectFactory.getDefaultDialect();
        }
        int n2 = this.columnNameList.size();
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append(" WHERE ");
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                String string;
                int n4 = this.columnTypeList.get(i2);
                int n5 = DBUtils.getColumnFRType(n4);
                if (n5 == DBConstants.FR_STREAM || (string = (String)this.columnValueList.get(i2)).indexOf("'") != -1 || string.indexOf("\"") != -1) continue;
                int n6 = n3 = this.relationTypeList.size() > 0 ? this.relationTypeList.get(i2) : 0;
                if (bl) {
                    stringBuffer.append(n3 == 0 ? " AND " : " OR ");
                }
                bl = true;
                int n7 = this.compareTypeList.get(i2);
                String[] stringArray = SQLUtils.getOPAndValueString(n7, string);
                String string2 = stringArray[0];
                string = stringArray[1];
                stringBuffer.append(dialect.column2SQL((String)this.columnNameList.get(i2)));
                stringBuffer.append(string2);
                if (n5 == DBConstants.FR_STRING) {
                    stringBuffer.append('\'');
                    stringBuffer.append(string);
                    stringBuffer.append('\'');
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void clearAllColumn() {
        this.columnNameList.clear();
        this.columnTypeList.clear();
        this.compareTypeList.clear();
        this.columnValueList.clear();
        this.relationTypeList.clear();
    }

    public String toString() {
        return this.toNormalSQLString(null);
    }
}

