/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.UniqueKey;
import com.fr.general.FRLogger;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CreateTable
extends AbstractDML {
    private List columnsList = new ArrayList();
    private String checkFilter = null;
    private List uniqueKeyList = null;
    public static KeySqlGenerator PrimaryKeySqlGenerator = new KeySqlGenerator(){

        public String name() {
            return "PRIMARY KEY";
        }

        public boolean filter(Column column) {
            return column.isPrimaryKey();
        }

        public String extra(CreateTable createTable) {
            return "";
        }
    };

    public CreateTable(Table table, Dialect dialect) {
        super(table, dialect);
    }

    public void addColumn(Column column) {
        this.columnsList.add(column);
    }

    public void clearColumn() {
        this.columnsList.clear();
    }

    public Column getColumn(int n2) {
        return (Column)this.columnsList.get(n2);
    }

    public int getColumnSize() {
        return this.columnsList.size();
    }

    public void addUniqueKey(UniqueKey uniqueKey) {
        if (this.uniqueKeyList == null) {
            this.uniqueKeyList = new ArrayList();
        }
        this.uniqueKeyList.add(uniqueKey);
    }

    public void addColumn(String string, int n2, int n3) {
        this.addColumn(string, n2, n3, false, null, false, false);
    }

    public void addColumn(String string, int n2, int n3, Boolean bl, String string2, Boolean bl2) {
        this.addColumn(string, n2, n3, bl, string2, bl2, false);
    }

    public void addColumn(String string, int n2, int n3, Boolean bl, Object object, Boolean bl2, Boolean bl3) {
        Column column = new Column();
        column.setName(string);
        column.setValueType(n2);
        column.setColumnSize(new ColumnSize(n3));
        column.setAllowNull(bl == false);
        column.setDefaultValue(object);
        column.setPrimaryKey(bl3);
        column.setSelfIncrease(bl2);
        this.addColumn(column);
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        String string = this.toStatementSQLString(this.dialect, connection);
        FRLogger.getLogger().info(string.toString());
        return connection.prepareStatement(string);
    }

    public String toStatementSQLString(Dialect dialect, Connection connection) {
        String string;
        if (this.getTable() == null) {
            return null;
        }
        if (this.columnsList.isEmpty()) {
            return null;
        }
        String string2 = this.getTable().toStatementSQLString(dialect);
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE ");
        stringBuffer.append(string2).append('(');
        int n2 = this.columnsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.getColumn(i2).toSQL(dialect, connection, string2));
            if (i2 >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (!(dialect instanceof SybaseDialect) && StringUtils.isNotBlank(string = this.createKeySQL(PrimaryKeySqlGenerator))) {
            stringBuffer.append(',').append(string);
        }
        if (this.uniqueKeyList != null) {
            if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
                for (UniqueKey uniqueKey : this.uniqueKeyList) {
                    String string3 = uniqueKey.sqlConstraintString(dialect);
                    if (string3 == null) continue;
                    stringBuffer.append(", ").append(string3);
                }
            } else {
                throw new RuntimeException("Can not create unique key!");
            }
        }
        stringBuffer.append(')');
        FRLogger.getLogger().info(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String createKeySQL(KeySqlGenerator keySqlGenerator) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        int n2 = this.getColumnSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!keySqlGenerator.filter(this.getColumn(i2))) continue;
            arrayList.add(this.getColumn(i2));
        }
        if (arrayList.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(keySqlGenerator.name() + " (");
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.dialect.column2SQL(((Column)arrayList.get(n2)).getName()));
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        stringBuffer.append(keySqlGenerator.extra(this));
        return stringBuffer.toString();
    }

    public static interface KeySqlGenerator {
        public boolean filter(Column var1);

        public String name();

        public String extra(CreateTable var1);
    }
}

