/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.DBTimestampTypeHandler;
import com.fr.data.core.db.handler.DialectSQLTypeHandlerFactory;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.InputStream;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends AbstractDialect {
    public static DialectSQLTypeHandlerFactory oracleDialectSQLTypeHandlerFactory = new DialectSQLTypeHandlerFactory();
    private static final int EXPRESSION_PADDING = 100;
    private int oracleFetchSize = 1024;
    private String sequenceName = "";
    private String table = "";
    private String column = "";
    private static Properties sequenceProperties;
    private static boolean isInitSequenceProperties;

    public OracleDialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    @Override
    public int getFetchSize() {
        return this.oracleFetchSize;
    }

    @Override
    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        try {
            this.createOracleSequence(connection, string, string2);
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        return string3;
    }

    private void createOracleSequence(java.sql.Connection connection, String string, String string2) throws SQLException {
        String string3;
        this.sequenceName = string3 = (string.substring(1, string.length() - 1) + "_sequence").toUpperCase();
        this.table = string;
        this.column = string2;
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop sequence " + string3.toUpperCase());
            statement.close();
        }
        catch (Exception exception) {
            statement.close();
        }
        PreparedStatement preparedStatement = connection.prepareStatement("create sequence " + string3 + " start with 1 increment by 1 minvalue 0 maxvalue 999999999999 cycle nocache");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static String getOravleIncCURRValue(String string) {
        String string2;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ((string2 = OracleDialect.getSequenceByTable(string)) != null) {
            return string2 + ".CURRVAL";
        }
        return string + "_SEQUENCE.CURRVAL";
    }

    private static String getSequenceByTable(String string) {
        OracleDialect.initSequenceProperties();
        return sequenceProperties.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSequenceProperties() {
        if (isInitSequenceProperties) {
            return;
        }
        Class<OracleDialect> clazz = OracleDialect.class;
        synchronized (OracleDialect.class) {
            if (isInitSequenceProperties) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sequenceProperties = new Properties();
            try {
                InputStream inputStream = GeneralContext.getEnvProvider().readBean("sequence.properties", "resources");
                if (inputStream != null) {
                    sequenceProperties.load(inputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isInitSequenceProperties = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getIdentitySelectString(String string, String string2, int n2) throws Exception {
        return "select " + OracleDialect.getOravleIncCURRValue(string) + " from dual";
    }

    @Override
    public String column2SQL4WhereSQL(String string, int n2) {
        if (n2 == 1) {
            return "trim(" + this.column2SQL(string) + ")";
        }
        return this.column2SQL(string);
    }

    public void createTrigger(java.sql.Connection connection) {
        if (StringUtils.isBlank(this.sequenceName)) {
            return;
        }
        String string = this.table.substring(1, this.table.length() - 1) + "Trigger";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.column;
        if (this.column.matches("^\".*\"$")) {
            string2 = this.column.substring(1, this.column.length() - 1);
        }
        stringBuffer.append("create or replace trigger ").append(string).append(" before insert on ").append(this.table).append(" for each row begin select ").append(this.sequenceName).append(".nextval into :new.").append(string2).append(" from dual; end;");
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
        }
    }

    @Override
    public String columnType2SQL(int n2, String string) {
        switch (n2) {
            case 16: {
                return "NUMBER(1,0)";
            }
            case -5: {
                return "NUMBER(" + string + ")";
            }
            case 4: {
                return "NUMBER(" + string + ")";
            }
            case -6: {
                return "NUMBER(" + string + ")";
            }
            case 5: {
                return "NUMBER(" + string + ")";
            }
            case 3: {
                return "NUMBER(" + string + ")";
            }
            case 8: {
                return "NUMBER(" + string + ")";
            }
            case 6: {
                return "NUMBER(" + string + ")";
            }
            case 2: {
                return "NUMBER(" + string + ")";
            }
            case 7: {
                return "NUMBER(" + string + ")";
            }
            case -3: {
                return "RAW(" + string + ")";
            }
            case -2: {
                return "RAW(" + string + ")";
            }
            case -4: {
                return "LONG RAW";
            }
            case -1: {
                return "LONG";
            }
            case 12: {
                return "VARCHAR2(" + string + ")";
            }
            case 1: {
                return "CHAR(" + string + ")";
            }
            case 1111: {
                return "NCLOB";
            }
            case -7: {
                return "VARCHAR2(1)";
            }
        }
        return TypeUtils.getTypeName(n2);
    }

    private String getOracleSQL(String string) {
        String string2 = "select owner,table_name from all_tables";
        if (!StringUtils.isBlank(string)) {
            string2 = string2 + " where owner='" + string + "'";
        }
        return string2;
    }

    @Override
    public TableProcedure[] getTableProcedure(java.sql.Connection connection, String string, boolean bl) throws Exception {
        boolean bl2;
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = DataCoreUtils.getOracleCurrentUserSchema(connection);
        boolean bl3 = bl2 = !bl && !ComparatorUtils.equals(string2, string);
        if (bl2) {
            return new TableProcedure[0];
        }
        String string3 = this.getOracleSQL(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(new TableProcedure(resultSet.getString("owner"), resultSet.getString("table_name"), "TABLE", this));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    @Override
    public TableProcedure[] getProcedureList(java.sql.Connection connection, ResultSet resultSet, String string, String string2) {
        String string3 = DataCoreUtils.getOracleCurrentUserSchema(connection);
        if (!ComparatorUtils.equals(string3, string2)) {
            return new TableProcedure[0];
        }
        return this.getUserStoreProcedure(connection, string2);
    }

    private TableProcedure[] getUserStoreProcedure(java.sql.Connection connection, String string) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = "select distinct name, type from user_source where type in ('PACKAGE','PROCEDURE')";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("name");
                String string4 = resultSet.getString("type");
                if (ComparatorUtils.equals("PACKAGE", string4)) {
                    this.dealPackageStoreProcedure(arrayList, connection.getMetaData(), string, string3);
                    continue;
                }
                arrayList.add(new TableProcedure(string, string3, "PROCEDURE", this));
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    private void dealPackageStoreProcedure(List<TableProcedure> list, DatabaseMetaData databaseMetaData, String string, String string2) {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getProcedures(string2, string, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n2 = string3.lastIndexOf(";");
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                String string4 = resultSet.getString(1);
                string3 = string4 + "." + string3;
                list.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE", this));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public String getLimitString(String string, int n2, int n3) {
        string = string.trim();
        boolean bl = false;
        String string2 = " for update";
        if (string.toLowerCase().endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        stringBuffer.append(string);
        stringBuffer.append(" ) row_ where rownum <= " + (n2 + n3) + ") where rownum_ > " + n2);
        if (bl) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    @Override
    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
    }

    @Override
    public String defaultValidationQuery(java.sql.Connection connection) {
        return "select 1 from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        StoreProcedureParameter[] storeProcedureParameterArray;
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String string3 = this.getProcedureParametersSql(string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            int n2 = 0;
            while (resultSet.next()) {
                ++n2;
                storeProcedureParameterArray = resultSet.getString("argument_name");
                String string4 = resultSet.getString("Data_type");
                String string5 = resultSet.getString("in_out");
                String string6 = resultSet.getString("pls_type");
                string4 = string4 == null ? "" : string4;
                int n3 = string4.toUpperCase().indexOf("CURSOR") > -1 ? -10 : this.sql2ColumnTypeForProcedure(string6);
                StoreProcedureParameter storeProcedureParameter = string4.toUpperCase().indexOf("VARCHAR") != -1 && StringUtils.isNotEmpty(string2) ? new StoreProcedureParameter((String)(storeProcedureParameterArray == null ? "storeParameter" + n2 : storeProcedureParameterArray), string2, this.sql2ParameterType(string5), n3) : new StoreProcedureParameter((String)(storeProcedureParameterArray == null ? "storeParameter" + n2 : storeProcedureParameterArray), this.sql2ParameterType(string5), n3);
                arrayList.add(storeProcedureParameter);
            }
            storeProcedureParameterArray = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            StoreProcedureParameter[] storeProcedureParameterArray2;
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                storeProcedureParameterArray2 = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return storeProcedureParameterArray2;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return storeProcedureParameterArray;
    }

    @Override
    public SQLTypeHandlerFactory buildSQLTypeHandlerFactory() {
        return oracleDialectSQLTypeHandlerFactory;
    }

    @Override
    public String getProcedureParametersSql(String string) {
        return "select argument_name, Data_type, in_out, pls_type from sys.user_arguments WHERE OBJECT_NAME='" + string + "' order by position";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block4: {
            String string4;
            statement = null;
            resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select comments as table_comment from user_tab_comments" + OracleDialect.getDBLinkValue(string3) + " where table_name = '" + string + "'");
                if (!resultSet.next()) break block4;
                string4 = resultSet.getString("table_comment");
            }
            catch (SQLException sQLException) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    throw throwable;
                }
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string4;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "";
    }

    public static String getDBLinkValue(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        return "@" + string;
    }

    private String getTableInfoString(String string, String string2, String string3) {
        Table table = new Table(string, string2);
        return "select * from " + this.table2SQL(table) + OracleDialect.getDBLinkValue(string3) + " where 1=2";
    }

    private static String getTablePrimayKeyString(String string, String string2, String string3) {
        return "select col.column_name from all_constraints" + OracleDialect.getDBLinkValue(string3) + " con, all_cons_columns" + OracleDialect.getDBLinkValue(string3) + " col where con.constraint_name = col.constraint_name  " + "and col.owner = '" + string + "' " + "and con.constraint_type='P' " + "and col.table_name= '" + string2 + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDBLinkTableFieldsInfo(java.sql.Connection connection, String string, String string2, String string3) {
        block7: {
            ArrayList arrayList;
            Statement statement = null;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                statement = connection.createStatement();
                HashSet<String> hashSet = new HashSet<String>();
                resultSet = statement.executeQuery(OracleDialect.getTablePrimayKeyString(string2, string, string3));
                while (resultSet.next()) {
                    hashSet.add(resultSet.getString("COLUMN_NAME"));
                }
                resultSet2 = statement.executeQuery(this.getTableInfoString(string2, string, string3));
                ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                ArrayList arrayList2 = new ArrayList();
                for (int i2 = 0; i2 < n2; ++i2) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String string4 = resultSetMetaData.getColumnLabel(i2 + 1);
                    hashMap.put("column_name", string4);
                    hashMap.put("column_type", new Integer(resultSetMetaData.getColumnType(i2 + 1)));
                    hashMap.put("column_size", new Integer(resultSetMetaData.getColumnDisplaySize(i2 + 1)));
                    hashMap.put("column_key", hashSet.contains(string4));
                    arrayList2.add(hashMap);
                    resultSetMetaData.getScale(i2 + 1);
                }
                arrayList = arrayList2;
                DBUtils.closeResultSet(resultSet);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                break block7;
            }
            finally {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeResultSet(resultSet2);
                DBUtils.closeStatement(statement);
            }
            DBUtils.closeResultSet(resultSet2);
            DBUtils.closeStatement(statement);
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getTableFieldsInfor(java.sql.Connection connection, String string, String string2, String string3) {
        List list;
        block7: {
            list = null;
            list = StringUtils.isBlank(string3) ? super.getTableFieldsInfor(connection, string, string2, string3) : this.getDBLinkTableFieldsInfo(connection, string, string2, string3);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select column_name, comments as column_comment from all_col_comments" + OracleDialect.getDBLinkValue(string3) + " where OWNER = '" + string2 + "' and table_name ='" + string + "'");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
                }
                for (Map map : list) {
                    String string4 = (String)map.get("column_name");
                    if (!hashMap.containsKey(string4)) continue;
                    map.put("column_comment", hashMap.get(string4));
                }
                DBUtils.closeResultSet(resultSet);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                break block7;
            }
            finally {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
            }
            DBUtils.closeStatement(statement);
        }
        return list;
    }

    @Override
    protected String getProcedureSql(String string) {
        return "SELECT * FROM SYS.user_source WHERE NAME = '" + string + "' AND TYPE = 'PROCEDURE' ORDER BY NAME, LINE";
    }

    protected String getProcedureSql(String string, String string2) {
        return "SELECT * FROM SYS.user_source WHERE NAME = '" + string + "' AND TYPE = 'PACKAGE BODY' ORDER BY LINE";
    }

    @Override
    protected String getValueName() {
        return "TEXT";
    }

    @Override
    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l2) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = StringUtils.join(",", stringArray);
        String string5 = "select " + string4 + " from ( SELECT ROWNUM no, " + string4 + " FROM " + this.table2SQL(table) + OracleDialect.getDBLinkValue(string3) + " ) where no >" + l2;
        statement.setFetchSize(2000);
        return statement.executeQuery(this.dealWithSqlCharSet(string5, connection));
    }

    @Override
    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1003, 1007);
    }

    @Override
    public String createLimitSQL(String string, String[] stringArray, long l2) {
        String string2 = StringUtils.join(",", stringArray);
        return "select " + string2 + " from (select ROWNUM no," + string2 + " from (" + string + ") t) where no >" + l2;
    }

    @Override
    public String getSpecificRowSql(String string, int n2) {
        return "select * from (select t.*, rownum rk from(" + string + ") t) where rk = " + n2;
    }

    @Override
    public String getRowRangeSql(String string, int n2, int n3, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (select t.*, rownum raak from(" + string + ") t) where raak > " + n2 + " and raak < " + (n3 + 1);
        return string2;
    }

    @Override
    public String getTopNRowSql(int n2, Table table) {
        return "select * from " + this.table2SQL(table) + " where rownum <= " + n2;
    }

    static {
        isInitSequenceProperties = false;
        oracleDialectSQLTypeHandlerFactory.register(91, new DBTimestampTypeHandler());
    }
}

