/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MSSQLDialect
extends AbstractDialect {
    private static int QUERY_STRING_LENGTH = 16;
    private String defaultAutoIncrease = "identity(1,1)";

    public MSSQLDialect() {
        this.left_quote = "[";
        this.right_quote = "]";
    }

    public String createSequence(Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(this.defaultAutoIncrease).toString();
    }

    protected String getIdentitySelectString() throws Exception {
        return "select @@identity";
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String string, int n2, int n3) {
        if (n2 > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(string.length() + QUERY_STRING_LENGTH).append(string).insert(MSSQLDialect.getAfterSelectInsertPoint(string), " top " + n3).toString();
    }

    static int getAfterSelectInsertPoint(String string) {
        String string2 = "select";
        String string3 = "select distinct";
        int n2 = string.toLowerCase().indexOf(string2);
        int n3 = string.toLowerCase().indexOf(string3);
        return n2 + (n3 == n2 ? string2.length() : string3.length());
    }

    public String defaultValidationQuery(Connection connection) {
        return "select 1";
    }

    public String getCountSql(String string) {
        return string == null ? null : "SELECT COUNT(*) AS totalRowCount FROM (" + string + ") t";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(Connection connection, String string, String string2) {
        StoreProcedureParameter[] storeProcedureParameterArray;
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String string3 = this.getProcedureParametersSql(string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            int n2 = 1;
            while (resultSet.next()) {
                storeProcedureParameterArray = resultSet.getString("parameter");
                String string4 = resultSet.getString("type");
                boolean bl = resultSet.getBoolean("inOut");
                string4 = string4 == null ? "" : string4;
                int n3 = string4.toUpperCase().indexOf("CURSOR") > -1 ? -10 : this.sql2ColumnTypeForProcedure(string4);
                int n4 = bl ? 0x7FFFFFFC : 0x7FFFFFFE;
                StoreProcedureParameter storeProcedureParameter = string4.toUpperCase().indexOf("VARCHAR") != -1 && StringUtils.isNotEmpty(string2) ? new StoreProcedureParameter(storeProcedureParameterArray == null ? "storeParameter" + n2 : (storeProcedureParameterArray.length() > 1 ? storeProcedureParameterArray.substring(1) : "storeParameter" + n2), string2, n4, n3) : new StoreProcedureParameter(storeProcedureParameterArray == null ? "storeParameter" + n2 : (storeProcedureParameterArray.length() > 1 ? storeProcedureParameterArray.substring(1) : "storeParameter" + n2), n4, n3);
                arrayList.add(storeProcedureParameter);
                ++n2;
            }
            storeProcedureParameterArray = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            StoreProcedureParameter[] storeProcedureParameterArray2;
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                storeProcedureParameterArray2 = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return storeProcedureParameterArray2;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return storeProcedureParameterArray;
    }

    public String getProcedureParametersSql(String string) {
        return "select a.name AS parameter, c.name AS type ,a.isoutparam AS inOut  from   syscolumns  a,sysobjects  b,systypes  c  where  a.id=b.id  and  LOWER(b.xtype)= 'p' and b.name='" + string + "' and  a.xusertype=c.xusertype ORDER BY  a.colorder";
    }

    protected String getProcedureSql(String string) {
        return "sp_helptext '" + string + "'";
    }

    protected String getValueName() {
        return "Text";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTableCommentName(Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block7: {
            String string4;
            block6: {
                statement = null;
                resultSet = null;
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(this.getTableCommentExpression(connection, string, string2));
                    if (resultSet.next()) {
                        string4 = resultSet.getString("table_comment");
                        DBUtils.closeResultSet(resultSet);
                        break block6;
                    }
                    DBUtils.closeResultSet(resultSet);
                    break block7;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().log(Level.WARNING, sQLException.getMessage());
                    return "";
                }
            }
            DBUtils.closeStatement(statement);
            return string4;
        }
        DBUtils.closeStatement(statement);
        return "";
        finally {
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableFieldsInfor(Connection connection, String string, String string2, String string3) {
        List list;
        block7: {
            list = super.getTableFieldsInfor(connection, string, string2, string3);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(this.getFieldsInforExpression(connection.getCatalog(), string, string2));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
                }
                for (Map map : list) {
                    String string4 = (String)map.get("column_name");
                    if (!hashMap.containsKey(string4)) continue;
                    map.put("column_comment", hashMap.get(string4));
                }
                DBUtils.closeResultSet(resultSet);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().log(Level.WARNING, sQLException.getMessage());
                break block7;
            }
            finally {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
            }
            DBUtils.closeStatement(statement);
        }
        return list;
    }

    protected String getTableCommentExpression(Connection connection, String string, String string2) {
        return "select CAST(f.value AS nvarchar) table_comment from (select name,id from " + string2 + ".sysobjects s where s.xtype='U' and s.name='" + string + "') O Left join sys.extended_properties F on O.id=F.major_id and F.minor_id= 0";
    }

    protected String getFieldsInforExpression(String string, String string2, String string3) {
        return "select sys.columns.name as column_name, CAST((select value from sys.extended_properties where sys.extended_properties.major_id = sys.columns.object_id and sys.extended_properties.minor_id = sys.columns.column_id) AS nvarchar) as column_comment from sys.columns where sys.columns.object_id = object_id('" + string2 + " ')";
    }

    public String getSpecificRowSql(String string, int n2) {
        return "select * from (select t.*, row_number() rk from(" + string + ") t) where rk = " + n2;
    }

    public String getRowRangeSql(String string, int n2, int n3, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (select t.*, row_number() raak from(" + string + ") t) where raak > " + n2 + " and raak < " + (n3 + 1);
        return string2;
    }
}

