/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.DefaultSQLTypeHandlerFactory;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.transaction.NotSupportedException;

public class AbstractDialect
implements Dialect,
Serializable {
    private static int fetchSize = -1;
    protected String left_quote = null;
    protected String right_quote = null;

    public int getFetchSize() {
        return fetchSize;
    }

    public String column2SQL(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return string;
        }
        return this.left_quote + string.trim() + this.right_quote;
    }

    public String column2SQL4WhereSQL(String string, int n2) {
        return this.column2SQL(string);
    }

    public String columnType2SQL(int n2, String string) {
        return TypeUtils.getTypeName(n2);
    }

    public String table2SQL(Table table) {
        if (table == null) {
            return "";
        }
        if (StringUtils.isBlank(this.left_quote) || StringUtils.isBlank(this.right_quote)) {
            return table.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = table.getSchema();
        if (!StringUtils.isBlank(string)) {
            stringBuffer.append(string).append('.');
        }
        stringBuffer.append(this.column2SQL(table.getName()));
        return stringBuffer.toString();
    }

    public String[] getSchemas(java.sql.Connection connection) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringUtils.isBlank(databaseMetaData.getSchemaTerm())) {
            ResultSet resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1).trim());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public TableProcedure[] getTableProcedure(java.sql.Connection connection, String string, boolean bl) throws Exception {
        if (connection == null) {
            throw new Exception("Cannot connect to database!");
        }
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = null;
        if (string != null) {
            string2 = connection.getCatalog();
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        catch (SQLException sQLException) {
            resultSet = databaseMetaData.getTables(string2, string, "%", stringArray);
        }
        while (resultSet.next()) {
            arrayList.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), this));
        }
        resultSet.close();
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    public TableProcedure[] getProcedureList(java.sql.Connection connection, ResultSet resultSet, String string, String string2) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getProcedures(string, string2, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n2 = string3.lastIndexOf(";");
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                arrayList.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE", this));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public boolean supportsUniqueViolationExceptionCheck() {
        return false;
    }

    public boolean isUniqueViolationException(SQLException sQLException) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStoreProcedureText(java.sql.Connection connection, String string) {
        String[] stringArray = string.split("\\.");
        String string2 = "";
        boolean bl = stringArray.length == 3 && this instanceof OracleDialect;
        string2 = bl ? ((OracleDialect)this).getProcedureSql(stringArray[stringArray.length - 2], stringArray[stringArray.length - 1]) : this.getProcedureSql(stringArray[stringArray.length - 1]);
        if (StringUtils.isEmpty(string2)) {
            return " Not Support Yet";
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string4 = resultSet.getString(this.getValueName());
                string3 = string3 + string4;
            }
            if (StringUtils.isEmpty(string3)) {
                string3 = "ERROR FETCHING...";
            }
        }
        catch (SQLException sQLException) {
            String string5;
            try {
                string5 = "ERROR FETCHING...";
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string5;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        if (bl) {
            int n2 = string3.toLowerCase().indexOf(("PROCEDURE " + stringArray[stringArray.length - 1]).toLowerCase());
            int n3 = string3.toLowerCase().indexOf(("END " + stringArray[stringArray.length - 1]).toLowerCase());
            string3 = string3.substring(n2, n3 + 3) + ";";
        } else {
            string3 = this.dealWithShowText(stringArray[stringArray.length - 1], string3);
        }
        return string3;
    }

    public String dealWithShowText(String string, String string2) {
        return string2;
    }

    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        return string3;
    }

    public String getIdentitySelectString(String string, String string2, int n2) throws Exception {
        return this.getIdentitySelectString();
    }

    public void setAutoCommit(java.sql.Connection connection, boolean bl) throws SQLException {
        connection.setAutoCommit(bl);
    }

    public String getLimitString(String string, int n2, int n3) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String getCountSql(String string) {
        return string == null ? null : "SELECT COUNT(*) AS rowcount FROM (" + string + ") t";
    }

    public boolean isYearData(java.sql.Connection connection, int n2, Table table, String string) {
        return false;
    }

    public String quartzDelegateClass() {
        return "com.fr.third.org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String defaultValidationQuery(java.sql.Connection connection) {
        block22: {
            Object object;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                object = databaseMetaData.getTableTypes();
                while (object.next()) {
                    if (!"TABLE".equals(object.getString("TABLE_TYPE"))) continue;
                    ResultSet resultSet = databaseMetaData.getTables(null, null, "%", new String[]{"TABLE"});
                    while (true) {
                        if (resultSet.next()) {
                            String string = resultSet.getString("TABLE_NAME");
                            if (!StringUtils.isNotBlank(string)) continue;
                            String string2 = resultSet.getString("TABLE_SCHEM");
                            if (StringUtils.isNotBlank(string2)) {
                                string = string2 + "." + string;
                            }
                            String string3 = "select count(*) from " + string + " where 1 = 2";
                            FRLogger.getLogger().info("try ValidationQuery:" + string3);
                            String string4 = string3;
                            return string4;
                        }
                        break block22;
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                object = "";
                return object;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return "";
    }

    public boolean isSupportFetchText() {
        return !StringUtils.isEmpty(this.getProcedureSql("abc`bca"));
    }

    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getTableFieldsInfor(java.sql.Connection connection, String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(connection.getCatalog(), string2, string);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet2 = databaseMetaData.getColumns(connection.getCatalog(), string2, string, null);
            while (resultSet2.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String string4 = resultSet2.getString("COLUMN_NAME");
                String string5 = resultSet2.getString("REMARKS");
                if (StringUtils.isEmpty(string5)) {
                    string5 = null;
                }
                hashMap.put("column_name", resultSet2.getString("COLUMN_NAME"));
                hashMap.put("column_comment", string5);
                hashMap.put("column_type", new Integer(resultSet2.getInt("DATA_TYPE")));
                hashMap.put("column_size", new Integer(resultSet2.getInt("COLUMN_SIZE")));
                hashMap.put("column_key", hashSet.contains(resultSet2.getString("COLUMN_NAME")));
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeResultSet(resultSet2);
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeResultSet(resultSet2);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeResultSet(resultSet2);
        return arrayList;
    }

    public Object parseValue(Object object, int n2) {
        if (object instanceof BigDecimal && (n2 == -5 || n2 == 4)) {
            object = new Long(((BigDecimal)object).longValue());
        }
        return this.parseOtherValue(object, n2);
    }

    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        return new StoreProcedureParameter[0];
    }

    public SQLTypeHandlerFactory buildSQLTypeHandlerFactory() {
        return DefaultSQLTypeHandlerFactory.getInstance();
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String buildForeignKeyString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30).append(" add constraint ").append(string).append(this.foreignKeyString(stringArray, string2, stringArray2, bl));
        return stringBuffer.toString();
    }

    protected String foreignKeyString(String[] stringArray, String string, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer().append(" foreign key (").append(StringUtils.join(", ", stringArray)).append(") references ").append(string);
        if (!bl) {
            stringBuffer.append(" (").append(StringUtils.join(", ", stringArray2)).append(')');
        }
        return stringBuffer.toString();
    }

    protected int sql2ColumnTypeForProcedure(String string) {
        if (string == null) {
            return 12;
        }
        if (string.toUpperCase().indexOf("CHAR") > -1 || string.toUpperCase().indexOf("BIT") > -1) {
            return 12;
        }
        if (string.toUpperCase().indexOf("INT") > -1) {
            return 4;
        }
        if (this.isDecimalType(string)) {
            return 3;
        }
        if (string.toUpperCase().indexOf("DATE") > -1) {
            return 91;
        }
        if (string.toUpperCase().indexOf("BOOLEAN") > -1) {
            return 16;
        }
        return 12;
    }

    protected String getIdentitySelectString() throws Exception {
        throw new Exception("Dialect does not support identity key generation");
    }

    protected int sql2ParameterType(String string) {
        if (ComparatorUtils.equals(string.toUpperCase(), "OUT")) {
            return 0x7FFFFFFD;
        }
        if (ComparatorUtils.equals(string.toUpperCase(), "IN")) {
            return 0x7FFFFFFE;
        }
        if (ComparatorUtils.equals(string.toUpperCase(), "IN/OUT")) {
            return 0x7FFFFFFC;
        }
        return 0x7FFFFFFE;
    }

    protected List parameterToList(String[] stringArray) {
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].trim();
            String[] stringArray2 = string.split(" ");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                if (ComparatorUtils.equals(stringArray2[i3], "")) continue;
                arrayList2.add(stringArray2[i3].trim());
            }
            if (arrayList2.size() == 2) {
                StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter((String)arrayList2.get(0), 0x7FFFFFFE, this.sql2ColumnTypeForProcedure((String)arrayList2.get(1)));
                arrayList.add(storeProcedureParameter);
                continue;
            }
            if (arrayList2.size() < 2) continue;
            StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter((String)arrayList2.get(1), this.sql2ParameterType((String)arrayList2.get(0)), this.sql2ColumnTypeForProcedure((String)arrayList2.get(2)));
            arrayList.add(storeProcedureParameter);
        }
        return arrayList;
    }

    protected String getValueName() {
        return "";
    }

    protected String getProcedureSql(String string) {
        return "";
    }

    protected String getProcedureParametersSql(String string) {
        return "";
    }

    protected Object parseOtherValue(Object object, int n2) {
        return object;
    }

    private boolean isDecimalType(String string) {
        return string.toUpperCase().indexOf("DECIMAL") > -1 || string.toUpperCase().indexOf("NUMERIC") > -1 || string.toUpperCase().indexOf("DOUBLE") > -1 || string.toUpperCase().indexOf("FLOAT") > -1 || string.toUpperCase().indexOf("NUMBER") > -1;
    }

    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l2) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = "select * from " + this.table2SQL(table);
        ResultSet resultSet = statement.executeQuery(this.dealWithSqlCharSet(string4, connection));
        resultSet.absolute((int)l2);
        return resultSet;
    }

    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1005, 1007);
    }

    protected String dealWithSqlCharSet(String string, Connection connection) {
        if (StringUtils.isNotBlank(connection.getOriginalCharsetName()) && StringUtils.isNotBlank(connection.getNewCharsetName())) {
            try {
                return new String(string.getBytes(connection.getNewCharsetName()), connection.getOriginalCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return string;
    }

    public String createLimitSQL(String string, String[] stringArray, long l2) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public String getSpecificRowSql(String string, int n2) {
        return string;
    }

    public String getRowRangeSql(String string, int n2, int n3, String[] stringArray) {
        return string;
    }

    public String getTopNRowSql(int n2, Table table) {
        return "select top " + n2 + " * from " + this.table2SQL(table);
    }

    public boolean isSupportQueryWhileInsert(int n2) {
        return n2 > 0;
    }
}

