/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.TemplateUtils;
import com.fr.data.DefaultRequestParameterHandler;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.core.db.handler.BlobDelegate;
import com.fr.data.core.db.handler.ClobDelegate;
import com.fr.file.ExtraClassManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.ManagerFactory;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.RequestParameterHandler;
import com.fr.stable.xml.FRFile;
import com.fr.third.JAI.ByteArraySeekableStream;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataUtils {
    private static final int BYTE_LENGTH = 10;
    private static final double MAX_WORD_FILE = 5000000.0;

    private DataUtils() {
    }

    public static String clob2String(Clob clob) {
        if (clob == null) {
            return "";
        }
        try {
            return DataUtils.reader2String(clob.getCharacterStream());
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            return "";
        }
    }

    public static String reader2String(Reader reader) {
        if (reader == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            GeneralUtils.copyCharTo(reader, stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            reader.close();
            stringWriter.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            try {
                reader.close();
            }
            catch (IOException iOException2) {
                FRLogger.getLogger().error(iOException2.getMessage(), iOException2);
            }
            try {
                stringWriter.close();
            }
            catch (IOException iOException3) {
                FRLogger.getLogger().error(iOException3.getMessage(), iOException3);
            }
            return "";
        }
    }

    public static Object resolveOtherValue(Object object, boolean bl, boolean bl2, Object object2, boolean bl3) {
        block6: {
            String string;
            block11: {
                BinaryObject binaryObject;
                block12: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        String string2 = string = object2 == null ? null : object2.toString();
                                        if (!(object instanceof FRFile)) break block5;
                                        FRFile fRFile = (FRFile)object;
                                        if ("image".equals(fRFile.getType())) {
                                            try {
                                                object = ImageIO.read(new ByteArrayInputStream(fRFile.getBytes()));
                                            }
                                            catch (IOException iOException) {
                                                FRLogger.getLogger().error(iOException.getMessage(), iOException);
                                                return "";
                                            }
                                        }
                                        break block6;
                                    }
                                    if (!(object instanceof Clob)) break block7;
                                    object = DataUtils.clob2Object((Clob)object, bl2, string, bl3);
                                    break block6;
                                }
                                if (!(object instanceof ClobDelegate)) break block8;
                                object = DataUtils.clobDelegate2Object((ClobDelegate)object, bl2, string, bl3);
                                break block6;
                            }
                            if (!(object instanceof Blob)) break block9;
                            object = DataUtils.blob2Object((Blob)object, bl, bl2, string, bl3);
                            break block6;
                        }
                        if (!(object instanceof BlobDelegate)) break block10;
                        object = DataUtils.blobDelegate2Object((BlobDelegate)object, bl, bl2, string, bl3);
                        break block6;
                    }
                    if (!(object instanceof BinaryObject)) break block11;
                    binaryObject = (BinaryObject)object;
                    if (!bl) break block12;
                    object = binaryObject.getImage();
                    break block6;
                }
                Image image = null;
                if (!((double)binaryObject.getBytes().length < 5000000.0) && (image = binaryObject.getImage()) == null) break block6;
                object = image == null ? binaryObject.getValue(bl2, string) : image;
                break block6;
            }
            if (object instanceof FArray && bl2) {
                boolean bl4 = object2 instanceof FArray && ((FArray)object2).length() >= ((FArray)object).length();
                for (int i2 = 0; i2 < ((FArray)object).length(); ++i2) {
                    Object object3;
                    Object object4 = ((FArray)object).elementAt(i2);
                    if (object4 == (object3 = DataUtils.resolveOtherValue(object4, bl, bl2, bl4 ? ((FArray)object2).elementAt(i2) : string, bl3))) continue;
                    ((FArray)object).setElement(i2, object3);
                }
            }
        }
        return object;
    }

    private static Object clob2Object(Clob clob, boolean bl, String string, boolean bl2) {
        if (bl) {
            return DataUtils.bytes2Object(DataUtils.clob2String(clob).getBytes(), true, string, bl2);
        }
        return DataUtils.clob2String(clob);
    }

    private static Object clobDelegate2Object(ClobDelegate clobDelegate, boolean bl, String string, boolean bl2) {
        Clob clob = clobDelegate.getClob();
        if (bl) {
            return DataUtils.bytes2Object(DataUtils.clob2String(clob).getBytes(), true, string, bl2);
        }
        if (clob == null) {
            return "";
        }
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
        }
        catch (Exception exception) {
            return clobDelegate.getReader();
        }
        return DataUtils.reader2String(reader);
    }

    private static Object bytes2Object(byte[] byArray, boolean bl, String string, boolean bl2) {
        Object object;
        BufferedImage bufferedImage = null;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        try {
            bufferedImage = GeneralUtils.readImage(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        if (bufferedImage == null) {
            try {
                BufferedImage bufferedImage2;
                object = new ByteArraySeekableStream(byArray);
                ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)object, null);
                RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage(0);
                Raster raster = renderedImage.getData();
                bufferedImage = bufferedImage2 = new BufferedImage(renderedImage.getColorModel(), Raster.createWritableRaster(renderedImage.getSampleModel(), raster.getDataBuffer(), null), false, new Hashtable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bufferedImage != null && !bl) {
            return bufferedImage;
        }
        if (bl2) {
            return new String(byArray);
        }
        object = "";
        object = string != null ? string : "Download" + StableUtils.getFileTypeFromBytes(byArray);
        if (byArray.length < 10 && ComparatorUtils.equals(object, "Download.txt")) {
            return new String(byArray);
        }
        return AttachmentCacheManager.addAttachment("other", (String)object, byArray);
    }

    private static Object delegateObject(BlobDelegate blobDelegate, String string) {
        String string2 = "";
        string2 = string != null ? string : "Download";
        return AttachmentCacheManager.addAttachment("other", string2, blobDelegate);
    }

    private static Object blob2Object(Blob blob, boolean bl, boolean bl2, String string, boolean bl3) {
        if (bl) {
            try {
                BufferedImage bufferedImage = GeneralUtils.readImage(blob.getBinaryStream());
                if (bufferedImage != null) {
                    return bufferedImage;
                }
                Object object = DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, null, bl3);
                if (object instanceof Image) {
                    return object;
                }
                return new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else {
            try {
                return DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, string, bl3);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
        }
        return null;
    }

    private static Object blobDelegate2Object(BlobDelegate blobDelegate, boolean bl, boolean bl2, String string, boolean bl3) {
        if (bl) {
            try {
                Blob blob = blobDelegate.getBlob();
                BufferedImage bufferedImage = GeneralUtils.readImage(blob.getBinaryStream());
                if (bufferedImage != null) {
                    return bufferedImage;
                }
                Object object = DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, null, bl3);
                if (object instanceof Image) {
                    return object;
                }
                return new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
            }
            catch (Exception exception) {
                return DataUtils.bytes2Object(blobDelegate.getValue(), bl2, string, bl3);
            }
        }
        if (bl2) {
            return DataUtils.delegateObject(blobDelegate, string);
        }
        return DataUtils.bytes2Object(blobDelegate.getValue(), bl2, string, bl3);
    }

    public static Object inputStream2Object(InputStream inputStream, boolean bl, String string, boolean bl2) {
        return DataUtils.bytes2Object(GeneralUtils.inputStream2Bytes(inputStream), bl, string, bl2);
    }

    public static String createServletURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getContextPath());
        stringBuffer.append('/').append(ManagerFactory.getConfigProvider().getServletMapping());
        return stringBuffer.toString();
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String string) {
        return DataUtils.getHTTPRequestEncodeParameter(httpServletRequest, string, true);
    }

    public static String getHTTPRequestEncodeParameter(HttpServletRequest httpServletRequest, String string, boolean bl) {
        Object object;
        RequestParameterHandler requestParameterHandler = ExtraClassManager.getInstance().getRequestParameterHandler();
        if (requestParameterHandler == null) {
            requestParameterHandler = DefaultRequestParameterHandler.getInstance();
        }
        if ((object = requestParameterHandler.getParameterFromRequest(httpServletRequest, string)) == null) {
            object = requestParameterHandler.getParameterFromAttribute(httpServletRequest, string);
        }
        if (object == null) {
            object = requestParameterHandler.getParameterFromJSONParameters(httpServletRequest, string);
        }
        if (object == null) {
            object = requestParameterHandler.getParameterFromSession(httpServletRequest, string);
        }
        if (object == null && (object = requestParameterHandler.getParameterFromRequest(httpServletRequest, string = CodeUtils.cjkEncode(string))) == null && (object = requestParameterHandler.getParameterFromAttribute(httpServletRequest, string)) == null) {
            object = requestParameterHandler.getParameterFromSession(httpServletRequest, string);
        }
        return bl ? DataUtils.checkURLDecode(object) : GeneralUtils.objectToString(object);
    }

    private static String checkURLDecode(Object object) {
        if (object == null) {
            return null;
        }
        String string = CodeUtils.decodeText(String.valueOf(object));
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    public static String getOriginalURL(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return "";
        }
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        Map map = httpServletRequest.getParameterMap();
        Iterator iterator = map.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (bl) {
                stringBuffer.append('?');
                bl = false;
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append('=');
            stringBuffer.append(DataUtils.getHTTPRequestParameter(httpServletRequest, entry.getKey().toString()));
        }
        return CodeUtils.cjkEncode(stringBuffer.toString());
    }

    public static void writeOutTemplate(String string, HttpServletResponse httpServletResponse, Map map) throws IOException {
        PrintWriter printWriter = DataUtils.createPrintWriter(httpServletResponse);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        printWriter.flush();
        printWriter.close();
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse) throws IOException {
        return DataUtils.createPrintWriter(httpServletResponse, ManagerFactory.getConfigProvider().getServerCharset());
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse, String string) throws IOException {
        PrintWriter printWriter;
        try {
            try {
                httpServletResponse.setCharacterEncoding(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string2 = null;
            try {
                string2 = httpServletResponse.getContentType();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isBlank(string2)) {
                httpServletResponse.setContentType("text/html;charset=" + string);
            } else if (string2.indexOf("charset=") == -1) {
                httpServletResponse.setContentType(string2 + ";charset=" + string);
            }
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage());
            printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        }
        return printWriter;
    }
}

