/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.data.FinishJob;
import com.fr.data.impl.SubmitJobValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ColumnRowRelated;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ListMap;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.write.DBWritable;
import com.fr.write.DMLReport;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassJob {
    private String className;
    private ListMap propertyMap = new ListMap();
    protected FinishJob definedJob = null;
    protected Field[] fields = null;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setPropertyMap(ListMap listMap) {
        this.propertyMap = listMap;
    }

    public ListMap getPropertyMap() {
        return this.propertyMap;
    }

    protected ColumnRow[] calculateRelatedColumnRows(ListMap listMap) {
        HashSet<ColumnRow> hashSet = new HashSet<ColumnRow>();
        for (Object e2 : listMap.entrySet()) {
            Object v2 = ((Map.Entry)e2).getValue();
            if (!(v2 instanceof ColumnRowRelated)) continue;
            ColumnRow[] columnRowArray = ((ColumnRowRelated)v2).getRelatedColumnRows();
            hashSet.addAll(Arrays.asList(columnRowArray));
        }
        return hashSet.toArray(new ColumnRow[hashSet.size()]);
    }

    public void doJob(Calculator calculator) throws Exception {
        this.definedJob = this.createFinishJob();
        if (this.definedJob == null) {
            return;
        }
        DBWritable.Action action = this.getAction();
        DMLReport dMLReport = (DMLReport)calculator.getAttribute(DMLReport.class);
        int n2 = 0;
        if (dMLReport != null) {
            n2 = dMLReport.setCurrentColumnRow(this.calculateRelatedColumnRows(this.getPropertyMap()), (ColumnRow)calculator.getAttribute(ColumnRow.class), calculator, action, 0);
        }
        if (n2 <= 0) {
            action.run(0, calculator, 0);
        }
        this.doFinish(calculator);
    }

    protected abstract DBWritable.Action getAction();

    protected abstract void doFinish(Calculator var1) throws Exception;

    protected abstract boolean checkValid(Class<?> var1);

    protected FinishJob createFinishJob() {
        if (StringUtils.isBlank(this.getClassName())) {
            return null;
        }
        try {
            Class clazz = GeneralUtils.classForName(this.getClassName());
            if (!this.checkValid(clazz)) {
                FRLogger.getLogger().error(this.getClassName() + Inter.getLocText("Implement-Description"));
                return null;
            }
            this.fields = clazz.getDeclaredFields();
            return (FinishJob)clazz.newInstance();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    protected ListMap getValues4Action(int n2, Calculator calculator) throws Exception {
        if (this.definedJob == null || this.fields == null) {
            return null;
        }
        ListMap listMap = new ListMap(this.getPropertyMap().size());
        Object object = null;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            String string = this.fields[i2].getName();
            if (!this.getPropertyMap().containsKey(string)) continue;
            object = this.dealPropertyValue(calculator, this.getPropertyMap().get(string), this.fields[i2]);
            StableUtils.setPrivateFieldValue(this.definedJob, string, object);
            listMap.put(string, object);
        }
        Set set = this.getPropertyMap().entrySet();
        for (Map.Entry entry : set) {
            if (listMap.containsKey(entry.getKey())) continue;
            listMap.put(entry.getKey(), this.dealPropertyValue(calculator, entry.getValue(), null));
        }
        return listMap;
    }

    protected Object dealPropertyValue(Calculator calculator, Object object, Field field) throws Exception {
        Object object2;
        Object object3 = object;
        int n2 = -1;
        if (object instanceof ColumnRowRelated) {
            if (this.needConvert(object, field) && (object2 = ((ColumnRowRelated)object).getRelatedColumnRows()) != null && ((ColumnRow[])object2).length == 1) {
                n2 = GeneralUtils.objectToNumber(calculator.eval(object2[0].stateDescription()), false).intValue();
            }
            if (object3 instanceof ColumnRow) {
                object3 = calculator.resolveVariable(object3);
            } else if (object3 instanceof FormulaProvider) {
                object3 = calculator.evalValue((FormulaProvider)object3);
            }
        }
        if (n2 != -1 || field == null) {
            return new SubmitJobValue(object3, n2);
        }
        object2 = field.getType().getName();
        if ("String".equals(object2)) {
            return object3.toString();
        }
        if ("Integer".equals(object2)) {
            return new Integer(object3.toString());
        }
        if ("Double".equals(object2)) {
            return new Double(object3.toString());
        }
        if ("Boolean".equals(object2)) {
            return Boolean.valueOf(object3.toString());
        }
        if ("Date".equals(object2)) {
            return DateUtils.object2Date(object3, false);
        }
        return object3;
    }

    private boolean needConvert(Object object, Field field) {
        return (object instanceof ColumnRow || object instanceof FormulaProvider && ((FormulaProvider)object).getContent().matches("^=[a-zA-Z]+\\d+$")) && (field == null || field.getType().getName().contains("JobValue"));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.getPropertyMap().clear();
        }
        if (xMLableReader.isChildNode()) {
            String string;
            if (xMLableReader.getTagName().equals("ClassAttr")) {
                String string2 = xMLableReader.getAttrAsString("className", null);
                if (StringUtils.isNotBlank(string2)) {
                    this.setClassName(string2);
                }
            } else if ("Property".equals(xMLableReader.getTagName()) && StringUtils.isNotBlank(string = xMLableReader.getAttrAsString("name", null))) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode()) {
                            if ("ColumnRow".equals(xMLableReader.getTagName())) {
                                int n2 = xMLableReader.getAttrAsInt("column", 0);
                                int n3 = xMLableReader.getAttrAsInt("row", 0);
                                AbstractClassJob.this.getPropertyMap().put(string, ColumnRow.valueOf(n2, n3));
                            } else if ("O".equals(xMLableReader.getTagName())) {
                                AbstractClassJob.this.getPropertyMap().put(string, GeneralXMLTools.readObject(xMLableReader));
                            }
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getClassName())) {
            xMLPrintWriter.startTAG("ClassAttr").attr("className", this.getClassName()).end();
        }
        for (Map.Entry entry : this.getPropertyMap().entrySet()) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            xMLPrintWriter.startTAG("Property").attr("name", string);
            if (v2 instanceof ColumnRow) {
                ColumnRow columnRow = (ColumnRow)v2;
                StableXMLUtils.writeColumnRow(xMLPrintWriter, columnRow);
            } else {
                GeneralXMLTools.writeObject(xMLPrintWriter, v2);
            }
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractClassJob abstractClassJob = (AbstractClassJob)super.clone();
        abstractClassJob.propertyMap = (ListMap)this.propertyMap.clone();
        return abstractClassJob;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractClassJob && ComparatorUtils.equals(((AbstractClassJob)object).className, this.className) && ComparatorUtils.equals(((AbstractClassJob)object).propertyMap, this.propertyMap);
    }
}

