/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.Base64;
import com.fr.base.MapCacheAttr;
import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.chart.ColorSelect4Shape;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.web.Browser;
import com.fr.web.core.ActionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JPanel;

public class ChartMapLayerAction
implements ActionCMD {
    private static final double RSIZE = 5.0;

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        JSONObject jSONObject = new JSONObject();
        String string2 = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "mapName"));
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2);
        if (mapAttr == null || mapAttr.getMapImage() == null) {
            return;
        }
        Image image = mapAttr.getMapImage();
        int n2 = image.getWidth(new JPanel());
        int n3 = image.getHeight(new JPanel());
        MapCacheAttr mapCacheAttr = MapCacheAttr.getInstance();
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        if (MapCacheAttr.isContainsColorSelect(string2)) {
            colorSelect4Shape = MapCacheAttr.getColorSelect(string2);
        }
        if (!colorSelect4Shape.hasLoadedImage(image)) {
            colorSelect4Shape.makesureImage(image);
        }
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("mapName", string2);
        jSONObject2.put("mapWidth", n2);
        jSONObject2.put("mapHeight", n3);
        if (Browser.resolve(httpServletRequest).isIE()) {
            jSONObject2.put("onie", ChartBaseUtils.addImageAsEmb(image));
        } else {
            jSONObject2.put("onsrc", "data:image/png;base64," + Base64.encode(image, "png"));
        }
        jSONArray.put(jSONObject2);
        jSONObject.put("mapName", string2);
        jSONObject.put("imageBounds", jSONArray);
        HashMap hashMap = this.dealShapePaths(string2, mapAttr, colorSelect4Shape);
        jSONObject.put("pathMap", this.pathMap2JSONArray(hashMap, mapAttr));
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private HashMap dealShapePaths(String string, MapAttr mapAttr, ColorSelect4Shape colorSelect4Shape) {
        HashMap<String, GeneralPath> hashMap = new HashMap<String, GeneralPath>();
        Iterator iterator = mapAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            GeneralPath generalPath;
            String string2 = (String)iterator.next();
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string2);
            if (mapShapeValue == null) continue;
            MapCacheAttr mapCacheAttr = MapCacheAttr.getInstance();
            GeneralPath generalPath2 = mapCacheAttr.getShapeWithName(string, mapShapeValue.getName());
            if (generalPath2 != null) {
                hashMap.put(mapShapeValue.getName(), generalPath2);
                continue;
            }
            Point[] pointArray = mapShapeValue.getShape();
            if (mapShapeValue.getMarkType() == 0) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)pointArray[0].getX(), (float)pointArray[0].getY());
                double d2 = 5.0;
                double d3 = pointArray[0].getX() - d2;
                double d4 = pointArray[0].getY() - d2;
                generalPath.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
                hashMap.put(mapShapeValue.getName(), generalPath);
                MapCacheAttr.addShapes(string, mapShapeValue.getName(), generalPath);
                continue;
            }
            generalPath = new GeneralPath();
            for (int i2 = 0; i2 < pointArray.length; ++i2) {
                colorSelect4Shape.makesureClickPoint(pointArray[i2].getX(), pointArray[i2].getY());
                GeneralPath generalPath3 = colorSelect4Shape.getSelectedPath();
                generalPath.append(generalPath3, false);
            }
            hashMap.put(mapShapeValue.getName(), generalPath);
            MapCacheAttr.addShapes(string, mapShapeValue.getName(), generalPath);
        }
        return hashMap;
    }

    private JSONArray pathMap2JSONArray(HashMap hashMap, MapAttr mapAttr) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            GeneralPath generalPath = (GeneralPath)hashMap.get(string);
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", string);
            jSONObject.put("path", ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", mapShapeValue.getMarkType());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public String getCMD() {
        return "map_layerto";
    }
}

