/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.module;

import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartCollection;
import com.fr.chart.chartattr.ChartGetter;
import com.fr.chart.chartattr.ChartIcon4ADHOC;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartdata.BubbleChartData;
import com.fr.chart.chartdata.GanttChartData;
import com.fr.chart.chartdata.GisMapChartData;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartdata.MeterChartData;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalReportDataDefinition;
import com.fr.chart.chartdata.ScatterChartData;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.StockChartData;
import com.fr.chart.web.Chart4BSService;
import com.fr.chart.web.ChartRelateService;
import com.fr.general.Inter;
import com.fr.module.BaseModule;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.Service;
import com.fr.stable.web.WebletCreator;

public class ChartModule
extends BaseModule {
    public void start() {
        super.start();
        this.init();
    }

    public void init() {
        this.registerXML4Chart();
        this.registerData4Chart();
    }

    private void registerXML4Chart() {
        StableFactory.registerXMLDescription("CC", new ChartCollection());
        StableFactory.registerXMLDescription("CP", new ChartPainter());
        StableFactory.registerXMLDescription("Chart", new Chart());
        StableFactory.registerXMLDescription("BaseNormalReportDefinition", new NormalReportDataDefinition());
    }

    private void registerData4Chart() {
        StableFactory.registerObDescription("BaseChartGetter", ChartGetter.class);
        StableFactory.registerObDescription("BubbleData", BubbleChartData.class);
        StableFactory.registerObDescription("NormalData", NormalChartData.class);
        StableFactory.registerObDescription("ScatterData", ScatterChartData.class);
        StableFactory.registerObDescription("MapData", MapChartData.class);
        StableFactory.registerObDescription("GisMapData", GisMapChartData.class);
        StableFactory.registerObDescription("StockData", StockChartData.class);
        StableFactory.registerObDescription("MeterData", MeterChartData.class);
        StableFactory.registerObDescription("GanttData", GanttChartData.class);
        StableFactory.registerObDescription("BaseMapAreaValue", MapAreaValue.class);
        StableFactory.registerObDescription("BaseMapTitleValue", MapTitleValue.class);
        StableFactory.registerObDescription("BaseSeriesDefinition", SeriesDefinition.class);
        StableFactory.registerXMLDescription("ChartIcon4ADHOC", new ChartIcon4ADHOC(new Chart()));
    }

    public String[] getChartFiles4WebClient() {
        return new String[]{"/com/fr/web/core/js/chart.utils.js", "/com/fr/web/core/js/chart.constants.js", "/com/fr/web/core/js/chart.finechart.js", "/com/fr/web/core/js/chart.shape.js", "/com/fr/web/core/js/chart.plotattr.js", "/com/fr/web/core/js/chart.axisglyph.js", "/com/fr/web/core/js/chart.datapoint.js", "/com/fr/web/core/js/chart.dataseries.js", "/com/fr/web/core/js/chart.glyph.js", "/com/fr/web/core/js/chart.legend.js", "/com/fr/web/core/js/chart.datasheet.js", "/com/fr/web/core/js/chart.handler.js", "/com/fr/web/core/js/chart.event.js", "/com/fr/web/core/js/chart.tooltip.js", "/com/fr/web/core/js/chart.report.widget.js", "/com/fr/web/core/js/chart.form.widget.js"};
    }

    public String[] getChartFiles4IEWebClient() {
        Object[] objectArray = this.getChartFiles4WebClient();
        Object[] objectArray2 = new String[]{"/com/fr/web/core/js/excanvas.js"};
        return (String[])ArrayUtils.addAll(objectArray, objectArray2);
    }

    public Service[] service4Register() {
        return (Service[])ArrayUtils.addAll(super.service4Register(), new Service[]{new Chart4BSService(), new ChartRelateService()});
    }

    public WebletCreator[] webletCreator4Register() {
        return (WebletCreator[])ArrayUtils.addAll(super.webletCreator4Register(), new WebletCreator[0]);
    }

    public String getInterNationalName() {
        return Inter.getLocText("chartModule");
    }
}

