/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.chart.chartglyph.NumberAxisGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RadarAxisGlyph
extends NumberAxisGlyph {
    private static final long serialVersionUID = -2702639014404531055L;
    private static final double LABEL_WIDTH = 8.0;
    private static final double HEIGHT = 12.0;
    private static final double CIR_ANGLE = 360.0;
    private static final double ANGLE = 90.0;
    private double diameter = 0.0;
    private double radian = 0.0;
    private int categoryCount;
    private List labelList = new ArrayList();
    private boolean isAllMaxMin = true;
    private double[] radarMax = new double[]{100.0};
    private double[] radarMin = new double[0];

    public String getJSAxisType() {
        return "RadarAxisGlyph";
    }

    public void setRadarMax(double[] dArray) {
        this.radarMax = dArray;
    }

    public void setRadarMin(double[] dArray) {
        this.radarMin = dArray;
    }

    public void setAllMaxMin(boolean bl) {
        this.isAllMaxMin = bl;
    }

    public void setCategoryCount(int n2) {
        this.categoryCount = n2;
    }

    public void setD(double d2) {
        this.diameter = d2;
    }

    public void setRadian(double d2) {
        this.radian = d2;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        Line2D[] line2DArray = this.getAxisLines();
        for (int i2 = 0; i2 < line2DArray.length; ++i2) {
            generalPath.append(line2DArray[i2], false);
        }
        return generalPath;
    }

    public double getCrossValue() {
        return this.minValue;
    }

    public double getArrowValue() {
        return this.maxValue;
    }

    public void addCategoryLabel(Object object) {
        this.labelList.add(object);
    }

    public void init(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this.setOrigin(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
        this.setD(Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()));
        this.setRadian(Math.toRadians(360.0 / (double)this.categoryCount));
        this.setAxisLength(this.diameter / 2.0);
    }

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n2) {
        double d2 = 8.0;
        double d3 = 8.0;
        int n3 = this.labelList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = Utils.objectToString(this.labelList.get(i2));
            double d4 = GlyphUtils.calculateTextDimensionWithRotation(string, new TextAttr(), n2).getWidth();
            if (i2 < n3 / 2) {
                d2 = Math.max(d4, d2);
                continue;
            }
            d3 = Math.max(d4, d3);
        }
        double d5 = 12.0;
        d2 = Math.max(d2, d5);
        d3 = Math.max(d3, d5);
        rectangle2D.setRect(rectangle2D.getX() + d2, rectangle2D.getY() + d5, rectangle2D.getWidth() - d2 - d3, rectangle2D.getHeight() - d5);
    }

    public void calculateAxisLengthUnit() {
        this.unitLength = this.axisLength / (this.getMaxValue() - this.getMinValue());
    }

    private double getCateMin(int n2) {
        if (n2 >= 0 && this.radarMin != null && this.radarMin.length > n2) {
            return this.radarMin[n2];
        }
        return this.getCrossValue();
    }

    private double getCateMax(int n2) {
        if (n2 >= 0 && this.radarMax.length > n2) {
            return this.radarMax[n2];
        }
        return this.getMaxValue();
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n2) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d2 = 8.0;
        for (int i2 = 0; i2 < this.categoryCount; ++i2) {
            double d3;
            double d4 = this.getCateMin(i2);
            BigDecimal bigDecimal = AxisHelper.calculateIncrement(d4, d3 = this.getCateMax(i2));
            if (bigDecimal.doubleValue() <= 0.0) continue;
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d4));
            BigDecimal bigDecimal3 = bigDecimal;
            for (double d5 = d4; d5 <= d3; d5 += bigDecimal.doubleValue()) {
                double d6 = this.getAxisLabelWidth(this.value2String((bigDecimal2 = bigDecimal2.add(bigDecimal3)).doubleValue()), n2);
                d2 = d6 < d2 ? d2 : d6;
            }
        }
        return d2;
    }

    protected boolean shouldBeHeight() {
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            return false;
        }
        return textAttr.getAlignText() == 1;
    }

    public Point2D getPointInBounds(int n2, double d2) {
        double d3 = this.getCateMin(n2);
        double d4 = this.getCateMax(n2);
        if (d2 < d3) {
            d2 = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        return this.getPoint2D(n2, d2);
    }

    private Point2D getPoint2D(int n2, double d2) {
        double d3 = this.getCateMin(n2);
        double d4 = this.getCateMax(n2);
        double d5 = d2 - d3;
        double d6 = this.axisLength / (d4 - d3);
        return new Point2D.Double(this.originPoint.getX() + Math.cos(this.radian * (double)n2 + 1.5707963267948966) * d5 * d6, this.originPoint.getY() - Math.sin(this.radian * (double)n2 + 1.5707963267948966) * d5 * d6);
    }

    public void drawAxisGrid(Graphics graphics) {
        if (!this.isAllMaxMin) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.getMainGridColor());
            graphics2D.setStroke(GraphHelper.getStroke(this.getMainGridStyle()));
            for (double d2 = this.getCrossValue(); d2 <= this.getMaxValue(); d2 += this.getMainUnit()) {
                Line2D[] line2DArray = this.getGridLine(d2);
                for (int i2 = 0; i2 < line2DArray.length; ++i2) {
                    graphics2D.draw(line2DArray[i2]);
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    public void paintRadarBackground(Graphics graphics, Color color) {
        if (!this.isAllMaxMin) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainUnit() > 0.0 && color != null) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(color);
            for (double d2 = this.getCrossValue(); d2 <= this.getMaxValue() - this.getMainUnit(); d2 += this.getMainUnit() * 2.0) {
                GeneralPath generalPath = this.getRadarPath(d2, this.getMainUnit());
                graphics2D.fill(generalPath);
            }
            graphics2D.setPaint(paint);
        }
    }

    public Line2D[] getGridLine(double d2) {
        Line2D[] line2DArray = new Line2D[this.categoryCount];
        for (int i2 = 0; i2 < this.categoryCount; ++i2) {
            line2DArray[i2] = i2 == this.categoryCount - 1 ? new Line2D.Double(this.getPoint2D(i2, d2), this.getPoint2D(0, d2)) : new Line2D.Double(this.getPoint2D(i2, d2), this.getPoint2D(i2 + 1, d2));
        }
        return line2DArray;
    }

    private GeneralPath getRadarPath(double d2, double d3) {
        int n2;
        GeneralPath generalPath = new GeneralPath(0);
        for (n2 = 0; n2 < this.categoryCount; ++n2) {
            if (n2 == 0) {
                generalPath.moveTo((float)this.getPoint2D(n2, d2).getX(), (float)this.getPoint2D(n2, d2).getY());
            } else {
                generalPath.lineTo((float)this.getPoint2D(n2, d2).getX(), (float)this.getPoint2D(n2, d2).getY());
            }
            if (n2 != this.categoryCount - 1) continue;
            generalPath.lineTo((float)this.getPoint2D(0, d2).getX(), (float)this.getPoint2D(0, d2).getY());
        }
        for (n2 = 0; n2 < this.categoryCount; ++n2) {
            generalPath.lineTo((float)this.getPoint2D(n2, d2 + d3).getX(), (float)this.getPoint2D(n2, d2 + d3).getY());
            if (n2 != this.categoryCount - 1) continue;
            generalPath.lineTo((float)this.getPoint2D(0, d2 + d3).getX(), (float)this.getPoint2D(0, d2 + d3).getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    protected void drawAxisLine(Graphics graphics, int n2) {
        if (this.getLineColor() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        GeneralPath generalPath = new GeneralPath();
        Line2D[] line2DArray = this.getAxisLines();
        for (int i2 = 0; i2 < line2DArray.length; ++i2) {
            graphics2D.setPaint(this.getLineColor());
            graphics2D.setStroke(GraphHelper.getStroke(this.getLineStyle()));
            graphics2D.draw(line2DArray[i2]);
            this.drawArrow(graphics2D, line2DArray[i2].getP1(), line2DArray[i2].getP2());
            if (this.isArrowShow()) {
                this.drawCateLabel(graphics2D, i2, line2DArray[i2].getP2(), 16.0, generalPath, n2);
                continue;
            }
            this.drawCateLabel(graphics2D, i2, line2DArray[i2].getP2(), 0.0, generalPath, n2);
        }
        this.drawTicks(graphics2D, generalPath, n2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected void drawTicks(Graphics graphics, int n2) {
    }

    protected void drawTicks(Graphics graphics, GeneralPath generalPath, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.lineColor);
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        for (int i2 = 0; i2 < this.categoryCount; ++i2) {
            double d2;
            int n3 = 0;
            n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : 1;
            double d3 = this.getCateMin(i2);
            double d4 = this.getCateMax(i2);
            BigDecimal bigDecimal = this.isCustomMainUnit() ? this.getBigDecimalMainUnit() : AxisHelper.calculateIncrement(d3, d4);
            double d5 = this.isCustomSecUnit() ? this.getSecUnit() : bigDecimal.doubleValue() / 5.0;
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d3));
            BigDecimal bigDecimal3 = bigDecimal;
            BigDecimal bigDecimal4 = new BigDecimal(Double.toString(n3));
            double d6 = this.checkDivUnit(graphics2D, n2);
            for (d2 = d3; d2 <= d4; d2 += bigDecimal.doubleValue() * (double)n3) {
                if (i2 == 0 || !this.isAllMaxMin) {
                    this.drawTickLine(graphics2D, this.getTickLine(i2, d2, 5, this.getTickMarkType()), basicStroke);
                    this.drawFirstAxisLabel(graphics, i2, bigDecimal2.doubleValue(), d6, generalPath, n2);
                }
                bigDecimal2 = bigDecimal2.add(bigDecimal3.multiply(bigDecimal4));
            }
            for (d2 = d3 + d5; d2 <= d4; d2 += d5) {
                if (i2 != 0 && this.isAllMaxMin) continue;
                this.drawTickLine(graphics2D, this.getTickLine(i2, d2, 3, this.getSecTickMarkType()), basicStroke);
            }
        }
        graphics2D.setPaint(paint);
    }

    private double checkDivUnit(Graphics2D graphics2D, int n2) {
        double d2 = 1.0;
        String string = this.getShowUnit();
        if (string != null) {
            d2 = AxisHelper.getDivideUnit(string);
            TextGlyph textGlyph = new TextGlyph(Inter.getLocText("Unit") + ":" + string, new TextAttr());
            Rectangle rectangle = new Rectangle(0, 0, 80, 20);
            textGlyph.setBounds(rectangle);
            textGlyph.draw(graphics2D, n2);
        }
        return d2;
    }

    private void drawCateLabel(Graphics graphics, int n2, Point2D point2D, double d2, GeneralPath generalPath, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.labelList.get(n2).toString();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + Math.cos(this.radian * (double)n2 + 1.5707963267948966) * d2, point2D.getY() - Math.sin(this.radian * (double)n2 + 1.5707963267948966) * d2);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, new TextAttr(), n3);
        double d3 = ((double)n2 * 360.0 / (double)this.categoryCount + 90.0) % 360.0;
        double d4 = ((Point2D)double_).getY();
        double d5 = ((Point2D)double_).getX();
        double d6 = 2.0;
        if (!this.isAllMaxMin) {
            double d7 = this.getCateMax(n2);
            double d8 = 1.0;
            String string2 = this.getShowUnit();
            if (string2 != null) {
                d8 = AxisHelper.getDivideUnit(string2);
            }
            String string3 = this.value2String(d7 / d8);
            d6 = 4.0 + GlyphUtils.calculateTextDimensionWithRotation(string3, new TextAttr(), n3).getWidth();
        }
        if (d3 > 90.0 && d3 < 270.0) {
            d5 = d5 - d6 - dimension2D.getWidth();
        } else if (d3 > 0.0 && d3 < 90.0) {
            d4 -= dimension2D.getHeight() / 2.0;
        } else if (d3 > 270.0 && d3 < 360.0) {
            d4 -= dimension2D.getHeight() / 2.0;
        } else if (d3 == 90.0) {
            d5 -= dimension2D.getWidth() / 2.0;
            d4 -= dimension2D.getHeight() * 3.0 / 2.0;
        } else if (d3 == 270.0) {
            d5 -= dimension2D.getWidth() / 2.0;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d5, d4, dimension2D.getWidth(), dimension2D.getHeight());
        if (!generalPath.intersects(double_2)) {
            generalPath.append(double_2, false);
            GlyphUtils.drawStrings(graphics2D, string, new TextAttr(), double_2, n3);
        }
    }

    private Line2D getTickLine(int n2, double d2, int n3, int n4) {
        Point2D point2D = this.getPoint2D(n2, d2);
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n3 / 2.0 * Math.cos((double)n2 * this.radian), point2D.getY() + (double)n3 / 2.0 * Math.sin((double)n2 * this.radian));
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n3 / 2.0 * Math.cos((double)n2 * this.radian), point2D.getY() - (double)n3 / 2.0 * Math.sin((double)n2 * this.radian));
        if (n4 == 3) {
            return new Line2D.Double(double_, double_2);
        }
        if (n4 == 1) {
            return new Line2D.Double(double_, point2D);
        }
        if (n4 == 2) {
            return new Line2D.Double(point2D, double_2);
        }
        return new Line2D.Double(point2D, point2D);
    }

    protected void drawFirstAxisLabel(Graphics graphics, int n2, double d2, double d3, GeneralPath generalPath, int n3) {
        if (!this.isShowAxisLabel()) {
            return;
        }
        Point2D point2D = this.getPoint2D(n2, d2);
        String string = this.value2String(d2 / d3);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n3);
        double d4 = 4.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - d4, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        if (this.getLabelNumber() != 0) {
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n3);
        } else if (!generalPath.intersects(double_)) {
            generalPath.append(double_, false);
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n3);
        }
    }

    private Line2D[] getAxisLines() {
        Line2D[] line2DArray = new Line2D[this.categoryCount];
        for (int i2 = 0; i2 < this.categoryCount; ++i2) {
            line2DArray[i2] = new Line2D.Double(this.getPoint2D(i2, this.getCateMin(i2)), this.getPoint2D(i2, this.getCateMax(i2)));
        }
        return line2DArray;
    }

    protected void drawAxisTitle(Graphics graphics, int n2) {
    }

    public boolean equals(Object object) {
        return object instanceof RadarAxisGlyph && super.equals(object) && ((RadarAxisGlyph)object).diameter == this.diameter && ((RadarAxisGlyph)object).radian == this.radian && ((RadarAxisGlyph)object).categoryCount == this.categoryCount && ((RadarAxisGlyph)object).isAllMaxMin == this.isAllMaxMin && ComparatorUtils.equals(((RadarAxisGlyph)object).labelList, this.labelList);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("D", this.diameter);
        jSONObject.put("radian", this.radian);
        jSONObject.put("categoryCount", this.categoryCount);
        if (this.labelList != null && this.labelList.size() > 0) {
            jSONObject.put("labelList", this.labelList.toArray());
        }
        jSONObject.put("radarMax", this.radarMax);
        jSONObject.put("radarMin", this.radarMin);
        jSONObject.put("isAllMaxMin", this.isAllMaxMin);
        return jSONObject;
    }

    public double getPreLeftWidth4DataSheet(int n2) {
        return 0.0;
    }
}

