/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class Pie3D
extends SpecialGlyph
implements Object3D {
    private static final long serialVersionUID = 4123668892673753116L;
    private Projection projection = new Projection();
    private List cylinderList = new ArrayList();

    private void drawBottom(Graphics2D graphics2D) {
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Cylinder cylinder = this.getCylinder(i2);
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            colorInfo.paint(graphics2D, cylinder.bottom());
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private void drawBack(Graphics2D graphics2D) {
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Cylinder cylinder = this.getCylinder(i2);
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            colorInfo.paint(graphics2D, cylinder.back());
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private void drawSide(Graphics2D graphics2D, Cylinder.CylinderSide[] cylinderSideArray) {
        for (int i2 = 0; i2 < cylinderSideArray.length; ++i2) {
            Cylinder cylinder = cylinderSideArray[i2].cylinder;
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            if (cylinderSideArray[i2].isStart) {
                colorInfo.paint(graphics2D, cylinder.getStartSide());
            } else {
                colorInfo.paint(graphics2D, cylinder.getEndSide());
            }
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private Cylinder.CylinderSide[] sortCylinderSide() {
        Object[] objectArray = new Cylinder.CylinderSide[this.getCylinderCount() * 2];
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            objectArray[2 * i2] = new Cylinder.CylinderSide(this.getCylinder(i2), true);
            objectArray[2 * i2 + 1] = new Cylinder.CylinderSide(this.getCylinder(i2), false);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void drawPositive(Graphics2D graphics2D) {
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Color color;
            Cylinder cylinder = this.getCylinder(i2);
            if (cylinder.getExtent() == 0.0 || (color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor()) == null) continue;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.1));
            graphics2D.fill(cylinder.front());
            graphics2D.setPaint(paint);
        }
    }

    private void drawTop(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            Color color;
            Cylinder cylinder = this.getCylinder(i2);
            if (cylinder.getExtent() == 0.0 || (color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor()) == null) continue;
            Arc2D arc2D = cylinder.top();
            double d2 = arc2D.getWidth();
            double d3 = arc2D.getHeight();
            double d4 = arc2D.getWidth() / 2.0;
            double d5 = d2 / 2.0 / d4;
            double d6 = d3 / 2.0 / d4;
            graphics2D.scale(d5, d6);
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.25);
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{color2, color};
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)(arc2D.getCenterX() / d5), (float)(arc2D.getCenterY() / d6), (float)d4, fArray, colorArray);
            graphics2D.setPaint((Paint)radialGradientPaint);
            graphics2D.fill(new Arc2D.Double(arc2D.getX() / d5, arc2D.getY() / d6, d2, d2, arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType()));
            graphics2D.scale(1.0 / d5, 1.0 / d6);
        }
        graphics2D.setPaint(paint);
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawBottom(graphics2D);
        this.drawBack(graphics2D);
        this.drawSide(graphics2D, this.sortCylinderSide());
        this.drawPositive(graphics2D);
        this.drawTop(graphics2D);
    }

    public void drawWithoutSide(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawPositive(graphics2D);
        this.drawTop(graphics2D);
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < this.getCylinderCount(); ++i2) {
            generalPath.append(this.getCylinder(i2).getShape(), false);
        }
        return generalPath;
    }

    public void addCylinder(Cylinder cylinder) {
        this.cylinderList.add(cylinder);
    }

    public Cylinder getCylinder(int n2) {
        return (Cylinder)this.cylinderList.get(n2);
    }

    public int getCylinderCount() {
        return this.cylinderList.size();
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void clearCylinder() {
        this.cylinderList.clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3D)) {
            return false;
        }
        Pie3D pie3D = (Pie3D)object;
        if (!ComparatorUtils.equals(pie3D.getProjection(), this.getProjection())) {
            return false;
        }
        if (pie3D.getCylinderCount() != this.getCylinderCount()) {
            return false;
        }
        for (int i2 = 0; i2 < pie3D.getCylinderCount(); ++i2) {
            if (pie3D.getCylinder(i2) == null || ComparatorUtils.equals(pie3D.getCylinder(i2), this.getCylinder(i2))) continue;
            return false;
        }
        return true;
    }

    public Point2D topCenterPoint(Point2D point2D) {
        return this.getCylinder(0).topCenterPoint(point2D);
    }
}

