/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class LinePlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = -1824689734124193168L;
    private static final double MARKERRAD = 5.0;
    private boolean isCurve = false;
    private boolean isStartPoint = true;

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public void layoutDataSeriesGlyph(int n2) {
        for (int i2 = 0; i2 < this.getSeriesSize(); ++i2) {
            this.dealLine4PlotGlyph(this.getSeries(i2), this, this.getxAxisGlyph(), this.getSeriesAxisGlyph(i2), n2);
        }
        this.dealLabelBoundsInOrder();
    }

    public void dealLine4PlotGlyph(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n2) {
        GeneralPath generalPath = new GeneralPath(1);
        GeneralPath generalPath2 = new GeneralPath(1);
        this.dealLine4AllSeries(dataSeries, categoryPlotGlyph, axisGlyph, axisGlyph2, generalPath, generalPath2, n2);
        if (this.isCurve) {
            this.dealCurveLinePath(generalPath, generalPath2, dataSeries);
        } else {
            this.dealCommonLinePath(generalPath, dataSeries);
        }
    }

    private void dealLine4AllSeries(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, GeneralPath generalPath, GeneralPath generalPath2, int n2) {
        int n3 = this.calculateLineDataCount(dataSeries);
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        n3 = 0;
        this.isStartPoint = true;
        for (int i2 = 0; i2 < dataSeries.getDataPointCount(); ++i2) {
            DataPoint dataPoint = dataSeries.getDataPoint(i2);
            if (dataPoint.isValueIsNull()) {
                if (!this.isNullValueBreak()) continue;
                this.isStartPoint = true;
                continue;
            }
            double d2 = categoryPlotGlyph.getDataPointPercentValue(dataSeries.getSeriesIndex(), i2);
            float f2 = (float)axisGlyph.getPoint2D((double)axisGlyph.getTickIndex4Value(i2) + 0.5).getX();
            if (this.isDataPointXNotInPlotBounds(f2)) continue;
            float f3 = this.calculatePoint_y(dataSeries, categoryPlotGlyph, axisGlyph2, d2, i2);
            dArray[n3] = f2;
            dArray2[n3] = f3;
            ++n3;
            this.dealLinePoint4EveryDataPoint(generalPath, generalPath2, f2, f3);
            this.initMarkerGlyph(dataPoint, f2, f3);
            this.dealDataPointLabel(dataPoint, n2);
        }
        this.trendLineFitting(dArray, dArray2, dataSeries);
    }

    private void dealLinePoint4EveryDataPoint(GeneralPath generalPath, GeneralPath generalPath2, float f2, float f3) {
        if (this.isCurve) {
            if (this.isStartPoint) {
                ChartUtils.curveTo(generalPath, generalPath2);
                generalPath2.reset();
                generalPath2.moveTo(f2, f3);
                generalPath.moveTo(f2, f3);
                this.isStartPoint = false;
            } else {
                generalPath2.lineTo(f2, f3);
            }
        } else if (this.isStartPoint) {
            generalPath.moveTo(f2, f3);
            this.isStartPoint = false;
        } else {
            generalPath.lineTo(f2, f3);
        }
    }

    private int calculateLineDataCount(DataSeries dataSeries) {
        int n2 = 0;
        for (int i2 = 0; i2 < dataSeries.getDataPointCount(); ++i2) {
            if (dataSeries.getDataPoint(i2).isValueIsNull()) continue;
            ++n2;
        }
        return n2;
    }

    private float calculatePoint_y(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, double d2, int n2) {
        return (float)axisGlyph.getBounds().getY() + (float)axisGlyph.getPoint2D(d2).getY();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n2) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n2);
    }

    private void initMarkerGlyph(DataPoint dataPoint, float f2, float f3) {
        MarkerGlyph markerGlyph = new MarkerGlyph();
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.setShape(new Rectangle2D.Double((double)f2 - 5.0, (double)f3 - 5.0, 10.0, 10.0));
        dataPoint.setDrawImpl(markerGlyph);
    }

    public boolean equals(Object object) {
        return object instanceof LinePlotGlyph && super.equals(object) && ((LinePlotGlyph)object).isCurve == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        LinePlotGlyph linePlotGlyph = (LinePlotGlyph)super.clone();
        return linePlotGlyph;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("isCurve", this.isCurve);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "LinePlotGlyph";
    }
}

