/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Locale;

public class LegendItem
implements Cloneable {
    private static final long serialVersionUID = -3537790025233710932L;
    private static final double LABEL_MARKER_GAP = 4.0;
    private Rectangle2D bounds;
    private String label;
    private LineMarkerIcon lineMarkerIcon;
    private Color fontColor = null;
    private transient boolean drawInCut = false;

    public LegendItem() {
    }

    public LegendItem(String string) {
        this.setLabel(string);
    }

    public void setLineMarkerIcon(LineMarkerIcon lineMarkerIcon) {
        this.lineMarkerIcon = lineMarkerIcon;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public void setDrawInCut(boolean bl) {
        this.drawInCut = bl;
    }

    public boolean isDrawInCut() {
        return this.drawInCut;
    }

    public void draw(Graphics graphics, FRFont fRFont, int n2) {
        if (this.bounds == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawLineMarkerIcon(graphics2D, fRFont, n2);
        this.drawLabel(graphics2D, fRFont, n2);
    }

    private void drawLineMarkerIcon(Graphics2D graphics2D, FRFont fRFont, int n2) {
        if (this.lineMarkerIcon != null) {
            graphics2D.translate(this.bounds.getX(), this.bounds.getY());
            int n3 = fRFont.getShowSize(n2);
            graphics2D.translate(0.0, (this.bounds.getHeight() - (double)n3) / 2.0);
            this.lineMarkerIcon.paint(graphics2D, n3);
            graphics2D.translate(0.0, -(this.bounds.getHeight() - (double)n3) / 2.0);
            graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
        }
    }

    private void drawLabel(Graphics2D graphics2D, FRFont fRFont, int n2) {
        if (StringUtils.isNotEmpty(this.label)) {
            Font font = graphics2D.getFont();
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (this.fontColor != null) {
                graphics2D.setPaint(this.fontColor);
            } else {
                graphics2D.setPaint(fRFont.getForeground());
            }
            Font font2 = null;
            if (ComparatorUtils.equals(Locale.ENGLISH, FRContext.getLocale())) {
                font2 = FRFont.getInstance("Dialog", fRFont.getStyle(), fRFont.getSize());
            }
            font2 = fRFont.applyResolutionNP(n2);
            graphics2D.setFont(font2);
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(graphics2D.getFont());
            String string = this.label;
            Dimension2D dimension2D = this.prefferedSize(fRFont, n2);
            if (dimension2D.getWidth() > this.bounds.getWidth()) {
                if (this.drawInCut) {
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(this.bounds);
                    GraphHelper.drawString(graphics2D, string, this.bounds.getX() + (double)fRFont.getShowSize(n2) + 4.0, this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent());
                    graphics2D.setClip(shape);
                } else {
                    string = this.getTextWhenNotEnoughWidth(string, fRFont.applyResolutionNP(n2), this.bounds.getWidth());
                    GraphHelper.drawString(graphics2D, string, this.bounds.getX() + (double)fRFont.getShowSize(n2) + 4.0, this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent());
                }
            } else {
                GraphHelper.drawString(graphics2D, string, this.bounds.getX() + (double)fRFont.getShowSize(n2) + 4.0, this.bounds.getY() + (this.bounds.getHeight() - (double)fontMetrics.getHeight()) / 2.0 + (double)fontMetrics.getAscent());
            }
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            graphics2D.setFont(font);
        }
    }

    private String getTextWhenNotEnoughWidth(String string, Font font, double d2) {
        String string2 = "...";
        if (StringUtils.isEmpty(string)) {
            return string2;
        }
        double d3 = this.getStringWidthWithFont("...", font);
        if (d3 > d2) {
            return string2;
        }
        String string3 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            double d4 = this.getStringWidthWithFont(string3 + c2 + string2, font);
            if (d4 > d2) break;
            string3 = string3 + c2;
        }
        return string3 + string2;
    }

    private int getStringWidthWithFont(String string, Font font) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(10, 10, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        return (int)GraphHelper.stringWidth(string, font, graphics2D.getFontRenderContext()) + font.getSize() / 2 + 4;
    }

    public Dimension2D prefferedSize(FRFont fRFont, int n2) {
        Font font = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n2), this.label);
        int n3 = font.getSize();
        int n4 = this.getStringWidthWithFont(this.label, font) + n3;
        return new Dimension(n4, n3);
    }

    public boolean equals(Object object) {
        return object instanceof LegendItem && ComparatorUtils.equals(((LegendItem)object).bounds, this.bounds) && ComparatorUtils.equals(((LegendItem)object).lineMarkerIcon, this.lineMarkerIcon);
    }

    public Object clone() throws CloneNotSupportedException {
        LegendItem legendItem = new LegendItem();
        if (this.bounds != null) {
            legendItem.bounds = (Rectangle2D)this.bounds.clone();
        }
        if (this.lineMarkerIcon != null) {
            legendItem.lineMarkerIcon = (LineMarkerIcon)this.lineMarkerIcon.clone();
        }
        if (this.label != null) {
            legendItem.label = this.label;
        }
        if (this.fontColor != null) {
            legendItem.fontColor = this.fontColor;
        }
        return legendItem;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("label", this.label);
        if (this.lineMarkerIcon != null) {
            jSONObject.put("lineMarkerIcon", this.lineMarkerIcon.toJSONObject());
        }
        if (this.fontColor != null) {
            jSONObject.put("fontColor", StableUtils.javaColor2JSColorWithAlpha(this.fontColor));
        }
        return jSONObject;
    }
}

